/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.filesystem;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dbflute.helper.filesystem.FileTextLineFilter;
import org.dbflute.helper.filesystem.FileTextWholeFilter;
import org.dbflute.helper.filesystem.exception.FileTextIONotFoundException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.util.Srl;

public class FileTextIO {
    protected String _encoding;
    protected boolean _removeUTF8Bom;
    protected boolean _replaceCrLfToLf;

    public FileTextIO encodeAsUTF8() {
        this._encoding = "UTF-8";
        return this;
    }

    public FileTextIO encodeAsWindows31J() {
        this._encoding = "Windows-31J";
        return this;
    }

    public FileTextIO removeUTF8Bom() {
        this._removeUTF8Bom = true;
        return this;
    }

    public FileTextIO replaceCrLfToLf() {
        this._replaceCrLfToLf = true;
        return this;
    }

    public String read(InputStream ins) {
        this.assertState();
        this.assertObjectNotNull("ins", ins);
        try {
            return this.readTextClosed(ins);
        }
        catch (IOException e) {
            return this.handleInputStreamReadFailureException(ins, e);
        }
    }

    public String read(String textPath) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        try {
            return this.readTextClosed(this.createFileInputStream(textPath));
        }
        catch (IOException e) {
            return this.handleTextFileReadFailureException(textPath, e);
        }
    }

    public String readFilteringLine(String textPath, FileTextLineFilter oneArgLambda) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        try {
            return this.filterAsLine(this.readTextClosed(this.createFileInputStream(textPath)), oneArgLambda);
        }
        catch (IOException e) {
            return this.handleTextFileReadFailureException(textPath, e);
        }
    }

    public String readFilteringLine(InputStream ins, FileTextLineFilter oneArgLambda) {
        this.assertState();
        this.assertObjectNotNull("ins", ins);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        try {
            return this.filterAsLine(this.readTextClosed(ins), oneArgLambda);
        }
        catch (IOException e) {
            return this.handleInputStreamReadFailureException(ins, e);
        }
    }

    public String readFilteringWhole(String textPath, FileTextWholeFilter oneArgLambda) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        try {
            return this.filterAsWhole(this.readTextClosed(this.createFileInputStream(textPath)), oneArgLambda);
        }
        catch (IOException e) {
            return this.handleTextFileReadFailureException(textPath, e);
        }
    }

    public String readFilteringWhole(InputStream ins, FileTextWholeFilter oneArgLambda) {
        this.assertState();
        this.assertObjectNotNull("ins", ins);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        try {
            return this.filterAsWhole(this.readTextClosed(ins), oneArgLambda);
        }
        catch (IOException e) {
            return this.handleInputStreamReadFailureException(ins, e);
        }
    }

    public String rewriteFilteringLine(String textPath, FileTextLineFilter oneArgLambda) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        String read = this.readFilteringLine(textPath, oneArgLambda);
        this.write(textPath, read);
        return read;
    }

    public String rewriteFilteringWhole(String textPath, FileTextWholeFilter oneArgLambda) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        String read = this.readFilteringWhole(textPath, oneArgLambda);
        this.write(textPath, read);
        return read;
    }

    public void write(OutputStream ous, String text) {
        this.assertState();
        this.assertObjectNotNull("ous", ous);
        this.assertObjectNotNull("text", text);
        this.writeTextClosed(ous, text);
    }

    public void write(String textPath, String text) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("text", text);
        this.writeTextClosed(this.createFileOutputStream(textPath), text);
    }

    public String writeFilteringLine(String textPath, String text, FileTextLineFilter oneArgLambda) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("text", text);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        String filtered = this.filterAsLine(text, oneArgLambda);
        this.writeTextClosed(this.createFileOutputStream(textPath), filtered);
        return filtered;
    }

    public String writeFilteringLine(OutputStream ous, String text, FileTextLineFilter oneArgLambda) {
        this.assertState();
        this.assertObjectNotNull("ous", ous);
        this.assertObjectNotNull("text", text);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        String filtered = this.filterAsLine(text, oneArgLambda);
        this.writeTextClosed(ous, filtered);
        return filtered;
    }

    public String writeFilteringLine(String textPath, String text, FileTextWholeFilter oneArgLambda) {
        this.assertState();
        this.assertStringNotNullAndNotTrimmedEmpty("textPath", textPath);
        this.assertObjectNotNull("text", text);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        String filtered = this.filterAsWhole(text, oneArgLambda);
        this.writeTextClosed(this.createFileOutputStream(textPath), filtered);
        return filtered;
    }

    public String writeFilteringLine(OutputStream ous, String text, FileTextWholeFilter oneArgLambda) {
        this.assertState();
        this.assertObjectNotNull("ous", ous);
        this.assertObjectNotNull("text", text);
        this.assertObjectNotNull("oneArgLambda(filter)", oneArgLambda);
        String filtered = this.filterAsWhole(text, oneArgLambda);
        this.writeTextClosed(ous, filtered);
        return filtered;
    }

    protected FileInputStream createFileInputStream(String textPath) {
        try {
            return new FileInputStream(textPath);
        }
        catch (FileNotFoundException e) {
            String msg = "Not found the text file: " + textPath;
            throw new FileTextIONotFoundException(msg, e);
        }
    }

    protected FileOutputStream createFileOutputStream(String textPath) {
        try {
            this.mkdirsIfNeeds(textPath);
            return new FileOutputStream(textPath);
        }
        catch (FileNotFoundException e) {
            String msg = "Not found the text file: " + textPath;
            throw new FileTextIONotFoundException(msg, e);
        }
    }

    protected void mkdirsIfNeeds(String textPath) {
        String dirPath;
        File dir;
        if (textPath.contains("/") && !(dir = new File(dirPath = Srl.substringLastFront(textPath, "/"))).exists()) {
            dir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytesClosed(InputStream ins) throws IOException {
        try {
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            int next = 0;
            while ((next = ins.read(buffer, 0, buffer.length)) != -1) {
                ous.write(buffer, 0, next);
            }
            byte[] byArray = ous.toByteArray();
            return byArray;
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected String readTextClosed(InputStream ins) throws IOException {
        byte[] bytes = this.readBytesClosed(ins);
        try {
            String text = new String(bytes, this._encoding);
            return this.adjustInOutTextIfNeeds(text);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unknown encoding: " + this._encoding;
            throw new IllegalStateException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTextClosed(OutputStream ous, String text) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(ous, this._encoding));
            String adjusted = this.adjustInOutTextIfNeeds(text);
            writer.write(adjusted != null ? adjusted : "");
            writer.flush();
            this.close(writer);
        }
        catch (IOException e) {
            try {
                this.handleOutputStreamWriteFailureException(ous, e);
                this.close(writer);
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
        }
    }

    protected String adjustInOutTextIfNeeds(String text) {
        return this.doReplaceCrLfToLfIfNeeds(this.doRemoveUTF8BomIfNeeds(text));
    }

    protected String doRemoveUTF8BomIfNeeds(String text) {
        if (this._removeUTF8Bom && text != null && !text.isEmpty() && text.charAt(0) == '\ufeff') {
            return text.substring(1);
        }
        return text;
    }

    protected String doReplaceCrLfToLfIfNeeds(String text) {
        return this._replaceCrLfToLf && text != null ? this.replace(text, "\r\n", "\n") : text;
    }

    protected void close(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void close(BufferedWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void handleOutputStreamWriteFailureException(OutputStream ous, IOException e) {
        String msg = "Failed to write the text to the output stream: " + ous;
        throw new IllegalStateException(msg, e);
    }

    protected void handleTextFileWriteFailureException(String textPath, IOException e) {
        String msg = "Failed to write the text file: " + textPath;
        throw new IllegalStateException(msg, e);
    }

    protected String handleInputStreamReadFailureException(InputStream ins, IOException e) {
        String msg = "Failed to read the input stream: " + ins;
        throw new IllegalStateException(msg, e);
    }

    protected String handleTextFileReadFailureException(String textPath, IOException e) {
        String msg = "Failed to read the text file: " + textPath;
        throw new IllegalStateException(msg, e);
    }

    protected String filterAsLine(String text, FileTextLineFilter filter) {
        String cr = "\r";
        String lf = "\n";
        StringBuilder sb = new StringBuilder();
        List<String> lineList = Srl.splitList(text, "\n");
        int lineCount = lineList.size();
        int index = 0;
        for (String line : lineList) {
            boolean hasCR;
            String pureLine;
            if (line.endsWith("\r")) {
                pureLine = Srl.substringLastFront(line, "\r");
                hasCR = true;
            } else {
                pureLine = line;
                hasCR = false;
            }
            String filteredLine = filter.filter(pureLine);
            if (filteredLine != null) {
                sb.append(filteredLine);
                if (index + 1 < lineCount) {
                    sb.append(hasCR ? cr : "").append("\n");
                }
            }
            ++index;
        }
        return sb.toString();
    }

    protected String filterAsWhole(String text, FileTextWholeFilter filter) {
        String filtered = filter.filter(text);
        return filtered != null ? filtered : "";
    }

    protected void assertState() {
        if (this._encoding == null || this._encoding.trim().length() == 0) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the encoding for the file.");
            br.addItem("Advice");
            br.addElement("You should specify 'encoding' like this:");
            br.addElement("  (o):");
            br.addElement("    FileTextIO textIO = new FileTextIO().encodeAsUTF8();");
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String replace(String str, String fromStr, String toStr) {
        StringBuilder sb = null;
        int pos = 0;
        int pos2 = 0;
        while (true) {
            pos = str.indexOf(fromStr, pos2);
            if (pos2 == 0 && pos < 0) {
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (pos == 0) {
                sb.append(toStr);
                pos2 = fromStr.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(str.substring(pos2, pos));
            sb.append(toStr);
            pos2 = pos + fromStr.length();
        }
        sb.append(str.substring(pos2));
        return sb.toString();
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }
}

