/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dbflute.Entity;
import org.dbflute.bhv.AbstractBehaviorReadable;
import org.dbflute.bhv.BehaviorWritable;
import org.dbflute.bhv.core.BehaviorCommandMeta;
import org.dbflute.bhv.core.command.AbstractBatchUpdateCommand;
import org.dbflute.bhv.core.command.BatchDeleteCommand;
import org.dbflute.bhv.core.command.BatchDeleteNonstrictCommand;
import org.dbflute.bhv.core.command.BatchInsertCommand;
import org.dbflute.bhv.core.command.BatchUpdateCommand;
import org.dbflute.bhv.core.command.BatchUpdateNonstrictCommand;
import org.dbflute.bhv.core.command.DeleteEntityCommand;
import org.dbflute.bhv.core.command.DeleteNonstrictEntityCommand;
import org.dbflute.bhv.core.command.InsertEntityCommand;
import org.dbflute.bhv.core.command.QueryDeleteCBCommand;
import org.dbflute.bhv.core.command.QueryInsertCBCommand;
import org.dbflute.bhv.core.command.QueryUpdateCBCommand;
import org.dbflute.bhv.core.command.UpdateEntityCommand;
import org.dbflute.bhv.core.command.UpdateNonstrictEntityCommand;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.bhv.writable.DeleteOption;
import org.dbflute.bhv.writable.InsertOption;
import org.dbflute.bhv.writable.QueryInsertSetupper;
import org.dbflute.bhv.writable.UpdateOption;
import org.dbflute.bhv.writable.WritableOptionCall;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.scoping.SpecifyQuery;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.info.UniqueInfo;
import org.dbflute.exception.EntityAlreadyDeletedException;
import org.dbflute.exception.EntityAlreadyUpdatedException;
import org.dbflute.exception.IllegalBehaviorStateException;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.exception.OptimisticLockColumnValueNullException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.hook.CommonColumnAutoSetupper;
import org.dbflute.optional.OptionalThing;

public abstract class AbstractBehaviorWritable<ENTITY extends Entity, CB extends ConditionBean>
extends AbstractBehaviorReadable<ENTITY, CB>
implements BehaviorWritable {
    protected static final int[] EMPTY_INT_ARRAY = new int[0];
    protected CommonColumnAutoSetupper _commonColumnAutoSetupper;

    protected void doInsert(ENTITY entity, InsertOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareInsertOption(option);
        this.delegateInsert((Entity)entity, (InsertOption<? extends ConditionBean>)option);
    }

    protected void prepareInsertOption(InsertOption<CB> option) {
        if (option == null) {
            return;
        }
        this.assertInsertOptionStatus(option);
        if (option.hasSpecifiedInsertColumn()) {
            CB cb = this.createCBForSpecifiedUpdate();
            option.resolveInsertColumnSpecification(cb);
        }
    }

    protected void assertInsertOptionStatus(InsertOption<? extends ConditionBean> option) {
        if (option.isCommonColumnAutoSetupDisabled() && !this.asDBMeta().hasCommonColumn()) {
            String msg = "The common column auto-setup disabling was set to the table not defined common columns:";
            msg = msg + " table=" + this.asTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
        if (option.isPrimaryKeyIdentityDisabled() && !this.asDBMeta().hasIdentity()) {
            String msg = "The identity disabling was set to the table not defined identity:";
            msg = msg + " table=" + this.asTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
    }

    protected CB createCBForSpecifiedUpdate() {
        Object cb = this.newConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    protected InsertOption<CB> createInsertOption(WritableOptionCall<CB, InsertOption<CB>> opCall) {
        this.assertInsertOpCallNotNull(opCall);
        InsertOption<CB> op = this.newInsertOption();
        opCall.callback(op);
        return op;
    }

    protected InsertOption<CB> newInsertOption() {
        return new InsertOption();
    }

    protected void assertInsertOpCallNotNull(WritableOptionCall<CB, InsertOption<CB>> opCall) {
        this.assertObjectNotNull("opLambda (for insert)", opCall);
    }

    @Override
    public void create(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.doCreate(entity, option);
    }

    protected void doCreate(Entity entity, InsertOption<? extends ConditionBean> option) {
        this.doInsert(this.downcast(entity), this.downcast(option));
    }

    protected void doUpdate(ENTITY entity, UpdateOption<CB> option) {
        this.prepareEntityUpdate(entity, option);
        this.helpUpdateInternally(entity, option);
    }

    protected void doUpdateNonstrict(ENTITY entity, UpdateOption<CB> option) {
        this.prepareEntityUpdate(entity, option);
        this.helpUpdateNonstrictInternally(entity, option);
    }

    protected void prepareEntityUpdate(ENTITY entity, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareUpdateOption(option);
        this.prepareEntityUpdateOption(entity, option);
    }

    protected void prepareUpdateOption(UpdateOption<CB> option) {
        if (option == null) {
            return;
        }
        this.assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(() -> this.createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            CB cb = this.createCBForSpecifiedUpdate();
            option.resolveUpdateColumnSpecification((ConditionBean)cb);
        }
    }

    protected void prepareEntityUpdateOption(ENTITY entity, UpdateOption<CB> option) {
        if (option == null) {
            return;
        }
        if (option.hasUniqueByUniqueInfo()) {
            this.reflectUniqueDriven(entity, option.getUniqueByUniqueInfo());
        }
    }

    protected void reflectUniqueDriven(ENTITY entity, UniqueInfo uniqueInfo) {
        List<ColumnInfo> uniqueColumnList = uniqueInfo.getUniqueColumnList();
        for (ColumnInfo columnInfo : uniqueColumnList) {
            entity.myuniqueByProperty(columnInfo.getPropertyName());
        }
    }

    protected CB createCBForVaryingUpdate() {
        Object cb = this.newConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected <RESULT extends ENTITY> void helpUpdateInternally(RESULT entity, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.assertEntityHasOptimisticLockValue((Entity)entity);
        int updatedCount = this.delegateUpdate((Entity)entity, (UpdateOption<? extends ConditionBean>)option);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected <RESULT extends ENTITY> void helpUpdateNonstrictInternally(RESULT entity, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        int updatedCount = this.delegateUpdateNonstrict((Entity)entity, (UpdateOption<? extends ConditionBean>)option);
        if (updatedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (updatedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, updatedCount);
        }
    }

    protected void throwUpdateEntityAlreadyDeletedException(ENTITY entity) {
        this.createBhvExThrower().throwUpdateEntityAlreadyDeletedException(entity);
    }

    protected void throwUpdateEntityDuplicatedException(ENTITY entity, int count) {
        this.createBhvExThrower().throwUpdateEntityDuplicatedException(entity, count);
    }

    protected void assertUpdateOptionStatus(UpdateOption<? extends ConditionBean> option) {
        if (option.isCommonColumnAutoSetupDisabled() && !this.asDBMeta().hasCommonColumn()) {
            String msg = "The common column auto-setup disabling was set to the table not defined common columns:";
            msg = msg + " table=" + this.asTableDbName() + " option=" + option;
            throw new IllegalStateException(msg);
        }
    }

    protected UpdateOption<CB> createUpdateOption(WritableOptionCall<CB, UpdateOption<CB>> opCall) {
        this.assertUpdateOpCallNotNull(opCall);
        UpdateOption<CB> op = this.newUpdateOption();
        opCall.callback(op);
        return op;
    }

    protected UpdateOption<CB> newUpdateOption() {
        return new UpdateOption();
    }

    protected void assertUpdateOpCallNotNull(WritableOptionCall<CB, UpdateOption<CB>> opCall) {
        this.assertObjectNotNull("opLambda (for update)", opCall);
    }

    @Override
    public void modify(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doModify(entity, option);
    }

    protected void doModify(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doUpdate(this.downcast(entity), this.downcast(option));
    }

    @Override
    public void modifyNonstrict(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.doModifyNonstrict(entity, option);
    }

    protected void doModifyNonstrict(Entity entity, UpdateOption<? extends ConditionBean> option) {
        if (this.asDBMeta().hasOptimisticLock()) {
            this.doUpdateNonstrict(this.downcast(entity), this.downcast(option));
        } else {
            this.doUpdate(this.downcast(entity), this.downcast(option));
        }
    }

    protected void doInsertOrUpdate(ENTITY entity, InsertOption<CB> insertOption, UpdateOption<CB> updateOption) {
        this.assertEntityNotNull((Entity)entity);
        this.helpInsertOrUpdateInternally(entity, insertOption, updateOption);
    }

    protected void doInsertOrUpdateNonstrict(ENTITY entity, InsertOption<CB> insertOption, UpdateOption<CB> updateOption) {
        this.assertEntityNotNull((Entity)entity);
        this.helpInsertOrUpdateNonstrictInternally(entity, insertOption, updateOption);
    }

    protected <RESULT extends ENTITY> void helpInsertOrUpdateInternally(RESULT entity, InsertOption<CB> insOption, UpdateOption<CB> updOption) {
        this.assertEntityNotNull((Entity)entity);
        if (this.helpDetermineInsertOrUpdateDirectInsert((Entity)entity)) {
            this.doCreate((Entity)entity, (InsertOption<? extends ConditionBean>)insOption);
            return;
        }
        RuntimeException updateException = null;
        try {
            this.doModify((Entity)entity, (UpdateOption<? extends ConditionBean>)updOption);
        }
        catch (EntityAlreadyUpdatedException e) {
            updateException = e;
        }
        catch (EntityAlreadyDeletedException e) {
            updateException = e;
        }
        catch (OptimisticLockColumnValueNullException e) {
            updateException = e;
        }
        if (updateException == null) {
            return;
        }
        Object cb = this.newConditionBean();
        Set<String> uniqueDrivenProperties = entity.myuniqueDrivenProperties();
        if (uniqueDrivenProperties != null && !uniqueDrivenProperties.isEmpty()) {
            for (String prop : uniqueDrivenProperties) {
                DBMeta dbmeta = entity.asDBMeta();
                ColumnInfo columnInfo = dbmeta.findColumnInfo(prop);
                Object value = columnInfo.read((Entity)entity);
                cb.localCQ().invokeQueryEqual(columnInfo.getColumnDbName(), value);
            }
        } else {
            cb.acceptPrimaryKeyMap(this.asDBMeta().extractPrimaryKeyMap((Entity)entity));
        }
        if (this.readCount((ConditionBean)cb) != 0) {
            throw updateException;
        }
        this.doCreate((Entity)entity, (InsertOption<? extends ConditionBean>)insOption);
    }

    protected <RESULT extends ENTITY> void helpInsertOrUpdateNonstrictInternally(RESULT entity, InsertOption<? extends ConditionBean> insOption, UpdateOption<? extends ConditionBean> updOption) {
        this.assertEntityNotNull((Entity)entity);
        if (this.helpDetermineInsertOrUpdateDirectInsert((Entity)entity)) {
            this.doCreate((Entity)entity, insOption);
        } else {
            try {
                this.doModifyNonstrict((Entity)entity, updOption);
            }
            catch (EntityAlreadyDeletedException ignored) {
                this.doCreate((Entity)entity, insOption);
            }
        }
    }

    protected boolean helpDetermineInsertOrUpdateDirectInsert(Entity entity) {
        Set<String> uniqueDrivenProperties = entity.myuniqueDrivenProperties();
        if (uniqueDrivenProperties != null && !uniqueDrivenProperties.isEmpty()) {
            return false;
        }
        return !entity.hasPrimaryKeyValue();
    }

    @Override
    public void createOrModify(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doCreateOrModify(entity, insertOption, updateOption);
    }

    protected void doCreateOrModify(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doInsertOrUpdate(this.downcast(entity), this.downcast(insertOption), this.downcast(updateOption));
    }

    @Override
    public void createOrModifyNonstrict(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        this.doCreateOrModifyNonstrict(entity, insertOption, updateOption);
    }

    protected void doCreateOrModifyNonstrict(Entity entity, InsertOption<? extends ConditionBean> insertOption, UpdateOption<? extends ConditionBean> updateOption) {
        if (this.asDBMeta().hasOptimisticLock()) {
            this.doInsertOrUpdateNonstrict(this.downcast(entity), this.downcast(insertOption), this.downcast(updateOption));
        } else {
            this.doInsertOrUpdate(this.downcast(entity), this.downcast(insertOption), this.downcast(updateOption));
        }
    }

    protected void doDelete(ENTITY entity, DeleteOption<CB> option) {
        this.prepareEntityDelete(entity, option);
        this.helpDeleteInternally(entity, option);
    }

    protected void doDeleteNonstrict(ENTITY entity, DeleteOption<CB> option) {
        this.prepareEntityDelete(entity, option);
        this.helpDeleteNonstrictInternally(entity, option);
    }

    protected void prepareEntityDelete(ENTITY entity, DeleteOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.prepareDeleteOption(option);
        this.prepareEntityDeleteOption(entity, option);
    }

    protected void prepareDeleteOption(DeleteOption<CB> option) {
        if (option != null) {
            this.assertDeleteOptionStatus(option);
        }
    }

    protected void prepareEntityDeleteOption(ENTITY entity, DeleteOption<CB> option) {
        if (option == null) {
            return;
        }
        if (option.hasUniqueByUniqueInfo()) {
            this.reflectUniqueDriven(entity, option.getUniqueByUniqueInfo());
        }
    }

    protected <RESULT extends ENTITY> void helpDeleteInternally(RESULT entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNull((Entity)entity);
        this.assertEntityHasOptimisticLockValue((Entity)entity);
        int deletedCount = this.delegateDelete((Entity)entity, option);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <RESULT extends ENTITY> void helpDeleteNonstrictInternally(RESULT entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNull((Entity)entity);
        int deletedCount = this.delegateDeleteNonstrict((Entity)entity, option);
        if (deletedCount == 0) {
            this.throwUpdateEntityAlreadyDeletedException(entity);
        } else if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected <RESULT extends ENTITY> void helpDeleteNonstrictIgnoreDeletedInternally(RESULT entity, DeleteOption<? extends ConditionBean> option) {
        this.assertEntityNotNull((Entity)entity);
        int deletedCount = this.delegateDeleteNonstrict((Entity)entity, option);
        if (deletedCount == 0) {
            return;
        }
        if (deletedCount > 1) {
            this.throwUpdateEntityDuplicatedException(entity, deletedCount);
        }
    }

    protected void assertDeleteOptionStatus(DeleteOption<? extends ConditionBean> option) {
    }

    protected DeleteOption<CB> createDeleteOption(WritableOptionCall<CB, DeleteOption<CB>> opCall) {
        this.assertDeleteOpCallNotNull(opCall);
        DeleteOption<CB> op = this.newDeleteOption();
        opCall.callback(op);
        return op;
    }

    protected DeleteOption<CB> newDeleteOption() {
        return new DeleteOption();
    }

    protected void assertDeleteOpCallNotNull(WritableOptionCall<CB, DeleteOption<CB>> opCall) {
        this.assertObjectNotNull("opLambda (for delete)", opCall);
    }

    @Override
    public void remove(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doRemove(entity, option);
    }

    protected void doRemove(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doDelete(this.downcast(entity), this.downcast(option));
    }

    @Override
    public void removeNonstrict(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.doRemoveNonstrict(entity, option);
    }

    protected void doRemoveNonstrict(Entity entity, DeleteOption<? extends ConditionBean> option) {
        if (this.asDBMeta().hasOptimisticLock()) {
            this.doDeleteNonstrict(this.downcast(entity), this.downcast(option));
        } else {
            this.doDelete(this.downcast(entity), this.downcast(option));
        }
    }

    protected int[] doBatchInsert(List<ENTITY> entityList, InsertOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        InsertOption<CB> rlop = option != null ? option : this.createPlainInsertOption();
        this.prepareBatchInsertOption(entityList, rlop);
        return this.delegateBatchInsert(entityList, rlop);
    }

    protected InsertOption<CB> createPlainInsertOption() {
        return this.newInsertOption();
    }

    protected <ELEMENT extends ENTITY> void prepareBatchInsertOption(List<ELEMENT> entityList, InsertOption<CB> option) {
        if (this.isBatchInsertColumnModifiedPropertiesFragmentedDisallowed()) {
            option.xdisallowInsertColumnModifiedPropertiesFragmented();
        }
        if (this.isCompatibleBatchInsertDefaultEveryColumn()) {
            option.xtoBeCompatibleBatchInsertDefaultEveryColumn();
        }
        option.xacceptInsertColumnModifiedPropertiesIfNeeds(entityList);
        this.prepareInsertOption(option);
    }

    protected boolean isBatchInsertColumnModifiedPropertiesFragmentedDisallowed() {
        return false;
    }

    protected boolean isCompatibleBatchInsertDefaultEveryColumn() {
        return false;
    }

    @Override
    public int[] lumpCreate(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpCreate(castList, option);
    }

    protected int[] doLumpCreate(List<Entity> entityList, InsertOption<? extends ConditionBean> option) {
        return this.doBatchInsert(this.downcast(entityList), this.downcast(option));
    }

    protected int[] doBatchUpdate(List<ENTITY> entityList, UpdateOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        UpdateOption<CB> rlop = option != null ? option : this.createPlainUpdateOption();
        this.prepareBatchUpdateOption(entityList, rlop);
        return this.delegateBatchUpdate(entityList, rlop);
    }

    protected int[] doBatchUpdateNonstrict(List<ENTITY> entityList, UpdateOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        UpdateOption<CB> rlop = option != null ? option : this.createPlainUpdateOption();
        this.prepareBatchUpdateOption(entityList, rlop);
        return this.delegateBatchUpdateNonstrict(entityList, rlop);
    }

    protected UpdateOption<CB> createPlainUpdateOption() {
        return new UpdateOption();
    }

    protected UpdateOption<CB> createSpecifiedUpdateOption(SpecifyQuery<CB> updateColumnSpec) {
        this.assertUpdateColumnSpecificationNotNull(updateColumnSpec);
        UpdateOption<CB> option = this.createPlainUpdateOption();
        option.specify(updateColumnSpec);
        return option;
    }

    protected void assertUpdateColumnSpecificationNotNull(SpecifyQuery<? extends ConditionBean> updateColumnSpec) {
        this.assertObjectNotNull("updateColumnSpec", updateColumnSpec);
    }

    protected <RESULT extends ENTITY> void prepareBatchUpdateOption(List<RESULT> entityList, UpdateOption<CB> option) {
        if (this.isBatchUpdateColumnModifiedPropertiesFragmentedAllowed()) {
            option.xallowUpdateColumnModifiedPropertiesFragmented();
        }
        if (this.isCompatibleBatchUpdateDefaultEveryColumn()) {
            option.xtoBeCompatibleBatchUpdateDefaultEveryColumn();
        }
        option.xacceptUpdateColumnModifiedPropertiesIfNeeds(entityList);
        this.prepareUpdateOption(option);
    }

    protected boolean isBatchUpdateColumnModifiedPropertiesFragmentedAllowed() {
        return false;
    }

    protected boolean isCompatibleBatchUpdateDefaultEveryColumn() {
        return false;
    }

    @Override
    public int[] lumpModify(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpModify(castList, option);
    }

    protected int[] doLumpModify(List<Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        return this.doBatchUpdate(this.downcast(entityList), this.downcast(option));
    }

    @Override
    public int[] lumpModifyNonstrict(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpModifyNonstrict(castList, option);
    }

    protected int[] doLumpModifyNonstrict(List<Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        if (this.asDBMeta().hasOptimisticLock()) {
            return this.doBatchUpdateNonstrict(this.downcast(entityList), this.downcast(option));
        }
        return this.doBatchUpdate(this.downcast(entityList), this.downcast(option));
    }

    protected int[] doBatchDelete(List<ENTITY> entityList, DeleteOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        this.prepareDeleteOption(option);
        return this.delegateBatchDelete(entityList, option);
    }

    protected int[] doBatchDeleteNonstrict(List<ENTITY> entityList, DeleteOption<CB> option) {
        this.assertEntityListNotNull(entityList);
        this.prepareDeleteOption(option);
        return this.delegateBatchDeleteNonstrict(entityList, option);
    }

    @Override
    public int[] lumpRemove(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpRemove(castList, option);
    }

    protected int[] doLumpRemove(List<Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        return this.doBatchDelete(this.downcast(entityList), this.downcast(option));
    }

    @Override
    public int[] lumpRemoveNonstrict(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        List<Entity> castList = entityList;
        return this.doLumpRemoveNonstrict(castList, option);
    }

    protected int[] doLumpRemoveNonstrict(List<Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        if (this.asDBMeta().hasOptimisticLock()) {
            return this.doBatchDeleteNonstrict(this.downcast(entityList), this.downcast(option));
        }
        return this.doBatchDelete(this.downcast(entityList), this.downcast(option));
    }

    protected int doQueryInsert(QueryInsertSetupper<ENTITY, CB> setupper, InsertOption<CB> option) {
        this.assertObjectNotNull("setupper", setupper);
        this.prepareInsertOption(option);
        Object et = this.newEntity();
        CB cb = this.createCBForQueryInsert();
        return this.delegateQueryInsert((Entity)et, (ConditionBean)cb, setupper.setup(et, cb), (InsertOption<? extends ConditionBean>)option);
    }

    protected CB createCBForQueryInsert() {
        Object cb = this.newConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    public int rangeCreate(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper, InsertOption<? extends ConditionBean> option) {
        return this.doRangeCreate(setupper, option);
    }

    protected int doRangeCreate(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper, InsertOption<? extends ConditionBean> option) {
        return this.doQueryInsert(this.downcast(setupper), this.downcast(option));
    }

    protected int doQueryUpdate(ENTITY entity, CB cb, UpdateOption<CB> option) {
        this.assertEntityNotNull((Entity)entity);
        this.assertCBStateValid((ConditionBean)cb);
        this.prepareUpdateOption(option);
        return this.checkCountBeforeQueryUpdateIfNeeds((ConditionBean)cb) ? this.delegateQueryUpdate((Entity)entity, (ConditionBean)cb, (UpdateOption<? extends ConditionBean>)option) : 0;
    }

    protected boolean checkCountBeforeQueryUpdateIfNeeds(ConditionBean cb) {
        boolean countExists = cb.isQueryUpdateCountPreCheck() ? this.readCount(cb) > 0 : true;
        return countExists;
    }

    @Override
    public int rangeModify(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        return this.doRangeModify(entity, cb, option);
    }

    protected int doRangeModify(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        return this.doQueryUpdate(this.downcast(entity), this.downcast(cb), this.downcast(option));
    }

    protected int doQueryDelete(CB cb, DeleteOption<CB> option) {
        this.assertCBStateValid((ConditionBean)cb);
        this.prepareDeleteOption(option);
        return this.checkCountBeforeQueryUpdateIfNeeds((ConditionBean)cb) ? this.delegateQueryDelete((ConditionBean)cb, (DeleteOption<? extends ConditionBean>)option) : 0;
    }

    @Override
    public int rangeRemove(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        return this.doRangeRemove(cb, option);
    }

    protected int doRangeRemove(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        return this.doQueryDelete(this.downcast(cb), this.downcast(option));
    }

    protected int delegateInsert(Entity entity, InsertOption<? extends ConditionBean> option) {
        OptionalThing<InsertOption<? extends ConditionBean>> optOption = this.createOptionalInsertOption(option);
        if (!this.adjustEntityBeforeInsert(entity, optOption)) {
            return 0;
        }
        InsertEntityCommand command = this.createInsertEntityCommand(entity, option);
        RuntimeException cause = null;
        try {
            this.hookBeforeInsert(command, entity, this.emptyOpt(), optOption);
            int n = this.invoke(command);
            return n;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyInsert(command, entity, this.emptyOpt(), optOption, this.createOptionalCause(cause));
        }
    }

    protected OptionalThing<RuntimeException> createOptionalCause(RuntimeException cause) {
        return OptionalThing.ofNullable(cause, () -> {
            throw new IllegalStateException("Not found the cause exception");
        });
    }

    protected <ELEMENT> OptionalThing<ELEMENT> emptyOpt() {
        return OptionalThing.empty();
    }

    protected int delegateUpdate(Entity entity, UpdateOption<? extends ConditionBean> option) {
        OptionalThing<UpdateOption<? extends ConditionBean>> optOption = this.createOptionalUpdateOption(option);
        if (!this.adjustEntityBeforeUpdate(entity, optOption)) {
            return 0;
        }
        if (this.asDBMeta().hasOptimisticLock()) {
            UpdateEntityCommand command = this.createUpdateEntityCommand(entity, option);
            RuntimeException cause = null;
            try {
                this.hookBeforeUpdate(command, entity, this.emptyOpt(), optOption);
                int n = this.invoke(command);
                return n;
            }
            catch (RuntimeException e) {
                cause = e;
                throw e;
            }
            finally {
                this.hookFinallyUpdate(command, entity, this.emptyOpt(), optOption, this.createOptionalCause(cause));
            }
        }
        return this.delegateUpdateNonstrict(entity, option);
    }

    protected int delegateUpdateNonstrict(Entity entity, UpdateOption<? extends ConditionBean> option) {
        OptionalThing<UpdateOption<? extends ConditionBean>> optOption = this.createOptionalUpdateOption(option);
        if (!this.adjustEntityBeforeUpdate(entity, optOption)) {
            return 0;
        }
        UpdateNonstrictEntityCommand command = this.createUpdateNonstrictEntityCommand(entity, option);
        RuntimeException cause = null;
        try {
            this.hookBeforeUpdate(command, entity, this.emptyOpt(), optOption);
            int n = this.invoke(command);
            return n;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyUpdate(command, entity, this.emptyOpt(), optOption, this.createOptionalCause(cause));
        }
    }

    protected OptionalThing<UpdateOption<? extends ConditionBean>> createOptionalUpdateOption(UpdateOption<? extends ConditionBean> option) {
        return OptionalThing.ofNullable(option, () -> {
            throw new IllegalStateException("Not found the update option.");
        });
    }

    protected int delegateDelete(Entity entity, DeleteOption<? extends ConditionBean> option) {
        OptionalThing<DeleteOption<? extends ConditionBean>> optOption = this.createOptionalDeleteOption(option);
        if (!this.adjustEntityBeforeDelete(entity, optOption)) {
            return 0;
        }
        if (this.asDBMeta().hasOptimisticLock()) {
            DeleteEntityCommand command = this.createDeleteEntityCommand(entity, option);
            OptionalThing<Object> optEntity = OptionalThing.of(entity);
            RuntimeException cause = null;
            try {
                this.hookBeforeDelete(command, optEntity, this.emptyOpt(), optOption);
                int n = this.invoke(command);
                return n;
            }
            catch (RuntimeException e) {
                cause = e;
                throw e;
            }
            finally {
                this.hookFinallyDelete(command, optEntity, this.emptyOpt(), optOption, this.createOptionalCause(cause));
            }
        }
        return this.delegateDeleteNonstrict(entity, option);
    }

    protected int delegateDeleteNonstrict(Entity entity, DeleteOption<? extends ConditionBean> option) {
        OptionalThing<DeleteOption<? extends ConditionBean>> optOption = this.createOptionalDeleteOption(option);
        if (!this.adjustEntityBeforeDelete(entity, optOption)) {
            return 0;
        }
        DeleteNonstrictEntityCommand command = this.createDeleteNonstrictEntityCommand(entity, option);
        OptionalThing<Object> optEntity = OptionalThing.of(entity);
        RuntimeException cause = null;
        try {
            this.hookBeforeDelete(command, optEntity, this.emptyOpt(), optOption);
            int n = this.invoke(command);
            return n;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyDelete(command, optEntity, this.emptyOpt(), optOption, this.createOptionalCause(cause));
        }
    }

    protected OptionalThing<DeleteOption<? extends ConditionBean>> createOptionalDeleteOption(DeleteOption<? extends ConditionBean> option) {
        return OptionalThing.ofNullable(option, () -> {
            throw new IllegalStateException("Not found the delete option.");
        });
    }

    protected int[] delegateBatchInsert(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        OptionalThing<InsertOption<? extends ConditionBean>> optOption = this.createOptionalInsertOption(option);
        List<? extends Entity> insertedList = this.adjustEntityListBeforeBatchInsert(entityList, option);
        if (insertedList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        BatchInsertCommand command = this.createBatchInsertCommand(insertedList, option);
        RuntimeException cause = null;
        try {
            this.hookBeforeInsert(command, entityList, this.emptyOpt(), optOption);
            int[] nArray = this.invoke(command);
            return nArray;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyInsert(command, entityList, this.emptyOpt(), optOption, this.createOptionalCause(cause));
        }
    }

    protected int[] delegateBatchUpdate(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        if (this.asDBMeta().hasOptimisticLock()) {
            List<? extends Entity> updatedList = this.adjustEntityListBeforeBatchUpdate(entityList, option, false);
            if (updatedList.isEmpty()) {
                return EMPTY_INT_ARRAY;
            }
            BatchUpdateCommand command = this.createBatchUpdateCommand(updatedList, option);
            OptionalThing<UpdateOption<? extends ConditionBean>> optOption = this.createOptionalUpdateOption(option);
            RuntimeException cause = null;
            try {
                this.hookBeforeUpdate(command, entityList, this.emptyOpt(), optOption);
                int[] nArray = this.invoke(command);
                return nArray;
            }
            catch (RuntimeException e) {
                cause = e;
                throw e;
            }
            finally {
                this.hookFinallyUpdate(command, entityList, this.emptyOpt(), optOption, this.createOptionalCause(cause));
            }
        }
        return this.delegateBatchUpdateNonstrict(entityList, option);
    }

    protected int[] delegateBatchUpdateNonstrict(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        OptionalThing<UpdateOption<? extends ConditionBean>> optOption = this.createOptionalUpdateOption(option);
        List<? extends Entity> updatedList = this.adjustEntityListBeforeBatchUpdate(entityList, option, true);
        if (updatedList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        BatchUpdateNonstrictCommand command = this.createBatchUpdateNonstrictCommand(updatedList, option);
        RuntimeException cause = null;
        try {
            this.hookBeforeUpdate(command, entityList, this.emptyOpt(), optOption);
            int[] nArray = this.invoke(command);
            return nArray;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyUpdate(command, entityList, this.emptyOpt(), optOption, this.createOptionalCause(cause));
        }
    }

    protected int[] delegateBatchDelete(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        if (this.asDBMeta().hasOptimisticLock()) {
            List<? extends Entity> deletedList = this.adjustEntityListBeforeBatchDelete(entityList, option, false);
            if (deletedList.isEmpty()) {
                return EMPTY_INT_ARRAY;
            }
            BatchDeleteCommand command = this.createBatchDeleteCommand(deletedList, option);
            OptionalThing<Object> optEntityList = OptionalThing.of(entityList);
            OptionalThing<DeleteOption<? extends ConditionBean>> optOption = this.createOptionalDeleteOption(option);
            RuntimeException cause = null;
            try {
                this.hookBeforeDelete(command, optEntityList, this.emptyOpt(), optOption);
                int[] nArray = this.invoke(command);
                return nArray;
            }
            catch (RuntimeException e) {
                cause = e;
                throw e;
            }
            finally {
                this.hookFinallyDelete(command, optEntityList, this.emptyOpt(), optOption, this.createOptionalCause(cause));
            }
        }
        return this.delegateBatchDeleteNonstrict(entityList, option);
    }

    protected int[] delegateBatchDeleteNonstrict(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        if (entityList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        List<? extends Entity> deletedList = this.adjustEntityListBeforeBatchDelete(entityList, option, true);
        if (deletedList.isEmpty()) {
            return EMPTY_INT_ARRAY;
        }
        BatchDeleteNonstrictCommand command = this.createBatchDeleteNonstrictCommand(deletedList, option);
        OptionalThing<Object> optEntityList = OptionalThing.of(entityList);
        OptionalThing<DeleteOption<? extends ConditionBean>> optOption = this.createOptionalDeleteOption(option);
        RuntimeException cause = null;
        try {
            this.hookBeforeDelete(command, optEntityList, this.emptyOpt(), optOption);
            int[] nArray = this.invoke(command);
            return nArray;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyDelete(command, optEntityList, this.emptyOpt(), optOption, this.createOptionalCause(cause));
        }
    }

    protected int delegateQueryInsert(Entity entity, ConditionBean inCB, ConditionBean resCB, InsertOption<? extends ConditionBean> option) {
        OptionalThing<InsertOption<? extends ConditionBean>> optOption = this.createOptionalInsertOption(option);
        if (!this.adjustEntityBeforeQueryInsert(entity, inCB, resCB, optOption)) {
            return 0;
        }
        QueryInsertCBCommand command = this.createQueryInsertCBCommand(entity, inCB, resCB, option);
        OptionalThing<ConditionBean> optInCB = OptionalThing.of(inCB);
        RuntimeException cause = null;
        try {
            this.hookBeforeInsert(command, entity, optInCB, optOption);
            int n = this.invoke(command);
            return n;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyInsert(command, entity, optInCB, optOption, this.createOptionalCause(cause));
        }
    }

    protected int delegateQueryUpdate(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        OptionalThing<UpdateOption<? extends ConditionBean>> optOption = this.createOptionalUpdateOption(option);
        if (!this.adjustEntityBeforeQueryUpdate(entity, cb, optOption)) {
            return 0;
        }
        QueryUpdateCBCommand command = this.createQueryUpdateCBCommand(entity, cb, option);
        OptionalThing<ConditionBean> optCB = OptionalThing.of(cb);
        RuntimeException cause = null;
        try {
            this.hookBeforeUpdate(command, entity, optCB, optOption);
            int n = this.invoke(command);
            return n;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyUpdate(command, entity, optCB, optOption, this.createOptionalCause(cause));
        }
    }

    protected int delegateQueryDelete(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        OptionalThing<DeleteOption<? extends ConditionBean>> optOption = this.createOptionalDeleteOption(option);
        if (!this.adjustEntityBeforeQueryDelete(cb, optOption)) {
            return 0;
        }
        QueryDeleteCBCommand command = this.createQueryDeleteCBCommand(cb, option);
        OptionalThing<ConditionBean> optCB = OptionalThing.of(cb);
        RuntimeException cause = null;
        try {
            this.hookBeforeDelete(command, this.emptyOpt(), optCB, optOption);
            int n = this.invoke(command);
            return n;
        }
        catch (RuntimeException e) {
            cause = e;
            throw e;
        }
        finally {
            this.hookFinallyDelete(command, this.emptyOpt(), optCB, optOption, this.createOptionalCause(cause));
        }
    }

    protected boolean adjustEntityBeforeInsert(Entity entity, OptionalThing<InsertOption<? extends ConditionBean>> option) {
        this.assertEntityNotNull(entity);
        this.frameworkFilterEntityOfInsert(entity, option);
        this.filterEntityOfInsert(entity, option);
        this.assertEntityOfInsert(entity, option);
        if (!entity.asDBMeta().hasIdentity()) {
            this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        }
        return true;
    }

    protected boolean adjustEntityBeforeQueryInsert(Entity entity, ConditionBean intoCB, ConditionBean resourceCB, OptionalThing<InsertOption<? extends ConditionBean>> option) {
        this.assertEntityNotNull(entity);
        this.assertObjectNotNull("intoCB", intoCB);
        if (resourceCB == null) {
            String msg = "The set-upper of query-insert should return condition-bean for resource table: " + entity.asTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this.frameworkFilterEntityOfInsert(entity, option);
        this.setupExclusiveControlColumnOfQueryInsert(entity);
        this.filterEntityOfInsert(entity, option);
        this.assertEntityOfInsert(entity, option);
        return true;
    }

    protected void setupExclusiveControlColumnOfQueryInsert(Entity entity) {
        ColumnInfo columnInfo;
        DBMeta dbmeta = this.asDBMeta();
        if (dbmeta.hasVersionNo()) {
            columnInfo = dbmeta.getVersionNoColumnInfo();
            columnInfo.write(entity, InsertOption.VERSION_NO_FIRST_VALUE);
        }
        if (dbmeta.hasUpdateDate()) {
            columnInfo = dbmeta.getUpdateDateColumnInfo();
            columnInfo.write(entity, ResourceContext.getAccessTimestamp());
        }
    }

    protected void frameworkFilterEntityOfInsert(Entity entity, OptionalThing<InsertOption<? extends ConditionBean>> option) {
        this.injectSequenceToPrimaryKeyIfNeeds(entity);
        this.setupCommonColumnOfInsertIfNeeds(entity, option);
    }

    protected void setupCommonColumnOfInsertIfNeeds(Entity entity, OptionalThing<InsertOption<? extends ConditionBean>> option) {
        if (option.filter(op -> op.isCommonColumnAutoSetupDisabled()).isPresent()) {
            return;
        }
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfInsertIfNeeds(entity);
    }

    private void assertCommonColumnAutoSetupperNotNull() {
        if (this._commonColumnAutoSetupper != null) {
            return;
        }
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Not found the auto set-upper of common column in the behavior!");
        br.addItem("Advice");
        br.addElement("Please confirm the definition of the set-upper at your component configuration of DBFlute.");
        br.addItem("Behavior");
        br.addElement("Behavior for " + this.asTableDbName());
        br.addItem("Attribute");
        br.addElement("behaviorCommandInvoker   : " + this._behaviorCommandInvoker);
        br.addElement("behaviorSelector         : " + this._behaviorSelector);
        br.addElement("commonColumnAutoSetupper : " + this._commonColumnAutoSetupper);
        String msg = br.buildExceptionMessage();
        throw new IllegalBehaviorStateException(msg);
    }

    @Override
    protected void filterEntityOfInsert(Entity entity, OptionalThing<InsertOption<? extends ConditionBean>> option) {
    }

    protected void assertEntityOfInsert(Entity entity, OptionalThing<InsertOption<? extends ConditionBean>> option) {
    }

    protected void hookBeforeInsert(BehaviorCommandMeta command, Object entityResource, OptionalThing<ConditionBean> cbResource, OptionalThing<InsertOption<? extends ConditionBean>> option) {
    }

    protected void hookFinallyInsert(BehaviorCommandMeta command, Object entityResource, OptionalThing<ConditionBean> cbResource, OptionalThing<InsertOption<? extends ConditionBean>> option, OptionalThing<RuntimeException> cause) {
    }

    protected boolean adjustEntityBeforeUpdate(Entity entity, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfUpdate(entity, option);
        this.filterEntityOfUpdate(entity, option);
        this.assertEntityOfUpdate(entity, option);
        return true;
    }

    protected boolean adjustEntityBeforeQueryUpdate(Entity entity, ConditionBean cb, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
        this.assertEntityNotNull(entity);
        this.assertCBStateValid(cb);
        this.frameworkFilterEntityOfUpdate(entity, option);
        this.filterEntityOfUpdate(entity, option);
        this.assertEntityOfUpdate(entity, option);
        this.assertQueryUpdateStatus(entity, cb, option);
        return true;
    }

    protected void frameworkFilterEntityOfUpdate(Entity entity, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
        this.setupCommonColumnOfUpdateIfNeeds(entity, option);
    }

    protected void setupCommonColumnOfUpdateIfNeeds(Entity entity, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
        if (option.filter(op -> op.isCommonColumnAutoSetupDisabled()).isPresent()) {
            return;
        }
        CommonColumnAutoSetupper setupper = this.getCommonColumnAutoSetupper();
        this.assertCommonColumnAutoSetupperNotNull();
        setupper.handleCommonColumnOfUpdateIfNeeds(entity);
    }

    protected void filterEntityOfUpdate(Entity entity, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
    }

    protected void assertEntityOfUpdate(Entity entity, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
    }

    protected void assertQueryUpdateStatus(Entity entity, ConditionBean cb, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
        if (option.filter(op -> op.isNonQueryUpdateAllowed()).isPresent()) {
            return;
        }
        if (cb.hasSelectAllPossible()) {
            this.createBhvExThrower().throwNonQueryUpdateNotAllowedException(entity, cb, option.orElse(null));
        }
    }

    protected void hookBeforeUpdate(BehaviorCommandMeta command, Object entityResource, OptionalThing<ConditionBean> cbResource, OptionalThing<UpdateOption<? extends ConditionBean>> option) {
    }

    protected void hookFinallyUpdate(BehaviorCommandMeta command, Object entityResource, OptionalThing<ConditionBean> cbResource, OptionalThing<UpdateOption<? extends ConditionBean>> option, OptionalThing<RuntimeException> cause) {
    }

    protected boolean adjustEntityBeforeDelete(Entity entity, OptionalThing<DeleteOption<? extends ConditionBean>> option) {
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfDelete(entity, option);
        this.filterEntityOfDelete(entity, option);
        this.assertEntityOfDelete(entity, option);
        return true;
    }

    protected boolean adjustEntityBeforeQueryDelete(ConditionBean cb, OptionalThing<DeleteOption<? extends ConditionBean>> option) {
        this.assertCBStateValid(cb);
        this.assertQueryDeleteStatus(cb, option);
        return true;
    }

    protected void frameworkFilterEntityOfDelete(Entity entity, OptionalThing<DeleteOption<? extends ConditionBean>> option) {
    }

    protected void filterEntityOfDelete(Entity entity, OptionalThing<DeleteOption<? extends ConditionBean>> option) {
    }

    protected void assertEntityOfDelete(Entity entity, OptionalThing<DeleteOption<? extends ConditionBean>> option) {
    }

    protected void assertQueryDeleteStatus(ConditionBean cb, OptionalThing<DeleteOption<? extends ConditionBean>> option) {
        if (option.filter(op -> op.isNonQueryDeleteAllowed()).isPresent()) {
            return;
        }
        if (cb.hasSelectAllPossible()) {
            this.createBhvExThrower().throwNonQueryDeleteNotAllowedException(cb, option.orElse(null));
        }
    }

    protected void hookBeforeDelete(BehaviorCommandMeta command, OptionalThing<Object> entityResource, OptionalThing<ConditionBean> cbResource, OptionalThing<DeleteOption<? extends ConditionBean>> option) {
    }

    protected void hookFinallyDelete(BehaviorCommandMeta command, OptionalThing<Object> entityResource, OptionalThing<ConditionBean> cbResource, OptionalThing<DeleteOption<? extends ConditionBean>> option, OptionalThing<RuntimeException> cause) {
    }

    protected void injectSequenceToPrimaryKeyIfNeeds(Entity entity) {
        DBMeta dbmeta = entity.asDBMeta();
        if (!dbmeta.hasSequence() || dbmeta.hasCompoundPrimaryKey() || entity.hasPrimaryKeyValue()) {
            return;
        }
        dbmeta.getPrimaryInfo().getFirstColumn().write(entity, this.readNextVal());
    }

    protected void assertEntityHasOptimisticLockValue(Entity entity) {
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
    }

    protected void assertEntityHasVersionNoValue(Entity entity) {
        if (!this.asDBMeta().hasVersionNo()) {
            return;
        }
        if (this.hasVersionNoValue(entity)) {
            return;
        }
        this.throwVersionNoValueNullException(entity);
    }

    protected void throwVersionNoValueNullException(Entity entity) {
        this.createBhvExThrower().throwVersionNoValueNullException(entity);
    }

    protected void assertEntityHasUpdateDateValue(Entity entity) {
        if (!this.asDBMeta().hasUpdateDate()) {
            return;
        }
        if (this.hasUpdateDateValue(entity)) {
            return;
        }
        this.throwUpdateDateValueNullException(entity);
    }

    protected void throwUpdateDateValueNullException(Entity entity) {
        this.createBhvExThrower().throwUpdateDateValueNullException(entity);
    }

    protected <ELEMENT extends Entity> List<ELEMENT> adjustEntityListBeforeBatchInsert(List<ELEMENT> entityList, InsertOption<? extends ConditionBean> option) {
        this.assertObjectNotNull("entityList", entityList);
        OptionalThing<InsertOption<? extends ConditionBean>> optOption = this.createOptionalInsertOption(option);
        ArrayList<Entity> filteredList = new ArrayList<Entity>(entityList.size());
        for (Entity entity : entityList) {
            if (!this.adjustEntityBeforeInsert(entity, optOption)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ELEMENT extends Entity> List<ELEMENT> adjustEntityListBeforeBatchUpdate(List<ELEMENT> entityList, UpdateOption<? extends ConditionBean> option, boolean nonstrict) {
        this.assertObjectNotNull("entityList", entityList);
        OptionalThing<UpdateOption<? extends ConditionBean>> optOption = this.createOptionalUpdateOption(option);
        ArrayList<Entity> filteredList = new ArrayList<Entity>(entityList.size());
        for (Entity entity : entityList) {
            if (!this.adjustEntityBeforeUpdate(entity, optOption)) continue;
            if (!nonstrict) {
                this.assertEntityHasOptimisticLockValue(entity);
            }
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ELEMENT extends Entity> List<ELEMENT> adjustEntityListBeforeBatchDelete(List<ELEMENT> entityList, DeleteOption<? extends ConditionBean> option, boolean nonstrict) {
        this.assertObjectNotNull("entityList", entityList);
        OptionalThing<DeleteOption<? extends ConditionBean>> optOption = this.createOptionalDeleteOption(option);
        ArrayList<Entity> filteredList = new ArrayList<Entity>(entityList.size());
        for (Entity entity : entityList) {
            if (!this.adjustEntityBeforeDelete(entity, optOption)) continue;
            if (!nonstrict) {
                this.assertEntityHasOptimisticLockValue(entity);
            }
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected UpdateEntityCommand createUpdateEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createUpdateEntityCommand");
        UpdateEntityCommand cmd = this.newUpdateEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected UpdateEntityCommand newUpdateEntityCommand() {
        return new UpdateEntityCommand();
    }

    protected UpdateNonstrictEntityCommand createUpdateNonstrictEntityCommand(Entity entity, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createUpdateNonstrictEntityCommand");
        UpdateNonstrictEntityCommand cmd = this.newUpdateNonstrictEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected UpdateNonstrictEntityCommand newUpdateNonstrictEntityCommand() {
        return new UpdateNonstrictEntityCommand();
    }

    protected DeleteEntityCommand createDeleteEntityCommand(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createDeleteEntityCommand");
        DeleteEntityCommand cmd = this.newDeleteEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected DeleteEntityCommand newDeleteEntityCommand() {
        return new DeleteEntityCommand();
    }

    protected DeleteNonstrictEntityCommand createDeleteNonstrictEntityCommand(Entity entity, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createDeleteNonstrictEntityCommand");
        DeleteNonstrictEntityCommand cmd = this.newDeleteNonstrictEntityCommand();
        this.xsetupEntityCommand(cmd, entity);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected DeleteNonstrictEntityCommand newDeleteNonstrictEntityCommand() {
        return new DeleteNonstrictEntityCommand();
    }

    protected BatchInsertCommand createBatchInsertCommand(List<? extends Entity> entityList, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchInsertCommand");
        BatchInsertCommand cmd = this.newBatchInsertCommand();
        this.setupListEntityCommand(cmd, entityList);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected BatchInsertCommand newBatchInsertCommand() {
        return new BatchInsertCommand();
    }

    protected BatchUpdateCommand createBatchUpdateCommand(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchUpdateCommand");
        BatchUpdateCommand cmd = this.newBatchUpdateCommand();
        this.setupListEntityCommand(cmd, entityList);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected BatchUpdateCommand newBatchUpdateCommand() {
        return new BatchUpdateCommand();
    }

    protected BatchUpdateNonstrictCommand createBatchUpdateNonstrictCommand(List<? extends Entity> entityList, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchUpdateNonstrictCommand");
        BatchUpdateNonstrictCommand cmd = this.newBatchUpdateNonstrictCommand();
        this.setupListEntityCommand(cmd, entityList);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected BatchUpdateNonstrictCommand newBatchUpdateNonstrictCommand() {
        return new BatchUpdateNonstrictCommand();
    }

    protected BatchDeleteCommand createBatchDeleteCommand(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchDeleteCommand");
        BatchDeleteCommand cmd = this.newBatchDeleteCommand();
        this.setupListEntityCommand(cmd, entityList);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected BatchDeleteCommand newBatchDeleteCommand() {
        return new BatchDeleteCommand();
    }

    protected BatchDeleteNonstrictCommand createBatchDeleteNonstrictCommand(List<? extends Entity> entityList, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createBatchDeleteNonstrictCommand");
        BatchDeleteNonstrictCommand cmd = this.newBatchDeleteNonstrictCommand();
        this.setupListEntityCommand(cmd, entityList);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected BatchDeleteNonstrictCommand newBatchDeleteNonstrictCommand() {
        return new BatchDeleteNonstrictCommand();
    }

    protected void setupListEntityCommand(AbstractBatchUpdateCommand command, List<? extends Entity> entityList) {
        if (entityList.isEmpty()) {
            String msg = "The argument 'entityList' should not be empty: " + entityList;
            throw new IllegalStateException(msg);
        }
        command.setTableDbName(this.asTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        command.setEntityType(entityList.get(0).getClass());
        command.setEntityList(entityList);
    }

    protected QueryInsertCBCommand createQueryInsertCBCommand(Entity entity, ConditionBean intoCB, ConditionBean resourceCB, InsertOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryInsertCBCommand");
        QueryInsertCBCommand cmd = new QueryInsertCBCommand();
        cmd.setTableDbName(this.asTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
        cmd.setIntoConditionBean(intoCB);
        cmd.setConditionBean(resourceCB);
        cmd.setInsertOption(option);
        return cmd;
    }

    protected QueryUpdateCBCommand createQueryUpdateCBCommand(Entity entity, ConditionBean cb, UpdateOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryUpdateCBCommand");
        QueryUpdateCBCommand cmd = new QueryUpdateCBCommand();
        cmd.setTableDbName(this.asTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setEntity(entity);
        cmd.setConditionBean(cb);
        cmd.setUpdateOption(option);
        return cmd;
    }

    protected QueryDeleteCBCommand createQueryDeleteCBCommand(ConditionBean cb, DeleteOption<? extends ConditionBean> option) {
        this.assertBehaviorCommandInvoker("createQueryDeleteCBCommand");
        QueryDeleteCBCommand cmd = new QueryDeleteCBCommand();
        cmd.setTableDbName(this.asTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(cmd);
        cmd.setConditionBean(cb);
        cmd.setDeleteOption(option);
        return cmd;
    }

    protected InsertOption<CB> downcast(InsertOption<? extends ConditionBean> option) {
        return option;
    }

    protected UpdateOption<CB> downcast(UpdateOption<? extends ConditionBean> option) {
        return option;
    }

    protected DeleteOption<CB> downcast(DeleteOption<? extends ConditionBean> option) {
        return option;
    }

    protected QueryInsertSetupper<ENTITY, CB> downcast(QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper) {
        return setupper;
    }

    protected CommonColumnAutoSetupper getCommonColumnAutoSetupper() {
        return this._commonColumnAutoSetupper;
    }

    public void setCommonColumnAutoSetupper(CommonColumnAutoSetupper commonColumnAutoSetupper) {
        this._commonColumnAutoSetupper = commonColumnAutoSetupper;
    }
}

