/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.twowaysql.node;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.beans.exception.DfBeanIllegalPropertyException;
import org.dbflute.helper.beans.exception.DfBeanMethodNotFoundException;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.twowaysql.exception.IfCommentDifferentTypeComparisonException;
import org.dbflute.twowaysql.exception.IfCommentEmptyExpressionException;
import org.dbflute.twowaysql.exception.IfCommentIllegalParameterBeanSpecificationException;
import org.dbflute.twowaysql.exception.IfCommentListIndexNotNumberException;
import org.dbflute.twowaysql.exception.IfCommentListIndexOutOfBoundsException;
import org.dbflute.twowaysql.exception.IfCommentMethodInvocationFailureException;
import org.dbflute.twowaysql.exception.IfCommentNotBooleanResultException;
import org.dbflute.twowaysql.exception.IfCommentNotFoundMethodException;
import org.dbflute.twowaysql.exception.IfCommentNotFoundPropertyException;
import org.dbflute.twowaysql.exception.IfCommentNullPointerException;
import org.dbflute.twowaysql.exception.IfCommentPropertyReadFailureException;
import org.dbflute.twowaysql.exception.IfCommentUnsupportedExpressionException;
import org.dbflute.twowaysql.exception.IfCommentUnsupportedTypeComparisonException;
import org.dbflute.twowaysql.node.LoopInfo;
import org.dbflute.twowaysql.node.NodeChecker;
import org.dbflute.twowaysql.node.ParameterFinder;
import org.dbflute.twowaysql.pmbean.MapParameterBean;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class IfCommentEvaluator {
    protected static final String AND = " && ";
    protected static final String OR = " || ";
    protected static final String EQUAL = " == ";
    protected static final String NOT_EQUAL = " != ";
    protected static final String GREATER_THAN = " > ";
    protected static final String LESS_THAN = " < ";
    protected static final String GREATER_EQUAL = " >= ";
    protected static final String LESS_EQUAL = " <= ";
    protected static final String BOOLEAN_NOT = "!";
    protected static final String METHOD_SUFFIX = "()";
    protected static final String[] CONNECTORS = new String[]{" && ".trim(), " || ".trim()};
    protected static final String[] OPERANDS = new String[]{" == ".trim(), " != ".trim(), " > ".trim(), " < ".trim(), " >= ".trim(), " <= ".trim()};
    protected final ParameterFinder _finder;
    protected final String _expression;
    protected final String _specifiedSql;
    protected final LoopInfo _loopInfo;

    public static String[] getConnectors() {
        return CONNECTORS;
    }

    public static String[] getOperands() {
        return OPERANDS;
    }

    public static boolean isConnector(String target) {
        return Srl.equalsPlain(target, CONNECTORS);
    }

    public static boolean isOperand(String target) {
        return Srl.equalsPlain(target, OPERANDS);
    }

    public static boolean isBooleanNotStatement(String target) {
        return Srl.startsWith(target, BOOLEAN_NOT);
    }

    public static boolean isMethodStatement(String target) {
        return Srl.endsWith(target, METHOD_SUFFIX);
    }

    public static String substringBooleanNotRear(String target) {
        return IfCommentEvaluator.isBooleanNotStatement(target) ? Srl.substringFirstRear(target, BOOLEAN_NOT) : target;
    }

    public IfCommentEvaluator(ParameterFinder finder, String expression, String specifiedSql, LoopInfo loopInfo) {
        this._finder = finder;
        this._expression = expression != null ? expression.trim() : null;
        this._specifiedSql = specifiedSql;
        this._loopInfo = loopInfo;
    }

    public boolean evaluate() {
        this.assertExpression();
        if (this._expression.contains(AND)) {
            List<String> clauseList = this.splitList(this._expression, AND);
            for (String booleanClause : clauseList) {
                boolean result = this.evaluateBooleanClause(booleanClause);
                if (result) continue;
                return false;
            }
            return true;
        }
        if (this._expression.contains(OR)) {
            List<String> clauseList = this.splitList(this._expression, OR);
            for (String booleanClause : clauseList) {
                boolean result = this.evaluateBooleanClause(booleanClause);
                if (!result) continue;
                return true;
            }
            return false;
        }
        return this.evaluateBooleanClause(this._expression);
    }

    public void assertExpression() {
        if (this._expression == null || this._expression.trim().length() == 0) {
            this.throwIfCommentEmptyExpressionException();
        }
        String filtered = Srl.replace(this._expression, METHOD_SUFFIX, "");
        if ((filtered = Srl.replace(filtered, ".get(", "")).contains("(")) {
            this.throwIfCommentUnsupportedExpressionException();
        }
        if (this._expression.contains(AND) && this._expression.contains(OR)) {
            this.throwIfCommentUnsupportedExpressionException();
        }
        if (this._expression.contains(" = ") || this._expression.contains(" <> ")) {
            this.throwIfCommentUnsupportedExpressionException();
        }
        if (this._expression.contains("\"")) {
            this.throwIfCommentUnsupportedExpressionException();
        }
    }

    protected boolean evaluateBooleanClause(final String booleanClause) {
        if (booleanClause.contains(EQUAL)) {
            return this.evaluateCompareClause(booleanClause, EQUAL, new OperandEvaluator(){

                @Override
                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult instanceof Number && rightResult instanceof Number) {
                        leftResult = new BigDecimal(leftResult.toString());
                        rightResult = new BigDecimal(rightResult.toString());
                    }
                    IfCommentEvaluator.this.assertCompareType(leftResult, rightResult, booleanClause);
                    return leftResult != null ? leftResult.equals(rightResult) : rightResult == null;
                }
            });
        }
        if (booleanClause.contains(NOT_EQUAL)) {
            return this.evaluateCompareClause(booleanClause, NOT_EQUAL, new OperandEvaluator(){

                @Override
                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult instanceof Number && rightResult instanceof Number) {
                        leftResult = new BigDecimal(leftResult.toString());
                        rightResult = new BigDecimal(rightResult.toString());
                    }
                    IfCommentEvaluator.this.assertCompareType(leftResult, rightResult, booleanClause);
                    return leftResult != null ? !leftResult.equals(rightResult) : rightResult != null;
                }
            });
        }
        if (booleanClause.contains(GREATER_THAN)) {
            return this.evaluateCompareClause(booleanClause, GREATER_THAN, new OperandEvaluator(){

                @Override
                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return false;
                    }
                    if (rightResult == null) {
                        return true;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminer(){

                        @Override
                        public boolean compare(int compareResult) {
                            return compareResult > 0;
                        }
                    }, booleanClause);
                }
            });
        }
        if (booleanClause.contains(LESS_THAN)) {
            return this.evaluateCompareClause(booleanClause, LESS_THAN, new OperandEvaluator(){

                @Override
                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return true;
                    }
                    if (rightResult == null) {
                        return false;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminer(){

                        @Override
                        public boolean compare(int compareResult) {
                            return compareResult < 0;
                        }
                    }, booleanClause);
                }
            });
        }
        if (booleanClause.contains(GREATER_EQUAL)) {
            return this.evaluateCompareClause(booleanClause, GREATER_EQUAL, new OperandEvaluator(){

                @Override
                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return rightResult == null;
                    }
                    if (rightResult == null) {
                        return true;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminer(){

                        @Override
                        public boolean compare(int compareResult) {
                            return compareResult >= 0;
                        }
                    }, booleanClause);
                }
            });
        }
        if (booleanClause.contains(LESS_EQUAL)) {
            return this.evaluateCompareClause(booleanClause, LESS_EQUAL, new OperandEvaluator(){

                @Override
                public boolean evaluate(Object leftResult, Object rightResult) {
                    if (leftResult == null) {
                        return true;
                    }
                    if (rightResult == null) {
                        return false;
                    }
                    return IfCommentEvaluator.this.compareLeftRight(leftResult, rightResult, new ComparaDeterminer(){

                        @Override
                        public boolean compare(int compareResult) {
                            return compareResult <= 0;
                        }
                    }, booleanClause);
                }
            });
        }
        return this.evaluateStandAloneValue(booleanClause);
    }

    protected boolean compareLeftRight(Object leftResult, Object rightResult, ComparaDeterminer determiner, String booleanClause) {
        this.assertCompareType(leftResult, rightResult, booleanClause);
        if (leftResult instanceof Number) {
            BigDecimal leftDecimal = new BigDecimal(((Number)leftResult).toString());
            BigDecimal rightDecimal = new BigDecimal(((Number)rightResult).toString());
            return determiner.compare(leftDecimal.compareTo(rightDecimal));
        }
        if (leftResult instanceof LocalDate) {
            LocalDate leftDate = (LocalDate)leftResult;
            LocalDate rightDate = this.toLocalDate(rightResult);
            return determiner.compare(leftDate.compareTo(rightDate));
        }
        if (leftResult instanceof LocalDateTime) {
            LocalDateTime leftDate = (LocalDateTime)leftResult;
            LocalDateTime rightDate = this.toLocalDateTime(rightResult);
            return determiner.compare(leftDate.compareTo(rightDate));
        }
        if (leftResult instanceof LocalTime) {
            LocalTime leftDate = (LocalTime)leftResult;
            LocalTime rightDate = this.toLocalTime(rightResult);
            return determiner.compare(leftDate.compareTo(rightDate));
        }
        if (leftResult instanceof Date) {
            Date leftDate = (Date)leftResult;
            Date rightDate = this.toDate(rightResult);
            return determiner.compare(leftDate.compareTo(rightDate));
        }
        this.throwIfCommentUnsupportedTypeComparisonException(leftResult, rightResult, booleanClause);
        return false;
    }

    protected void assertCompareType(Object leftResult, Object rightResult, String booleanClause) {
        if (leftResult == null || rightResult == null) {
            return;
        }
        if (leftResult instanceof Number) {
            if (!(rightResult instanceof Number)) {
                this.throwIfCommentDifferentTypeComparisonException(leftResult, rightResult, booleanClause);
            }
        } else if ((leftResult instanceof Date || DfTypeUtil.isAnyLocalDate(leftResult)) && !(rightResult instanceof Date) && !DfTypeUtil.isAnyLocalDate(rightResult)) {
            this.throwIfCommentDifferentTypeComparisonException(leftResult, rightResult, booleanClause);
        }
    }

    protected boolean evaluateCompareClause(String booleanClause, String operand, OperandEvaluator evaluator) {
        String left = booleanClause.substring(0, booleanClause.indexOf(operand)).trim();
        String right = booleanClause.substring(booleanClause.indexOf(operand) + operand.length()).trim();
        Object leftResult = this.evaluateComparePiece(left, null);
        Object rightResult = this.evaluateComparePiece(right, leftResult);
        return evaluator.evaluate(leftResult, rightResult);
    }

    protected Object evaluateComparePiece(String piece, Object leftResult) {
        if (!this.startsWithParameterBean(piece = piece.trim())) {
            String rearValue;
            if ("null".equalsIgnoreCase(piece)) {
                return null;
            }
            if ("true".equalsIgnoreCase(piece)) {
                return true;
            }
            if ("false".equalsIgnoreCase(piece)) {
                return false;
            }
            String quote = "'";
            int qlen = "'".length();
            if (piece.startsWith("'") && piece.endsWith("'")) {
                return piece.substring(qlen, piece.length() - qlen);
            }
            String dateMark = "date ";
            if (piece.toLowerCase().startsWith("date ") && (rearValue = piece.substring("date ".length()).trim()).startsWith("'") && rearValue.endsWith("'")) {
                String literal = rearValue.substring(qlen, rearValue.length() - qlen).trim();
                try {
                    if (leftResult instanceof LocalDate) {
                        return this.toLocalDate(literal);
                    }
                    if (leftResult instanceof LocalDateTime) {
                        return this.toLocalDateTime(literal);
                    }
                    if (leftResult instanceof LocalTime) {
                        return this.toLocalTime(literal);
                    }
                    return DfTypeUtil.toTimestamp(literal);
                }
                catch (DfTypeUtil.ParseTimestampException ignored) {
                    // empty catch block
                }
            }
            try {
                return DfTypeUtil.toBigDecimal(piece);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        ArrayList<String> propertyList = new ArrayList<String>();
        String preProperty = this.setupPropertyList(piece, propertyList);
        Object baseObject = this.findBaseObject(preProperty);
        for (String property : propertyList) {
            baseObject = this.processOneProperty(baseObject, preProperty, property);
            preProperty = property;
        }
        return baseObject;
    }

    protected boolean evaluateStandAloneValue(String piece) {
        piece = piece.trim();
        boolean not = false;
        if (piece.startsWith(BOOLEAN_NOT)) {
            not = true;
            piece = piece.substring(BOOLEAN_NOT.length());
        }
        if (!this.startsWithParameterBean(piece)) {
            if ("true".equalsIgnoreCase(piece)) {
                return !not;
            }
            if ("false".equalsIgnoreCase(piece)) {
                return not;
            }
        }
        ArrayList<String> propertyList = new ArrayList<String>();
        String preProperty = this.setupPropertyList(piece, propertyList);
        Object baseObject = this.findBaseObject(preProperty);
        for (String property : propertyList) {
            baseObject = this.processOneProperty(baseObject, preProperty, property);
            preProperty = property;
        }
        if (baseObject == null) {
            this.throwIfCommentNotBooleanResultException();
        }
        boolean result = Boolean.valueOf(baseObject.toString());
        return not ? !result : result;
    }

    protected boolean startsWithParameterBean(String piece) {
        return piece.startsWith("pmb");
    }

    protected String setupPropertyList(String piece, List<String> propertyList) {
        List<String> clauseList = this.splitList(piece, ".");
        String firstName = null;
        for (int i = 0; i < clauseList.size(); ++i) {
            String token = clauseList.get(i);
            if (i == 0) {
                this.assertFirstName(token);
                firstName = token;
                continue;
            }
            propertyList.add(token);
        }
        return firstName;
    }

    protected void assertFirstName(String firstName) {
        Object firstArg;
        if (this.isLoopCurrentVariable(firstName)) {
            return;
        }
        if (NodeChecker.isCurrentVariableOutOfScope(firstName, this.isInLoop())) {
            this.throwLoopCurrentVariableOutOfForCommentException();
        }
        if (NodeChecker.isWrongParameterBeanName(firstName, firstArg = this._finder.find(firstName))) {
            this.throwIfCommentIllegalParameterBeanSpecificationException();
        }
    }

    protected void throwLoopCurrentVariableOutOfForCommentException() {
        NodeChecker.throwLoopCurrentVariableOutOfForCommentException(this._expression, this._specifiedSql);
    }

    protected Object processOneProperty(Object baseObject, String firstProperty, String property) {
        Map map;
        DfBeanDesc beanDesc;
        if (baseObject == null) {
            this.throwIfCommentNullPointerException(firstProperty);
        }
        if ((beanDesc = DfBeanDescFactory.getBeanDesc(baseObject.getClass())).hasPropertyDesc(property)) {
            DfPropertyDesc propertyDesc = beanDesc.getPropertyDesc(property);
            try {
                return propertyDesc.getValue(baseObject);
            }
            catch (DfBeanIllegalPropertyException e) {
                this.throwIfCommentPropertyReadFailureException(baseObject, propertyDesc.getPropertyName(), e);
                return null;
            }
        }
        if (property.endsWith(METHOD_SUFFIX)) {
            String methodName = property.substring(0, property.length() - METHOD_SUFFIX.length());
            try {
                Method method = beanDesc.getMethod(methodName);
                return DfReflectionUtil.invoke(method, baseObject, null);
            }
            catch (DfBeanMethodNotFoundException e) {
                this.throwIfCommentNotFoundMethodException(baseObject, methodName);
                return null;
            }
            catch (DfReflectionUtil.ReflectionFailureException e) {
                this.throwIfCommentMethodInvocationFailureException(baseObject, methodName, e);
                return null;
            }
        }
        if (MapParameterBean.class.isInstance(baseObject) && (map = ((MapParameterBean)baseObject).getParameterMap()).containsKey(property)) {
            return map.get(property);
        }
        if (Map.class.isInstance(baseObject)) {
            map = (Map)baseObject;
            return map.get(property);
        }
        if (List.class.isInstance(baseObject) && property.startsWith("get(") && property.endsWith(")")) {
            List list = (List)baseObject;
            String exp = Srl.extractScopeFirst(property, "get(", ")").getContent();
            try {
                Integer index = DfTypeUtil.toInteger(exp);
                return list.get(index);
            }
            catch (NumberFormatException e) {
                this.throwIfCommentListIndexNotNumberException(list, exp, e);
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                this.throwIfCommentListIndexOutOfBoundsException(list, exp, e);
                return null;
            }
        }
        this.throwIfCommentNotFoundPropertyException(baseObject, property);
        return null;
    }

    protected Object findBaseObject(String firstName) {
        if (this.isLoopCurrentVariable(firstName)) {
            return this._loopInfo.getCurrentParameter();
        }
        return this._finder.find(firstName);
    }

    protected boolean isInLoop() {
        return this._loopInfo != null;
    }

    protected boolean isLoopCurrentVariable(String firstName) {
        return this.isInLoop() && "#current".equals(firstName);
    }

    protected void throwIfCommentEmptyExpressionException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment expression was empty!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment." + this.ln();
        msg = msg + "For example, wrong and correct IF comment is as below:" + this.ln();
        msg = msg + "  /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "  (x) - /*IF */" + this.ln();
        msg = msg + "  (o) - /*IF pmb.memberId != null*/" + this.ln();
        msg = msg + "  - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentEmptyExpressionException(msg);
    }

    protected void throwIfCommentUnsupportedExpressionException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment expression was unsupported!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your unsupported IF comment." + this.ln();
        msg = msg + "For example, unsupported examples:" + this.ln();
        msg = msg + "  (x:andOr) - /*IF (pmb.fooId != null || pmb.barId != null) && pmb.fooName != null*/" + this.ln();
        msg = msg + "  (x:argsMethod) - /*IF pmb.buildFooId(123)*/" + this.ln();
        msg = msg + "  (x:stringLiteral) - /*IF pmb.fooName == 'Pixy' || pmb.fooName == \"Pixy\"*/" + this.ln();
        msg = msg + "  (x:singleEqual) - /*IF pmb.fooId = null*/ --> /*IF pmb.fooId == null*/" + this.ln();
        msg = msg + "  (x:anotherNot) - /*IF pmb.fooId <> null*/ --> /*IF pmb.fooId != null*/" + this.ln();
        msg = msg + "  (x:doubleQuotation) - /*IF pmb.fooName == \"Pixy\"*/ --> /*IF pmb.fooName == 'Pixy'*/" + this.ln();
        msg = msg + "  " + this.ln();
        msg = msg + "If you want to write a complex condition, write an ExParameterBean property." + this.ln();
        msg = msg + "And use the property in IF comment." + this.ln();
        msg = msg + "For example, ExParameterBean original property:" + this.ln();
        msg = msg + "  e.g. ExParameterBean (your original property)" + this.ln();
        msg = msg + "  /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "  public boolean isOriginalMemberProperty() {" + this.ln();
        msg = msg + "      return (getMemberId() != null || getBirthdate() != null) && getMemberName() != null);" + this.ln();
        msg = msg + "  }" + this.ln();
        msg = msg + "  - - - - - - - - - -/" + this.ln();
        msg = msg + "  " + this.ln();
        msg = msg + "  e.g. IF comment" + this.ln();
        msg = msg + "  /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "  /*IF pmb.originalMemberProperty*/" + this.ln();
        msg = msg + "  - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentUnsupportedExpressionException(msg);
    }

    public void throwIfCommentIllegalParameterBeanSpecificationException() {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment had the illegal parameter-bean specification!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment." + this.ln();
        msg = msg + "For example, wrong and correct IF comment is as below:" + this.ln();
        msg = msg + "  (x) - /*IF pmb,memberId != null*/" + this.ln();
        msg = msg + "  (x) - /*IF p mb.memberId != null*/" + this.ln();
        msg = msg + "  (x) - /*IF pmb:memberId != null*/" + this.ln();
        msg = msg + "  (x) - /*IF pnb.memberId != null*/" + this.ln();
        msg = msg + "  (o) - /*IF pmb.memberId != null*/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentIllegalParameterBeanSpecificationException(msg);
    }

    protected void throwIfCommentPropertyReadFailureException(Object baseObject, String propertyName, DfBeanIllegalPropertyException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Failed to read the property on the IF comment!");
        br.addItem("Advice");
        br.addElement("Please confirm your IF comment properties.");
        br.addElement("(readable? accessbile? and so on...)");
        br.addItem("IF Comment");
        br.addElement(this._expression);
        br.addItem("Illegal Property");
        br.addElement(DfTypeUtil.toClassTitle(baseObject) + "." + propertyName);
        br.addItem("Exception Message");
        br.addElement(e.getClass());
        br.addElement(e.getMessage());
        Throwable cause = e.getCause();
        if (cause != null) {
            br.addElement(cause.getClass());
            br.addElement(cause.getMessage());
            Throwable nextCause = cause.getCause();
            if (nextCause != null) {
                br.addElement(nextCause.getClass());
                br.addElement(nextCause.getMessage());
            }
        }
        br.addItem("Specified ParameterBean");
        br.addElement(this.getDisplayParameterBean());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentPropertyReadFailureException(msg, e);
    }

    protected void throwIfCommentNotFoundMethodException(Object baseObject, String notFoundMethod) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The method on the IF comment was not found!");
        br.addItem("Advice");
        br.addElement("Please confirm your IF comment properties.");
        br.addElement("For example, wrong and correct IF comment is as below:");
        br.addElement("  /- - - - - - - - - - - - - - - - - - - - - - - - - - ");
        br.addElement("  (x) - /*IF pmb.getMemborWame() != null*/");
        br.addElement("  (o) - /*IF pmb.getMemberName() != null*/");
        br.addElement("  - - - - - - - - - -/");
        br.addItem("IF Comment");
        br.addElement(this._expression);
        br.addItem("NotFound Method");
        br.addElement(DfTypeUtil.toClassTitle(baseObject) + "." + notFoundMethod + METHOD_SUFFIX);
        br.addItem("Specified ParameterBean");
        br.addElement(this.getDisplayParameterBean());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentNotFoundMethodException(msg);
    }

    protected void throwIfCommentMethodInvocationFailureException(Object baseObject, String methodName, DfReflectionUtil.ReflectionFailureException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("Failed to invoke the method on the IF comment!");
        br.addItem("Advice");
        br.addElement("Please confirm the method implementation on your comment.");
        br.addItem("IF Comment");
        br.addElement(this._expression);
        br.addItem("Failure Method");
        br.addElement(DfTypeUtil.toClassTitle(baseObject) + "." + methodName + METHOD_SUFFIX);
        br.addItem("Exception Message");
        br.addElement(e.getMessage());
        br.addItem("Specified ParameterBean");
        br.addElement(this.getDisplayParameterBean());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentMethodInvocationFailureException(msg, e);
    }

    protected void throwIfCommentNotFoundPropertyException(Object baseObject, String notFoundProperty) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment property was not found!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment properties." + this.ln();
        msg = msg + "For example, wrong and correct IF comment is as below:" + this.ln();
        msg = msg + "  /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        msg = msg + "  (x) - /*IF pmb.memderBame != null*/" + this.ln();
        msg = msg + "  (o) - /*IF pmb.memberName != null*/" + this.ln();
        msg = msg + "  - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[not found Property]" + this.ln();
        msg = msg + (baseObject != null ? DfTypeUtil.toClassTitle(baseObject) + "." : "");
        msg = msg + notFoundProperty + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentNotFoundPropertyException(msg);
    }

    protected void throwIfCommentNullPointerException(String nullProperty) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment met the null pointer!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment and its property values." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Null Property]" + this.ln() + nullProperty + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentNullPointerException(msg);
    }

    protected void throwIfCommentDifferentTypeComparisonException(Object left, Object right, String booleanClause) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment had the different type comparison!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment property types." + this.ln();
        msg = msg + "If the left type is Number, the right type should be Number." + this.ln();
        msg = msg + "If the left type is Date, the right type should be Date." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target Boolean Clause]" + this.ln() + booleanClause + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Left]" + this.ln() + (left != null ? left.getClass() : "null") + this.ln();
        msg = msg + " => " + left + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Right]" + this.ln() + (right != null ? right.getClass() : "null") + this.ln();
        msg = msg + " => " + right + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentDifferentTypeComparisonException(msg);
    }

    protected void throwIfCommentUnsupportedTypeComparisonException(Object left, Object right, String booleanClause) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The IF comment had the different type comparison!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Please confirm your IF comment property types." + this.ln();
        msg = msg + "For example, String type is unsupported at comparison(>, <, >=, <=)." + this.ln();
        msg = msg + "Number and Date are only supported." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[IF Comment Expression]" + this.ln() + this._expression + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target Boolean Clause]" + this.ln() + booleanClause + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Left]" + this.ln() + (left != null ? left.getClass() : "null") + this.ln();
        msg = msg + " => " + left + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Right]" + this.ln() + (right != null ? right.getClass() : "null") + this.ln();
        msg = msg + " => " + right + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified ParameterBean]" + this.ln() + this.getDisplayParameterBean() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Specified SQL]" + this.ln() + this._specifiedSql + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IfCommentUnsupportedTypeComparisonException(msg);
    }

    protected void throwIfCommentNotBooleanResultException() {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The IF comment was not boolean!");
        br.addItem("Advice");
        br.addElement("Please confirm your IF comment property.");
        br.addElement("IF-statement result should be boolean type.");
        br.addElement("(and also the result should not be null)");
        br.addItem("IF Comment");
        br.addElement(this._expression);
        br.addItem("Specified ParameterBean");
        br.addElement(this.getDisplayParameterBean());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentNotBooleanResultException(msg);
    }

    protected void throwIfCommentListIndexNotNumberException(List<?> list, String notNumberIndex, NumberFormatException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The list index on the IF comment was not number!");
        br.addItem("Advice");
        br.addElement("Please confirm the index on your comment.");
        br.addItem("IF Comment");
        br.addElement(this._expression);
        br.addItem("Target List");
        br.addElement(list);
        br.addItem("NotNumber Index");
        br.addElement(notNumberIndex);
        br.addItem("NumberFormatException");
        br.addElement(e.getMessage());
        br.addItem("Specified ParameterBean");
        br.addElement(this.getDisplayParameterBean());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentListIndexNotNumberException(msg, e);
    }

    protected void throwIfCommentListIndexOutOfBoundsException(List<?> list, String numberIndex, IndexOutOfBoundsException e) {
        ExceptionMessageBuilder br = this.createExceptionMessageBuilder();
        br.addNotice("The list index on the IF comment was out of bounds!");
        br.addItem("Advice");
        br.addElement("Please confirm the index on your comment.");
        br.addItem("IF Comment");
        br.addElement(this._expression);
        br.addItem("Target List");
        br.addElement(list);
        br.addItem("OutOfBounds Index");
        br.addElement(numberIndex);
        br.addItem("IndexOutOfBoundsException");
        br.addElement(e.getMessage());
        br.addItem("Specified ParameterBean");
        br.addElement(this.getDisplayParameterBean());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentListIndexOutOfBoundsException(msg, e);
    }

    protected Object getDisplayParameterBean() {
        return this.findBaseObject("pmb");
    }

    protected LocalDate toLocalDate(Object obj) {
        return DfTypeUtil.toLocalDate(obj, this.getDBFluteSystemFinalTimeZone());
    }

    protected LocalDateTime toLocalDateTime(Object obj) {
        return DfTypeUtil.toLocalDateTime(obj, this.getDBFluteSystemFinalTimeZone());
    }

    protected LocalTime toLocalTime(Object obj) {
        return DfTypeUtil.toLocalTime(obj, this.getDBFluteSystemFinalTimeZone());
    }

    protected Date toDate(Object obj) {
        return DfTypeUtil.toDate(obj, this.getDBFluteSystemFinalTimeZone());
    }

    protected TimeZone getDBFluteSystemFinalTimeZone() {
        return DBFluteSystem.getFinalTimeZone();
    }

    protected ExceptionMessageBuilder createExceptionMessageBuilder() {
        return new ExceptionMessageBuilder();
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }

    protected List<String> splitList(String str, String delimiter) {
        return Srl.splitList(str, delimiter);
    }

    public String getExpression() {
        return this._expression;
    }

    protected static interface OperandEvaluator {
        public boolean evaluate(Object var1, Object var2);
    }

    protected static interface ComparaDeterminer {
        public boolean compare(int var1);
    }
}

