/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.manage.refresh;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.util.Srl;

public class DfRefreshResourceRequest {
    public static final String AUTO_DETECT_MARK = "$$AutoDetect$$";
    public static final String KEY_BODY = "body";
    public static final String KEY_HEADER_FIELDS = "headerFields";
    protected final List<String> _projectNameList;
    protected final String _requestUrl;

    public DfRefreshResourceRequest(List<String> projectNameList, String requestUrl) {
        if (projectNameList == null || projectNameList.isEmpty()) {
            String msg = "The argument 'projectNameList' should not be null or empty: " + projectNameList;
            throw new IllegalArgumentException(msg);
        }
        if (Srl.is_Null_or_TrimmedEmpty(requestUrl)) {
            String msg = "The argument 'requestUrl' should not be null or empty: " + requestUrl;
            throw new IllegalArgumentException(msg);
        }
        this._projectNameList = projectNameList;
        this._requestUrl = requestUrl;
    }

    public Map<String, Map<String, Object>> refreshResources() throws IOException {
        Map<String, Map<String, Object>> resultMap = this.newResultMap();
        for (String projectName : this._projectNameList) {
            resultMap.put(projectName, this.doRefreshResources(projectName));
        }
        return resultMap;
    }

    protected Map<String, Map<String, Object>> newResultMap() {
        return new LinkedHashMap<String, Map<String, Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> doRefreshResources(String projectName) throws IOException {
        String pathAndQuery = this.buildRefreshPathAndQuery(projectName);
        URL url = this.createRefreshRequestURL(pathAndQuery);
        if (url == null) {
            return null;
        }
        InputStream ins = null;
        try {
            URLConnection conn = this.openConnect(url);
            ins = conn.getInputStream();
            LinkedHashMap<String, Object> elementMap = this.newElementMap();
            this.setupBasicResult(conn, elementMap, ins);
            this.handleConnectedConnection(conn, elementMap);
            LinkedHashMap<String, Object> linkedHashMap = elementMap;
            return linkedHashMap;
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected LinkedHashMap<String, Object> newElementMap() {
        return new LinkedHashMap<String, Object>();
    }

    protected String buildRefreshPathAndQuery(String projectName) {
        StringBuilder sb = new StringBuilder();
        sb.append("refresh?").append(projectName).append("=INFINITE");
        return sb.toString();
    }

    protected void setupBasicResult(URLConnection conn, Map<String, Object> elementMap, InputStream ins) throws IOException {
        String body = this.extractResponseBody(ins);
        elementMap.put(KEY_BODY, body);
        elementMap.put(KEY_HEADER_FIELDS, conn.getHeaderFields());
    }

    protected String extractResponseBody(InputStream ins) throws IOException {
        byte[] body = new byte[1024];
        ins.read(body);
        return new String(body, "UTF-8");
    }

    protected void handleConnectedConnection(URLConnection conn, Map<String, Object> elementMap) throws IOException {
    }

    protected URLConnection openConnect(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setReadTimeout(this.getRefreshRequestReadTimeout());
        conn.connect();
        return conn;
    }

    protected URL createRefreshRequestURL(String path) throws MalformedURLException {
        String requestUrl = this._requestUrl;
        if (!requestUrl.endsWith("/")) {
            requestUrl = requestUrl + "/";
        }
        return new URL(requestUrl + path);
    }

    protected int getRefreshRequestReadTimeout() {
        return 3000;
    }
}

