/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.hook;

import org.dbflute.bhv.core.BehaviorCommandHook;
import org.dbflute.bhv.core.BehaviorCommandMeta;
import org.dbflute.hook.SqlFireHook;
import org.dbflute.hook.SqlFireReadyInfo;
import org.dbflute.hook.SqlFireResultInfo;
import org.dbflute.hook.SqlLogHandler;
import org.dbflute.hook.SqlResultHandler;
import org.dbflute.hook.SqlStringFilter;
import org.dbflute.util.DfTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackContext {
    private static final Logger _log = LoggerFactory.getLogger(CallbackContext.class);
    protected static final ThreadLocal<CallbackContext> _defaultThreadLocal = new ThreadLocal();
    protected static final CallbackContextHolder _defaultHolder;
    protected static CallbackContextHolder _holder;
    protected static boolean _locked;
    protected BehaviorCommandHook _behaviorCommandHook;
    protected SqlFireHook _sqlFireHook;
    protected SqlLogHandler _sqlLogHandler;
    protected SqlResultHandler _sqlResultHandler;
    protected SqlStringFilter _sqlStringFilter;

    public static CallbackContext getCallbackContextOnThread() {
        return CallbackContext.getActiveHolder().provide();
    }

    public static void setCallbackContextOnThread(CallbackContext callbackContext) {
        if (callbackContext == null) {
            String msg = "The argument 'callbackContext' must not be null.";
            throw new IllegalArgumentException(msg);
        }
        CallbackContext.getActiveHolder().save(callbackContext);
    }

    public static boolean isExistCallbackContextOnThread() {
        return CallbackContext.getActiveHolder().provide() != null;
    }

    public static void clearCallbackContextOnThread() {
        CallbackContext.getActiveHolder().save(null);
    }

    protected static CallbackContextHolder getActiveHolder() {
        return _holder;
    }

    public static void useSurrogateHolder(CallbackContextHolder holder) {
        CallbackContext.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting surrogate holder for callback context: " + holder);
        }
        _holder = holder != null ? holder : _defaultHolder;
        _locked = true;
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the static world of the callback context!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the static world of the callback context!");
        }
        _locked = false;
    }

    protected static void assertNotLocked() {
        if (!CallbackContext.isLocked()) {
            return;
        }
        String msg = "The callback context is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    public static void setBehaviorCommandHookOnThread(BehaviorCommandHook behaviorCommandHook) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setBehaviorCommandHook(behaviorCommandHook);
    }

    public static boolean isExistBehaviorCommandHookOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook() != null;
    }

    public static void clearBehaviorCommandHookOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setBehaviorCommandHook(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlFireHookOnThread(SqlFireHook sqlFireHook) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlFireHook(sqlFireHook);
    }

    public static boolean isExistSqlFireHookOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlFireHook() != null;
    }

    public static void clearSqlFireHookOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlFireHook(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlLogHandlerOnThread(SqlLogHandler sqlLogHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlLogHandler(sqlLogHandler);
    }

    public static boolean isExistSqlLogHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlLogHandler() != null;
    }

    public static void clearSqlLogHandlerOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlLogHandler(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlResultHandlerOnThread(SqlResultHandler sqlResultHandler) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlResultHandler(sqlResultHandler);
    }

    public static boolean isExistSqlResultHandlerOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlResultHandler() != null;
    }

    public static void clearSqlResultHandlerOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlResultHandler(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    public static void setSqlStringFilterOnThread(SqlStringFilter sqlStringFilter) {
        CallbackContext context = CallbackContext.getOrCreateContext();
        context.setSqlStringFilter(sqlStringFilter);
    }

    public static boolean isExistSqlStringFilterOnThread() {
        return CallbackContext.isExistCallbackContextOnThread() && CallbackContext.getCallbackContextOnThread().getSqlStringFilter() != null;
    }

    public static void clearSqlStringFilterOnThread() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            CallbackContext context = CallbackContext.getCallbackContextOnThread();
            context.setSqlStringFilter(null);
            CallbackContext.clearIfNoInterface(context);
        }
    }

    protected static CallbackContext getOrCreateContext() {
        if (CallbackContext.isExistCallbackContextOnThread()) {
            return CallbackContext.getCallbackContextOnThread();
        }
        CallbackContext context = new CallbackContext();
        CallbackContext.setCallbackContextOnThread(context);
        return context;
    }

    protected static void clearIfNoInterface(CallbackContext context) {
        if (!context.hasAnyInterface()) {
            CallbackContext.clearCallbackContextOnThread();
        }
    }

    public boolean hasAnyInterface() {
        return this._behaviorCommandHook != null || this._sqlFireHook != null || this._sqlLogHandler != null || this._sqlResultHandler != null || this._sqlStringFilter != null;
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":{behaviorCommandHook=").append(this._behaviorCommandHook);
        sb.append(", sqlFireHook=").append(this._sqlFireHook);
        sb.append(", sqlLogHandler=").append(this._sqlLogHandler);
        sb.append(", sqlResultHandler=").append(this._sqlResultHandler);
        sb.append(", sqlStringFilter=").append(this._sqlStringFilter);
        sb.append("}");
        return sb.toString();
    }

    public BehaviorCommandHook getBehaviorCommandHook() {
        return this._behaviorCommandHook;
    }

    public void setBehaviorCommandHook(BehaviorCommandHook behaviorCommandHook) {
        this._behaviorCommandHook = behaviorCommandHook != null && behaviorCommandHook.inheritsExistingHook() ? this.createInheritableBehaviorCommandHook(behaviorCommandHook) : behaviorCommandHook;
    }

    protected InheritableBehaviorCommandHook createInheritableBehaviorCommandHook(BehaviorCommandHook behaviorCommandHook) {
        return new InheritableBehaviorCommandHook(this._behaviorCommandHook, behaviorCommandHook);
    }

    public SqlFireHook getSqlFireHook() {
        return this._sqlFireHook;
    }

    public void setSqlFireHook(SqlFireHook sqlFireHook) {
        this._sqlFireHook = sqlFireHook != null && sqlFireHook.inheritsExistingHook() ? this.createInheritableSqlFireHook(sqlFireHook) : sqlFireHook;
    }

    protected InheritableSqlFireHook createInheritableSqlFireHook(SqlFireHook sqlFireHook) {
        return new InheritableSqlFireHook(this._sqlFireHook, sqlFireHook);
    }

    public SqlLogHandler getSqlLogHandler() {
        return this._sqlLogHandler;
    }

    public void setSqlLogHandler(SqlLogHandler sqlLogHandler) {
        this._sqlLogHandler = sqlLogHandler;
    }

    public SqlResultHandler getSqlResultHandler() {
        return this._sqlResultHandler;
    }

    public void setSqlResultHandler(SqlResultHandler sqlResultHandler) {
        this._sqlResultHandler = sqlResultHandler;
    }

    public SqlStringFilter getSqlStringFilter() {
        return this._sqlStringFilter;
    }

    public void setSqlStringFilter(SqlStringFilter sqlStringFilter) {
        this._sqlStringFilter = sqlStringFilter;
    }

    static {
        _holder = _defaultHolder = new CallbackContextHolder(){

            @Override
            public CallbackContext provide() {
                return _defaultThreadLocal.get();
            }

            @Override
            public void save(CallbackContext context) {
                _defaultThreadLocal.set(context);
            }
        };
        _locked = true;
    }

    protected static class InheritableSqlFireHook
    implements SqlFireHook {
        protected final SqlFireHook _originally;
        protected final SqlFireHook _yourHook;

        public InheritableSqlFireHook(SqlFireHook originally, SqlFireHook yourHook) {
            this._originally = originally;
            this._yourHook = yourHook;
        }

        @Override
        public void hookBefore(BehaviorCommandMeta meta, SqlFireReadyInfo fireReadyInfo) {
            if (this._originally != null) {
                this._originally.hookBefore(meta, fireReadyInfo);
            }
            this._yourHook.hookBefore(meta, fireReadyInfo);
        }

        @Override
        public void hookFinally(BehaviorCommandMeta meta, SqlFireResultInfo fireResultInfo) {
            this._yourHook.hookFinally(meta, fireResultInfo);
            if (this._originally != null) {
                this._originally.hookFinally(meta, fireResultInfo);
            }
        }
    }

    protected static class InheritableBehaviorCommandHook
    implements BehaviorCommandHook {
        protected final BehaviorCommandHook _originally;
        protected final BehaviorCommandHook _yourHook;

        public InheritableBehaviorCommandHook(BehaviorCommandHook originally, BehaviorCommandHook yourHook) {
            this._originally = originally;
            this._yourHook = yourHook;
        }

        @Override
        public void hookBefore(BehaviorCommandMeta meta) {
            if (this._originally != null) {
                this._originally.hookBefore(meta);
            }
            this._yourHook.hookBefore(meta);
        }

        @Override
        public void hookFinally(BehaviorCommandMeta meta, RuntimeException cause) {
            this._yourHook.hookFinally(meta, cause);
            if (this._originally != null) {
                this._originally.hookFinally(meta, cause);
            }
        }
    }

    public static interface CallbackContextHolder {
        public CallbackContext provide();

        public void save(CallbackContext var1);
    }
}

