/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.result;

import org.dbflute.cbean.paging.numberlink.PageNumberLinkOptionCall;
import org.dbflute.cbean.paging.numberlink.group.PageGroupBean;
import org.dbflute.cbean.paging.numberlink.group.PageGroupOption;
import org.dbflute.cbean.paging.numberlink.range.PageRangeBean;
import org.dbflute.cbean.paging.numberlink.range.PageRangeOption;
import org.dbflute.cbean.result.ListResultBean;
import org.dbflute.cbean.result.mapping.EntityDtoMapper;

public class PagingResultBean<ENTITY>
extends ListResultBean<ENTITY> {
    private static final long serialVersionUID = 1L;
    protected int _pageSize;
    protected int _currentPageNumber;

    public boolean existsPreviousPage() {
        return this._allRecordCount > 0 && this._currentPageNumber > 1;
    }

    public boolean existsNextPage() {
        return this._allRecordCount > 0 && this._currentPageNumber < this.getAllPageCount();
    }

    public boolean isExistPrePage() {
        return this.existsPreviousPage();
    }

    public boolean isExistNextPage() {
        return this.existsNextPage();
    }

    public PageGroupBean pageGroup(PageNumberLinkOptionCall<PageGroupOption> opLambda) {
        this.assertPageGroupOptionCall(opLambda);
        return this.createPageGroupBean(this.createPageGroupOption(opLambda));
    }

    protected void assertPageGroupOptionCall(PageNumberLinkOptionCall<PageGroupOption> opLambda) {
        if (opLambda == null) {
            throw new IllegalArgumentException("The argument 'opLambda' should not be null.");
        }
    }

    protected PageGroupOption createPageGroupOption(PageNumberLinkOptionCall<PageGroupOption> opLambda) {
        PageGroupOption op = this.newPageGroupOption();
        opLambda.callback(op);
        return op;
    }

    protected PageGroupOption newPageGroupOption() {
        return new PageGroupOption();
    }

    protected PageGroupBean createPageGroupBean(PageGroupOption op) {
        PageGroupBean bean = this.newPageGroupBean();
        bean.setPageGroupOption(op);
        bean.setCurrentPageNumber(this.getCurrentPageNumber());
        bean.setAllPageCount(this.getAllPageCount());
        return bean;
    }

    protected PageGroupBean newPageGroupBean() {
        return new PageGroupBean();
    }

    public PageRangeBean pageRange(PageNumberLinkOptionCall<PageRangeOption> opLambda) {
        this.assertPageRangeOptionCall(opLambda);
        return this.createPageRangeBean(this.createPageRangeOption(opLambda));
    }

    protected void assertPageRangeOptionCall(PageNumberLinkOptionCall<PageRangeOption> opLambda) {
        if (opLambda == null) {
            throw new IllegalArgumentException("The argument 'opLambda' should not be null.");
        }
    }

    protected PageRangeOption createPageRangeOption(PageNumberLinkOptionCall<PageRangeOption> opLambda) {
        PageRangeOption op = this.newPageRangeOption();
        opLambda.callback(op);
        return op;
    }

    protected PageRangeOption newPageRangeOption() {
        return new PageRangeOption();
    }

    protected PageRangeBean createPageRangeBean(PageRangeOption op) {
        PageRangeBean bean = this.newPageRangeBean();
        bean.setPageRangeOption(op);
        bean.setCurrentPageNumber(this.getCurrentPageNumber());
        bean.setAllPageCount(this.getAllPageCount());
        return bean;
    }

    protected PageRangeBean newPageRangeBean() {
        return new PageRangeBean();
    }

    protected int calculateAllPageCount(int allRecordCount, int pageSize) {
        if (allRecordCount == 0) {
            return 1;
        }
        int pageCountBase = allRecordCount / pageSize;
        if (allRecordCount % pageSize > 0) {
            ++pageCountBase;
        }
        return pageCountBase;
    }

    protected int calculateCurrentStartRecordNumber(int currentPageNumber, int pageSize) {
        return (currentPageNumber - 1) * pageSize + 1;
    }

    protected int calculateCurrentEndRecordNumber(int currentPageNumber, int pageSize) {
        int listSize = this._selectedList != null ? this._selectedList.size() : 1;
        return this.calculateCurrentStartRecordNumber(currentPageNumber, pageSize) + listSize - 1;
    }

    @Override
    public <DTO> PagingResultBean<DTO> mappingList(EntityDtoMapper<ENTITY, DTO> entityDtoMapper) {
        ListResultBean<DTO> ls = super.mappingList(entityDtoMapper);
        PagingResultBean<DTO> mappingList = new PagingResultBean<DTO>();
        mappingList.setSelectedList(ls.getSelectedList());
        mappingList.setTableDbName(this.getTableDbName());
        mappingList.setAllRecordCount(this.getAllRecordCount());
        mappingList.setOrderByClause(this.getOrderByClause());
        mappingList.setPageSize(this.getPageSize());
        mappingList.setCurrentPageNumber(this.getCurrentPageNumber());
        return mappingList;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this._pageSize;
        result = 31 * result + this._currentPageNumber;
        if (this._selectedList != null) {
            result = 31 * result + this._selectedList.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        boolean equals = super.equals(other);
        if (!equals) {
            return false;
        }
        if (!(other instanceof PagingResultBean)) {
            return false;
        }
        PagingResultBean otherBean = (PagingResultBean)other;
        if (this._pageSize != otherBean.getPageSize()) {
            return false;
        }
        return this._currentPageNumber == otherBean.getCurrentPageNumber();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.getCurrentPageNumber()).append("/").append(this.getAllPageCount());
        sb.append(" of ").append(this.getAllRecordCount());
        sb.append(" ").append(this.existsPreviousPage()).append("/").append(this.existsNextPage());
        sb.append(" list=").append(this.size()).append(" page=").append(this.getPageSize());
        sb.append("}");
        sb.append(":selectedList=").append(this.getSelectedList());
        return sb.toString();
    }

    @Override
    public int getAllRecordCount() {
        return super.getAllRecordCount();
    }

    @Override
    public void setAllRecordCount(int allRecordCount) {
        super.setAllRecordCount(allRecordCount);
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public void setPageSize(int pageSize) {
        this._pageSize = pageSize;
    }

    public int getCurrentPageNumber() {
        return this._currentPageNumber;
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this._currentPageNumber = currentPageNumber;
    }

    public int getAllPageCount() {
        return this.calculateAllPageCount(this._allRecordCount, this._pageSize);
    }

    public int getPreviousPageNumber() {
        if (!this.existsPreviousPage()) {
            String msg = "The previous page should exist when you use previousPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._currentPageNumber - 1;
    }

    public int getNextPageNumber() {
        if (!this.existsNextPage()) {
            String msg = "The next page should exist when you use nextPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber;
            throw new IllegalStateException(msg);
        }
        return this._currentPageNumber + 1;
    }

    public int getPrePageNumber() {
        return this.getPreviousPageNumber();
    }

    public int getCurrentStartRecordNumber() {
        return this.calculateCurrentStartRecordNumber(this._currentPageNumber, this._pageSize);
    }

    public int getCurrentEndRecordNumber() {
        return this.calculateCurrentEndRecordNumber(this._currentPageNumber, this._pageSize);
    }
}

