/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.twowaysql;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.dbflute.exception.ParameterCommentNotAllowedInitialCharacterException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.twowaysql.DisplaySqlBuilder;
import org.dbflute.twowaysql.SqlTokenizer;
import org.dbflute.twowaysql.context.CommandContext;
import org.dbflute.twowaysql.context.CommandContextCreator;
import org.dbflute.twowaysql.exception.EndCommentNotFoundException;
import org.dbflute.twowaysql.exception.ForCommentExpressionEmptyException;
import org.dbflute.twowaysql.exception.IfCommentConditionEmptyException;
import org.dbflute.twowaysql.factory.DefaultNodeAdviceFactory;
import org.dbflute.twowaysql.factory.NodeAdviceFactory;
import org.dbflute.twowaysql.factory.SqlAnalyzerFactory;
import org.dbflute.twowaysql.node.BeginNode;
import org.dbflute.twowaysql.node.BindVariableNode;
import org.dbflute.twowaysql.node.ElseNode;
import org.dbflute.twowaysql.node.EmbeddedVariableNode;
import org.dbflute.twowaysql.node.ForNode;
import org.dbflute.twowaysql.node.IfNode;
import org.dbflute.twowaysql.node.LoopAbstractNode;
import org.dbflute.twowaysql.node.Node;
import org.dbflute.twowaysql.node.RootNode;
import org.dbflute.twowaysql.node.SqlConnectorAdjustable;
import org.dbflute.twowaysql.node.SqlConnectorNode;
import org.dbflute.twowaysql.node.SqlPartsNode;
import org.dbflute.twowaysql.node.VariableNode;
import org.dbflute.twowaysql.style.BoundDateDisplayStyle;
import org.dbflute.util.Srl;

public class SqlAnalyzer {
    protected static final NodeAdviceFactory _defaultNodeAdviceFactory = new DefaultNodeAdviceFactory();
    protected final String _specifiedSql;
    protected final boolean _blockNullParameter;
    protected final SqlTokenizer _tokenizer;
    protected boolean _overlookNativeBinding;
    protected boolean _switchBindingToReplaceOnlyEmbedded;
    protected final Stack<Node> _nodeStack = new Stack();
    protected boolean _inBeginScope;
    protected List<String> _researchIfCommentList;
    protected List<String> _researchForCommentList;
    protected List<String> _researchBindVariableCommentList;
    protected List<String> _researchEmbeddedVariableCommentList;

    public SqlAnalyzer(String sql, boolean blockNullParameter) {
        this._specifiedSql = this.filterAtFirst(sql);
        this._blockNullParameter = blockNullParameter;
        this._tokenizer = this.createSqlTokenizer(this._specifiedSql);
    }

    protected String filterAtFirst(String sql) {
        return this.removeTerminalMarkAtFirst(this.trimSqlAtFirst(sql));
    }

    protected String trimSqlAtFirst(String sql) {
        return sql.trim();
    }

    protected String removeTerminalMarkAtFirst(String sql) {
        return sql.endsWith(";") ? sql.substring(0, sql.length() - 1) : sql;
    }

    protected SqlTokenizer createSqlTokenizer(String sql) {
        SqlTokenizer tokenizer = this.newSqlTokenizer(sql);
        if (this._overlookNativeBinding) {
            tokenizer.overlookNativeBinding();
        }
        return tokenizer;
    }

    protected SqlTokenizer newSqlTokenizer(String sql) {
        return new SqlTokenizer(sql);
    }

    public SqlAnalyzer overlookNativeBinding() {
        this._overlookNativeBinding = true;
        this._tokenizer.overlookNativeBinding();
        return this;
    }

    public SqlAnalyzer switchBindingToReplaceOnlyEmbedded() {
        this._switchBindingToReplaceOnlyEmbedded = true;
        return this;
    }

    public Node analyze() {
        this.push(this.createRootNode());
        while (99 != this._tokenizer.next()) {
            this.parseToken();
        }
        return this.pop();
    }

    protected RootNode createRootNode() {
        return new RootNode();
    }

    protected void parseToken() {
        switch (this._tokenizer.getTokenType()) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
            }
        }
    }

    protected void parseSql() {
        String token = this._tokenizer.getToken();
        if (this.isElseMode()) {
            token = this.replaceString(token, "--", "");
        }
        String sql = token;
        Node node = this.peek();
        if (this.isSqlConnectorAdjustable(node)) {
            this.processSqlConnectorAdjustable(node, sql);
        } else {
            node.addChild(this.createSqlPartsNodeOutOfConnector(node, sql));
        }
    }

    protected void processSqlConnectorAdjustable(Node node, String sql) {
        SqlTokenizer st = this.createSqlTokenizer(sql);
        st.skipWhitespace();
        String skippedToken = st.skipToken();
        st.skipWhitespace();
        if (this.processSqlConnectorMark(node, sql)) {
            return;
        }
        if (this.processSqlConnectorCondition(node, st, skippedToken)) {
            return;
        }
        node.addChild(this.createSqlPartsNodeThroughConnector(node, sql));
    }

    protected boolean processSqlConnectorMark(Node node, String sql) {
        return this.doProcessSqlConnectorMark(node, sql, ",");
    }

    protected boolean doProcessSqlConnectorMark(Node node, String sql, String mark) {
        String ltrimmedSql = Srl.ltrim(sql);
        if (ltrimmedSql.startsWith(mark)) {
            String markSpace = mark + " ";
            String realMark = ltrimmedSql.startsWith(markSpace) ? markSpace : mark;
            node.addChild(this.createSqlConnectorNode(node, realMark, ltrimmedSql.substring(realMark.length())));
            return true;
        }
        return false;
    }

    protected boolean processSqlConnectorCondition(Node node, SqlTokenizer st, String skippedToken) {
        if ("and".equalsIgnoreCase(skippedToken) || "or".equalsIgnoreCase(skippedToken)) {
            node.addChild(this.createSqlConnectorNode(node, st.getBefore(), st.getAfter()));
            return true;
        }
        return false;
    }

    protected boolean isSqlConnectorAdjustable(Node node) {
        if (node.getChildSize() > 0) {
            return false;
        }
        return node instanceof SqlConnectorAdjustable && !this.isTopBegin(node);
    }

    protected void parseComment() {
        String comment = this._tokenizer.getToken();
        if (this.isTargetComment(comment)) {
            if (this.isBeginComment(comment)) {
                this.parseBegin();
            } else if (this.isIfComment(comment)) {
                this.parseIf();
            } else if (this.isForComment(comment)) {
                this.parseFor();
            } else if (this.isLoopVariableComment(comment)) {
                this.parseLoopVariable();
            } else {
                if (this.isEndComment(comment)) {
                    return;
                }
                this.parseCommentBindVariable();
            }
        } else if (Srl.is_NotNull_and_NotTrimmedEmpty(comment)) {
            if (this.isFrequentlyMistakePattern(comment)) {
                this.throwParameterCommentNotAllowedInitialCharacterException(comment);
            }
            String before = this._tokenizer.getBefore();
            String content = before.substring(before.lastIndexOf("/*"));
            this.peek().addChild(this.createSqlPartsNode(content));
        }
    }

    protected boolean isTargetComment(String comment) {
        if (Srl.is_Null_or_TrimmedEmpty(comment)) {
            return false;
        }
        return this.isSpecialInitChar(comment) || this.isTargetCommentFirstChar(comment);
    }

    protected boolean isSpecialInitChar(String comment) {
        return comment.startsWith("#current");
    }

    protected boolean isTargetCommentFirstChar(String comment) {
        return Character.isJavaIdentifierStart(comment.charAt(0));
    }

    protected boolean isFrequentlyMistakePattern(String comment) {
        return comment.startsWith(" pmb.");
    }

    protected void throwParameterCommentNotAllowedInitialCharacterException(String comment) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The initial character in the parameter comment was not allowed.");
        br.addItem("Advice");
        br.addElement("The parameter comment should start with identifier.");
        br.addElement("Fix like this:");
        br.addElement("  (x) - /* pmb.memberName */");
        br.addElement("  (o) - /*pmb.memberName*/");
        br.addElement("");
        br.addElement("Or rewrite your plain comment:");
        br.addElement("  (x) - /* pmb. so ...(as plain comment) */");
        br.addElement("  (o) - /* this is pmb. so ...(as plain comment) */");
        br.addItem("Checked Comment");
        br.addElement("/*" + comment + "*/");
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new ParameterCommentNotAllowedInitialCharacterException(msg);
    }

    protected boolean isBeginComment(String comment) {
        return "BEGIN".equals(comment);
    }

    protected void parseBegin() {
        BeginNode beginNode = this.createBeginNode();
        try {
            this._inBeginScope = true;
            this.peek().addChild(beginNode);
            this.push(beginNode);
            this.parseEnd();
        }
        finally {
            this._inBeginScope = false;
        }
    }

    protected BeginNode createBeginNode() {
        return this.newBeginNode();
    }

    protected BeginNode newBeginNode() {
        return new BeginNode(this._inBeginScope);
    }

    protected boolean isTopBegin(Node node) {
        if (!(node instanceof BeginNode)) {
            return false;
        }
        return !((BeginNode)node).isNested();
    }

    protected boolean isNestedBegin(Node node) {
        if (!(node instanceof BeginNode)) {
            return false;
        }
        return ((BeginNode)node).isNested();
    }

    protected boolean isIfComment(String comment) {
        return comment.startsWith("IF ");
    }

    protected void parseIf() {
        String comment = this._tokenizer.getToken();
        String condition = comment.substring("IF ".length()).trim();
        if (Srl.is_Null_or_TrimmedEmpty(condition)) {
            this.throwIfCommentConditionEmptyException();
        }
        IfNode ifNode = this.createIfNode(condition);
        this.peek().addChild(ifNode);
        this.push(ifNode);
        this.parseEnd();
    }

    protected IfNode createIfNode(String expr) {
        this.researchIfNeeds(this._researchIfCommentList, expr);
        return this.newIfNode(expr);
    }

    protected IfNode newIfNode(String expr) {
        return new IfNode(expr, this._specifiedSql);
    }

    protected void throwIfCommentConditionEmptyException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The condition of IF comment was empty!");
        br.addItem("Advice");
        br.addElement("Please confirm the IF comment expression.");
        br.addElement("Your IF comment might not have a condition.");
        br.addElement("For example:");
        br.addElement("  (x) - /*IF */XXX_ID = /*pmb.xxxId*/3/*END*/");
        br.addElement("  (o) - /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/");
        br.addItem("IF Comment");
        br.addElement(this._tokenizer.getToken());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentConditionEmptyException(msg);
    }

    protected void parseElse() {
        Node parent = this.peek();
        if (!(parent instanceof IfNode)) {
            return;
        }
        IfNode ifNode = (IfNode)this.pop();
        ElseNode elseNode = this.createElseNode();
        ifNode.setElseNode(elseNode);
        this.push(elseNode);
        this._tokenizer.skipWhitespace();
    }

    protected ElseNode createElseNode() {
        return this.newElseNode();
    }

    protected ElseNode newElseNode() {
        return new ElseNode();
    }

    protected boolean isForComment(String comment) {
        return comment.startsWith("FOR ");
    }

    protected void parseFor() {
        String comment = this._tokenizer.getToken();
        String condition = comment.substring("FOR ".length()).trim();
        if (Srl.is_Null_or_TrimmedEmpty(condition)) {
            this.throwForCommentExpressionEmptyException();
        }
        ForNode forNode = this.createForNode(condition);
        this.peek().addChild(forNode);
        this.push(forNode);
        this.parseEnd();
    }

    protected ForNode createForNode(String expr) {
        this.researchIfNeeds(this._researchForCommentList, expr);
        return this.newForNode(expr);
    }

    protected ForNode newForNode(String expr) {
        return new ForNode(expr, this._specifiedSql, this.getNodeAdviceFactory());
    }

    protected boolean isLoopVariableComment(String comment) {
        return comment.startsWith("FIRST") || comment.startsWith("NEXT") || comment.startsWith("LAST");
    }

    protected void parseLoopVariable() {
        String comment = this._tokenizer.getToken();
        String code = Srl.substringFirstFront(comment, " ");
        if (Srl.is_Null_or_TrimmedEmpty(code)) {
            String msg = "Unknown loop variable comment: " + comment;
            throw new IllegalStateException(msg);
        }
        ForNode.LoopVariableType type = ForNode.LoopVariableType.codeOf(code);
        if (type == null) {
            String msg = "Unknown loop variable comment: " + comment;
            throw new IllegalStateException(msg);
        }
        String condition = comment.substring(type.name().length()).trim();
        LoopAbstractNode loopFirstNode = this.createLoopFirstNode(condition, type);
        this.peek().addChild(loopFirstNode);
        if (Srl.count(condition, "'") < 2) {
            this.push(loopFirstNode);
            this.parseEnd();
        }
    }

    protected LoopAbstractNode createLoopFirstNode(String expr, ForNode.LoopVariableType type) {
        return type.createNode(expr, this._specifiedSql);
    }

    protected void throwForCommentExpressionEmptyException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The expression of FOR comment was empty!");
        br.addItem("Advice");
        br.addElement("Please confirm the FOR comment expression.");
        br.addElement("Your FOR comment might not have an expression.");
        br.addElement("For example:");
        br.addElement("  (x) - /*FOR */XXX_ID = /*#element*/3/*END*/");
        br.addElement("  (o) - /*FOR pmb.xxxList*/XXX_ID = /*#element*/3/*END*/");
        br.addItem("FOR Comment");
        br.addElement(this._tokenizer.getToken());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new ForCommentExpressionEmptyException(msg);
    }

    protected boolean isEndComment(String content) {
        return content != null && "END".equals(content);
    }

    protected void parseEnd() {
        int commentType = 2;
        while (99 != this._tokenizer.next()) {
            if (this._tokenizer.getTokenType() == 2 && this.isEndComment(this._tokenizer.getToken())) {
                this.pop();
                return;
            }
            this.parseToken();
        }
        this.throwEndCommentNotFoundException();
    }

    protected void throwEndCommentNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The end comment was not found!");
        br.addItem("Advice");
        br.addElement("Please confirm the parameter comment logic.");
        br.addElement("It may exist the parameter comment that DOESN'T have an end comment.");
        br.addElement("For example:");
        br.addElement("  (x): /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3");
        br.addElement("  (o): /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/");
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new EndCommentNotFoundException(msg);
    }

    protected void parseBindVariable() {
        String expr = this._tokenizer.getToken();
        this.peek().addChild(this.createBindVariableNode(expr, null));
    }

    protected void parseCommentBindVariable() {
        String expr = this._tokenizer.getToken();
        String testValue = this._tokenizer.skipToken(true);
        if (expr.startsWith("$")) {
            if (expr.startsWith("$$")) {
                this.peek().addChild(this.prepareReplaceOnlyEmbeddedVariableNode(expr, testValue, true));
            } else if (expr.startsWith("$.")) {
                this.peek().addChild(this.prepareTerminalDotEmbeddedVariableNode(expr, testValue));
            } else {
                this.peek().addChild(this.prepareNormalEmbeddedVariableNode(expr, testValue));
            }
        } else {
            VariableNode bindVariableNode = this._switchBindingToReplaceOnlyEmbedded ? this.prepareReplaceOnlyEmbeddedVariableNode(expr, testValue, false) : this.createBindVariableNode(expr, testValue);
            this.peek().addChild(bindVariableNode);
        }
    }

    protected EmbeddedVariableNode prepareReplaceOnlyEmbeddedVariableNode(String expr, String testValue, boolean removePrefix) {
        String realExpr = removePrefix ? expr.substring("$$".length()) : expr;
        return this.createEmbeddedVariableNode(realExpr, testValue, true, false);
    }

    protected EmbeddedVariableNode prepareTerminalDotEmbeddedVariableNode(String expr, String testValue) {
        String realExpr = expr.substring("$.".length());
        return this.createEmbeddedVariableNode(realExpr, testValue, false, true);
    }

    protected EmbeddedVariableNode prepareNormalEmbeddedVariableNode(String expr, String testValue) {
        String realExpr = expr.substring("$".length());
        return this.createEmbeddedVariableNode(realExpr, testValue, false, false);
    }

    protected EmbeddedVariableNode createEmbeddedVariableNode(String expr, String testValue, boolean replaceOnly, boolean terminalDot) {
        this.researchIfNeeds(this._researchEmbeddedVariableCommentList, expr);
        return this.newEmbeddedVariableNode(expr, testValue, replaceOnly, terminalDot);
    }

    protected EmbeddedVariableNode newEmbeddedVariableNode(String expr, String testValue, boolean replaceOnly, boolean terminalDot) {
        NodeAdviceFactory tracerFactory = this.getNodeAdviceFactory();
        return new EmbeddedVariableNode(expr, testValue, this._specifiedSql, this._blockNullParameter, tracerFactory, replaceOnly, terminalDot);
    }

    protected BindVariableNode createBindVariableNode(String expr, String testValue) {
        this.researchIfNeeds(this._researchBindVariableCommentList, expr);
        return this.newBindVariableNode(expr, testValue);
    }

    protected BindVariableNode newBindVariableNode(String expr, String testValue) {
        NodeAdviceFactory tracerFactory = this.getNodeAdviceFactory();
        return new BindVariableNode(expr, testValue, this._specifiedSql, this._blockNullParameter, tracerFactory);
    }

    protected SqlConnectorNode createSqlConnectorNode(Node node, String connector, String sqlParts) {
        if (this.isNestedBegin(node)) {
            return SqlConnectorNode.createSqlConnectorNodeAsIndependent(connector, sqlParts);
        }
        return SqlConnectorNode.createSqlConnectorNode(connector, sqlParts);
    }

    protected SqlPartsNode createSqlPartsNodeOutOfConnector(Node node, String sqlParts) {
        if (this.isTopBegin(node)) {
            return SqlPartsNode.createSqlPartsNodeAsIndependent(sqlParts);
        }
        return this.createSqlPartsNode(sqlParts);
    }

    protected SqlPartsNode createSqlPartsNodeThroughConnector(Node node, String sqlParts) {
        if (this.isNestedBegin(node)) {
            return SqlPartsNode.createSqlPartsNodeAsIndependent(sqlParts);
        }
        return this.createSqlPartsNode(sqlParts);
    }

    protected SqlPartsNode createSqlPartsNode(String sqlParts) {
        return SqlPartsNode.createSqlPartsNode(sqlParts);
    }

    protected Node pop() {
        return this._nodeStack.pop();
    }

    protected Node peek() {
        return this._nodeStack.peek();
    }

    protected void push(Node node) {
        this._nodeStack.push(node);
    }

    protected boolean isElseMode() {
        for (int i = 0; i < this._nodeStack.size(); ++i) {
            if (!(this._nodeStack.get(i) instanceof ElseNode)) continue;
            return true;
        }
        return false;
    }

    protected NodeAdviceFactory getNodeAdviceFactory() {
        return _defaultNodeAdviceFactory;
    }

    public List<String> researchIfComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchIfCommentList = resultList;
        return resultList;
    }

    public List<String> researchBindVariableComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchBindVariableCommentList = resultList;
        return resultList;
    }

    public List<String> researchEmbeddedVariableComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchEmbeddedVariableCommentList = resultList;
        return resultList;
    }

    protected void researchIfNeeds(List<String> researchList, String expr) {
        if (researchList != null) {
            researchList.add(expr);
        }
    }

    protected String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    public static String convertTwoWaySql2DisplaySql(SqlAnalyzerFactory factory, String twoWaySql, Object arg, BoundDateDisplayStyle dateDisplayStyle) {
        String[] argNames = new String[]{"pmb"};
        Class[] argTypes = new Class[]{arg.getClass()};
        Object[] args = new Object[]{arg};
        return SqlAnalyzer.convertTwoWaySql2DisplaySql(factory, twoWaySql, argNames, argTypes, args, dateDisplayStyle);
    }

    public static String convertTwoWaySql2DisplaySql(SqlAnalyzerFactory factory, String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args, BoundDateDisplayStyle dateDisplayStyle) {
        SqlAnalyzer parser = SqlAnalyzer.createSqlAnalyzer4DisplaySql(factory, twoWaySql);
        Node node = parser.analyze();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        String preparedSql = context.getSql();
        DisplaySqlBuilder builder = new DisplaySqlBuilder(dateDisplayStyle);
        return builder.buildDisplaySql(preparedSql, context.getBindVariables());
    }

    protected static SqlAnalyzer createSqlAnalyzer4DisplaySql(SqlAnalyzerFactory factory, String twoWaySql) {
        if (factory == null) {
            String msg = "The factory of SQL analyzer should exist.";
            throw new IllegalStateException(msg);
        }
        boolean blockNullParameter = false;
        SqlAnalyzer created = factory.create(twoWaySql, false);
        if (created != null) {
            return created;
        }
        String msg = "The factory should not return null:";
        msg = msg + " sql=" + twoWaySql + " factory=" + factory;
        throw new IllegalStateException(msg);
    }
}

