/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Srl {
    protected static final String HARF_LOWER_ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    protected static final String HARF_NUMBER = "0123456789";
    protected static final Set<Character> _alphabetHarfCharSet;
    protected static final Set<Character> _alphabetHarfLowerCharSet;
    protected static final Set<Character> _alphabetHarfUpperCharSet;
    protected static final Set<Character> _numberHarfCharSet;
    protected static final Set<Character> _alphabetHarfNumberHarfCharSet;
    protected static final Set<Character> _alphabetNumberHarfLowerCharSet;
    protected static final Set<Character> _alphabetNumberHarfUpperCharSet;

    public static boolean is_Null_or_Empty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean is_Null_or_TrimmedEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean is_NotNull_and_NotEmpty(String str) {
        return !Srl.is_Null_or_Empty(str);
    }

    public static boolean is_NotNull_and_NotTrimmedEmpty(String str) {
        return !Srl.is_Null_or_TrimmedEmpty(str);
    }

    public static boolean isEmpty(String str) {
        return str != null && str.length() == 0;
    }

    public static boolean isTrimmedEmpty(String str) {
        return str != null && str.trim().length() == 0;
    }

    public static int length(String str) {
        Srl.assertStringNotNull(str);
        return str.length();
    }

    public static String cut(String str, int length) {
        Srl.assertStringNotNull(str);
        return Srl.cut(str, length, null);
    }

    public static String cut(String str, int length, String suffix) {
        Srl.assertStringNotNull(str);
        return str.length() > length ? str.substring(0, length) + (suffix != null ? suffix : "") : str;
    }

    public static String toLowerCase(String str) {
        Srl.assertStringNotNull(str);
        return str.toLowerCase();
    }

    public static String toUpperCase(String str) {
        Srl.assertStringNotNull(str);
        return str.toUpperCase();
    }

    public static String trim(String str) {
        return Srl.doTrim(str, null);
    }

    public static String trim(String str, String trimStr) {
        return Srl.doTrim(str, trimStr);
    }

    public static String ltrim(String str) {
        return Srl.doLTrim(str, null);
    }

    public static String ltrim(String str, String trimStr) {
        return Srl.doLTrim(str, trimStr);
    }

    public static String rtrim(String str) {
        return Srl.doRTrim(str, null);
    }

    public static String rtrim(String str, String trimStr) {
        return Srl.doRTrim(str, trimStr);
    }

    protected static String doTrim(String str, String trimStr) {
        return Srl.doRTrim(Srl.doLTrim(str, trimStr), trimStr);
    }

    protected static String doLTrim(String str, String trimStr) {
        Srl.assertStringNotNull(str);
        if (trimStr == null) {
            String notTrimmedString = "a";
            String trimmed = (str + "a").trim();
            return trimmed.substring(0, trimmed.length() - "a".length());
        }
        String trimmed = str;
        while (trimmed.startsWith(trimStr)) {
            trimmed = Srl.substringFirstRear(trimmed, trimStr);
        }
        return trimmed;
    }

    protected static String doRTrim(String str, String trimStr) {
        Srl.assertStringNotNull(str);
        if (trimStr == null) {
            String notTrimmedString = "a";
            return ("a" + str).trim().substring("a".length());
        }
        String trimmed = str;
        while (trimmed.endsWith(trimStr)) {
            trimmed = Srl.substringLastFront(trimmed, trimStr);
        }
        return trimmed;
    }

    public static String replace(String str, String fromStr, String toStr) {
        Srl.assertStringNotNull(str);
        Srl.assertFromStringNotNull(fromStr);
        Srl.assertToStringNotNull(toStr);
        StringBuilder sb = null;
        int pos = 0;
        int pos2 = 0;
        while (true) {
            pos = str.indexOf(fromStr, pos2);
            if (pos2 == 0 && pos < 0) {
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (pos == 0) {
                sb.append(toStr);
                pos2 = fromStr.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(str.substring(pos2, pos));
            sb.append(toStr);
            pos2 = pos + fromStr.length();
        }
        sb.append(str.substring(pos2));
        return sb.toString();
    }

    public static String replaceBy(String str, Map<String, String> fromToMap) {
        Srl.assertStringNotNull(str);
        Srl.assertFromToMapNotNull(fromToMap);
        Set<Map.Entry<String, String>> entrySet = fromToMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            str = Srl.replace(str, entry.getKey(), entry.getValue());
        }
        return str;
    }

    public static String replaceScopeContent(String str, String fromStr, String toStr, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = Srl.extractScopeList(str, beginMark, endMark);
        if (scopeList.isEmpty()) {
            return str;
        }
        return scopeList.get(0).replaceContentOnBaseString(fromStr, toStr);
    }

    public static String replaceScopeInterspace(String str, String fromStr, String toStr, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = Srl.extractScopeList(str, beginMark, endMark);
        if (scopeList.isEmpty()) {
            return str;
        }
        return scopeList.get(0).replaceInterspaceOnBaseString(fromStr, toStr);
    }

    public static List<String> splitList(String str, String delimiter) {
        return Srl.doSplitList(str, delimiter, false);
    }

    public static List<String> splitListTrimmed(String str, String delimiter) {
        return Srl.doSplitList(str, delimiter, true);
    }

    protected static List<String> doSplitList(String str, String delimiter, boolean trim) {
        String element;
        Srl.assertStringNotNull(str);
        Srl.assertDelimiterNotNull(delimiter);
        ArrayList<String> list = new ArrayList<String>();
        int elementIndex = 0;
        int delimiterIndex = str.indexOf(delimiter);
        while (delimiterIndex >= 0) {
            element = str.substring(elementIndex, delimiterIndex);
            list.add(trim ? element.trim() : element);
            elementIndex = delimiterIndex + delimiter.length();
            delimiterIndex = str.indexOf(delimiter, elementIndex);
        }
        element = str.substring(elementIndex);
        list.add(trim ? element.trim() : element);
        return list;
    }

    public static IndexOfInfo indexOfFirst(String str, String ... delimiters) {
        return Srl.doIndexOfFirst(false, str, delimiters);
    }

    public static IndexOfInfo indexOfFirstIgnoreCase(String str, String ... delimiters) {
        return Srl.doIndexOfFirst(true, str, delimiters);
    }

    protected static IndexOfInfo doIndexOfFirst(boolean ignoreCase, String str, String ... delimiters) {
        return Srl.doIndexOf(ignoreCase, false, str, delimiters);
    }

    public static IndexOfInfo indexOfLast(String str, String ... delimiters) {
        return Srl.doIndexOfLast(false, str, delimiters);
    }

    public static IndexOfInfo indexOfLastIgnoreCase(String str, String ... delimiters) {
        return Srl.doIndexOfLast(true, str, delimiters);
    }

    protected static IndexOfInfo doIndexOfLast(boolean ignoreCase, String str, String ... delimiters) {
        return Srl.doIndexOf(ignoreCase, true, str, delimiters);
    }

    protected static IndexOfInfo doIndexOf(boolean ignoreCase, boolean last, String str, String ... delimiters) {
        String filteredStr = ignoreCase ? str.toLowerCase() : str;
        int targetIndex = -1;
        String targetDelimiter = null;
        for (String delimiter : delimiters) {
            String filteredDelimiter = ignoreCase ? delimiter.toLowerCase() : delimiter;
            int index = last ? filteredStr.lastIndexOf(filteredDelimiter) : filteredStr.indexOf(filteredDelimiter);
            if (index < 0 || targetIndex >= 0 && !(last ? targetIndex < index : targetIndex > index)) continue;
            targetIndex = index;
            targetDelimiter = delimiter;
        }
        if (targetIndex < 0) {
            return null;
        }
        IndexOfInfo info = new IndexOfInfo();
        info.setBaseString(str);
        info.setIndex(targetIndex);
        info.setDelimiter(targetDelimiter);
        return info;
    }

    public static String substring(String str, int beginIndex) {
        Srl.assertStringNotNull(str);
        if (str.length() < beginIndex) {
            String msg = "The length of the string was smaller than the begin index:";
            msg = msg + " str=" + str + ", beginIndex=" + beginIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(beginIndex);
    }

    public static String substring(String str, int beginIndex, int endIndex) {
        Srl.assertStringNotNull(str);
        if (str.length() < beginIndex) {
            String msg = "The length of the string was smaller than the begin index:";
            msg = msg + " str=" + str + " beginIndex=" + beginIndex + " endIndex=" + endIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        if (str.length() < endIndex) {
            String msg = "The length of the string was smaller than the end index:";
            msg = msg + " str=" + str + " beginIndex=" + beginIndex + " endIndex=" + endIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        if (beginIndex > endIndex) {
            String msg = "The begin index was larger than the end index:";
            msg = msg + " str=" + str + " beginIndex=" + beginIndex + " endIndex=" + endIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String frontstring(String str, int index) {
        Srl.assertStringNotNull(str);
        if (str.length() < index) {
            String msg = "The length of the string was smaller than the index:";
            msg = msg + " str=" + str + " index=" + index;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(0, index);
    }

    public static String rearstring(String str, int reverseIndex) {
        Srl.assertStringNotNull(str);
        if (str.length() < reverseIndex) {
            String msg = "The length of the string was smaller than the index:";
            msg = msg + " str=" + str + " reverseIndex=" + reverseIndex;
            throw new StringIndexOutOfBoundsException(msg);
        }
        return str.substring(str.length() - reverseIndex);
    }

    public static String substringFirstFront(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(false, false, false, str, delimiters);
    }

    public static String substringFirstFrontIgnoreCase(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(false, false, true, str, delimiters);
    }

    public static String substringFirstRear(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(false, true, false, str, delimiters);
    }

    public static String substringFirstRearIgnoreCase(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(false, true, true, str, delimiters);
    }

    public static String substringLastFront(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(true, false, false, str, delimiters);
    }

    public static String substringLastFrontIgnoreCase(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(true, false, true, str, delimiters);
    }

    public static String substringLastRear(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(true, true, false, str, delimiters);
    }

    public static String substringLastRearIgnoreCase(String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        return Srl.doSubstringFirstRear(true, true, true, str, delimiters);
    }

    protected static final String doSubstringFirstRear(boolean last, boolean rear, boolean ignoreCase, String str, String ... delimiters) {
        Srl.assertStringNotNull(str);
        IndexOfInfo info = ignoreCase ? (last ? Srl.indexOfLastIgnoreCase(str, delimiters) : Srl.indexOfFirstIgnoreCase(str, delimiters)) : (last ? Srl.indexOfLast(str, delimiters) : Srl.indexOfFirst(str, delimiters));
        if (info == null) {
            return str;
        }
        if (rear) {
            return str.substring(info.getIndex() + info.getDelimiter().length());
        }
        return str.substring(0, info.getIndex());
    }

    public static boolean contains(String str, String keyword) {
        return Srl.containsAll(str, keyword);
    }

    public static boolean containsIgnoreCase(String str, String keyword) {
        return Srl.containsAllIgnoreCase(str, keyword);
    }

    public static boolean containsAll(String str, String ... keywords) {
        return Srl.doContainsAll(false, str, keywords);
    }

    public static boolean containsAllIgnoreCase(String str, String ... keywords) {
        return Srl.doContainsAll(true, str, keywords);
    }

    protected static boolean doContainsAll(boolean ignoreCase, String str, String ... keywords) {
        Srl.assertStringNotNull(str);
        if (keywords == null || keywords.length == 0) {
            return false;
        }
        if (ignoreCase) {
            str = str.toLowerCase();
        }
        for (String keyword : keywords) {
            if (ignoreCase) {
                String string = keyword = keyword != null ? keyword.toLowerCase() : null;
            }
            if (keyword != null && str.contains(keyword)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String str, String ... keywords) {
        return Srl.doContainsAny(false, str, keywords);
    }

    public static boolean containsAnyIgnoreCase(String str, String ... keywords) {
        return Srl.doContainsAny(true, str, keywords);
    }

    protected static boolean doContainsAny(boolean ignoreCase, String str, String ... keywords) {
        Srl.assertStringNotNull(str);
        if (keywords == null || keywords.length == 0) {
            return false;
        }
        if (ignoreCase) {
            str = str.toLowerCase();
        }
        for (String keyword : keywords) {
            if (ignoreCase) {
                String string = keyword = keyword != null ? keyword.toLowerCase() : null;
            }
            if (keyword == null || !str.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOrderedAll(String str, String ... keywords) {
        return Srl.doContainsOrderedAll(false, str, keywords);
    }

    public static boolean containsOrderedAllIgnoreCase(String str, String ... keywords) {
        return Srl.doContainsOrderedAll(true, str, keywords);
    }

    protected static boolean doContainsOrderedAll(boolean ignoreCase, String str, String ... keywords) {
        Srl.assertStringNotNull(str);
        if (keywords == null || keywords.length == 0) {
            return false;
        }
        if (ignoreCase) {
            str = str.toLowerCase();
        }
        String current = str;
        for (String keyword : keywords) {
            if (ignoreCase) {
                String string = keyword = keyword != null ? keyword.toLowerCase() : null;
            }
            if (keyword == null || !current.contains(keyword)) {
                return false;
            }
            current = Srl.substringFirstRear(current, keyword);
        }
        return true;
    }

    public static boolean containsElement(Collection<String> strList, String element) {
        return Srl.containsElementAll(strList, element);
    }

    public static boolean containsElementIgnoreCase(Collection<String> strList, String element) {
        return Srl.containsElementAllIgnoreCase(strList, element);
    }

    public static boolean containsElementAll(Collection<String> strList, String ... elements) {
        return Srl.doContainsElementAll(false, strList, elements);
    }

    public static boolean containsElementAllIgnoreCase(Collection<String> strList, String ... elements) {
        return Srl.doContainsElementAll(true, strList, elements);
    }

    protected static boolean doContainsElementAll(boolean ignoreCase, Collection<String> strList, String ... elements) {
        Srl.assertStringListNotNull(strList);
        Srl.assertElementVaryingNotNull(elements);
        return Srl.doContainsElement(true, ignoreCase, ListElementContainsType.EQUAL, strList, elements);
    }

    public static boolean containsElementAny(Collection<String> strList, String ... elements) {
        return Srl.doContainsElementAny(false, strList, elements);
    }

    public static boolean containsElementAnyIgnoreCase(Collection<String> strList, String ... elements) {
        return Srl.doContainsElementAny(true, strList, elements);
    }

    protected static boolean doContainsElementAny(boolean ignoreCase, Collection<String> strList, String ... elements) {
        Srl.assertStringListNotNull(strList);
        Srl.assertElementVaryingNotNull(elements);
        return Srl.doContainsElement(false, ignoreCase, ListElementContainsType.EQUAL, strList, elements);
    }

    protected static boolean doContainsElement(boolean all, boolean ignoreCase, ListElementContainsType type, Collection<String> strList, String ... elements) {
        Srl.assertStringListNotNull(strList);
        Srl.assertElementVaryingNotNull(elements);
        if (elements.length == 0) {
            return false;
        }
        for (String element : elements) {
            boolean exists = false;
            for (String current : strList) {
                boolean result = ignoreCase ? (ListElementContainsType.PREFIX.equals((Object)type) ? (current != null ? Srl.startsWithIgnoreCase(current, element) : false) : (ListElementContainsType.SUFFIX.equals((Object)type) ? (current != null ? Srl.endsWithIgnoreCase(current, element) : false) : (ListElementContainsType.KEYWORD.equals((Object)type) ? (current != null ? Srl.containsIgnoreCase(current, element) : false) : Srl.equalsIgnoreCase(current, element)))) : (ListElementContainsType.PREFIX.equals((Object)type) ? (current != null ? Srl.startsWith(current, element) : false) : (ListElementContainsType.SUFFIX.equals((Object)type) ? (current != null ? Srl.endsWith(current, element) : false) : (ListElementContainsType.KEYWORD.equals((Object)type) ? (current != null ? Srl.contains(current, element) : false) : Srl.equalsPlain(current, element))));
                if (!result) continue;
                exists = true;
            }
            if (all) {
                if (exists) continue;
                return false;
            }
            if (!exists) continue;
            return true;
        }
        return all;
    }

    public static boolean containsKeyword(Collection<String> strList, String keyword) {
        return Srl.containsKeywordAll(strList, keyword);
    }

    public static boolean containsKeywordIgnoreCase(Collection<String> strList, String keyword) {
        return Srl.containsKeywordAllIgnoreCase(strList, keyword);
    }

    public static boolean containsKeywordAll(Collection<String> strList, String ... keywords) {
        return Srl.doContainsKeywordAll(false, strList, keywords);
    }

    public static boolean containsKeywordAllIgnoreCase(Collection<String> strList, String ... keywords) {
        return Srl.doContainsKeywordAll(true, strList, keywords);
    }

    protected static boolean doContainsKeywordAll(boolean ignoreCase, Collection<String> strList, String ... keywords) {
        Srl.assertStringListNotNull(strList);
        Srl.assertKeywordVaryingNotNull(keywords);
        return Srl.doContainsElement(true, ignoreCase, ListElementContainsType.KEYWORD, strList, keywords);
    }

    public static boolean containsKeywordAny(Collection<String> strList, String ... keywords) {
        return Srl.doContainsKeywordAny(false, strList, keywords);
    }

    public static boolean containsKeywordAnyIgnoreCase(Collection<String> strList, String ... keywords) {
        return Srl.doContainsKeywordAny(true, strList, keywords);
    }

    protected static boolean doContainsKeywordAny(boolean ignoreCase, Collection<String> strList, String ... keywords) {
        Srl.assertStringListNotNull(strList);
        Srl.assertKeywordVaryingNotNull(keywords);
        return Srl.doContainsElement(false, ignoreCase, ListElementContainsType.KEYWORD, strList, keywords);
    }

    public static boolean containsPrefix(Collection<String> strList, String prefix) {
        return Srl.containsPrefixAll(strList, prefix);
    }

    public static boolean containsPrefixIgnoreCase(Collection<String> strList, String prefix) {
        return Srl.containsPrefixAllIgnoreCase(strList, prefix);
    }

    public static boolean containsPrefixAll(Collection<String> strList, String ... prefixes) {
        return Srl.doContainsPrefixAll(false, strList, prefixes);
    }

    public static boolean containsPrefixAllIgnoreCase(Collection<String> strList, String ... prefixes) {
        return Srl.doContainsPrefixAll(true, strList, prefixes);
    }

    protected static boolean doContainsPrefixAll(boolean ignoreCase, Collection<String> strList, String ... prefixes) {
        Srl.assertStringListNotNull(strList);
        return Srl.doContainsElement(true, ignoreCase, ListElementContainsType.PREFIX, strList, prefixes);
    }

    public static boolean containsPrefixAny(Collection<String> strList, String ... prefixes) {
        return Srl.doContainsPrefixAny(false, strList, prefixes);
    }

    public static boolean containsPrefixAnyIgnoreCase(Collection<String> strList, String ... prefixes) {
        return Srl.doContainsPrefixAny(true, strList, prefixes);
    }

    protected static boolean doContainsPrefixAny(boolean ignoreCase, Collection<String> strList, String ... prefixes) {
        Srl.assertStringListNotNull(strList);
        return Srl.doContainsElement(false, ignoreCase, ListElementContainsType.PREFIX, strList, prefixes);
    }

    public static boolean containsSuffix(Collection<String> strList, String suffix) {
        return Srl.containsSuffixAll(strList, suffix);
    }

    public static boolean containsSuffixIgnoreCase(Collection<String> strList, String suffix) {
        return Srl.containsSuffixAllIgnoreCase(strList, suffix);
    }

    public static boolean containsSuffixAll(Collection<String> strList, String ... suffixes) {
        return Srl.doContainsSuffixAll(false, strList, suffixes);
    }

    public static boolean containsSuffixAllIgnoreCase(Collection<String> strList, String ... suffixes) {
        return Srl.doContainsSuffixAll(true, strList, suffixes);
    }

    protected static boolean doContainsSuffixAll(boolean ignoreCase, Collection<String> strList, String ... suffixes) {
        Srl.assertStringListNotNull(strList);
        return Srl.doContainsElement(true, ignoreCase, ListElementContainsType.SUFFIX, strList, suffixes);
    }

    public static boolean containsSuffixAny(Collection<String> strList, String ... suffixes) {
        return Srl.doContainsSuffixAny(false, strList, suffixes);
    }

    public static boolean containsSuffixAnyIgnoreCase(Collection<String> strList, String ... suffixes) {
        return Srl.doContainsSuffixAny(true, strList, suffixes);
    }

    protected static boolean doContainsSuffixAny(boolean ignoreCase, Collection<String> strList, String ... suffixes) {
        Srl.assertStringListNotNull(strList);
        return Srl.doContainsElement(false, ignoreCase, ListElementContainsType.SUFFIX, strList, suffixes);
    }

    public static final boolean startsWith(String str, String ... prefixes) {
        return Srl.doStartsWith(false, str, prefixes);
    }

    public static final boolean startsWithIgnoreCase(String str, String ... prefixes) {
        return Srl.doStartsWith(true, str, prefixes);
    }

    protected static final boolean doStartsWith(boolean ignoreCase, String str, String ... prefixes) {
        Srl.assertStringNotNull(str);
        if (prefixes == null || prefixes.length == 0) {
            return false;
        }
        if (ignoreCase) {
            str = str.toLowerCase();
        }
        for (String prefix : prefixes) {
            if (ignoreCase) {
                String string = prefix = prefix != null ? prefix.toLowerCase() : null;
            }
            if (prefix == null || !str.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static final boolean endsWith(String str, String ... suffixes) {
        return Srl.doEndsWith(false, str, suffixes);
    }

    public static final boolean endsWithIgnoreCase(String str, String ... suffixes) {
        return Srl.doEndsWith(true, str, suffixes);
    }

    protected static final boolean doEndsWith(boolean ignoreCase, String str, String ... suffixes) {
        Srl.assertStringNotNull(str);
        if (suffixes == null || suffixes.length == 0) {
            return false;
        }
        if (ignoreCase) {
            str = str.toLowerCase();
        }
        for (String suffix : suffixes) {
            if (ignoreCase) {
                String string = suffix = suffix != null ? suffix.toLowerCase() : null;
            }
            if (suffix == null || !str.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasKeywordAll(String keyword, String ... strs) {
        return Srl.doHasKeywordAll(false, keyword, strs);
    }

    public static final boolean hasKeywordAllIgnoreCase(String keyword, String ... strs) {
        return Srl.doHasKeywordAll(true, keyword, strs);
    }

    protected static final boolean doHasKeywordAll(boolean ignoreCase, String keyword, String ... strs) {
        Srl.assertKeywordNotNull(keyword);
        return Srl.doHasKeyword(true, ignoreCase, KeywordType.CONTAIN, keyword, strs);
    }

    public static final boolean hasKeywordAny(String keyword, String ... strs) {
        return Srl.doHasKeywordAny(false, keyword, strs);
    }

    public static final boolean hasKeywordAnyIgnoreCase(String keyword, String ... strs) {
        return Srl.doHasKeywordAny(true, keyword, strs);
    }

    protected static final boolean doHasKeywordAny(boolean ignoreCase, String keyword, String ... strs) {
        Srl.assertKeywordNotNull(keyword);
        return Srl.doHasKeyword(false, ignoreCase, KeywordType.CONTAIN, keyword, strs);
    }

    protected static final boolean doHasKeyword(boolean all, boolean ignoreCase, KeywordType type, String keyword, String ... strs) {
        Srl.assertKeywordNotNull(keyword);
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (String str : strs) {
            boolean result;
            if (ignoreCase) {
                result = KeywordType.PREFIX.equals((Object)type) ? (str != null ? Srl.startsWithIgnoreCase(str, keyword) : false) : (KeywordType.SUFFIX.equals((Object)type) ? (str != null ? Srl.endsWithIgnoreCase(str, keyword) : false) : (str != null ? Srl.containsIgnoreCase(str, keyword) : false));
            } else if (KeywordType.PREFIX.equals((Object)type)) {
                result = str != null ? Srl.startsWith(str, keyword) : false;
            } else if (KeywordType.SUFFIX.equals((Object)type)) {
                result = str != null ? Srl.endsWith(str, keyword) : false;
            } else {
                boolean bl = result = str != null ? Srl.contains(str, keyword) : false;
            }
            if (all) {
                if (result) continue;
                return false;
            }
            if (!result) continue;
            return true;
        }
        return all;
    }

    public static final boolean hasPrefixAll(String prefix, String ... strs) {
        return Srl.doHasPrefixAll(false, prefix, strs);
    }

    public static final boolean hasPrefixAllIgnoreCase(String prefix, String ... strs) {
        return Srl.doHasPrefixAll(true, prefix, strs);
    }

    protected static final boolean doHasPrefixAll(boolean ignoreCase, String prefix, String ... strs) {
        Srl.assertPrefixNotNull(prefix);
        return Srl.doHasKeyword(true, ignoreCase, KeywordType.PREFIX, prefix, strs);
    }

    public static final boolean hasPrefixAny(String prefix, String ... strs) {
        return Srl.doHasPrefixAny(false, prefix, strs);
    }

    public static final boolean hasPrefixAnyIgnoreCase(String prefix, String ... strs) {
        return Srl.doHasPrefixAny(true, prefix, strs);
    }

    protected static final boolean doHasPrefixAny(boolean ignoreCase, String prefix, String ... strs) {
        Srl.assertPrefixNotNull(prefix);
        return Srl.doHasKeyword(false, ignoreCase, KeywordType.PREFIX, prefix, strs);
    }

    public static final boolean hasSuffixAll(String suffix, String ... strs) {
        return Srl.doHasSuffixAll(false, suffix, strs);
    }

    public static final boolean hasSuffixAllIgnoreCase(String suffix, String ... strs) {
        return Srl.doHasSuffixAll(true, suffix, strs);
    }

    protected static final boolean doHasSuffixAll(boolean ignoreCase, String suffix, String ... strs) {
        Srl.assertSuffixNotNull(suffix);
        return Srl.doHasKeyword(true, ignoreCase, KeywordType.SUFFIX, suffix, strs);
    }

    public static final boolean hasSuffixAny(String suffix, String ... strs) {
        return Srl.doHasSuffixAny(false, suffix, strs);
    }

    public static final boolean hasSuffixAnyIgnoreCase(String suffix, String ... strs) {
        return Srl.doHasSuffixAny(true, suffix, strs);
    }

    protected static final boolean doHasSuffixAny(boolean ignoreCase, String suffix, String ... strs) {
        Srl.assertSuffixNotNull(suffix);
        return Srl.doHasKeyword(false, ignoreCase, KeywordType.SUFFIX, suffix, strs);
    }

    public static int count(String str, String element) {
        return Srl.doCount(str, element, false);
    }

    public static int countIgnoreCase(String str, String element) {
        return Srl.doCount(str, element, true);
    }

    protected static int doCount(String str, String element, boolean ignoreCase) {
        int index;
        Srl.assertStringNotNull(str);
        Srl.assertElementNotNull(element);
        int count = 0;
        if (ignoreCase) {
            str = str.toLowerCase();
            element = element.toLowerCase();
        }
        while ((index = str.indexOf(element)) >= 0) {
            str = str.substring(index + element.length());
            ++count;
        }
        return count;
    }

    public static boolean equalsIgnoreCase(String str1, String ... strs) {
        if (strs != null) {
            for (String element : strs) {
                if ((str1 == null || !str1.equalsIgnoreCase(element)) && (str1 != null || element != null)) continue;
                return true;
            }
            return false;
        }
        return str1 == null;
    }

    public static boolean equalsFlexible(String str1, String ... strs) {
        if (strs != null) {
            str1 = str1 != null ? Srl.replace(str1, "_", "") : null;
            for (String element : strs) {
                String string = element = element != null ? Srl.replace(element, "_", "") : null;
                if ((str1 == null || !str1.equalsIgnoreCase(element)) && (str1 != null || element != null)) continue;
                return true;
            }
            return false;
        }
        return str1 == null;
    }

    public static boolean equalsFlexibleTrimmed(String str1, String ... strs) {
        String string = str1 = str1 != null ? str1.trim() : null;
        if (strs != null) {
            String[] trimmedStrs = new String[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                String element = strs[i];
                trimmedStrs[i] = element != null ? element.trim() : null;
            }
            return Srl.equalsFlexible(str1, trimmedStrs);
        }
        return Srl.equalsFlexible(str1, null);
    }

    public static boolean equalsPlain(String str1, String ... strs) {
        if (strs != null) {
            for (String element : strs) {
                if ((str1 == null || !str1.equals(element)) && (str1 != null || element != null)) continue;
                return true;
            }
            return false;
        }
        return str1 == null;
    }

    public static String connectByDelimiter(Collection<String> strList, String delimiter) {
        Srl.assertStringListNotNull(strList);
        return Srl.doConnectByDelimiter(strList, delimiter, null);
    }

    public static String connectByDelimiterQuoted(Collection<String> strList, String delimiter, String quotation) {
        Srl.assertStringListNotNull(strList);
        Srl.assertQuotationNotNull(quotation);
        return Srl.doConnectByDelimiter(strList, delimiter, quotation);
    }

    protected static String doConnectByDelimiter(Collection<String> strList, String delimiter, String quotation) {
        Srl.assertStringListNotNull(strList);
        StringBuilder sb = new StringBuilder();
        for (String str : strList) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(quotation != null ? Srl.quoteAnything(str != null ? str : "null", quotation) : str);
        }
        return sb.toString();
    }

    public static String connectPrefix(String str, String prefix, String delimiter) {
        Srl.assertStringNotNull(str);
        if (Srl.is_NotNull_and_NotTrimmedEmpty(prefix)) {
            return prefix + delimiter + str;
        }
        return str;
    }

    public static String connectSuffix(String str, String suffix, String delimiter) {
        Srl.assertStringNotNull(str);
        if (Srl.is_NotNull_and_NotTrimmedEmpty(suffix)) {
            return str + delimiter + suffix;
        }
        return str;
    }

    public static String removePrefix(String str, String prefix) {
        Srl.assertStringNotNull(str);
        if (Srl.startsWith(str, prefix)) {
            return Srl.substringFirstRear(str, prefix);
        }
        return str;
    }

    public static String removePrefixIgnoreCase(String str, String prefix) {
        Srl.assertStringNotNull(str);
        if (Srl.startsWithIgnoreCase(str, prefix)) {
            return Srl.substringFirstRearIgnoreCase(str, prefix);
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        Srl.assertStringNotNull(str);
        if (Srl.endsWith(str, suffix)) {
            return Srl.substringLastFront(str, suffix);
        }
        return str;
    }

    public static String removeSuffixIgnoreCase(String str, String suffix) {
        Srl.assertStringNotNull(str);
        if (Srl.endsWithIgnoreCase(str, suffix)) {
            return Srl.substringLastFrontIgnoreCase(str, suffix);
        }
        return str;
    }

    public static String rfill(String str, int size) {
        return Srl.doFill(str, size, false, Character.valueOf(' '));
    }

    public static String rfill(String str, int size, Character addedChar) {
        return Srl.doFill(str, size, false, addedChar);
    }

    public static String lfill(String str, int size) {
        return Srl.doFill(str, size, true, Character.valueOf(' '));
    }

    public static String lfill(String str, int size, Character addedChar) {
        return Srl.doFill(str, size, true, addedChar);
    }

    protected static String doFill(String str, int size, boolean left, Character addedChar) {
        Srl.assertStringNotNull(str);
        if (str.length() >= size) {
            return str;
        }
        int addSize = size - str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < addSize; ++i) {
            sb.append(addedChar);
        }
        if (left) {
            return sb + str;
        }
        return str + sb;
    }

    public static boolean isQuotedAnything(String str, String quotation) {
        Srl.assertStringNotNull(str);
        Srl.assertQuotationNotNull(quotation);
        return Srl.isQuotedAnything(str, quotation, quotation);
    }

    public static boolean isQuotedAnything(String str, String beginMark, String endMark) {
        Srl.assertStringNotNull(str);
        Srl.assertBeginMarkNotNull(beginMark);
        Srl.assertEndMarkNotNull(endMark);
        return str.length() > 1 && str.startsWith(beginMark) && str.endsWith(endMark);
    }

    public static boolean isQuotedDouble(String str) {
        Srl.assertStringNotNull(str);
        return Srl.isQuotedAnything(str, "\"");
    }

    public static boolean isQuotedSingle(String str) {
        Srl.assertStringNotNull(str);
        return Srl.isQuotedAnything(str, "'");
    }

    public static String quoteAnything(String str, String quotation) {
        Srl.assertStringNotNull(str);
        Srl.assertQuotationNotNull(quotation);
        return Srl.quoteAnything(str, quotation, quotation);
    }

    public static String quoteAnything(String str, String beginMark, String endMark) {
        Srl.assertStringNotNull(str);
        Srl.assertBeginMarkNotNull(beginMark);
        Srl.assertEndMarkNotNull(endMark);
        return beginMark + str + endMark;
    }

    public static String quoteDouble(String str) {
        Srl.assertStringNotNull(str);
        return Srl.quoteAnything(str, "\"");
    }

    public static String quoteSingle(String str) {
        Srl.assertStringNotNull(str);
        return Srl.quoteAnything(str, "'");
    }

    public static String unquoteAnything(String str, String quotation) {
        Srl.assertStringNotNull(str);
        Srl.assertQuotationNotNull(quotation);
        return Srl.unquoteAnything(str, quotation, quotation);
    }

    public static String unquoteAnything(String str, String beginMark, String endMark) {
        Srl.assertStringNotNull(str);
        Srl.assertBeginMarkNotNull(beginMark);
        Srl.assertEndMarkNotNull(endMark);
        if (!Srl.isQuotedAnything(str, beginMark, endMark)) {
            return str;
        }
        str = Srl.substring(str, beginMark.length());
        str = Srl.substring(str, 0, str.length() - endMark.length());
        return str;
    }

    public static String unquoteDouble(String str) {
        Srl.assertStringNotNull(str);
        return Srl.unquoteAnything(str, "\"");
    }

    public static String unquoteSingle(String str) {
        Srl.assertStringNotNull(str);
        return Srl.unquoteAnything(str, "'");
    }

    public static final List<DelimiterInfo> extractDelimiterList(String str, String delimiter) {
        int beginIndex;
        Srl.assertStringNotNull(str);
        Srl.assertDelimiterNotNull(delimiter);
        ArrayList<DelimiterInfo> delimiterList = new ArrayList<DelimiterInfo>();
        DelimiterInfo previous = null;
        String rear = str;
        while ((beginIndex = rear.indexOf(delimiter)) >= 0) {
            DelimiterInfo info = new DelimiterInfo();
            info.setBaseString(str);
            info.setDelimiter(delimiter);
            int absoluteIndex = (previous != null ? previous.getEndIndex() : 0) + beginIndex;
            info.setBeginIndex(absoluteIndex);
            info.setEndIndex(absoluteIndex + delimiter.length());
            if (previous != null) {
                info.setPrevious(previous);
                previous.setNext(info);
            }
            delimiterList.add(info);
            previous = info;
            rear = str.substring(info.getEndIndex());
        }
        return delimiterList;
    }

    public static final ScopeInfo extractScopeFirst(String str, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = Srl.doExtractScopeList(str, beginMark, endMark, true);
        if (scopeList == null || scopeList.isEmpty()) {
            return null;
        }
        if (scopeList.size() > 1) {
            String msg = "This method should extract only one scope: " + scopeList;
            throw new IllegalStateException(msg);
        }
        return scopeList.get(0);
    }

    public static final ScopeInfo extractScopeLast(String str, String beginMark, String endMark) {
        List<ScopeInfo> scopeList = Srl.doExtractScopeList(str, beginMark, endMark, false);
        if (scopeList == null || scopeList.isEmpty()) {
            return null;
        }
        return scopeList.get(scopeList.size() - 1);
    }

    public static final List<ScopeInfo> extractScopeList(String str, String beginMark, String endMark) {
        ArrayList scopeList = Srl.doExtractScopeList(str, beginMark, endMark, false);
        return scopeList != null ? scopeList : new ArrayList();
    }

    protected static final List<ScopeInfo> doExtractScopeList(String str, String beginMark, String endMark, boolean firstOnly) {
        int endIndex;
        int beginIndex;
        Srl.assertStringNotNull(str);
        Srl.assertBeginMarkNotNull(beginMark);
        Srl.assertEndMarkNotNull(endMark);
        ArrayList<ScopeInfo> resultList = null;
        ScopeInfo previous = null;
        String rear = str;
        while ((beginIndex = rear.indexOf(beginMark)) >= 0 && (rear = rear.substring(beginIndex)).length() > beginMark.length() && (endIndex = (rear = rear.substring(beginMark.length())).indexOf(endMark)) >= 0) {
            String scope = beginMark + rear.substring(0, endIndex + endMark.length());
            ScopeInfo info = new ScopeInfo();
            info.setBaseString(str);
            int absoluteIndex = (previous != null ? previous.getEndIndex() : 0) + beginIndex;
            info.setBeginIndex(absoluteIndex);
            info.setEndIndex(absoluteIndex + scope.length());
            info.setBeginMark(beginMark);
            info.setEndMark(endMark);
            info.setContent(Srl.rtrim(Srl.ltrim(scope, beginMark), endMark));
            info.setScope(scope);
            if (previous != null) {
                info.setPrevious(previous);
                previous.setNext(info);
            }
            if (resultList == null) {
                resultList = new ArrayList<ScopeInfo>();
            }
            resultList.add(info);
            if (previous == null && firstOnly) break;
            previous = info;
            rear = str.substring(info.getEndIndex());
        }
        return resultList;
    }

    public static final ScopeInfo extractScopeWide(String str, String beginMark, String endMark) {
        Srl.assertStringNotNull(str);
        Srl.assertBeginMarkNotNull(beginMark);
        Srl.assertEndMarkNotNull(endMark);
        IndexOfInfo first = Srl.indexOfFirst(str, beginMark);
        if (first == null) {
            return null;
        }
        IndexOfInfo last = Srl.indexOfLast(str, endMark);
        if (last == null) {
            return null;
        }
        String content = str.substring(first.getIndex() + first.getDelimiter().length(), last.getIndex());
        ScopeInfo info = new ScopeInfo();
        info.setBaseString(str);
        info.setBeginIndex(first.getIndex());
        info.setEndIndex(last.getIndex());
        info.setBeginMark(beginMark);
        info.setEndMark(endMark);
        info.setContent(content);
        info.setScope(beginMark + content + endMark);
        return info;
    }

    public static String removeScope(String str, String beginMark, String endMark) {
        Srl.assertStringNotNull(str);
        StringBuilder sb = new StringBuilder();
        String rear = str;
        while (true) {
            int beginIndex;
            if ((beginIndex = rear.indexOf(beginMark)) < 0) {
                sb.append(rear);
                break;
            }
            int endIndex = rear.indexOf(endMark);
            if (endIndex < 0) {
                sb.append(rear);
                break;
            }
            if (beginIndex > endIndex) {
                int borderIndex = endIndex + endMark.length();
                sb.append(rear.substring(0, borderIndex));
                rear = rear.substring(borderIndex);
                continue;
            }
            sb.append(rear.substring(0, beginIndex));
            rear = rear.substring(endIndex + endMark.length());
        }
        return sb.toString();
    }

    public static String removeEmptyLine(String str) {
        Srl.assertStringNotNull(str);
        StringBuilder sb = new StringBuilder();
        List<String> lineList = Srl.splitList(str, "\n");
        for (String line : lineList) {
            if (Srl.is_Null_or_TrimmedEmpty(line)) continue;
            sb.append(Srl.removeCR(line)).append("\n");
        }
        String filtered = sb.toString();
        return filtered.substring(0, filtered.length() - "\n".length());
    }

    public static String initCap(String str) {
        Srl.assertStringNotNull(str);
        if (Srl.is_Null_or_Empty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String initCapTrimmed(String str) {
        Srl.assertStringNotNull(str);
        str = str.trim();
        return Srl.initCap(str);
    }

    public static String initUncap(String str) {
        Srl.assertStringNotNull(str);
        if (Srl.is_Null_or_Empty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String initUncapTrimmed(String str) {
        Srl.assertStringNotNull(str);
        str = str.trim();
        return Srl.initUncap(str);
    }

    public static String initBeansProp(String capitalizedName) {
        Srl.assertObjectNotNull("capitalizedName", capitalizedName);
        if (Srl.is_Null_or_TrimmedEmpty(capitalizedName)) {
            return capitalizedName;
        }
        if (Srl.isInitTwoUpperCase(capitalizedName)) {
            return capitalizedName;
        }
        return Srl.initUncap(capitalizedName);
    }

    public static boolean isInitLowerCase(String str) {
        Srl.assertStringNotNull(str);
        if (Srl.is_Null_or_Empty(str)) {
            return false;
        }
        return Srl.isLowerCase(str.charAt(0));
    }

    public static boolean isInitTwoLowerCase(String str) {
        Srl.assertStringNotNull(str);
        if (str.length() < 2) {
            return false;
        }
        return Srl.isLowerCase(str.charAt(0), str.charAt(1));
    }

    public static boolean isInitUpperCase(String str) {
        Srl.assertStringNotNull(str);
        if (Srl.is_Null_or_Empty(str)) {
            return false;
        }
        return Srl.isUpperCase(str.charAt(0));
    }

    public static boolean isInitTwoUpperCase(String str) {
        Srl.assertStringNotNull(str);
        if (str.length() < 2) {
            return false;
        }
        return Srl.isUpperCase(str.charAt(0), str.charAt(1));
    }

    public static String camelize(String decamelName) {
        Srl.assertDecamelNameNotNull(decamelName);
        return Srl.doCamelize(decamelName, "_");
    }

    public static String camelize(String decamelName, String ... delimiters) {
        Srl.assertDecamelNameNotNull(decamelName);
        String name = decamelName;
        for (String delimiter : delimiters) {
            name = Srl.doCamelize(name, delimiter);
        }
        return name;
    }

    protected static String doCamelize(String decamelName, String delimiter) {
        Srl.assertDecamelNameNotNull(decamelName);
        Srl.assertDelimiterNotNull(delimiter);
        if (Srl.is_Null_or_TrimmedEmpty(decamelName)) {
            return decamelName;
        }
        StringBuilder sb = new StringBuilder();
        List<String> partList = Srl.splitListTrimmed(decamelName, delimiter);
        for (String part : partList) {
            boolean allUpperCase = true;
            for (int i = 1; i < part.length(); ++i) {
                if (!Srl.isLowerCase(part.charAt(i))) continue;
                allUpperCase = false;
            }
            if (allUpperCase) {
                part = part.toLowerCase();
            }
            sb.append(Srl.initCap(part));
        }
        return sb.toString();
    }

    public static String decamelize(String camelName) {
        Srl.assertCamelNameNotNull(camelName);
        return Srl.doDecamelize(camelName, "_");
    }

    public static String decamelize(String camelName, String delimiter) {
        Srl.assertCamelNameNotNull(camelName);
        Srl.assertDelimiterNotNull(delimiter);
        return Srl.doDecamelize(camelName, delimiter);
    }

    protected static String doDecamelize(String camelName, String delimiter) {
        Srl.assertCamelNameNotNull(camelName);
        if (Srl.is_Null_or_TrimmedEmpty(camelName)) {
            return camelName;
        }
        if (camelName.length() == 1) {
            return camelName.toUpperCase();
        }
        StringBuilder sb = new StringBuilder();
        boolean previousLower = false;
        int pos = 0;
        for (int i = 1; i < camelName.length(); ++i) {
            char currentChar = camelName.charAt(i);
            if (Srl.isUpperCase(currentChar)) {
                if (sb.length() > 0 && previousLower) {
                    sb.append(delimiter);
                }
                sb.append(camelName.substring(pos, i).toUpperCase());
                pos = i;
                previousLower = false;
                continue;
            }
            if (!Srl.isLowerCase(currentChar)) continue;
            previousLower = true;
        }
        if (sb.length() > 0 && previousLower) {
            sb.append(delimiter);
        }
        sb.append(camelName.substring(pos, camelName.length()).toUpperCase());
        String generated = sb.toString();
        return Srl.replace(generated, delimiter + delimiter, delimiter);
    }

    public static String removeBlockComment(String sql) {
        Srl.assertSqlNotNull(sql);
        return Srl.removeScope(sql, "/*", "*/");
    }

    public static String removeLineComment(String sql) {
        Srl.assertSqlNotNull(sql);
        StringBuilder sb = new StringBuilder();
        List<String> lineList = Srl.splitList(sql, "\n");
        for (String line : lineList) {
            if (line == null || (line = Srl.removeCR(line)).trim().startsWith("--")) continue;
            List<DelimiterInfo> delimiterList = Srl.extractDelimiterList(line, "--");
            int realIndex = -1;
            block1: for (DelimiterInfo delimiter : delimiterList) {
                List<ScopeInfo> scopeList = Srl.extractScopeList(line, "/*", "*/");
                int delimiterIndex = delimiter.getBeginIndex();
                for (ScopeInfo scope : scopeList) {
                    if (scope.isBeforeScope(delimiterIndex)) break;
                    if (!scope.isInScope(delimiterIndex)) continue;
                    continue block1;
                }
                realIndex = delimiterIndex;
            }
            if (realIndex >= 0) {
                line = line.substring(0, realIndex);
            }
            sb.append(line).append("\n");
        }
        String filtered = sb.toString();
        return filtered.substring(0, filtered.length() - "\n".length());
    }

    protected static String removeCR(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\r", "");
    }

    public static String indent(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String indent(int size, String str) {
        List<String> lineList = Srl.splitList(Srl.removeCR(str), "\n");
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String element : lineList) {
            if (index > 0) {
                sb.append("\n");
            }
            sb.append(Srl.indent(size)).append(element);
            ++index;
        }
        return sb.toString();
    }

    public static boolean isAlphabetHarfAll(String str) {
        return Srl.isAnyCharAll(str, _alphabetHarfCharSet);
    }

    public static boolean isAlphabetHarfLowerAll(String str) {
        return Srl.isAnyCharAll(str, _alphabetHarfLowerCharSet);
    }

    public static boolean isAlphabetHarfUpperAll(String str) {
        return Srl.isAnyCharAll(str, _alphabetHarfUpperCharSet);
    }

    public static boolean isNumberHarfAll(String str) {
        return Srl.isAnyCharAll(str, _numberHarfCharSet);
    }

    public static boolean isAlphabetNumberHarfAll(String str) {
        return Srl.isAnyCharAll(str, _alphabetHarfNumberHarfCharSet);
    }

    public static boolean isAlphabetNumberHarfAllOr(String str, Character ... addedChars) {
        HashSet<Character> charSet = new HashSet<Character>(_alphabetHarfNumberHarfCharSet);
        for (Character ch : addedChars) {
            charSet.add(ch);
        }
        return Srl.isAnyCharAll(str, charSet);
    }

    public static boolean isAlphabetNumberHarfLowerAll(String str) {
        return Srl.isAnyCharAll(str, _alphabetNumberHarfLowerCharSet);
    }

    public static boolean isAlphabetNumberHarfUpperAll(String str) {
        return Srl.isAnyCharAll(str, _alphabetNumberHarfUpperCharSet);
    }

    protected static boolean isAnyCharAll(String str, Set<Character> charSet) {
        if (Srl.is_Null_or_Empty(str)) {
            return false;
        }
        char[] chAry = str.toCharArray();
        for (int i = 0; i < chAry.length; ++i) {
            char ch = chAry[i];
            if (charSet.contains(Character.valueOf(ch))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isLowerCase(char ch) {
        return Character.isLowerCase(ch);
    }

    protected static boolean isLowerCase(char ch1, char ch2) {
        return Srl.isLowerCase(ch1) && Srl.isLowerCase(ch2);
    }

    public static boolean isLowerCaseAll(String str) {
        Srl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Srl.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCaseAny(String str) {
        Srl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!Srl.isLowerCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected static boolean isUpperCase(char ch) {
        return Character.isUpperCase(ch);
    }

    protected static boolean isUpperCase(char ch1, char ch2) {
        return Srl.isUpperCase(ch1) && Srl.isUpperCase(ch2);
    }

    public static boolean isUpperCaseAll(String str) {
        Srl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Srl.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCaseAny(String str) {
        Srl.assertStringNotNull(str);
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!Srl.isUpperCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected static void assertStringNotNull(String str) {
        Srl.assertObjectNotNull("str", str);
    }

    protected static void assertStringListNotNull(Collection<String> strList) {
        Srl.assertObjectNotNull("strList", strList);
    }

    protected static void assertElementNotNull(String element) {
        Srl.assertObjectNotNull("element", element);
    }

    protected static void assertElementVaryingNotNull(String[] elements) {
        Srl.assertObjectNotNull("elements", elements);
    }

    protected static void assertKeywordNotNull(String keyword) {
        Srl.assertObjectNotNull("keyword", keyword);
    }

    protected static void assertKeywordVaryingNotNull(String[] keywords) {
        Srl.assertObjectNotNull("keywords", keywords);
    }

    protected static void assertPrefixNotNull(String prefix) {
        Srl.assertObjectNotNull("prefix", prefix);
    }

    protected static void assertSuffixNotNull(String suffix) {
        Srl.assertObjectNotNull("suffix", suffix);
    }

    protected static void assertFromToMapNotNull(Map<String, String> fromToMap) {
        Srl.assertObjectNotNull("fromToMap", fromToMap);
    }

    protected static void assertDelimiterNotNull(String delimiter) {
        Srl.assertObjectNotNull("delimiter", delimiter);
    }

    protected static void assertFromStringNotNull(String fromStr) {
        Srl.assertObjectNotNull("fromStr", fromStr);
    }

    protected static void assertToStringNotNull(String toStr) {
        Srl.assertObjectNotNull("toStr", toStr);
    }

    protected static void assertQuotationNotNull(String quotation) {
        Srl.assertObjectNotNull("quotation", quotation);
    }

    protected static void assertBeginMarkNotNull(String beginMark) {
        Srl.assertObjectNotNull("beginMark", beginMark);
    }

    protected static void assertEndMarkNotNull(String endMark) {
        Srl.assertObjectNotNull("endMark", endMark);
    }

    protected static void assertDecamelNameNotNull(String decamelName) {
        Srl.assertObjectNotNull("decamelName", decamelName);
    }

    protected static void assertCamelNameNotNull(String camelName) {
        Srl.assertObjectNotNull("camelName", camelName);
    }

    protected static void assertSqlNotNull(String sql) {
        Srl.assertObjectNotNull("sql", sql);
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected static void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        Srl.assertObjectNotNull("variableName", variableName);
        Srl.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        char[] chAry;
        HashSet<Character> setupSet = new HashSet<Character>();
        StringBuilder sb = new StringBuilder();
        sb.append(HARF_LOWER_ALPHABET);
        sb.append(sb.toString().toUpperCase());
        for (char ch : chAry = sb.toString().toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _alphabetHarfCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        sb = new StringBuilder();
        sb.append(HARF_LOWER_ALPHABET);
        for (char ch : chAry = sb.toString().toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _alphabetHarfLowerCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        sb = new StringBuilder();
        sb.append(HARF_LOWER_ALPHABET.toUpperCase());
        for (char ch : chAry = sb.toString().toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _alphabetHarfUpperCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        String chStr = HARF_NUMBER;
        for (char ch : chAry = HARF_NUMBER.toCharArray()) {
            setupSet.add(Character.valueOf(ch));
        }
        _numberHarfCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        setupSet.addAll(_alphabetHarfCharSet);
        setupSet.addAll(_numberHarfCharSet);
        _alphabetHarfNumberHarfCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        setupSet.addAll(_alphabetHarfLowerCharSet);
        setupSet.addAll(_numberHarfCharSet);
        _alphabetNumberHarfLowerCharSet = Collections.unmodifiableSet(setupSet);
        setupSet = new HashSet();
        setupSet.addAll(_alphabetHarfUpperCharSet);
        setupSet.addAll(_numberHarfCharSet);
        _alphabetNumberHarfUpperCharSet = Collections.unmodifiableSet(setupSet);
    }

    public static class ScopeInfo {
        protected String _baseString;
        protected int _beginIndex;
        protected int _endIndex;
        protected String beginMark;
        protected String endMark;
        protected String _content;
        protected String _scope;
        protected ScopeInfo _previous;
        protected ScopeInfo _next;

        public boolean isBeforeScope(int index) {
            return index < this._beginIndex;
        }

        public boolean isInScope(int index) {
            return index >= this._beginIndex && index <= this._endIndex;
        }

        public String replaceContentOnBaseString(String toStr) {
            List<ScopeInfo> scopeList = this.takeScopeList();
            StringBuilder sb = new StringBuilder();
            for (ScopeInfo scope : scopeList) {
                sb.append(scope.substringInterspaceToPrevious());
                sb.append(scope.getBeginMark());
                sb.append(toStr);
                sb.append(scope.getEndMark());
                if (scope.getNext() != null) continue;
                sb.append(scope.substringInterspaceToNext());
            }
            return sb.toString();
        }

        public String replaceContentOnBaseString(String fromStr, String toStr) {
            List<ScopeInfo> scopeList = this.takeScopeList();
            StringBuilder sb = new StringBuilder();
            for (ScopeInfo scope : scopeList) {
                sb.append(scope.substringInterspaceToPrevious());
                sb.append(scope.getBeginMark());
                sb.append(Srl.replace(scope.getContent(), fromStr, toStr));
                sb.append(scope.getEndMark());
                if (scope.getNext() != null) continue;
                sb.append(scope.substringInterspaceToNext());
            }
            return sb.toString();
        }

        public String replaceInterspaceOnBaseString(String fromStr, String toStr) {
            List<ScopeInfo> scopeList = this.takeScopeList();
            StringBuilder sb = new StringBuilder();
            for (ScopeInfo scope : scopeList) {
                sb.append(Srl.replace(scope.substringInterspaceToPrevious(), fromStr, toStr));
                sb.append(scope.getScope());
                if (scope.getNext() != null) continue;
                sb.append(Srl.replace(scope.substringInterspaceToNext(), fromStr, toStr));
            }
            return sb.toString();
        }

        protected List<ScopeInfo> takeScopeList() {
            ScopeInfo next;
            ScopeInfo previous;
            ScopeInfo scope = this;
            while ((previous = scope.getPrevious()) != null) {
                scope = previous;
            }
            ArrayList<ScopeInfo> scopeList = new ArrayList<ScopeInfo>();
            scopeList.add(scope);
            while ((next = scope.getNext()) != null) {
                scope = next;
                scopeList.add(next);
            }
            return scopeList;
        }

        public String substringInterspaceToPrevious() {
            int previousEndIndex = -1;
            if (this._previous != null) {
                previousEndIndex = this._previous.getEndIndex();
            }
            if (previousEndIndex >= 0) {
                return this._baseString.substring(previousEndIndex, this._beginIndex);
            }
            return this._baseString.substring(0, this._beginIndex);
        }

        public String substringInterspaceToNext() {
            int nextBeginIndex = -1;
            if (this._next != null) {
                nextBeginIndex = this._next.getBeginIndex();
            }
            if (nextBeginIndex >= 0) {
                return this._baseString.substring(this._endIndex, nextBeginIndex);
            }
            return this._baseString.substring(this._endIndex);
        }

        public String substringScopeToPrevious() {
            int previousBeginIndex = -1;
            if (this._previous != null) {
                previousBeginIndex = this._previous.getBeginIndex();
            }
            if (previousBeginIndex >= 0) {
                return this._baseString.substring(previousBeginIndex, this._endIndex);
            }
            return this._baseString.substring(0, this._endIndex);
        }

        public String substringScopeToNext() {
            int nextEndIndex = -1;
            if (this._next != null) {
                nextEndIndex = this._next.getEndIndex();
            }
            if (nextEndIndex >= 0) {
                return this._baseString.substring(this._beginIndex, nextEndIndex);
            }
            return this._baseString.substring(this._beginIndex);
        }

        public String toString() {
            return this._scope + ":(" + this._beginIndex + ", " + this._endIndex + ")";
        }

        public String getBaseString() {
            return this._baseString;
        }

        public void setBaseString(String baseString) {
            this._baseString = baseString;
        }

        public int getBeginIndex() {
            return this._beginIndex;
        }

        public void setBeginIndex(int beginIndex) {
            this._beginIndex = beginIndex;
        }

        public int getEndIndex() {
            return this._endIndex;
        }

        public void setEndIndex(int endIndex) {
            this._endIndex = endIndex;
        }

        public String getBeginMark() {
            return this.beginMark;
        }

        public void setBeginMark(String beginMark) {
            this.beginMark = beginMark;
        }

        public String getEndMark() {
            return this.endMark;
        }

        public void setEndMark(String endMark) {
            this.endMark = endMark;
        }

        public String getContent() {
            return this._content;
        }

        public void setContent(String content) {
            this._content = content;
        }

        public String getScope() {
            return this._scope;
        }

        public void setScope(String scope) {
            this._scope = scope;
        }

        public ScopeInfo getPrevious() {
            return this._previous;
        }

        public void setPrevious(ScopeInfo previous) {
            this._previous = previous;
        }

        public ScopeInfo getNext() {
            return this._next;
        }

        public void setNext(ScopeInfo next) {
            this._next = next;
        }
    }

    public static class DelimiterInfo {
        protected String _baseString;
        protected int _beginIndex;
        protected int _endIndex;
        protected String _delimiter;
        protected DelimiterInfo _previous;
        protected DelimiterInfo _next;

        public String substringInterspaceToPrevious() {
            int previousIndex = -1;
            if (this._previous != null) {
                previousIndex = this._previous.getBeginIndex();
            }
            if (previousIndex >= 0) {
                return this._baseString.substring(previousIndex + this._previous.getDelimiter().length(), this._beginIndex);
            }
            return this._baseString.substring(0, this._beginIndex);
        }

        public String substringInterspaceToNext() {
            int nextIndex = -1;
            if (this._next != null) {
                nextIndex = this._next.getBeginIndex();
            }
            if (nextIndex >= 0) {
                return this._baseString.substring(this._endIndex, nextIndex);
            }
            return this._baseString.substring(this._endIndex);
        }

        public String toString() {
            return this._delimiter + ":(" + this._beginIndex + ", " + this._endIndex + ")";
        }

        public String getBaseString() {
            return this._baseString;
        }

        public void setBaseString(String baseStr) {
            this._baseString = baseStr;
        }

        public int getBeginIndex() {
            return this._beginIndex;
        }

        public void setBeginIndex(int beginIndex) {
            this._beginIndex = beginIndex;
        }

        public int getEndIndex() {
            return this._endIndex;
        }

        public void setEndIndex(int endIndex) {
            this._endIndex = endIndex;
        }

        public String getDelimiter() {
            return this._delimiter;
        }

        public void setDelimiter(String delimiter) {
            this._delimiter = delimiter;
        }

        public DelimiterInfo getPrevious() {
            return this._previous;
        }

        public void setPrevious(DelimiterInfo previous) {
            this._previous = previous;
        }

        public DelimiterInfo getNext() {
            return this._next;
        }

        public void setNext(DelimiterInfo next) {
            this._next = next;
        }
    }

    protected static enum KeywordType {
        CONTAIN,
        PREFIX,
        SUFFIX;

    }

    protected static enum ListElementContainsType {
        EQUAL,
        KEYWORD,
        PREFIX,
        SUFFIX;

    }

    public static class IndexOfInfo {
        protected String _baseString;
        protected int _index;
        protected String _delimiter;

        public String substringFront() {
            return this._baseString.substring(0, this.getIndex());
        }

        public String substringFrontTrimmed() {
            return this.substringFront().trim();
        }

        public String substringRear() {
            return this._baseString.substring(this.getRearIndex());
        }

        public String substringRearTrimmed() {
            return this.substringRear().trim();
        }

        public int getRearIndex() {
            return this._index + this._delimiter.length();
        }

        public String getBaseString() {
            return this._baseString;
        }

        public void setBaseString(String baseStr) {
            this._baseString = baseStr;
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        public String getDelimiter() {
            return this._delimiter;
        }

        public void setDelimiter(String delimiter) {
            this._delimiter = delimiter;
        }
    }
}

