/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DfReflectionUtil {
    private static Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();
    private static Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();
    private static Map<String, Class<?>> primitiveClsssNameMap = new HashMap();
    private static final Method IS_BRIDGE_METHOD;
    private static final Method IS_SYNTHETIC_METHOD;

    private static Method getIsBridgeMethod() {
        try {
            return Method.class.getMethod("isBridge", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getIsSyntheticMethod() {
        try {
            return Method.class.getMethod("isSynthetic", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Class<?> forName(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            String msg = "The class was not found: class=" + className + " loader=" + loader;
            throw new ReflectionFailureException(msg, e);
        }
    }

    public static Object newInstance(Class<?> clazz) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            String msg = "Failed to instantiate the class: " + clazz;
            throw new ReflectionFailureException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the class: " + clazz;
            throw new ReflectionFailureException(msg, e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            String msg = "Such a method was not found:";
            msg = msg + " class=" + clazz + " argTypes=" + Arrays.asList(argTypes);
            throw new ReflectionFailureException(msg, e);
        }
    }

    public static Object newInstance(Constructor<?> constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            String msg = "Failed to instantiate the class: " + constructor;
            throw new ReflectionFailureException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the constructor: " + constructor;
            throw new ReflectionFailureException(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "The InvocationTargetException occurred: " + constructor;
            throw new ReflectionFailureException(msg, e.getTargetException());
        }
    }

    public static boolean isAssignableFrom(Class<?> toClass, Class<?> fromClass) {
        if (toClass == Object.class && !fromClass.isPrimitive()) {
            return true;
        }
        if (toClass.isPrimitive()) {
            fromClass = DfReflectionUtil.getPrimitiveClassIfWrapper(fromClass);
        }
        return toClass.isAssignableFrom(fromClass);
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        return wrapperToPrimitiveMap.get(clazz);
    }

    public static Class<?> getPrimitiveClassIfWrapper(Class<?> clazz) {
        Class<?> ret = DfReflectionUtil.getPrimitiveClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        return primitiveToWrapperMap.get(clazz);
    }

    public static Field getAccessibleField(Class<?> clazz, String fieldName) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        return DfReflectionUtil.findField(clazz, fieldName, VisibilityType.ACCESSIBLE);
    }

    public static Field getPublicField(Class<?> clazz, String fieldName) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        return DfReflectionUtil.findField(clazz, fieldName, VisibilityType.PUBLIC);
    }

    public static Field getWholeField(Class<?> clazz, String fieldName) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        return DfReflectionUtil.findField(clazz, fieldName, VisibilityType.WHOLE);
    }

    protected static Field findField(Class<?> clazz, String fieldName, VisibilityType visibilityType) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        for (Class<?> target = clazz; target != null && target != Object.class; target = target.getSuperclass()) {
            Field declaredField;
            try {
                declaredField = target.getDeclaredField(fieldName);
            }
            catch (SecurityException e) {
                String msg = "The security violation was found: " + fieldName;
                throw new IllegalStateException(msg, e);
            }
            catch (NoSuchFieldException continued) {
                continue;
            }
            int modifier = declaredField.getModifiers();
            if (DfReflectionUtil.isOutOfTargetForPublic(visibilityType, modifier) || DfReflectionUtil.isOutOfTargetForAccessible(visibilityType, modifier, clazz, target)) continue;
            return declaredField;
        }
        return null;
    }

    public static Object getValue(Field field, Object target) {
        DfReflectionUtil.assertObjectNotNull("field", field);
        try {
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the field: field=" + field + " target=" + target;
            throw new ReflectionFailureException(msg, e);
        }
    }

    public static Object getValueForcedly(Field field, Object target) {
        DfReflectionUtil.assertObjectNotNull("field", field);
        field.setAccessible(true);
        return DfReflectionUtil.getValue(field, target);
    }

    public static void setValue(Field field, Object target, Object value) {
        DfReflectionUtil.assertObjectNotNull("field", field);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the field: field=" + field + " target=" + target + " value=" + value;
            throw new ReflectionFailureException(msg, e);
        }
    }

    public static void setValueForcedly(Field field, Object target, Object value) {
        DfReflectionUtil.assertObjectNotNull("field", field);
        field.setAccessible(true);
        DfReflectionUtil.setValue(field, target, value);
    }

    public static boolean isStaticFinalField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isStatic(mod) && Modifier.isFinal(mod);
    }

    public static boolean isStaticVariableField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    public static boolean isInstanceFinalField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && Modifier.isFinal(mod);
    }

    public static boolean isInstanceVariableField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    public static boolean isPublicField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        DfReflectionUtil.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        return DfReflectionUtil.findMethod(clazz, methodName, argTypes, VisibilityType.ACCESSIBLE, false);
    }

    public static Method getAccessibleMethodFlexibly(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        DfReflectionUtil.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        return DfReflectionUtil.findMethod(clazz, methodName, argTypes, VisibilityType.ACCESSIBLE, true);
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        DfReflectionUtil.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        return DfReflectionUtil.findMethod(clazz, methodName, argTypes, VisibilityType.PUBLIC, false);
    }

    public static Method getPublicMethodFlexibly(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        DfReflectionUtil.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        return DfReflectionUtil.findMethod(clazz, methodName, argTypes, VisibilityType.PUBLIC, true);
    }

    public static Method getWholeMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        DfReflectionUtil.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        return DfReflectionUtil.findMethod(clazz, methodName, argTypes, VisibilityType.WHOLE, false);
    }

    public static Method getWholeMethodFlexibly(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        DfReflectionUtil.assertObjectNotNull("clazz", clazz);
        DfReflectionUtil.assertStringNotNullAndNotTrimmedEmpty("methodName", methodName);
        return DfReflectionUtil.findMethod(clazz, methodName, argTypes, VisibilityType.WHOLE, true);
    }

    protected static Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes, VisibilityType visibilityType, boolean flexibly) {
        Method method = DfReflectionUtil.doFindMethodBasic(clazz, methodName, argTypes, visibilityType);
        if (method != null) {
            return method;
        }
        if (flexibly && argTypes.length >= 1) {
            return DfReflectionUtil.doFindMethodFlexibly(clazz, methodName, argTypes, visibilityType);
        }
        return null;
    }

    protected static Method doFindMethodBasic(Class<?> clazz, String methodName, Class<?>[] argTypes, VisibilityType visibilityType) {
        for (Class<?> target = clazz; target != null && target != Object.class; target = target.getSuperclass()) {
            Method declaredMethod;
            try {
                declaredMethod = target.getDeclaredMethod(methodName, argTypes);
            }
            catch (SecurityException e) {
                String msg = "The security violation was found: " + methodName;
                throw new IllegalStateException(msg, e);
            }
            catch (NoSuchMethodException continued) {
                continue;
            }
            catch (NoClassDefFoundError e) {
                String msg = "No class definition: specified=" + clazz.getName() + "#" + methodName + "()";
                throw new IllegalStateException(msg, e);
            }
            int modifier = declaredMethod.getModifiers();
            if (DfReflectionUtil.isOutOfTargetForPublic(visibilityType, modifier) || DfReflectionUtil.isOutOfTargetForAccessible(visibilityType, modifier, clazz, target)) continue;
            return declaredMethod;
        }
        return null;
    }

    protected static Method doFindMethodFlexibly(Class<?> clazz, String methodName, Class<?>[] argTypes, VisibilityType visibilityType) {
        for (Class<?> target = clazz; target != null && target != Object.class; target = target.getSuperclass()) {
            Method[] methods = target.getDeclaredMethods();
            for (int methodIndex = 0; methodIndex < methods.length; ++methodIndex) {
                Method current = methods[methodIndex];
                int modifier = current.getModifiers();
                if (DfReflectionUtil.isOutOfTargetForPublic(visibilityType, modifier) || DfReflectionUtil.isOutOfTargetForAccessible(visibilityType, modifier, clazz, target) || !methodName.equals(current.getName())) continue;
                Class<?>[] types = current.getParameterTypes();
                if (!(types != null && types.length != 0 || argTypes != null && argTypes.length != 0)) {
                    return current;
                }
                if (types.length != argTypes.length) continue;
                boolean diff = false;
                for (int argIndex = 0; argIndex < types.length; ++argIndex) {
                    if (types[argIndex].isAssignableFrom(argTypes[argIndex])) continue;
                    diff = true;
                    break;
                }
                if (diff) continue;
                return current;
            }
        }
        return null;
    }

    protected static boolean isOutOfTargetForPublic(VisibilityType visibilityType, int modifier) {
        return visibilityType == VisibilityType.PUBLIC && !Modifier.isPublic(modifier);
    }

    protected static boolean isOutOfTargetForAccessible(VisibilityType visibilityType, int modifier, Class<?> clazz, Class<?> target) {
        return visibilityType == VisibilityType.ACCESSIBLE && clazz != target && DfReflectionUtil.isDefaultOrPrivate(modifier);
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        DfReflectionUtil.assertObjectNotNull("method", method);
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            String msg = "The InvocationTargetException occurred: ";
            msg = msg + " method=" + method + " target=" + target;
            msg = msg + " args=" + (args != null ? Arrays.asList(args) : "");
            throw new ReflectionFailureException(msg, t);
        }
        catch (IllegalArgumentException e) {
            String msg = "Illegal argument for the method:";
            msg = msg + " method=" + method + " target=" + target;
            msg = msg + " args=" + (args != null ? Arrays.asList(args) : "");
            throw new ReflectionFailureException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Illegal access to the method:";
            msg = msg + " method=" + method + " target=" + target;
            msg = msg + " args=" + (args != null ? Arrays.asList(args) : "");
            throw new ReflectionFailureException(msg, e);
        }
    }

    public static Object invokeForcedly(Method method, Object target, Object[] args) {
        DfReflectionUtil.assertObjectNotNull("method", method);
        if (!DfReflectionUtil.isPublicMethod(method) && !method.isAccessible()) {
            method.setAccessible(true);
        }
        return DfReflectionUtil.invoke(method, target, args);
    }

    public static Object invokeStatic(Method method, Object[] args) {
        DfReflectionUtil.assertObjectNotNull("method", method);
        return DfReflectionUtil.invoke(method, null, args);
    }

    public static boolean isPublicMethod(Method method) {
        int mod = method.getModifiers();
        return Modifier.isPublic(mod);
    }

    public static boolean isBridgeMethod(Method method) {
        if (IS_BRIDGE_METHOD == null) {
            return false;
        }
        return (Boolean)DfReflectionUtil.invoke(IS_BRIDGE_METHOD, method, null);
    }

    public static boolean isSyntheticMethod(Method method) {
        if (IS_SYNTHETIC_METHOD == null) {
            return false;
        }
        return (Boolean)DfReflectionUtil.invoke(IS_SYNTHETIC_METHOD, method, null);
    }

    public static boolean isPublic(int modifier) {
        return Modifier.isPublic(modifier);
    }

    protected static boolean isDefaultOrPrivate(int modifier) {
        return !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier);
    }

    public static boolean isStatic(int modifier) {
        return Modifier.isStatic(modifier);
    }

    public static Class<?> getGenericType(Type type) {
        return DfReflectionUtil.getRawClass(DfReflectionUtil.getGenericParameter(type, 0));
    }

    protected static boolean isTypeOf(Type type, Class<?> clazz) {
        if (Class.class.isInstance(type)) {
            return clazz.isAssignableFrom((Class)Class.class.cast(type));
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return DfReflectionUtil.isTypeOf(parameterizedType.getRawType(), clazz);
        }
        return false;
    }

    protected static Class<?> getRawClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return DfReflectionUtil.getRawClass(parameterizedType.getRawType());
        }
        if (WildcardType.class.isInstance(type)) {
            WildcardType wildcardType = (WildcardType)WildcardType.class.cast(type);
            Type[] types = wildcardType.getUpperBounds();
            return DfReflectionUtil.getRawClass(types[0]);
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> rawClass = DfReflectionUtil.getRawClass(genericArrayType.getGenericComponentType());
            return Array.newInstance(rawClass, 0).getClass();
        }
        return null;
    }

    protected static Type getGenericParameter(Type type, int index) {
        if (!ParameterizedType.class.isInstance(type)) {
            return null;
        }
        List<Type> genericParameter = DfReflectionUtil.getGenericParameterList(type);
        if (genericParameter.isEmpty()) {
            return null;
        }
        return genericParameter.get(index);
    }

    protected static List<Type> getGenericParameterList(Type type) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType paramType = (ParameterizedType)ParameterizedType.class.cast(type);
            return Arrays.asList(paramType.getActualTypeArguments());
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType arrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            return DfReflectionUtil.getGenericParameterList(arrayType.getGenericComponentType());
        }
        List emptyList = Collections.EMPTY_LIST;
        return emptyList;
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public static void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        DfReflectionUtil.assertObjectNotNull("variableName", variableName);
        DfReflectionUtil.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        primitiveToWrapperMap.put(Character.TYPE, Character.class);
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveClsssNameMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveClsssNameMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveClsssNameMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveClsssNameMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveClsssNameMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveClsssNameMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveClsssNameMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveClsssNameMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        IS_BRIDGE_METHOD = DfReflectionUtil.getIsBridgeMethod();
        IS_SYNTHETIC_METHOD = DfReflectionUtil.getIsSyntheticMethod();
    }

    public static class ReflectionFailureException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReflectionFailureException(String msg) {
            super(msg);
        }

        public ReflectionFailureException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static enum VisibilityType {
        ACCESSIBLE,
        PUBLIC,
        WHOLE;

    }
}

