/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DfCollectionUtil {
    private static final List<?> EMPTY_LIST = Collections.emptyList();
    private static final Map<?, ?> EMPTY_MAP = Collections.emptyMap();
    private static final Set<?> EMPTY_SET = Collections.emptySet();

    public static Class<?> findFirstElementType(Collection<?> collection) {
        for (Object object : collection) {
            if (object == null) continue;
            return object.getClass();
        }
        return null;
    }

    public static boolean hasValidElement(Collection<?> collection) {
        for (Object object : collection) {
            if (object == null) continue;
            return true;
        }
        return false;
    }

    public static <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return new ArrayList();
    }

    public static <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> elements) {
        ArrayList<ELEMENT> list = DfCollectionUtil.newArrayListSized(elements.size());
        list.addAll(elements);
        return list;
    }

    @SafeVarargs
    public static <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT ... elements) {
        ArrayList<ELEMENT> list = DfCollectionUtil.newArrayListSized(elements.length);
        for (ELEMENT element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <ELEMENT> ArrayList<ELEMENT> newArrayListSized(int size) {
        return new ArrayList(size);
    }

    public static <ELEMENT> List<ELEMENT> emptyList() {
        return EMPTY_LIST;
    }

    public static <ELEMENT> List<List<ELEMENT>> splitByLimit(List<ELEMENT> elementList, int limit) {
        ArrayList<List<ELEMENT>> valueList = DfCollectionUtil.newArrayList();
        int valueSize = elementList.size();
        int index = 0;
        int remainderSize = valueSize;
        do {
            int beginIndex = limit * index;
            int endPoint = beginIndex + limit;
            int endIndex = limit <= remainderSize ? endPoint : valueSize;
            ArrayList<ELEMENT> splitList = DfCollectionUtil.newArrayList();
            splitList.addAll(elementList.subList(beginIndex, endIndex));
            valueList.add(splitList);
            remainderSize = valueSize - endIndex;
            ++index;
        } while (remainderSize > 0);
        return valueList;
    }

    public static <ELEMENT> OrderDiff<ELEMENT> analyzeOrderDiff(List<ELEMENT> beforeUniqueList, List<ELEMENT> afterUniqueList) {
        LinkedHashSet<ELEMENT> linkedBeforeSet = DfCollectionUtil.newLinkedHashSet(beforeUniqueList);
        if (beforeUniqueList.size() != linkedBeforeSet.size()) {
            String msg = "The argument 'beforeList' should be unique: " + beforeUniqueList;
            throw new IllegalArgumentException(msg);
        }
        LinkedHashSet<ELEMENT> linkedAfterSet = DfCollectionUtil.newLinkedHashSet(afterUniqueList);
        if (afterUniqueList.size() != linkedAfterSet.size()) {
            String msg = "The argument 'afterList' should be unique: " + afterUniqueList;
            throw new IllegalArgumentException(msg);
        }
        ElementDiff<ELEMENT> elementDiff = DfCollectionUtil.analyzeElementDiff(linkedBeforeSet, linkedAfterSet);
        Set<ELEMENT> addedSet = elementDiff.getAddedSet();
        Set<ELEMENT> deletedSet = elementDiff.getDeletedSet();
        ArrayList<ELEMENT> beforeRemainingList = DfCollectionUtil.newArrayList(beforeUniqueList);
        beforeRemainingList.removeAll(deletedSet);
        ArrayList<ELEMENT> afterRemainingList = DfCollectionUtil.newArrayList(afterUniqueList);
        afterRemainingList.removeAll(addedSet);
        if (beforeRemainingList.size() != afterRemainingList.size()) {
            String msg = "The beforeRemainingList.size() should be the same as the afterRemainingList's:";
            msg = msg + " beforeRemainingList.size()=" + beforeRemainingList.size();
            msg = msg + " afterRemainingList.size()=" + afterRemainingList.size();
            throw new IllegalStateException(msg);
        }
        LinkedHashMap movedMap = DfCollectionUtil.newLinkedHashMap();
        DfCollectionUtil.doAnalyzeOrderChange(beforeRemainingList, afterRemainingList, movedMap);
        for (Map.Entry entry : movedMap.entrySet()) {
            int movedIndex;
            ELEMENT realPrevious;
            Object movedElement = entry.getKey();
            Object previousElement = ((OrderDiffDetail)entry.getValue()).getPreviousElement();
            if (previousElement.equals(realPrevious = afterUniqueList.get((movedIndex = afterUniqueList.indexOf(movedElement)) - 1))) continue;
            ((OrderDiffDetail)entry.getValue()).setPreviousElement(realPrevious);
        }
        OrderDiff orderDiff = new OrderDiff();
        orderDiff.setMovedMap(movedMap);
        return orderDiff;
    }

    protected static <ELEMENT> void doAnalyzeOrderChange(List<ELEMENT> beforeRemainingList, List<ELEMENT> afterRemainingList, Map<ELEMENT, OrderDiffDetail<ELEMENT>> movedMap) {
        ELEMENT movedElement = null;
        ELEMENT previousElement = null;
        for (int i = 0; i < beforeRemainingList.size(); ++i) {
            ELEMENT beforeElement = beforeRemainingList.get(i);
            int afterIndex = afterRemainingList.indexOf(beforeElement);
            if (i == afterIndex) continue;
            movedElement = beforeElement;
            previousElement = afterRemainingList.get(afterIndex - 1);
            break;
        }
        if (movedElement != null) {
            OrderDiffDetail<Object> diffResult = new OrderDiffDetail<Object>();
            diffResult.setMovedElement(movedElement);
            diffResult.setPreviousElement(previousElement);
            movedMap.put(movedElement, diffResult);
            List<Object> movedList = DfCollectionUtil.moveElementToIndex(beforeRemainingList, movedElement, previousElement);
            DfCollectionUtil.doAnalyzeOrderChange(movedList, afterRemainingList, movedMap);
        }
    }

    public static <ELEMENT> List<ELEMENT> moveElementToIndex(List<ELEMENT> list, ELEMENT fromElement, ELEMENT toElement) {
        DfCollectionUtil.assertObjectNotNull("list", list);
        int fromIndex = list.indexOf(fromElement);
        int toIndex = list.indexOf(toElement);
        return DfCollectionUtil.moveElementToIndex(list, fromIndex, toIndex);
    }

    public static <ELEMENT> List<ELEMENT> moveElementToIndex(List<ELEMENT> list, int fromIndex, int toIndex) {
        DfCollectionUtil.assertObjectNotNull("list", list);
        if (fromIndex == toIndex) {
            String msg = "The argument 'fromIndex' and 'toIndex' should not be same:";
            msg = msg + " fromIndex=" + fromIndex + " toIndex" + toIndex;
            throw new IllegalArgumentException(msg);
        }
        if (fromIndex < 0 || toIndex < 0) {
            String msg = "The argument 'fromIndex' and 'toIndex' should not be minus:";
            msg = msg + " fromIndex=" + fromIndex + " toIndex" + toIndex;
            throw new IllegalArgumentException(msg);
        }
        boolean fromLess = fromIndex < toIndex;
        ArrayList<ELEMENT> movedList = new ArrayList<ELEMENT>();
        int firstIndex = fromLess ? fromIndex : toIndex;
        int secondIndex = !fromLess ? fromIndex : toIndex;
        List<ELEMENT> first = list.subList(0, firstIndex);
        ELEMENT element = list.get(fromIndex);
        int adjustmentIndex = fromLess ? 1 : 0;
        List<ELEMENT> middle = list.subList(firstIndex + adjustmentIndex, secondIndex + adjustmentIndex);
        List<ELEMENT> last = list.subList(secondIndex + 1, list.size());
        movedList.addAll(first);
        if (!fromLess) {
            movedList.add(element);
        }
        movedList.addAll(middle);
        if (fromLess) {
            movedList.add(element);
        }
        movedList.addAll(last);
        return movedList;
    }

    public static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    public static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap(Map<KEY, VALUE> map) {
        return new HashMap<KEY, VALUE>(map);
    }

    public static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap(KEY key, VALUE value) {
        HashMap<KEY, VALUE> map = DfCollectionUtil.newHashMapSized(1);
        map.put(key, value);
        return map;
    }

    public static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap(KEY key1, VALUE value1, KEY key2, VALUE value2) {
        HashMap<KEY, VALUE> map = DfCollectionUtil.newHashMapSized(2);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <KEY, VALUE> HashMap<KEY, VALUE> newHashMapSized(int size) {
        return new HashMap(size);
    }

    public static <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(Map<KEY, VALUE> map) {
        return new LinkedHashMap<KEY, VALUE>(map);
    }

    public static <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key, VALUE value) {
        LinkedHashMap<KEY, VALUE> map = DfCollectionUtil.newLinkedHashMapSized(1);
        map.put(key, value);
        return map;
    }

    public static <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key1, VALUE value1, KEY key2, VALUE value2) {
        LinkedHashMap<KEY, VALUE> map = DfCollectionUtil.newLinkedHashMapSized(2);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMapSized(int size) {
        return new LinkedHashMap(size);
    }

    public static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap(Map<KEY, VALUE> map) {
        return new ConcurrentHashMap<KEY, VALUE>(map);
    }

    public static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap(KEY key, VALUE value) {
        ConcurrentHashMap<KEY, VALUE> map = DfCollectionUtil.newConcurrentHashMapSized(1);
        map.put(key, value);
        return map;
    }

    public static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap(KEY key1, VALUE value1, KEY key2, VALUE value2) {
        ConcurrentHashMap<KEY, VALUE> map = DfCollectionUtil.newConcurrentHashMapSized(2);
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMapSized(int size) {
        return new ConcurrentHashMap(size);
    }

    public static <KEY, VALUE> Map<KEY, VALUE> emptyMap() {
        return EMPTY_MAP;
    }

    public static <ELEMENT> HashSet<ELEMENT> newHashSet() {
        return new HashSet();
    }

    public static <ELEMENT> HashSet<ELEMENT> newHashSet(Collection<ELEMENT> elements) {
        HashSet<ELEMENT> set = DfCollectionUtil.newHashSetSized(elements.size());
        set.addAll(elements);
        return set;
    }

    @SafeVarargs
    public static <ELEMENT> HashSet<ELEMENT> newHashSet(ELEMENT ... elements) {
        HashSet<ELEMENT> set = DfCollectionUtil.newHashSetSized(elements.length);
        for (ELEMENT element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <ELEMENT> HashSet<ELEMENT> newHashSetSized(int size) {
        return new HashSet(size);
    }

    public static <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet(Collection<ELEMENT> elements) {
        LinkedHashSet<ELEMENT> set = DfCollectionUtil.newLinkedHashSetSized(elements.size());
        set.addAll(elements);
        return set;
    }

    @SafeVarargs
    public static <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet(ELEMENT ... elements) {
        LinkedHashSet<ELEMENT> set = DfCollectionUtil.newLinkedHashSetSized(elements.length);
        for (ELEMENT element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSetSized(int size) {
        return new LinkedHashSet(size);
    }

    public static <ELEMENT> Set<ELEMENT> emptySet() {
        return EMPTY_SET;
    }

    public static <ELEMENT> ElementDiff<ELEMENT> analyzeElementDiff(Set<ELEMENT> beforeCol, Set<ELEMENT> afterCol) {
        LinkedHashSet<ELEMENT> addedSet = DfCollectionUtil.newLinkedHashSet();
        LinkedHashSet<ELEMENT> deletedSet = DfCollectionUtil.newLinkedHashSet();
        LinkedHashSet<ELEMENT> remainingSet = DfCollectionUtil.newLinkedHashSet();
        for (ELEMENT beforeElement : beforeCol) {
            if (afterCol.contains(beforeElement)) {
                remainingSet.add(beforeElement);
                continue;
            }
            deletedSet.add(beforeElement);
        }
        for (ELEMENT afterElement : afterCol) {
            if (beforeCol.contains(afterElement)) continue;
            addedSet.add(afterElement);
        }
        ElementDiff<ELEMENT> elementDiff = new ElementDiff<ELEMENT>();
        elementDiff.setAddedSet(addedSet);
        elementDiff.setDeletedSet(deletedSet);
        elementDiff.setRemainingSet(remainingSet);
        return elementDiff;
    }

    public static <ELEMENT_TYPE, ID_TYPE> void orderAccordingTo(List<ELEMENT_TYPE> unorderedList, AccordingToOrderResource<ELEMENT_TYPE, ID_TYPE> resource) {
        DfCollectionUtil.assertObjectNotNull("unorderedList", unorderedList);
        if (unorderedList.isEmpty()) {
            return;
        }
        DfCollectionUtil.assertObjectNotNull("resource", resource);
        List<ID_TYPE> orderedUniqueIdList = resource.getOrderedUniqueIdList();
        DfCollectionUtil.assertObjectNotNull("resource.getOrderedUniqueIdList()", orderedUniqueIdList);
        if (orderedUniqueIdList.isEmpty()) {
            return;
        }
        final AccordingToOrderIdExtractor<ELEMENT_TYPE, ID_TYPE> idExtractor = resource.getIdExtractor();
        DfCollectionUtil.assertObjectNotNull("resource.getIdExtractor()", idExtractor);
        final LinkedHashMap<ID_TYPE, Integer> idIndexMap = new LinkedHashMap<ID_TYPE, Integer>();
        int index = 0;
        for (ID_TYPE id : orderedUniqueIdList) {
            if (idIndexMap.containsKey(id)) {
                String msg = "The id was duplicated: id=" + id + " orderedUniqueIdList=" + orderedUniqueIdList;
                throw new IllegalStateException(msg);
            }
            idIndexMap.put(id, index);
            ++index;
        }
        Comparator comp = new Comparator<ELEMENT_TYPE>(){

            @Override
            public int compare(ELEMENT_TYPE o1, ELEMENT_TYPE o2) {
                Object id1 = idExtractor.extractId(o1);
                Object id2 = idExtractor.extractId(o2);
                DfCollectionUtil.assertObjectNotNull("id1 of " + o1, id1);
                DfCollectionUtil.assertObjectNotNull("id2 of " + o2, id2);
                Integer index1 = (Integer)idIndexMap.get(id1);
                Integer index2 = (Integer)idIndexMap.get(id2);
                if (index1 != null && index2 != null) {
                    return index1.compareTo(index2);
                }
                if (index1 == null && index2 == null) {
                    return 0;
                }
                return index1 == null ? 1 : -1;
            }
        };
        Collections.sort(unorderedList, comp);
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public static class AccordingToOrderResource<ELEMENT_TYPE, ID_TYPE> {
        protected List<ID_TYPE> _orderedUniqueIdList;
        protected AccordingToOrderIdExtractor<ELEMENT_TYPE, ID_TYPE> _idExtractor;

        public AccordingToOrderResource<ELEMENT_TYPE, ID_TYPE> setupResource(List<ID_TYPE> orderedUniqueIdList, AccordingToOrderIdExtractor<ELEMENT_TYPE, ID_TYPE> idExtractor) {
            this.setOrderedUniqueIdList(orderedUniqueIdList);
            this.setIdExtractor(idExtractor);
            return this;
        }

        public List<ID_TYPE> getOrderedUniqueIdList() {
            return this._orderedUniqueIdList;
        }

        public void setOrderedUniqueIdList(List<ID_TYPE> orderedUniqueIdList) {
            this._orderedUniqueIdList = orderedUniqueIdList;
        }

        public AccordingToOrderIdExtractor<ELEMENT_TYPE, ID_TYPE> getIdExtractor() {
            return this._idExtractor;
        }

        public void setIdExtractor(AccordingToOrderIdExtractor<ELEMENT_TYPE, ID_TYPE> idExtractor) {
            this._idExtractor = idExtractor;
        }
    }

    public static interface AccordingToOrderIdExtractor<ELEMENT_TYPE, ID_TYPE> {
        public ID_TYPE extractId(ELEMENT_TYPE var1);
    }

    public static class ElementDiff<ELEMENT> {
        protected Set<ELEMENT> _addedSet;
        protected Set<ELEMENT> _deletedSet;
        protected Set<ELEMENT> _remainingSet;

        public Set<ELEMENT> getAddedSet() {
            return this._addedSet;
        }

        public void setAddedSet(Set<ELEMENT> addedSet) {
            this._addedSet = addedSet;
        }

        public Set<ELEMENT> getDeletedSet() {
            return this._deletedSet;
        }

        public void setDeletedSet(Set<ELEMENT> deletedSet) {
            this._deletedSet = deletedSet;
        }

        public Set<ELEMENT> getRemainingSet() {
            return this._remainingSet;
        }

        public void setRemainingSet(Set<ELEMENT> remainingSet) {
            this._remainingSet = remainingSet;
        }
    }

    public static class OrderDiffDetail<ELEMENT> {
        protected ELEMENT _movedElement;
        protected ELEMENT _previousElement;

        public ELEMENT getMovedElement() {
            return this._movedElement;
        }

        public void setMovedElement(ELEMENT movedElement) {
            this._movedElement = movedElement;
        }

        public ELEMENT getPreviousElement() {
            return this._previousElement;
        }

        public void setPreviousElement(ELEMENT previousElement) {
            this._previousElement = previousElement;
        }
    }

    public static class OrderDiff<ELEMENT> {
        protected Map<ELEMENT, OrderDiffDetail<ELEMENT>> _movedMap;

        public Map<ELEMENT, OrderDiffDetail<ELEMENT>> getMovedMap() {
            return this._movedMap;
        }

        public void setMovedMap(Map<ELEMENT, OrderDiffDetail<ELEMENT>> movedMap) {
            this._movedMap = movedMap;
        }
    }
}

