/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.extension;

import java.util.Map;
import org.dbflute.Entity;
import org.dbflute.bhv.core.context.ConditionBeanContext;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.exception.RelationEntityNotFoundException;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThingExceptionThrower;
import org.dbflute.optional.RelationOptionalFactory;
import org.dbflute.outsidesql.OutsideSqlContext;
import org.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TnRelationRowOptionalHandler {
    private static final Logger _log = LoggerFactory.getLogger(TnRelationRowOptionalHandler.class);
    protected final RelationOptionalFactory _relationOptionalFactory;

    public TnRelationRowOptionalHandler(RelationOptionalFactory relationOptionalFactory) {
        this._relationOptionalFactory = relationOptionalFactory;
    }

    public Object filterOptionalRelationRowIfNeeds(Object row, TnRelationPropertyType rpt, Object relationRow) {
        DfPropertyDesc pd;
        Class<?> optionalType = this.getOptionalEntityType();
        if (optionalType.isAssignableFrom((pd = rpt.getPropertyDesc()).getPropertyType())) {
            if (relationRow == null) {
                return this.createOptionalNullEntity(row, rpt);
            }
            if (!optionalType.isInstance(relationRow)) {
                return this.createOptionalPresentEntity(relationRow);
            }
        }
        return relationRow;
    }

    protected Object createOptionalNullEntity(Object row, TnRelationPropertyType rpt) {
        return this._relationOptionalFactory.createOptionalNullEntity(this.createOptionalNullableThrower(row, rpt));
    }

    protected OptionalThingExceptionThrower createOptionalNullableThrower(final Object row, TnRelationPropertyType rpt) {
        Object parameterBean;
        String outsideSqlPath;
        final String propertyName = rpt.getPropertyDesc().getPropertyName();
        final DBMeta localDBMeta = rpt.getMyBeanMetaData().getDBMeta();
        final ConditionBean cb = ConditionBeanContext.isExistConditionBeanOnThread() ? ConditionBeanContext.getConditionBeanOnThread() : null;
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
            outsideSqlPath = context.getOutsideSqlPath();
            parameterBean = context.getParameterBean();
        } else {
            outsideSqlPath = null;
            parameterBean = null;
        }
        return new OptionalThingExceptionThrower(){

            @Override
            public void throwNotFoundException() {
                TnRelationRowOptionalHandler.this.throwRelationEntityNotFoundException(row, propertyName, localDBMeta, cb, outsideSqlPath, parameterBean);
            }
        };
    }

    protected void throwRelationEntityNotFoundException(Object row, String propertyName, DBMeta localDBMeta, ConditionBean cb, String outsideSqlPath, Object parameterBean) {
        String localSuffix;
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the relation entity.");
        br.addItem("Advice");
        br.addElement("Confirm the existence in your business rule.");
        br.addElement("If the relation entity might not exist, check it.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    List<Member> memberList = memberBhv.selectList(cb -> {");
        br.addElement("        cb.setupSelect_MemberServiceAsOne();");
        br.addElement("    });");
        br.addElement("    for (Member member : memberList) {");
        br.addElement("        ... = member.getMemberServiceAsOne().alwaysPresent(...); // *No");
        br.addElement("    }");
        br.addElement("  (o):");
        br.addElement("    List<Member> memberList = memberBhv.selectList(cb -> {");
        br.addElement("        cb.setupSelect_MemberServiceAsOne();");
        br.addElement("    });");
        br.addElement("    for (Member member : memberList) {");
        br.addElement("        member.getMemberServiceAsOne().ifPresent(service -> {  // OK");
        br.addElement("            ... = service.getServicePointCount();");
        br.addElement("        });");
        br.addElement("    }");
        br.addItem("Your Operation");
        String localTable = localDBMeta.getTableDbName();
        if (row instanceof Entity) {
            Map<String, Object> pkMap = localDBMeta.extractPrimaryKeyMap((Entity)row);
            localSuffix = pkMap.toString();
        } else {
            localSuffix = "{" + row + "}";
        }
        br.addElement(localTable + ":" + localSuffix + " => " + propertyName);
        if (row instanceof Entity) {
            Entity entity = (Entity)row;
            br.addItem("Local Entity");
            try {
                br.addElement(entity.toStringWithRelation());
            }
            catch (RuntimeException continued) {
                String tableDbName = entity.asTableDbName();
                String msg = "*Failed to build string from the entity for debug: " + tableDbName;
                if (_log.isDebugEnabled()) {
                    _log.debug(msg);
                }
                br.addElement(msg);
            }
        } else {
            br.addItem("Local Entity");
            br.addElement(row);
        }
        if (cb != null) {
            br.addItem("ConditionBean");
            try {
                String displaySql = cb.toDisplaySql();
                br.addElement(displaySql);
            }
            catch (RuntimeException continued) {
                String tableDbName = cb.asTableDbName();
                String msg = "*Failed to get display SQL from the condition-bean for debug: " + tableDbName;
                if (_log.isDebugEnabled()) {
                    _log.debug(msg);
                }
                br.addElement(msg);
            }
        }
        if (outsideSqlPath != null) {
            br.addItem("OutsideSql");
            br.addElement("path : " + outsideSqlPath);
            br.addElement("pmb  : " + parameterBean);
        }
        String msg = br.buildExceptionMessage();
        throw new RelationEntityNotFoundException(msg);
    }

    protected Object createOptionalPresentEntity(Object relationRow) {
        return this._relationOptionalFactory.createOptionalPresentEntity(relationRow);
    }

    public Class<?> getOptionalEntityType() {
        return this._relationOptionalFactory.getOptionalEntityType();
    }
}

