/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbmeta.accessory;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.dbflute.Entity;
import org.dbflute.exception.SpecifyDerivedReferrerInvalidAliasNameException;
import org.dbflute.exception.SpecifyDerivedReferrerPropertyValueNotFoundException;
import org.dbflute.exception.SpecifyDerivedReferrerUnknownAliasNameException;
import org.dbflute.exception.SpecifyDerivedReferrerUnmatchedPropertyTypeException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalScalar;

public class EntityDerivedMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> _derivedMap;

    public void registerDerivedValue(String aliasName, Object selectedValue) {
        this.getDerivedMap().put(aliasName, selectedValue);
    }

    public <VALUE> OptionalScalar<VALUE> findDerivedValue(Entity entity, String aliasName, Class<VALUE> propertyType) {
        Map<String, Object> derivedMap;
        if (aliasName == null) {
            throw new IllegalArgumentException("The argument 'aliasName' should not be null.");
        }
        if (propertyType == null) {
            throw new IllegalArgumentException("The argument 'propertyType' should not be null.");
        }
        if (aliasName.trim().length() == 0) {
            throw new IllegalArgumentException("The argument 'aliasName' should not be empty: [" + aliasName + "]");
        }
        if (!aliasName.startsWith("$")) {
            this.throwInvalidDerivedAliasNameException(entity, aliasName);
        }
        if (!(derivedMap = this.getDerivedMap()).containsKey(aliasName)) {
            this.throwUnknownDerivedAliasNameException(entity, aliasName, derivedMap);
        }
        try {
            VALUE found = propertyType.cast(derivedMap.get(aliasName));
            String tableDbName = entity.asTableDbName();
            return OptionalScalar.ofNullable(found, () -> this.throwDerivedPropertyValueNotFoundException(tableDbName, aliasName));
        }
        catch (ClassCastException e) {
            this.throwUnmatchDerivedPropertyTypeException(entity, aliasName, propertyType, e);
            return null;
        }
    }

    public boolean isEmpty() {
        return this.getDerivedMap().isEmpty();
    }

    public void clear() {
        this.getDerivedMap().clear();
    }

    public void remove(String aliasName) {
        this.getDerivedMap().remove(aliasName);
    }

    protected Map<String, Object> getDerivedMap() {
        if (this._derivedMap == null) {
            this._derivedMap = new HashMap<String, Object>(4);
        }
        return this._derivedMap;
    }

    protected void throwInvalidDerivedAliasNameException(Entity entity, String aliasName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Illegal alias name (not start with '$') for the derived property.");
        br.addItem("Advice");
        br.addElement("Make sure your alias name to find the derived value.");
        br.addElement("You should specify the name that starts with '$'.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, \"$HIGHEST_PURCHASE_PRICE\");");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    ... = member.derived(\"HIGHEST_PURCHASE_PRICE\", Integer.class); // *NG");
        br.addElement("  (o):");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, \"$HIGHEST_PURCHASE_PRICE\");");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    ... = member.derived(\"$HIGHEST_PURCHASE_PRICE\", Integer.class); // OK");
        br.addItem("Table");
        this.buildExceptionTableInfo(br, entity);
        br.addItem("Illegal Alias");
        br.addElement(aliasName);
        String msg = br.buildExceptionMessage();
        throw new SpecifyDerivedReferrerInvalidAliasNameException(msg);
    }

    protected void throwUnknownDerivedAliasNameException(Entity entity, String aliasName, Map<String, Object> derivedMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the alias name in the derived map");
        br.addItem("Advice");
        br.addElement("Make sure your alias name to find the derived value.");
        br.addElement("You should specify the name specified as DerivedReferrer.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    String highestAlias = \"$HIGHEST_PURCHASE_PRICE\"");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, highestAlias);");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    ... = member.derived(\"$BIG_SHOT\", Integer.class); // *NG");
        br.addElement("  (o):");
        br.addElement("    String highestAlias = \"$HIGHEST_PURCHASE_PRICE\"");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, highestAlias);");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    ... = member.derived(highestAlias, Integer.class); // OK");
        br.addItem("Table");
        this.buildExceptionTableInfo(br, entity);
        br.addItem("Unknown Alias");
        br.addElement(aliasName);
        this.buildExceptionExistingDerivedMapInfo(br, derivedMap);
        String msg = br.buildExceptionMessage();
        throw new SpecifyDerivedReferrerUnknownAliasNameException(msg);
    }

    protected void throwUnmatchDerivedPropertyTypeException(Entity entity, String aliasName, Class<?> propertyType, ClassCastException cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Illegal property type for the derived property.");
        br.addItem("Advice");
        br.addElement("Make sure your property type to find the derived value.");
        br.addElement("You should specify the matched type, it's rule is following:");
        br.addElement("  count()      : Integer");
        br.addElement("  max(), min() : (same as property type of the column)");
        br.addElement("  sum(), avg() : BigDecimal");
        br.addElement("");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    String highestAlias = \"$HIGHEST_PURCHASE_PRICE\"");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, highestAlias);");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    ... = member.derived(highestAlias, LocalDate.class); // *NG");
        br.addElement("  (o):");
        br.addElement("    String highestAlias = \"$HIGHEST_PURCHASE_PRICE\"");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, highestAlias);");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    ... = member.derived(highestAlias, Integer.class); // OK");
        this.buildExceptionTableInfo(br, entity);
        br.addItem("NotFound Alias");
        br.addElement(aliasName);
        br.addItem("Specified PropertyType");
        br.addElement(propertyType);
        this.buildExceptionExistingDerivedMapInfo(br, this.getDerivedMap());
        String msg = br.buildExceptionMessage();
        throw new SpecifyDerivedReferrerUnmatchedPropertyTypeException(msg, cause);
    }

    protected void buildExceptionTableInfo(ExceptionMessageBuilder br, Entity entity) {
        br.addItem("Table");
        br.addElement(entity.asTableDbName());
        try {
            br.addElement(entity.asDBMeta().extractPrimaryKeyMap(entity));
        }
        catch (RuntimeException continued) {
            br.addElement("*Failed to get PK info:");
            br.addElement(continued.getMessage());
        }
    }

    protected void buildExceptionExistingDerivedMapInfo(ExceptionMessageBuilder br, Map<String, Object> derivedMap) {
        br.addItem("Existing DerivedMap");
        for (Map.Entry<String, Object> entry : derivedMap.entrySet()) {
            Object value = entry.getValue();
            br.addElement(entry.getKey() + " = " + (value != null ? value.getClass() : null));
        }
    }

    protected void throwDerivedPropertyValueNotFoundException(String tableDbName, String aliasName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the derived property value.");
        br.addItem("Advice");
        br.addElement("Please confirm the existence your property value.");
        br.addElement("Especially e.g. max(), sum(), ... might return null if no referrer data");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    String highestAlias = \"$HIGHEST_PURCHASE_PRICE\"");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, highestAlias);");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    member.derived(highestAlias, Integer.class).alwaysPresent(...); // *NG");
        br.addElement("  (o):");
        br.addElement("    String highestAlias = \"$HIGHEST_PURCHASE_PRICE\"");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, highestAlias);");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    member.derived(highestAlias, Integer.class).ifPresent(...); // OK");
        br.addElement("  (o):");
        br.addElement("    String highestAlias = \"$HIGHEST_PURCHASE_PRICE\"");
        br.addElement("    cb.specify().derivedPurchaseList().max(purchaseCB -> {");
        br.addElement("        purchaseCB.specify().columnPurchasePrice();");
        br.addElement("    }, highestAlias, op -> op.coalesce(0)); // *point");
        br.addElement("    ...");
        br.addElement("    Member member = ...");
        br.addElement("    member.derived(highestAlias, Integer.class).alwaysPresent(...); // OK");
        br.addItem("Table");
        br.addElement(tableDbName);
        br.addItem("DerivedProperty (Alias)");
        br.addElement(aliasName);
        String msg = br.buildExceptionMessage();
        throw new SpecifyDerivedReferrerPropertyValueNotFoundException(msg);
    }

    public String toString() {
        return "derivedMap:" + this._derivedMap;
    }
}

