/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dbflute.cbean.result.ResultBeanBuilder;
import org.dbflute.cbean.result.grouping.GroupingListDeterminer;
import org.dbflute.cbean.result.grouping.GroupingListRowResource;
import org.dbflute.cbean.result.grouping.GroupingMapDeterminer;
import org.dbflute.cbean.result.mapping.EntityColumnExtractor;
import org.dbflute.cbean.result.mapping.EntityDtoMapper;
import org.dbflute.cbean.sqlclause.orderby.OrderByClause;

public class ListResultBean<ENTITY>
implements List<ENTITY>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String _tableDbName;
    protected int _allRecordCount;
    protected OrderByClause _orderByClause;
    protected List<ENTITY> _selectedList;

    public <DTO> ListResultBean<DTO> mappingList(EntityDtoMapper<ENTITY, DTO> entityLambda) {
        ArrayList<DTO> mappingList;
        if (this.hasWrappedListInstance()) {
            List<ENTITY> selectedList = this.getSelectedList();
            mappingList = new ArrayList<DTO>(selectedList.size());
            for (ENTITY entity : selectedList) {
                mappingList.add(entityLambda.map(entity));
            }
        } else {
            mappingList = null;
        }
        return this.createInheritedResultBean(mappingList);
    }

    public List<ListResultBean<ENTITY>> groupingList(GroupingListDeterminer<ENTITY> determiner) {
        ArrayList<ListResultBean<ENTITY>> groupingRowList = new ArrayList<ListResultBean<ENTITY>>();
        if (!this.hasWrappedListInstance()) {
            return groupingRowList;
        }
        GroupingListRowResource<ENTITY> rowResource = new GroupingListRowResource<ENTITY>();
        int rowElementIndex = 0;
        int wholeElementIndex = 0;
        List<ENTITY> selectedList = this.getSelectedList();
        for (ENTITY entity : selectedList) {
            rowResource.addGroupingEntity(entity);
            rowResource.setCurrentIndex(rowElementIndex);
            if (selectedList.size() == wholeElementIndex + 1) {
                groupingRowList.add(this.createInheritedResultBean(rowResource.getGroupingEntityList()));
                break;
            }
            ENTITY nextElement = selectedList.get(wholeElementIndex + 1);
            if (determiner.isBreakRow(rowResource, nextElement)) {
                groupingRowList.add(this.createInheritedResultBean(rowResource.getGroupingEntityList()));
                rowResource = new GroupingListRowResource();
                rowElementIndex = 0;
                ++wholeElementIndex;
                continue;
            }
            ++rowElementIndex;
            ++wholeElementIndex;
        }
        return groupingRowList;
    }

    public Map<String, ListResultBean<ENTITY>> groupingMap(GroupingMapDeterminer<ENTITY> entityLambda) {
        LinkedHashMap<String, ListResultBean<ENTITY>> groupingListMap = new LinkedHashMap<String, ListResultBean<ENTITY>>();
        if (!this.hasWrappedListInstance()) {
            return groupingListMap;
        }
        for (ENTITY entity : this.getSelectedList()) {
            String groupingKey = entityLambda.provideKey(entity);
            ListResultBean rowList = (ListResultBean)groupingListMap.get(groupingKey);
            if (rowList == null) {
                rowList = this.createInheritedResultBean(null);
                groupingListMap.put(groupingKey, rowList);
            }
            rowList.add(entity);
        }
        return groupingListMap;
    }

    public <COLUMN> List<COLUMN> extractColumnList(EntityColumnExtractor<ENTITY, COLUMN> entityLambda) {
        if (!this.hasWrappedListInstance()) {
            return new ArrayList(2);
        }
        List<ENTITY> selectedList = this.getSelectedList();
        ArrayList<COLUMN> columnList = new ArrayList<COLUMN>(selectedList.size());
        for (ENTITY entity : selectedList) {
            COLUMN column = entityLambda.extract(entity);
            if (column == null) continue;
            columnList.add(column);
        }
        return columnList;
    }

    public <COLUMN> Set<COLUMN> extractColumnSet(EntityColumnExtractor<ENTITY, COLUMN> entityLambda) {
        if (!this.hasWrappedListInstance()) {
            return new LinkedHashSet(2);
        }
        List<ENTITY> selectedList = this.getSelectedList();
        LinkedHashSet<COLUMN> columnSet = new LinkedHashSet<COLUMN>(selectedList.size());
        for (ENTITY entity : selectedList) {
            COLUMN column = entityLambda.extract(entity);
            if (column == null) continue;
            columnSet.add(column);
        }
        return columnSet;
    }

    public boolean isSelectedResult() {
        return this._tableDbName != null;
    }

    protected <ELEMENT> ListResultBean<ELEMENT> createInheritedResultBean(List<ELEMENT> selectedList) {
        ResultBeanBuilder<ELEMENT> builder = this.newResultBeanBuilder(this.getTableDbName());
        return builder.buildListInherited(this, selectedList);
    }

    protected <ELEMENT> ResultBeanBuilder<ELEMENT> newResultBeanBuilder(String tableDbName) {
        return new ResultBeanBuilder(tableDbName);
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this.hasWrappedListInstance()) {
            result = 31 * result + this.getSelectedList().hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof List)) {
            return false;
        }
        if (!this.hasWrappedListInstance()) {
            return false;
        }
        if (other instanceof ListResultBean) {
            return this.getSelectedList().equals(((ListResultBean)other).getSelectedList());
        }
        return this.getSelectedList().equals(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this._tableDbName);
        sb.append(",").append(this._allRecordCount);
        sb.append(",").append(this._orderByClause != null ? this._orderByClause.getOrderByClause() : null);
        sb.append(",").append(this._selectedList);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean add(ENTITY o) {
        return this.getSelectedList().add(o);
    }

    @Override
    public boolean addAll(Collection<? extends ENTITY> c) {
        return this.getSelectedList().addAll(c);
    }

    @Override
    public void clear() {
        if (this.hasWrappedListInstance()) {
            this.getSelectedList().clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.hasWrappedListInstance() ? this.getSelectedList().contains(o) : false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.hasWrappedListInstance() ? this.getSelectedList().containsAll(c) : false;
    }

    @Override
    public boolean isEmpty() {
        return this.hasWrappedListInstance() ? this.getSelectedList().isEmpty() : true;
    }

    @Override
    public Iterator<ENTITY> iterator() {
        return this.hasWrappedListInstance() ? this.getSelectedList().iterator() : this.createEmptyIterator();
    }

    protected Iterator<ENTITY> createEmptyIterator() {
        return new Iterator<ENTITY>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public ENTITY next() {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.getSelectedList().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getSelectedList().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getSelectedList().retainAll(c);
    }

    @Override
    public int size() {
        return this.getSelectedList().size();
    }

    @Override
    public Object[] toArray() {
        return this.getSelectedList().toArray();
    }

    @Override
    public <TYPE> TYPE[] toArray(TYPE[] a) {
        return this.getSelectedList().toArray(a);
    }

    @Override
    public void add(int index, ENTITY element) {
        this.getSelectedList().add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ENTITY> c) {
        return this.getSelectedList().addAll(index, c);
    }

    @Override
    public ENTITY get(int index) {
        return this.getSelectedList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getSelectedList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getSelectedList().lastIndexOf(o);
    }

    @Override
    public ListIterator<ENTITY> listIterator() {
        return this.getSelectedList().listIterator();
    }

    @Override
    public ListIterator<ENTITY> listIterator(int index) {
        return this.getSelectedList().listIterator(index);
    }

    @Override
    public ENTITY remove(int index) {
        return this.getSelectedList().remove(index);
    }

    @Override
    public ENTITY set(int index, ENTITY element) {
        return this.getSelectedList().set(index, element);
    }

    @Override
    public List<ENTITY> subList(int fromIndex, int toIndex) {
        return this.getSelectedList().subList(fromIndex, toIndex);
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public int getAllRecordCount() {
        return this._allRecordCount;
    }

    public void setAllRecordCount(int allRecordCount) {
        this._allRecordCount = allRecordCount;
    }

    public OrderByClause getOrderByClause() {
        if (this._orderByClause == null) {
            this._orderByClause = new OrderByClause();
        }
        return this._orderByClause;
    }

    public void setOrderByClause(OrderByClause orderByClause) {
        this._orderByClause = orderByClause;
    }

    public List<ENTITY> getSelectedList() {
        if (this._selectedList == null) {
            this._selectedList = new ArrayList<ENTITY>();
        }
        return this._selectedList;
    }

    public void setSelectedList(List<ENTITY> selectedList) {
        this._selectedList = selectedList;
    }

    protected boolean hasWrappedListInstance() {
        return this._selectedList != null;
    }
}

