/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.chelper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpQDRSetupper;
import org.dbflute.cbean.ckey.ConditionKey;
import org.dbflute.cbean.coption.ConditionOptionCall;
import org.dbflute.cbean.coption.DerivedReferrerOption;
import org.dbflute.cbean.coption.FromToOption;
import org.dbflute.cbean.coption.RangeOfOption;
import org.dbflute.cbean.scoping.SubQuery;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfTypeUtil;

public class HpQDRParameter<CB extends ConditionBean, PARAMETER> {
    protected final String _function;
    protected final SubQuery<CB> _subQuery;
    protected final DerivedReferrerOption _option;
    protected final HpQDRSetupper<CB> _setupper;

    public HpQDRParameter(String function, SubQuery<CB> subQuery, DerivedReferrerOption option, HpQDRSetupper<CB> setupper) {
        this._function = function;
        this._subQuery = subQuery;
        this._option = option;
        this._setupper = setupper;
    }

    public void equal(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_EQUAL.getOperand(), value, this._option);
    }

    public void notEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_NOT_EQUAL_STANDARD.getOperand(), value, this._option);
    }

    public void greaterThan(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_GREATER_THAN.getOperand(), value, this._option);
    }

    public void lessThan(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_LESS_THAN.getOperand(), value, this._option);
    }

    public void greaterEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_GREATER_EQUAL.getOperand(), value, this._option);
    }

    public void lessEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_LESS_EQUAL.getOperand(), value, this._option);
    }

    public void isNull() {
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_IS_NULL.getOperand(), null, this._option);
    }

    public void isNotNull() {
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_IS_NOT_NULL.getOperand(), null, this._option);
    }

    public void rangeOf(Number minNumber, Number maxNumber, ConditionOptionCall<RangeOfOption> opLambda) {
        this.doRangeOf(minNumber, maxNumber, this.createRangeOfOption(opLambda));
    }

    protected void doRangeOf(Number minNumber, Number maxNumber, RangeOfOption option) {
        this.assertRangeOfOption(option);
        this.assertRangeOfNotCalledUnsupported(minNumber, maxNumber, option);
        this.assertRangeOfNumberBothExistsOrOneSideAllowed(minNumber, maxNumber, option);
        Number fromValue = minNumber;
        Number toValue = maxNumber;
        this.dispatchFromTo(fromValue, toValue);
    }

    protected RangeOfOption createRangeOfOption(ConditionOptionCall<RangeOfOption> opLambda) {
        this.assertRangeOfOptionCall(opLambda);
        RangeOfOption op = this.newRangeOfOption();
        opLambda.callback(op);
        return op;
    }

    protected RangeOfOption newRangeOfOption() {
        return new RangeOfOption();
    }

    public void fromTo(LocalDate fromDate, LocalDate toDate, ConditionOptionCall<FromToOption> opLambda) {
        this.doFromTo(this.toDate(fromDate), this.toDate(toDate), this.createFromToOption(opLambda));
    }

    public void fromTo(LocalDateTime fromDate, LocalDateTime toDate, ConditionOptionCall<FromToOption> opLambda) {
        this.doFromTo(this.toDate(fromDate), this.toDate(toDate), this.createFromToOption(opLambda));
    }

    public void fromTo(Date fromDate, Date toDate, ConditionOptionCall<FromToOption> opLambda) {
        this.doFromTo(fromDate, toDate, this.createFromToOption(opLambda));
    }

    protected FromToOption createFromToOption(ConditionOptionCall<FromToOption> opLambda) {
        this.assertFromToOptionCall(opLambda);
        FromToOption op = this.newFromToOption();
        opLambda.callback(op);
        return op;
    }

    protected FromToOption newFromToOption() {
        return new FromToOption();
    }

    protected void doFromTo(Date fromDate, Date toDate, FromToOption option) {
        this.assertFromToOption(option);
        this.assertFromToNotCalledUnsupported(fromDate, toDate, option);
        this.assertFromToDateBothExistsOrOneSideAllowed(fromDate, toDate, option);
        if (fromDate != null) {
            fromDate = option.filterFromDate(fromDate);
        }
        if (toDate != null) {
            toDate = option.xfilterToDateBetweenWay(toDate);
        }
        Date fromValue = fromDate;
        Date toValue = toDate;
        this.dispatchFromTo(fromValue, toValue);
    }

    protected void dispatchFromTo(PARAMETER fromValue, PARAMETER toValue) {
        if (fromValue != null && toValue != null) {
            this.doBetween(fromValue, toValue);
        } else if (fromValue != null) {
            this.greaterEqual(fromValue);
        } else if (toValue != null) {
            this.lessEqual(toValue);
        }
    }

    protected void doBetween(PARAMETER fromValue, PARAMETER toValue) {
        this.assertParameterFromNotNull(fromValue);
        this.assertParameterToNotNull(toValue);
        ArrayList<PARAMETER> fromToValueList = new ArrayList<PARAMETER>(2);
        fromToValueList.add(fromValue);
        fromToValueList.add(toValue);
        this._setupper.setup(this._function, this._subQuery, this.getBetweenKeyword(), fromToValueList, this._option);
    }

    protected String getBetweenKeyword() {
        return "between";
    }

    protected Date toDate(Object obj) {
        return DfTypeUtil.toDate(obj, this.getFromToConversionTimeZone());
    }

    protected TimeZone getFromToConversionTimeZone() {
        return this.getDBFluteSystemFinalTimeZone();
    }

    protected TimeZone getDBFluteSystemFinalTimeZone() {
        return DBFluteSystem.getFinalTimeZone();
    }

    protected void assertParameterNotNull(Object value) {
        if (value == null) {
            String msg = "The argument 'value' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertRangeOfOptionCall(ConditionOptionCall<RangeOfOption> opLambda) {
        if (opLambda == null) {
            String msg = "The argument 'opLambda' for range-of option of (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertRangeOfOption(RangeOfOption option) {
        if (option == null) {
            String msg = "The argument 'option' of range-of for (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertRangeOfNotCalledUnsupported(Number minNumber, Number maxNumber, RangeOfOption option) {
        if (option.isGreaterThan() || option.isLessThan() || option.isOrIsNull()) {
            String msg = "Cannot use the options of the range-of for (Query)DerivedReferrer:";
            msg = msg + " min=" + minNumber + ", max=" + maxNumber + ", option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (option.hasCalculationRange()) {
            String msg = "Cannot use the calculation option of the range-of for (Query)DerivedReferrer:";
            msg = msg + " min=" + minNumber + ", max=" + maxNumber + ", option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertRangeOfNumberBothExistsOrOneSideAllowed(Number minNumber, Number maxNumber, RangeOfOption option) {
        boolean oneSideAllowed = option.isOneSideAllowed();
        if (minNumber == null && maxNumber == null) {
            String msg = "The both arguments of range-of for (Query)DerivedReferrer were null: " + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (minNumber == null && !oneSideAllowed) {
            String msg = "The argument 'minNumber' of range-of for (Query)DerivedReferrer was null:";
            msg = msg + " maxNumber=" + maxNumber + " option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (maxNumber == null && !oneSideAllowed) {
            String msg = "The argument 'maxNumber' of range-of for (Query)DerivedReferrer was null:";
            msg = msg + " minNumber=" + minNumber + " option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertFromToOptionCall(ConditionOptionCall<FromToOption> opLambda) {
        if (opLambda == null) {
            String msg = "The argument 'opLambda' for from-to option of (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertFromToOption(FromToOption option) {
        if (option == null) {
            String msg = "The argument 'option' of from-to for (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertFromToNotCalledUnsupported(Date fromDate, Date toDate, FromToOption option) {
        if (option.isGreaterThan() || option.isLessThan() || option.isOrIsNull()) {
            String msg = "Cannot use the options of the from-to for (Query)DerivedReferrer:";
            msg = msg + " from=" + fromDate + ", to=" + toDate + ", option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (option.isUsePattern()) {
            String msg = "Cannot use the pattern option .e.g compareAsDate() of the from-to for (Query)DerivedReferrer:";
            msg = msg + " from=" + fromDate + ", to=" + toDate + ", option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertFromToDateBothExistsOrOneSideAllowed(Date fromDate, Date toDate, FromToOption option) {
        boolean oneSideAllowed = option.isOneSideAllowed();
        if (fromDate == null && toDate == null) {
            String msg = "The both arguments of from-to for (Query)DerivedReferrer were null: " + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (fromDate == null && !oneSideAllowed) {
            String msg = "The argument 'fromDate' of from-to for (Query)DerivedReferrer was null:";
            msg = msg + " toDate=" + toDate + " option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (toDate == null && !oneSideAllowed) {
            String msg = "The argument 'toDate' of from-to for (Query)DerivedReferrer was null:";
            msg = msg + " fromDate=" + fromDate + " option=" + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertParameterFromNotNull(Object fromValue) {
        if (fromValue == null) {
            String msg = "The argument 'fromValue' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertParameterToNotNull(Object toValue) {
        if (toValue == null) {
            String msg = "The argument 'toValue' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    public static boolean isOperandIsNull(String operand) {
        return ConditionKey.CK_IS_NULL.getOperand().equals(operand);
    }
}

