/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.chelper;

import java.util.List;
import java.util.Map;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpCalcElement;
import org.dbflute.cbean.chelper.HpCalcStatement;
import org.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.dbflute.cbean.coption.ColumnConversionOption;
import org.dbflute.cbean.coption.FunctionFilterOptionCall;
import org.dbflute.cbean.dream.ColumnCalculator;
import org.dbflute.cbean.dream.SpecifiedColumn;
import org.dbflute.cbean.scoping.SpecifyQuery;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.name.ColumnRealName;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class HpCalcSpecification<CB extends ConditionBean>
implements ColumnCalculator,
HpCalcStatement {
    protected final SpecifyQuery<CB> _specifyQuery;
    protected ConditionBean _baseCB;
    protected CB _specifedCB;
    protected final List<HpCalcElement> _calculationList = DfCollectionUtil.newArrayList();
    protected boolean _leftMode;
    protected HpCalcSpecification<CB> _leftCalcSp;
    protected boolean _convert;
    protected boolean _synchronizeSetupSelectByJourneyLogBook;
    protected Object _mysticBindingSnapshot;

    public HpCalcSpecification(SpecifyQuery<CB> specifyQuery) {
        this._specifyQuery = specifyQuery;
    }

    public HpCalcSpecification(SpecifyQuery<CB> specifyQuery, ConditionBean baseCB) {
        this._specifyQuery = specifyQuery;
        this._baseCB = baseCB;
    }

    public void specify(CB cb) {
        this._specifyQuery.specify(cb);
        this._specifedCB = cb;
        if (this._baseCB == null) {
            this._baseCB = cb;
        }
    }

    public ColumnInfo getSpecifiedColumnInfo() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            SpecifiedColumn dreamCruiseTicket = this._specifedCB.xshowDreamCruiseTicket();
            return !dreamCruiseTicket.isDerived() ? dreamCruiseTicket.getColumnInfo() : null;
        }
        return this._specifedCB.getSqlClause().getSpecifiedColumnInfoAsOne();
    }

    public ColumnInfo getSpecifiedDerivingColumnInfo() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            SpecifiedColumn dreamCruiseTicket = this._specifedCB.xshowDreamCruiseTicket();
            return dreamCruiseTicket.isDerived() ? dreamCruiseTicket.getColumnInfo() : null;
        }
        return this._specifedCB.getSqlClause().getSpecifiedDerivingColumnInfoAsOne();
    }

    public SpecifiedColumn getResolvedSpecifiedColumn() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            SpecifiedColumn dreamCruiseTicket = this._specifedCB.xshowDreamCruiseTicket();
            return !dreamCruiseTicket.isDerived() ? dreamCruiseTicket : null;
        }
        return this._specifedCB.getSqlClause().getSpecifiedColumnAsOne();
    }

    public ColumnInfo getResolvedSpecifiedColumnInfo() {
        this.checkSpecifiedCB();
        ColumnInfo columnInfo = this.getSpecifiedColumnInfo();
        return columnInfo != null ? columnInfo : this.getSpecifiedDerivingColumnInfo();
    }

    public String getResolvedSpecifiedColumnDbName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            SpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.getColumnDbName();
        }
        ColumnInfo columnInfo = this.getResolvedSpecifiedColumnInfo();
        return columnInfo != null ? columnInfo.getColumnDbName() : null;
    }

    protected ColumnSqlName getResolvedSpecifiedColumnSqlName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            SpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.toColumnSqlName();
        }
        return this._specifedCB.getSqlClause().getSpecifiedResolvedColumnSqlNameAsOne();
    }

    public ColumnRealName getResolvedSpecifiedColumnRealName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            SpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.toColumnRealName();
        }
        return this._specifedCB.getSqlClause().getSpecifiedResolvedColumnRealNameAsOne();
    }

    public String getResolvedSpecifiedTableAliasName() {
        this.checkSpecifiedCB();
        if (this._specifedCB.xhasDreamCruiseTicket()) {
            SpecifiedColumn ticket = this._specifedCB.xshowDreamCruiseTicket();
            return ticket.getTableAliasName();
        }
        ColumnRealName columnRealName = this._specifedCB.getSqlClause().getSpecifiedColumnRealNameAsOne();
        if (columnRealName != null) {
            return columnRealName.getTableAliasName();
        }
        return this._specifedCB.getSqlClause().getSpecifiedDerivingAliasNameAsOne();
    }

    protected void checkSpecifiedCB() {
        if (this._specifedCB == null) {
            this.throwSpecifiedConditionBeanNotFoundException();
        }
    }

    protected void throwSpecifiedConditionBeanNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the specified condition-bean.");
        br.addItem("Advice");
        br.addElement("You should call specify(cb) before building statements.");
        br.addItem("Specify Query");
        br.addElement(this._specifyQuery);
        br.addItem("Calculation List");
        if (!this._calculationList.isEmpty()) {
            for (HpCalcElement element : this._calculationList) {
                br.addElement(element);
            }
        } else {
            br.addElement("*No calculation");
        }
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    public ColumnCalculator plus(Number plusValue) {
        this.assertObjectNotNull("plusValue", plusValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.plus(plusValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.PLUS, plusValue);
    }

    @Override
    public ColumnCalculator plus(SpecifiedColumn plusColumn) {
        this.assertObjectNotNull("plusColumn", plusColumn);
        this.assertCalculationColumnNumber(plusColumn);
        this.assertSpecifiedDreamCruiseTicket(plusColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.plus(plusColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.PLUS, plusColumn);
    }

    @Override
    public ColumnCalculator minus(Number minusValue) {
        this.assertObjectNotNull("minusValue", minusValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.minus(minusValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MINUS, minusValue);
    }

    @Override
    public ColumnCalculator minus(SpecifiedColumn minusColumn) {
        this.assertObjectNotNull("minusColumn", minusColumn);
        this.assertCalculationColumnNumber(minusColumn);
        this.assertSpecifiedDreamCruiseTicket(minusColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.plus(minusColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MINUS, minusColumn);
    }

    @Override
    public ColumnCalculator multiply(Number multiplyValue) {
        this.assertObjectNotNull("multiplyValue", multiplyValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.multiply(multiplyValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MULTIPLY, multiplyValue);
    }

    @Override
    public ColumnCalculator multiply(SpecifiedColumn multiplyColumn) {
        this.assertObjectNotNull("multiplyColumn", multiplyColumn);
        this.assertCalculationColumnNumber(multiplyColumn);
        this.assertSpecifiedDreamCruiseTicket(multiplyColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.multiply(multiplyColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.MULTIPLY, multiplyColumn);
    }

    @Override
    public ColumnCalculator divide(Number divideValue) {
        this.assertObjectNotNull("divideValue", divideValue);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.divide(divideValue);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.DIVIDE, divideValue);
    }

    @Override
    public ColumnCalculator divide(SpecifiedColumn divideColumn) {
        this.assertObjectNotNull("divideColumn", divideColumn);
        this.assertCalculationColumnNumber(divideColumn);
        this.assertSpecifiedDreamCruiseTicket(divideColumn);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.divide(divideColumn);
            return this;
        }
        return this.register(HpCalcElement.CalculationType.DIVIDE, divideColumn);
    }

    protected ColumnCalculator register(HpCalcElement.CalculationType type, Number value) {
        this.assertObjectNotNull("type", (Object)type);
        if (value == null) {
            String msg = "The null value was specified as " + (Object)((Object)type) + ".";
            throw new IllegalArgumentException(msg);
        }
        HpCalcElement calculation = new HpCalcElement();
        calculation.setCalculationType(type);
        calculation.setCalculationValue(value);
        this._calculationList.add(calculation);
        return this;
    }

    protected ColumnCalculator register(HpCalcElement.CalculationType type, SpecifiedColumn column) {
        this.assertObjectNotNull("type", (Object)type);
        if (column == null) {
            String msg = "The null column was specified as " + (Object)((Object)type) + ".";
            throw new IllegalArgumentException(msg);
        }
        HpCalcElement calculation = new HpCalcElement();
        calculation.setCalculationType(type);
        calculation.setCalculationColumn(column);
        this._calculationList.add(calculation);
        this.setupSelectDreamCruiseJourneyLogBookIfUnionExists(column);
        return this;
    }

    @Override
    public ColumnCalculator convert(FunctionFilterOptionCall<ColumnConversionOption> opLambda) {
        this.assertObjectNotNull("opLambda", opLambda);
        if (this._leftMode) {
            this.assertLeftCalcSp();
            this._leftCalcSp.convert(opLambda);
            return this;
        }
        ColumnConversionOption option = this.createColumnConversionOption();
        opLambda.callback(option);
        return this.registerConv(option);
    }

    protected ColumnConversionOption createColumnConversionOption() {
        return new ColumnConversionOption();
    }

    protected ColumnCalculator registerConv(ColumnConversionOption option) {
        if (option == null) {
            String msg = "The null value was specified as conversion option.";
            throw new IllegalArgumentException(msg);
        }
        HpCalcElement calculation = new HpCalcElement();
        calculation.setCalculationType(HpCalcElement.CalculationType.CONV);
        calculation.setColumnConversionOption(option);
        this._calculationList.add(calculation);
        this._convert = true;
        return this;
    }

    protected void prepareConvOption(ColumnConversionOption option, boolean removeCalcAlias) {
        if (removeCalcAlias) {
            option.xremoveCalcAlias();
        }
        option.xjudgeDatabase(this._baseCB.getSqlClause());
        if (option.xgetTargetColumnInfo() == null) {
            ColumnInfo columnInfo = this.getResolvedSpecifiedColumnInfo();
            option.xsetTargetColumnInfo(columnInfo);
        }
        if (this._mysticBindingSnapshot != null && option.xgetMysticBindingSnapshot() == null) {
            option.xsetMysticBindingSnapshot(this._mysticBindingSnapshot);
        }
        this._baseCB.localCQ().xregisterParameterOption(option);
    }

    protected void assertLeftCalcSp() {
        if (this._leftCalcSp == null) {
            this.throwCalculationLeftColumnUnsupportedException();
        }
    }

    protected void throwCalculationLeftColumnUnsupportedException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The calculation for left column is unsupported at the function.");
        br.addItem("Advice");
        br.addElement("For example, ColumnQuery supports it);");
        br.addElement("but UpdateOption does not.");
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    @Override
    public ColumnCalculator left() {
        this._leftMode = true;
        return this;
    }

    @Override
    public ColumnCalculator right() {
        this._leftMode = false;
        return this;
    }

    @Override
    public String buildStatementAsSqlName(String aliasName) {
        ColumnSqlName columnSqlName = this.getResolvedSpecifiedColumnSqlName();
        if (columnSqlName == null) {
            String msg = "Specified column is not found or too many columns are specified: " + aliasName;
            throw new IllegalConditionBeanOperationException(msg);
        }
        String columnExp = (aliasName != null ? aliasName : "") + columnSqlName.toString();
        boolean removeCalcAlias = aliasName == null;
        return this.doBuildStatement(columnExp, null, removeCalcAlias);
    }

    @Override
    public String buildStatementToSpecifidName(String columnExp) {
        return this.doBuildStatement(columnExp, null, false);
    }

    public String buildStatementToSpecifidNameRemovedCalcAlias(String columnExp) {
        return this.doBuildStatement(columnExp, null, true);
    }

    @Override
    public String buildStatementToSpecifidName(String columnExp, Map<String, String> columnAliasMap) {
        return this.doBuildStatement(columnExp, columnAliasMap, false);
    }

    protected String doBuildStatement(String columnExp, Map<String, String> columnAliasMap, boolean removeCalcAlias) {
        if (this._calculationList.isEmpty()) {
            return null;
        }
        String targetExp = columnAliasMap != null ? columnExp : this.decryptIfNeeds(columnExp);
        int index = 0;
        boolean firstEnclosing = this.needsFirstEnclosing(targetExp);
        for (HpCalcElement calculation : this._calculationList) {
            ColumnConversionOption option;
            if (index > 0 || index == 0 && firstEnclosing) {
                targetExp = "(" + targetExp + ")";
            }
            if (!calculation.isPreparedConvOption() && (option = calculation.getColumnConversionOption()) != null) {
                this.prepareConvOption(option, removeCalcAlias);
                calculation.setPreparedConvOption(true);
            }
            targetExp = this.buildCalculationExp(targetExp, columnAliasMap, calculation, removeCalcAlias);
            ++index;
        }
        return targetExp;
    }

    protected boolean needsFirstEnclosing(String targetExp) {
        if (targetExp == null) {
            return false;
        }
        String checkedStr = targetExp.contains(")") ? Srl.substringLastRear(targetExp, ")") : targetExp;
        return Srl.containsAny(checkedStr, " + ", " - ", " * ", " / ");
    }

    protected String buildCalculationExp(String targetExp, Map<String, String> columnAliasMap, HpCalcElement calculation, boolean removeCalcAlias) {
        Object calcValueExp;
        HpCalcElement.CalculationType calculationType = calculation.getCalculationType();
        if (calculationType.equals((Object)HpCalcElement.CalculationType.CONV)) {
            ColumnConversionOption columnConversionOption = calculation.getColumnConversionOption();
            return columnConversionOption.filterFunction(targetExp);
        }
        if (calculation.hasCalculationValue()) {
            calcValueExp = calculation.getCalculationValue();
        } else if (calculation.hasCalculationColumn()) {
            String baseExp;
            String columnExp;
            SpecifiedColumn calculationColumn = calculation.getCalculationColumn();
            if (removeCalcAlias) {
                String basePointAliasName = this._baseCB.getSqlClause().getBasePointAliasName();
                if (!basePointAliasName.equals(calculationColumn.getTableAliasName())) {
                    this.throwCalculationColumnRelationUnresolvedException(targetExp, calculationColumn);
                }
                columnExp = calculationColumn.toColumnSqlName().toString();
            } else {
                columnExp = calculationColumn.toColumnRealName().toString();
            }
            if (columnAliasMap != null) {
                String mappedAlias = columnAliasMap.get(columnExp);
                baseExp = mappedAlias != null ? mappedAlias : columnExp;
            } else {
                ColumnInfo columnInfo = calculationColumn.getColumnInfo();
                baseExp = !calculationColumn.isDerived() ? this.decryptIfNeeds(columnInfo, columnExp) : columnExp;
            }
            calcValueExp = this.filterNestedCalculation(baseExp, calculationColumn);
        } else {
            this.throwCalculationElementIllegalStateException(targetExp);
            return null;
        }
        return targetExp + " " + calculationType.operand() + " " + calcValueExp;
    }

    protected String decryptIfNeeds(String valueExp) {
        return this.decryptIfNeeds(this.getSpecifiedColumnInfo(), valueExp);
    }

    protected String decryptIfNeeds(ColumnInfo columnInfo, String valueExp) {
        if (columnInfo == null) {
            return valueExp;
        }
        ColumnFunctionCipher cipher = this._baseCB.getSqlClause().findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.decrypt(valueExp) : valueExp;
    }

    protected Object filterNestedCalculation(Object specifiedRealName, SpecifiedColumn hpCol) {
        if (hpCol != null && hpCol.hasSpecifyCalculation()) {
            hpCol.xinitSpecifyCalculation();
            HpCalcSpecification<ConditionBean> calcSpecification = hpCol.getSpecifyCalculation();
            return "(" + calcSpecification.buildStatementToSpecifidName(specifiedRealName.toString()) + ")";
        }
        return specifiedRealName;
    }

    protected void throwCalculationColumnRelationUnresolvedException(String targetExp, SpecifiedColumn calculationColumn) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The relation for the calculation column was unresolved.");
        br.addItem("Advice");
        br.addElement("For example, you cannot use relation columns for calculation");
        br.addElement("on set clause of update. (because of relation unresolved)");
        br.addItem("Base ConditionBean");
        br.addElement(this._baseCB.getClass().getName());
        br.addItem("Specified Column");
        br.addElement(targetExp);
        br.addItem("Calculation Column");
        br.addElement(calculationColumn);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwCalculationElementIllegalStateException(String targetExp) {
        String msg = "The either calculationValue or calculationColumn should exist: targetExp=" + targetExp;
        throw new IllegalStateException(msg);
    }

    public boolean isSpecifyColumn() {
        return this.getSpecifiedColumnInfo() != null;
    }

    public boolean isDerivedReferrer() {
        return this.getSpecifiedDerivingColumnInfo() != null;
    }

    public boolean mayNullRevived() {
        if (this._specifedCB != null && this._specifedCB.xhasDreamCruiseTicket() || this.isDerivedReferrer()) {
            return true;
        }
        for (HpCalcElement calcElement : this._calculationList) {
            if (calcElement.getCalculationColumn() != null) {
                return true;
            }
            ColumnConversionOption option = calcElement.getColumnConversionOption();
            if (option == null || !option.mayNullRevived()) continue;
            return true;
        }
        return false;
    }

    public void synchronizeSetupSelectByJourneyLogBook() {
        this._synchronizeSetupSelectByJourneyLogBook = true;
        if (this._leftCalcSp != null) {
            this._leftCalcSp.synchronizeSetupSelectByJourneyLogBook();
        }
    }

    protected void setupSelectDreamCruiseJourneyLogBookIfUnionExists(SpecifiedColumn column) {
        if (!this._synchronizeSetupSelectByJourneyLogBook) {
            return;
        }
        column.setupSelectDreamCruiseJourneyLogBookIfUnionExists();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCalculationColumnNumber(SpecifiedColumn specifiedColumn) {
        ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
        if (columnInfo == null) {
            return;
        }
        if (!columnInfo.isObjectNativeTypeNumber()) {
            String msg = "The type of the calculation column should be Number: " + specifiedColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertSpecifiedDreamCruiseTicket(SpecifiedColumn column) {
        if (!column.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + column;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        return title + ":{left=" + this._leftMode + ", convert=" + this._convert + ", logBook=" + this._synchronizeSetupSelectByJourneyLogBook + "}";
    }

    public SpecifyQuery<CB> getSpecifyQuery() {
        return this._specifyQuery;
    }

    public void setBaseCB(ConditionBean baseCB) {
        this._baseCB = baseCB;
    }

    public boolean hasCalculation() {
        return !this._calculationList.isEmpty();
    }

    public List<HpCalcElement> getCalculationList() {
        return this._calculationList;
    }

    public boolean hasConvert() {
        return this._convert;
    }

    public HpCalcSpecification<CB> getLeftCalcSp() {
        return this._leftCalcSp;
    }

    public void setLeftCalcSp(HpCalcSpecification<CB> leftCalcSp) {
        this._leftCalcSp = leftCalcSp;
    }

    public Object getMysticBindingSnapshot() {
        return this._mysticBindingSnapshot;
    }

    public void setMysticBindingSnapshot(Object mysticBindingSnapshot) {
        this._mysticBindingSnapshot = mysticBindingSnapshot;
    }
}

