/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.twowaysql.node;

import java.util.Iterator;
import java.util.List;
import org.dbflute.twowaysql.context.CommandContext;
import org.dbflute.twowaysql.factory.NodeAdviceFactory;
import org.dbflute.twowaysql.node.AbstractNode;
import org.dbflute.twowaysql.node.BoundValue;
import org.dbflute.twowaysql.node.BoundValueTracer;
import org.dbflute.twowaysql.node.FilteringBindOption;
import org.dbflute.twowaysql.node.LoopAcceptable;
import org.dbflute.twowaysql.node.LoopInfo;
import org.dbflute.twowaysql.node.NodeChecker;
import org.dbflute.twowaysql.node.ParameterCommentType;
import org.dbflute.util.Srl;

public abstract class VariableNode
extends AbstractNode
implements LoopAcceptable {
    protected static final String INLOOP_OPTION_LIKE_PREFIX = "likePrefix";
    protected static final String INLOOP_OPTION_LIKE_SUFFIX = "likeSuffix";
    protected static final String INLOOP_OPTION_LIKE_CONTAIN = "likeContain";
    protected static final String INLOOP_OPTION_NOT_LIKE = "notLike";
    protected final String _expression;
    protected final String _testValue;
    protected final String _optionDef;
    protected final List<String> _nameList;
    protected final String _specifiedSql;
    protected final boolean _blockNullParameter;
    protected final NodeAdviceFactory _nodeAdviceFactory;

    public VariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter, NodeAdviceFactory nodeAdviceFactory) {
        if (expression.contains(":")) {
            this._expression = Srl.substringFirstFront(expression, ":").trim();
            this._optionDef = Srl.substringFirstRear(expression, ":").trim();
        } else {
            this._expression = expression;
            this._optionDef = null;
        }
        this._testValue = testValue;
        this._nameList = Srl.splitList(this._expression, ".");
        this._specifiedSql = specifiedSql;
        this._blockNullParameter = blockNullParameter;
        this._nodeAdviceFactory = nodeAdviceFactory;
    }

    @Override
    public void accept(CommandContext ctx) {
        this.doAccept(ctx, null);
    }

    @Override
    public void accept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        if (firstName.equals("#current")) {
            Object parameter = loopInfo.getCurrentParameter();
            Class<?> parameterType = loopInfo.getCurrentParameterType();
            this.doAccept(ctx, parameter, parameterType, loopInfo, true);
        } else {
            this.doAccept(ctx, loopInfo);
        }
    }

    protected void doAccept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        this.assertFirstNameAsNormal(ctx, firstName);
        Object firstValue = ctx.getArg(firstName);
        Class<?> firstType = ctx.getArgType(firstName);
        this.doAccept(ctx, firstValue, firstType, loopInfo, false);
    }

    protected void doAccept(CommandContext ctx, Object firstValue, Class<?> firstType, LoopInfo loopInfo, boolean inheritLoop) {
        this.assertInLoopOnlyOptionInLoop(loopInfo);
        BoundValue boundValue = new BoundValue();
        boundValue.setFirstValue(firstValue);
        boundValue.setFirstType(firstType);
        this.setupBoundValue(boundValue);
        this.processLikeSearch(boundValue, loopInfo, inheritLoop);
        if (this._blockNullParameter && boundValue.getTargetValue() == null) {
            this.throwBindOrEmbeddedCommentParameterNullValueException(boundValue);
        }
        this.doProcess(ctx, boundValue, loopInfo);
    }

    protected abstract void doProcess(CommandContext var1, BoundValue var2, LoopInfo var3);

    protected void assertFirstNameAsNormal(CommandContext ctx, String firstName) {
        if (NodeChecker.isCurrentVariableOutOfScope(firstName, false)) {
            this.throwLoopCurrentVariableOutOfForCommentException();
        }
        if (NodeChecker.isWrongParameterBeanName(firstName, ctx)) {
            this.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException();
        }
    }

    protected void throwLoopCurrentVariableOutOfForCommentException() {
        NodeChecker.throwLoopCurrentVariableOutOfForCommentException(this._expression, this._specifiedSql);
    }

    protected void setupBoundValue(BoundValue boundValue) {
        ParameterCommentType commentType = this.getCommentType();
        BoundValueTracer tracer = this.createBoundValueTracer(commentType);
        tracer.trace(boundValue);
    }

    protected BoundValueTracer createBoundValueTracer(ParameterCommentType commentType) {
        return this._nodeAdviceFactory.createBoundValueTracer(this._nameList, this._expression, this._specifiedSql, commentType);
    }

    protected abstract ParameterCommentType getCommentType();

    protected void processLikeSearch(BoundValue boundValue, LoopInfo loopInfo, boolean inheritLoop) {
        if (!this.isAcceptableLikeSearch(loopInfo)) {
            return;
        }
        FilteringBindOption inLoopForcedLikeSearchOption = this.getInLoopForcedLikeSearchOption(loopInfo);
        if (inLoopForcedLikeSearchOption != null) {
            boundValue.setFilteringBindOption(inLoopForcedLikeSearchOption);
        } else if (inheritLoop) {
            boundValue.inheritLikeSearchOptionIfNeeds(loopInfo);
        }
        boundValue.filterValueByOptionIfNeeds();
    }

    protected boolean isAcceptableLikeSearch(LoopInfo loopInfo) {
        List<String> optionList;
        return loopInfo == null || !Srl.is_NotNull_and_NotTrimmedEmpty(this._optionDef) || !(optionList = Srl.splitListTrimmed(this._optionDef, "|")).contains(INLOOP_OPTION_NOT_LIKE);
    }

    protected FilteringBindOption getInLoopForcedLikeSearchOption(LoopInfo loopInfo) {
        List<String> optionList;
        Iterator<String> iterator;
        if (Srl.is_NotNull_and_NotTrimmedEmpty(this._optionDef) && (iterator = (optionList = Srl.splitListTrimmed(this._optionDef, "|")).iterator()).hasNext()) {
            String option = iterator.next();
            return this.createLikeSearchOption(option);
        }
        return null;
    }

    protected FilteringBindOption createLikeSearchOption(String likeDirection) {
        return this._nodeAdviceFactory.createInLoopLikeSearchOption(likeDirection);
    }

    protected void assertInLoopOnlyOptionInLoop(LoopInfo loopInfo) {
        if (loopInfo == null && Srl.is_NotNull_and_NotTrimmedEmpty(this._optionDef)) {
            String onlyInLoop = INLOOP_OPTION_NOT_LIKE;
            List<String> optionList = Srl.splitListTrimmed(this._optionDef, "|");
            for (String option : optionList) {
                if (!INLOOP_OPTION_NOT_LIKE.equals(option)) continue;
                this.throwInLoopOptionOutOfLoopException();
            }
        }
    }

    protected void setupRearOption(CommandContext ctx, BoundValue boundValue) {
        String rearOption = boundValue.buildRearOptionOnSql();
        if (Srl.is_NotNull_and_NotTrimmedEmpty(rearOption)) {
            ctx.addSql(rearOption);
        }
    }

    protected boolean isInScope() {
        if (this._testValue == null) {
            return false;
        }
        return this._testValue.startsWith("(") && this._testValue.endsWith(")");
    }

    protected void throwBindOrEmbeddedCommentParameterNullValueException(BoundValue boundValue) {
        Class<?> targetType = boundValue.getTargetType();
        NodeChecker.throwBindOrEmbeddedCommentParameterNullValueException(this._expression, targetType, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentInScopeNotListException(BoundValue boundValue) {
        Class<?> targetType = boundValue.getTargetType();
        NodeChecker.throwBindOrEmbeddedCommentInScopeNotListException(this._expression, targetType, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException() {
        NodeChecker.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentParameterEmptyListException() {
        NodeChecker.throwBindOrEmbeddedCommentParameterEmptyListException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentParameterNullOnlyListException() {
        NodeChecker.throwBindOrEmbeddedCommentParameterNullOnlyListException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwInLoopOptionOutOfLoopException() {
        NodeChecker.throwInLoopOptionOutOfLoopException(this._expression, this._specifiedSql, this._optionDef);
    }

    protected boolean isBind() {
        return this.getCommentType().equals((Object)ParameterCommentType.BIND);
    }

    public String getExpression() {
        return this._expression;
    }

    public String getTestValue() {
        return this._testValue;
    }

    public String getOptionDef() {
        return this._optionDef;
    }

    public boolean isBlockNullParameter() {
        return this._blockNullParameter;
    }
}

