/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.sqlhandler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.bhv.exception.SQLExceptionResource;
import org.dbflute.dbway.DBDef;
import org.dbflute.exception.BatchEntityAlreadyUpdatedException;
import org.dbflute.exception.EntityAlreadyDeletedException;
import org.dbflute.exception.EntityDuplicatedException;
import org.dbflute.hook.SqlLogInfo;
import org.dbflute.jdbc.StatementFactory;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.metadata.TnPropertyType;
import org.dbflute.s2dao.sqlhandler.TnAbstractEntityHandler;
import org.dbflute.system.XLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TnAbstractBatchHandler
extends TnAbstractEntityHandler {
    private static final Logger _log = LoggerFactory.getLogger(TnAbstractBatchHandler.class);
    protected StringBuilder _batchLoggingSb;
    protected int _loggingRecordCount;
    protected int _loggingScopeSize;
    protected boolean _existsSkippedLogging;
    protected boolean _alreadySavedToResultInfo;

    public TnAbstractBatchHandler(DataSource dataSource, StatementFactory statementFactory, String sql, TnBeanMetaData beanMetaData, TnPropertyType[] boundPropTypes) {
        super(dataSource, statementFactory, sql, beanMetaData, boundPropTypes);
    }

    @Override
    public int execute(Object[] args) {
        String msg = "This method should not be called when BatchUpdate.";
        throw new IllegalStateException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(List<?> beanList) {
        if (beanList == null) {
            String msg = "The argument 'beanList' should not be null";
            throw new IllegalArgumentException(msg);
        }
        if (beanList.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip executeBatch() bacause of the empty list.");
            }
            return new int[0];
        }
        Connection conn = this.getConnection();
        try {
            this.processBefore(conn, beanList);
            RuntimeException sqlEx = null;
            PreparedStatement ps = this.prepareStatement(conn);
            int[] result = null;
            try {
                for (Object bean : beanList) {
                    this.processBatchBefore(bean);
                    this.prepareBatchElement(conn, ps, bean);
                }
                this.handleBatchLogging();
                result = this.executeBatch(ps, beanList);
                this.handleBatchUpdateResultWithOptimisticLock(ps, beanList, result);
            }
            catch (RuntimeException e) {
                sqlEx = e;
                throw e;
            }
            finally {
                this.close(ps);
                this.processFinally(conn, beanList, sqlEx);
            }
            int index = 0;
            for (Object bean : beanList) {
                this.processBatchSuccess(bean, index);
                ++index;
            }
            this.processSuccess(conn, beanList, result.length);
            Object object = result;
            return object;
        }
        finally {
            this.close(conn);
        }
    }

    protected void prepareBatchElement(Connection conn, PreparedStatement ps, Object bean) {
        this.setupBindVariables(bean);
        Object[] bindVariables = this._bindVariables;
        this.logSql(bindVariables, this.getArgTypes(bindVariables));
        this.bindArgs(conn, ps, bindVariables, this._bindVariableValueTypes);
        this.addBatch(ps);
    }

    @Override
    protected void logSql(Object[] args, Class<?>[] argTypes) {
        if (this.isBatchLoggingOver()) {
            this._existsSkippedLogging = true;
            return;
        }
        super.logSql(args, argTypes);
    }

    protected boolean isBatchLoggingOver() {
        Integer batchLoggingLimit = this.getBatchLoggingLimit();
        if (batchLoggingLimit == null || batchLoggingLimit < 0) {
            return false;
        }
        return this._loggingRecordCount >= batchLoggingLimit;
    }

    protected abstract Integer getBatchLoggingLimit();

    @Override
    protected boolean processBeforeLogging(Object[] args, Class<?>[] argTypes, boolean logEnabled, boolean hasSqlFireHook, boolean hasSqlLog, boolean hasSqlResult, Object sqlLogRegistry) {
        if (this._batchLoggingSb == null) {
            this._batchLoggingSb = new StringBuilder(1000);
        }
        String displaySql = this.buildDisplaySql(this._sql, args);
        this.saveBatchLoggingSql(displaySql);
        this.doLogSql(args, argTypes, false, false, hasSqlLog, false, sqlLogRegistry);
        if (this.needsBreakLoggingScope()) {
            this.handleBatchLogging();
        }
        return true;
    }

    protected void saveBatchLoggingSql(String displaySql) {
        ++this._loggingRecordCount;
        ++this._loggingScopeSize;
        this._batchLoggingSb.append(this.ln()).append(displaySql).append(";");
    }

    protected boolean needsBreakLoggingScope() {
        return this._loggingScopeSize >= 100;
    }

    protected String handleBatchLogging() {
        if (this._batchLoggingSb == null) {
            this.handleBatchResultSqlSaving(null);
            return null;
        }
        String batchSql = this._batchLoggingSb.toString();
        if (this.isLogEnabled()) {
            this.log(batchSql);
        }
        this.clearBatchLogging();
        this.handleBatchResultSqlSaving(batchSql);
        return batchSql;
    }

    protected void handleBatchResultSqlSaving(String batchSql) {
        boolean hasSqlFireHook = this.hasSqlFireHook();
        boolean hasSqlResultHandler = this.hasSqlResultHandler();
        if (!this._alreadySavedToResultInfo && (hasSqlFireHook || hasSqlResultHandler)) {
            Object[] bindArgs = this._bindVariables;
            Class<?>[] bindArgTypes = this.getArgTypes(bindArgs);
            String savedDisplaySql = batchSql != null ? batchSql.trim() : null;
            SqlLogInfo sqlLogInfo = this.prepareSqlLogInfo(bindArgs, bindArgTypes, savedDisplaySql);
            if (hasSqlFireHook) {
                super.saveHookSqlLogInfo(sqlLogInfo);
            }
            if (hasSqlResultHandler) {
                super.saveResultSqlLogInfo(sqlLogInfo);
            }
            this._alreadySavedToResultInfo = true;
        }
    }

    @Override
    protected void saveHookSqlLogInfo(SqlLogInfo sqlLogInfo) {
    }

    @Override
    protected void saveResultSqlLogInfo(SqlLogInfo sqlLogInfo) {
    }

    protected void clearBatchLogging() {
        this._batchLoggingSb = null;
        this._loggingScopeSize = 0;
    }

    @Override
    protected void processBefore(Connection conn, Object beanList) {
        super.processBefore(conn, beanList);
    }

    @Override
    protected void processFinally(Connection conn, Object beanList, RuntimeException sqlEx) {
        super.processFinally(conn, beanList, sqlEx);
        this.noticeBatchLoggingOver();
        this._existsSkippedLogging = false;
        this._alreadySavedToResultInfo = false;
    }

    protected void noticeBatchLoggingOver() {
        if (this._existsSkippedLogging && XLog.isLogEnabled()) {
            Integer batchLoggingLimit = this.getBatchLoggingLimit();
            XLog.log("...Skipping several loggings by the limit option: " + batchLoggingLimit);
        }
    }

    @Override
    protected void processSuccess(Connection conn, Object beanList, int ret) {
        super.processSuccess(conn, beanList, ret);
    }

    protected void processBatchBefore(Object bean) {
    }

    protected void processBatchSuccess(Object bean, int index) {
        this.updateTimestampIfNeed(bean, index);
        this.updateVersionNoIfNeed(bean, index);
    }

    protected void handleBatchUpdateResultWithOptimisticLock(PreparedStatement ps, List<?> list, int[] result) {
        if (this.isCurrentDBDef(DBDef.Oracle)) {
            int updateCount;
            try {
                updateCount = ps.getUpdateCount();
            }
            catch (SQLException e) {
                SQLExceptionResource resource = this.createSQLExceptionResource();
                resource.setNotice("Failed to get update count.");
                this.handleSQLException(e, resource);
                return;
            }
            this.handleBatchUpdateResultWithOptimisticLockByUpdateCount(list, updateCount);
        } else {
            this.handleBatchUpdateResultWithOptimisticLockByResult(list, result);
        }
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return ResourceContext.isCurrentDBDef(currentDBDef);
    }

    protected void handleBatchUpdateResultWithOptimisticLockByUpdateCount(List<?> list, int updateCount) {
        if (list.isEmpty()) {
            return;
        }
        if (updateCount < 0) {
            return;
        }
        int entityCount = list.size();
        if (updateCount < entityCount) {
            if (this._optimisticLockHandling) {
                throw new BatchEntityAlreadyUpdatedException(list.get(0), 0, updateCount);
            }
            String msg = "The entity was NOT found! it has already been deleted.";
            msg = msg + " updateCount=" + updateCount;
            msg = msg + " entityCount=" + entityCount;
            msg = msg + " allEntities=" + list;
            throw new EntityAlreadyDeletedException(msg);
        }
    }

    protected void handleBatchUpdateResultWithOptimisticLockByResult(List<?> list, int[] result) {
        if (list.isEmpty()) {
            return;
        }
        int[] updatedCountArray = result;
        int entityCount = list.size();
        int index = 0;
        boolean alreadyUpdated = false;
        for (int oneUpdateCount : updatedCountArray) {
            if (entityCount <= index) break;
            if (oneUpdateCount == 0) {
                alreadyUpdated = true;
                break;
            }
            if (oneUpdateCount > 1) {
                String msg = "The entity updated two or more records in batch update:";
                msg = msg + " entity=" + list.get(index);
                msg = msg + " updatedCount=" + oneUpdateCount;
                msg = msg + " allEntities=" + list;
                throw new EntityDuplicatedException(msg);
            }
            ++index;
        }
        if (alreadyUpdated) {
            int updateCount = 0;
            for (int oneUpdateCount : updatedCountArray) {
                updateCount += oneUpdateCount;
            }
            if (this._optimisticLockHandling) {
                throw new BatchEntityAlreadyUpdatedException(list.get(index), 0, updateCount);
            }
            String msg = "The entity was NOT found! it has already been deleted:";
            msg = msg + " entity=" + list.get(index);
            msg = msg + " updateCount=" + updateCount;
            msg = msg + " allEntities=" + list;
            throw new EntityAlreadyDeletedException(msg);
        }
    }

    @Override
    protected Set<String> extractUniqueDrivenPropSet(Object bean) {
        return null;
    }

    @Override
    protected String buildExceptionMessageSql() {
        if (this._exceptionMessageSqlArgs == null && this._bindVariables != null) {
            this._exceptionMessageSqlArgs = this._bindVariables;
        }
        return super.buildExceptionMessageSql();
    }
}

