/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.sqlhandler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.dbflute.bhv.core.context.ConditionBeanContext;
import org.dbflute.bhv.core.context.InternalMapContext;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.bhv.exception.SQLExceptionHandler;
import org.dbflute.bhv.exception.SQLExceptionResource;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.hook.CallbackContext;
import org.dbflute.hook.SqlFireHook;
import org.dbflute.hook.SqlFireReadyInfo;
import org.dbflute.hook.SqlFireResultInfo;
import org.dbflute.hook.SqlLogHandler;
import org.dbflute.hook.SqlLogInfo;
import org.dbflute.hook.SqlResultHandler;
import org.dbflute.jdbc.DataSourceHandler;
import org.dbflute.jdbc.ExecutionTimeInfo;
import org.dbflute.jdbc.HandlingDataSourceWrapper;
import org.dbflute.jdbc.ManualThreadDataSourceHandler;
import org.dbflute.jdbc.NotClosingConnectionWrapper;
import org.dbflute.jdbc.StatementFactory;
import org.dbflute.jdbc.ValueType;
import org.dbflute.s2dao.extension.TnSqlLogRegistry;
import org.dbflute.s2dao.valuetype.TnValueTypes;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.system.QLog;
import org.dbflute.twowaysql.DisplaySqlBuilder;
import org.dbflute.twowaysql.style.BoundDateDisplayStyle;
import org.dbflute.twowaysql.style.BoundDateDisplayTimeZoneProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TnAbstractBasicSqlHandler {
    private static final Logger _log = LoggerFactory.getLogger(TnAbstractBasicSqlHandler.class);
    protected final DataSource _dataSource;
    protected final StatementFactory _statementFactory;
    protected final String _sql;
    protected Object[] _exceptionMessageSqlArgs;

    public TnAbstractBasicSqlHandler(DataSource dataSource, StatementFactory statementFactory, String sql) {
        this.assertObjectNotNull("dataSource", dataSource);
        this.assertObjectNotNull("statementFactory", statementFactory);
        this.assertObjectNotNull("sql", sql);
        this._dataSource = dataSource;
        this._statementFactory = statementFactory;
        this._sql = sql;
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, ValueType[] valueTypes) {
        if (args == null) {
            return;
        }
        Object current = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                ValueType valueType = valueTypes[i];
                current = args[i];
                valueType.bindValue(conn, ps, i + 1, current);
            }
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to bind the value.");
            if (current != null) {
                resource.addResource("Bound Value", current);
            }
            this.handleSQLException(e, resource);
        }
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, Class<?>[] argTypes) {
        this.bindArgs(conn, ps, args, argTypes, 0);
    }

    protected void bindArgs(Connection conn, PreparedStatement ps, Object[] args, Class<?>[] argTypes, int beginIndex) {
        if (args == null) {
            return;
        }
        Object current = null;
        try {
            for (int i = beginIndex; i < args.length; ++i) {
                current = args[i];
                ValueType valueType = this.findValueType(argTypes[i], current);
                valueType.bindValue(conn, ps, i + 1, current);
            }
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to bind the value.");
            if (current != null) {
                resource.addResource("Bound Value", current);
            }
            this.handleSQLException(e, resource);
        }
    }

    protected ValueType findValueType(Class<?> type, Object instance) {
        return TnValueTypes.findByTypeOrValue(type, instance);
    }

    protected Class<?>[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            argTypes[i] = arg.getClass();
        }
        return argTypes;
    }

    protected void logSql(Object[] args, Class<?>[] argTypes) {
        boolean hasRegistry;
        boolean logEnabled = this.isLogEnabled();
        boolean hasSqlFireHook = this.hasSqlFireHook();
        boolean hasSqlLog = this.hasSqlLogHandler();
        boolean hasSqlResult = this.hasSqlResultHandler();
        Object sqlLogRegistry = this.getSqlLogRegistry();
        boolean bl = hasRegistry = sqlLogRegistry != null;
        if (logEnabled || hasSqlFireHook || hasSqlLog || hasSqlResult || hasRegistry) {
            if (this.isInternalDebugEnabled()) {
                String determination = logEnabled + ", " + hasSqlFireHook + ", " + hasSqlLog + ", " + hasSqlResult + ", " + hasRegistry;
                _log.debug("...Logging SQL by " + determination);
            }
            if (this.processBeforeLogging(args, argTypes, logEnabled, hasSqlFireHook, hasSqlLog, hasSqlResult, sqlLogRegistry)) {
                return;
            }
            this.doLogSql(args, argTypes, logEnabled, hasSqlFireHook, hasSqlLog, hasSqlResult, sqlLogRegistry);
        }
    }

    protected boolean processBeforeLogging(Object[] args, Class<?>[] argTypes, boolean logEnabled, boolean hasSqlFireHook, boolean hasSqlLog, boolean hasSqlResult, Object sqlLogRegistry) {
        return false;
    }

    protected void doLogSql(Object[] args, Class<?>[] argTypes, boolean logEnabled, boolean hasSqlFireHook, boolean hasSqlLog, boolean hasSqlResult, Object sqlLogRegistry) {
        String firstDisplaySql;
        boolean hasRegistry;
        boolean bl = hasRegistry = sqlLogRegistry != null;
        if (logEnabled || hasRegistry) {
            if (this.isInternalDebugEnabled()) {
                _log.debug("...Building DisplaySql by " + logEnabled + ", " + hasRegistry);
            }
            firstDisplaySql = this.buildDisplaySql(this._sql, args);
            if (logEnabled) {
                this.logDisplaySql(firstDisplaySql);
            }
            if (hasRegistry) {
                this.pushToSqlLogRegistry(args, argTypes, firstDisplaySql, sqlLogRegistry);
            }
        } else {
            firstDisplaySql = null;
        }
        if (hasSqlFireHook || hasSqlLog || hasSqlResult) {
            SqlLogInfo sqlLogInfo;
            if (this.isInternalDebugEnabled()) {
                _log.debug("...Handling SqlFireHook or SqlLog or SqlResult by " + hasSqlFireHook + ", " + hasSqlLog + ", " + hasSqlResult);
            }
            if ((sqlLogInfo = this.prepareSqlLogInfo(args, argTypes, firstDisplaySql)) != null) {
                if (hasSqlLog) {
                    this.getSqlLogHander().handle(sqlLogInfo);
                }
                if (hasSqlFireHook) {
                    this.saveHookSqlLogInfo(sqlLogInfo);
                }
                if (hasSqlResult) {
                    this.saveResultSqlLogInfo(sqlLogInfo);
                }
            }
        }
    }

    protected void logDisplaySql(String displaySql) {
        this.log((this.isContainsLineSeparatorInSql(displaySql) ? this.ln() : "") + displaySql);
    }

    protected boolean isContainsLineSeparatorInSql(String displaySql) {
        return displaySql != null ? displaySql.contains(this.ln()) : false;
    }

    protected String buildDisplaySql(String sql, Object[] args) {
        return this.createDisplaySqlBuilder().buildDisplaySql(sql, args);
    }

    protected String getBindVariableText(Object bindVariable) {
        return this.createDisplaySqlBuilder().getBindVariableText(bindVariable);
    }

    protected DisplaySqlBuilder createDisplaySqlBuilder() {
        BoundDateDisplayStyle specifiedStyle = this.getSpecifiedLogDateDisplayStyle();
        BoundDateDisplayStyle realStyle = specifiedStyle != null ? specifiedStyle : this.createResourcedLogDateDisplayStyle();
        return this.newDisplaySqlBuilder(realStyle);
    }

    protected BoundDateDisplayStyle getSpecifiedLogDateDisplayStyle() {
        ConditionBean cb;
        BoundDateDisplayStyle specifiedStyle;
        if (ConditionBeanContext.isExistConditionBeanOnThread() && (specifiedStyle = (cb = ConditionBeanContext.getConditionBeanOnThread()).getLogDateDisplayStyle()) != null) {
            return specifiedStyle;
        }
        return null;
    }

    protected BoundDateDisplayStyle createResourcedLogDateDisplayStyle() {
        String datePattern = ResourceContext.getLogDatePattern();
        String iimestampPattern = ResourceContext.getLogTimestampPattern();
        String timePattern = ResourceContext.getLogTimePattern();
        BoundDateDisplayTimeZoneProvider timeZoneProvider = ResourceContext.getLogTimeZoneProvider();
        return new BoundDateDisplayStyle(datePattern, iimestampPattern, timePattern, timeZoneProvider);
    }

    protected DisplaySqlBuilder newDisplaySqlBuilder(BoundDateDisplayStyle dateDisplayStyle) {
        return new DisplaySqlBuilder(dateDisplayStyle);
    }

    protected SqlFireHook getSqlFireHook() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlFireHook();
    }

    protected boolean hasSqlFireHook() {
        return this.getSqlFireHook() != null;
    }

    protected void saveHookSqlLogInfo(SqlLogInfo sqlLogInfo) {
        InternalMapContext.setHookSqlLogInfo(sqlLogInfo);
    }

    protected SqlLogHandler getSqlLogHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlLogHandler();
    }

    protected boolean hasSqlLogHandler() {
        return this.getSqlLogHander() != null;
    }

    protected SqlLogInfo prepareSqlLogInfo(Object[] args, Class<?>[] argTypes, String alreadyBuiltDisplaySql) {
        SqlLogInfo.SqlLogDisplaySqlBuilder sqlLogDisplaySqlBuilder = this.createSqlLogDisplaySqlBuilder(alreadyBuiltDisplaySql);
        return new SqlLogInfo(ResourceContext.behaviorCommand(), this._sql, args, argTypes, sqlLogDisplaySqlBuilder);
    }

    protected SqlLogInfo.SqlLogDisplaySqlBuilder createSqlLogDisplaySqlBuilder(final String alreadyBuiltDisplaySql) {
        if (alreadyBuiltDisplaySql != null) {
            return new SqlLogInfo.SqlLogDisplaySqlBuilder(){

                @Override
                public String build(String executedSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
                    if (TnAbstractBasicSqlHandler.this.isInternalDebugEnabled()) {
                        _log.debug("...Returning DisplaySql, already built");
                    }
                    return alreadyBuiltDisplaySql;
                }
            };
        }
        return new SqlLogInfo.SqlLogDisplaySqlBuilder(){

            @Override
            public String build(String executedSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
                if (TnAbstractBasicSqlHandler.this.isInternalDebugEnabled()) {
                    _log.debug("...Building DisplaySql lazily");
                }
                return TnAbstractBasicSqlHandler.this.buildDisplaySql(executedSql, bindArgs);
            }
        };
    }

    protected SqlResultHandler getSqlResultHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlResultHandler();
    }

    protected boolean hasSqlResultHandler() {
        return this.getSqlResultHander() != null;
    }

    protected void saveResultSqlLogInfo(SqlLogInfo sqlLogInfo) {
        InternalMapContext.setResultSqlLogInfo(sqlLogInfo);
    }

    protected Object getSqlLogRegistry() {
        return TnSqlLogRegistry.findContainerSqlLogRegistry();
    }

    protected void pushToSqlLogRegistry(Object[] args, Class<?>[] argTypes, String firstDisplaySql, Object sqlLogRegistry) {
        TnSqlLogRegistry.push(this._sql, firstDisplaySql, args, argTypes, sqlLogRegistry);
    }

    protected void handleSQLException(SQLException e, SQLExceptionResource resource) {
        resource.setExecutedSql(this._sql);
        resource.setDisplaySql(this.buildExceptionMessageSql());
        this.createSQLExceptionHandler().handleSQLException(e, resource);
    }

    protected SQLExceptionHandler createSQLExceptionHandler() {
        return ResourceContext.createSQLExceptionHandler();
    }

    protected SQLExceptionResource createSQLExceptionResource() {
        return new SQLExceptionResource();
    }

    protected String buildExceptionMessageSql() {
        String displaySql;
        block3: {
            displaySql = null;
            if (this._sql != null && this._exceptionMessageSqlArgs != null) {
                try {
                    displaySql = this.buildDisplaySql(this._sql, this._exceptionMessageSqlArgs);
                }
                catch (RuntimeException continued) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug("*Failed to build SQL for an exception message: " + continued.getMessage());
                }
            }
        }
        return displaySql;
    }

    protected Connection getConnection() {
        try {
            ManualThreadDataSourceHandler handler = this.getManualThreadDataSourceHandler();
            if (handler != null) {
                return handler.getConnection(this._dataSource);
            }
            Connection conn = this._dataSource.getConnection();
            return conn;
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to get database connection.");
            this.handleSQLException(e, resource);
            return null;
        }
    }

    protected ManualThreadDataSourceHandler getManualThreadDataSourceHandler() {
        return ManualThreadDataSourceHandler.getDataSourceHandler();
    }

    protected PreparedStatement prepareStatement(Connection conn) {
        if (this._sql == null) {
            throw new IllegalStateException("The SQL should not be null.");
        }
        return this._statementFactory.createPreparedStatement(conn, this._sql);
    }

    protected CallableStatement prepareCall(Connection conn) {
        if (this._sql == null) {
            throw new IllegalStateException("The SQL should not be null.");
        }
        return this._statementFactory.createCallableStatement(conn, this._sql);
    }

    protected HandlingDataSourceWrapper createInheritedConnectionDataSource(final Connection conn) {
        return new HandlingDataSourceWrapper(this._dataSource, new DataSourceHandler(){

            @Override
            public Connection getConnection(DataSource dataSource) throws SQLException {
                return new NotClosingConnectionWrapper(conn);
            }
        });
    }

    protected ResultSet executeQuery(PreparedStatement ps) throws SQLException {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        ResultSet rs = null;
        SQLException nativeCause = null;
        try {
            rs = ps.executeQuery();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            ResultSet resultSet = rs;
            return resultSet;
        }
        catch (SQLException e) {
            nativeCause = e;
            throw e;
        }
        finally {
            this.hookSqlFireFinally(rs, nativeCause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(PreparedStatement ps) {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        Integer updated = null;
        SQLException nativeCause = null;
        try {
            updated = ps.executeUpdate();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            int n = updated;
            return n;
        }
        catch (SQLException e) {
            nativeCause = e;
            SQLExceptionResource resource = this.createSQLExceptionResource();
            String processTitle = this.getUpdateSQLFailureProcessTitle();
            resource.setNotice("Failed to execute the SQL for " + processTitle + ".");
            resource.enableUniqueConstraintHandling();
            this.handleSQLException(e, resource);
            int n = -1;
            return n;
        }
        finally {
            this.hookSqlFireFinally(updated, nativeCause);
        }
    }

    protected String getUpdateSQLFailureProcessTitle() {
        return "update (non-select)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeBatch(PreparedStatement ps, List<?> list) {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        int[] batchResult = null;
        SQLException nativeCause = null;
        try {
            batchResult = ps.executeBatch();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            int[] nArray = batchResult;
            return nArray;
        }
        catch (SQLException e) {
            nativeCause = e;
            SQLExceptionResource resource = this.createSQLExceptionResource();
            String processTitle = this.getBatchUpdateSQLFailureProcessTitle();
            resource.setNotice("Failed to execute the SQL for " + processTitle + ".");
            resource.enableUniqueConstraintHandling();
            resource.enableDisplaySqlPartHandling();
            this.handleSQLException(e, resource);
            int[] nArray = null;
            return nArray;
        }
        finally {
            this.hookSqlFireFinally(batchResult, nativeCause);
        }
    }

    protected String getBatchUpdateSQLFailureProcessTitle() {
        return "batch update (non-select)";
    }

    protected void addBatch(PreparedStatement ps) {
        try {
            ps.addBatch();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to add the batch statement.");
            resource.enableUniqueConstraintHandling();
            this.handleSQLException(e, resource);
        }
    }

    protected boolean executeProcedure(CallableStatement cs) throws SQLException {
        boolean saveMillis = this.isSaveMillis();
        if (saveMillis) {
            this.saveBeforeSqlTimeMillis();
        }
        this.hookSqlFireBefore();
        Boolean executed = null;
        SQLException nativeCause = null;
        try {
            executed = cs.execute();
            if (saveMillis) {
                this.saveAfterSqlTimeMillis();
            }
            boolean bl = executed;
            return bl;
        }
        catch (SQLException e) {
            nativeCause = e;
            throw e;
        }
        finally {
            this.hookSqlFireFinally(executed, nativeCause);
        }
    }

    protected boolean isSaveMillis() {
        return this.hasSqlFireHook() || this.hasSqlResultHandler();
    }

    protected void saveBeforeSqlTimeMillis() {
        InternalMapContext.setSqlBeforeTimeMillis(this.systemTime());
    }

    protected void saveAfterSqlTimeMillis() {
        InternalMapContext.setSqlAfterTimeMillis(this.systemTime());
    }

    protected void hookSqlFireBefore() {
        if (!this.hasSqlFireHook()) {
            return;
        }
        SqlLogInfo sqlLogInfo = InternalMapContext.getHookSqlLogInfo();
        SqlFireReadyInfo fireReadyInfo = new SqlFireReadyInfo(sqlLogInfo);
        this.getSqlFireHook().hookBefore(ResourceContext.behaviorCommand(), fireReadyInfo);
    }

    protected void hookSqlFireFinally(Object nativeResult, SQLException nativeCause) {
        if (!this.hasSqlFireHook()) {
            return;
        }
        SqlLogInfo sqlLogInfo = InternalMapContext.getHookSqlLogInfo();
        Long sqlBefore = InternalMapContext.getSqlBeforeTimeMillis();
        Long sqlAfter = InternalMapContext.getSqlAfterTimeMillis();
        ExecutionTimeInfo timeInfo = new ExecutionTimeInfo(null, null, sqlBefore, sqlAfter);
        SqlFireResultInfo fireResultInfo = new SqlFireResultInfo(nativeResult, sqlLogInfo, timeInfo, nativeCause);
        this.getSqlFireHook().hookFinally(ResourceContext.behaviorCommand(), fireResultInfo);
    }

    protected void setFetchSize(Statement st, int fetchSize) {
        if (st == null) {
            return;
        }
        try {
            st.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to set fetch size.");
            resource.addResource("Fetch Size", fetchSize);
            this.handleSQLException(e, resource);
        }
    }

    protected void setMaxRows(Statement st, int maxRows) {
        if (st == null) {
            return;
        }
        try {
            st.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to set max rows.");
            resource.addResource("Max Rows", maxRows);
            this.handleSQLException(e, resource);
        }
    }

    protected void close(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to close the statement.");
            this.handleSQLException(e, resource);
        }
    }

    protected void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to close the result set.");
            this.handleSQLException(e, resource);
        }
    }

    protected void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to close the database connection.");
            this.handleSQLException(e, resource);
        }
    }

    protected boolean isLogEnabled() {
        return QLog.isLogEnabled();
    }

    protected void log(String msg) {
        QLog.log(msg);
    }

    protected boolean isInternalDebugEnabled() {
        return ResourceContext.isInternalDebug() && _log.isDebugEnabled();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }

    protected long systemTime() {
        return DBFluteSystem.currentTimeMillis();
    }

    public void setExceptionMessageSqlArgs(Object[] exceptionMessageSqlArgs) {
        this._exceptionMessageSqlArgs = exceptionMessageSqlArgs;
    }
}

