/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.rshandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbflute.bhv.core.context.ConditionBeanContext;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.dbmeta.accessory.DomainEntity;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.outsidesql.OutsideSqlContext;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.metadata.TnPropertyMapping;
import org.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.dbflute.s2dao.rowcreator.TnRelationKey;
import org.dbflute.s2dao.rowcreator.TnRelationRowCache;
import org.dbflute.s2dao.rowcreator.TnRelationRowCreator;
import org.dbflute.s2dao.rowcreator.TnRelationSelector;
import org.dbflute.s2dao.rowcreator.TnRowCreator;
import org.dbflute.s2dao.rshandler.TnAbstractBeanResultSetHandler;
import org.dbflute.util.DfCollectionUtil;

public class TnBeanListResultSetHandler
extends TnAbstractBeanResultSetHandler {
    public TnBeanListResultSetHandler(TnBeanMetaData beanMetaData, TnRowCreator rowCreator, TnRelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator, relationRowCreator);
    }

    @Override
    public Object handle(ResultSet rs) throws SQLException {
        final ArrayList list = new ArrayList();
        this.mappingBean(rs, new BeanRowHandler(){

            @Override
            public boolean handle(Object row) throws SQLException {
                list.add(row);
                return true;
            }
        });
        return list;
    }

    protected void mappingBean(ResultSet rs, BeanRowHandler handler) throws SQLException {
        Map<String, String> selectColumnMap = null;
        Map<String, TnPropertyMapping> propertyCache = null;
        Map<String, Map<String, TnPropertyMapping>> relPropCache = null;
        TnRelationRowCache relRowCache = null;
        TnRelationSelector relSelector = null;
        TnBeanMetaData basePointBmd = this.getBeanMetaData();
        boolean hasCB = this.hasConditionBean();
        ConditionBean cb = hasCB ? this.getConditionBean() : null;
        boolean hasOql = this.hasOutsideSqlContext();
        OutsideSqlContext oqlCtx = OutsideSqlContext.getOutsideSqlContextOnThread();
        boolean checkNonSp = this.checkNonSpecifiedColumnAccess(hasCB, cb, hasOql, oqlCtx);
        boolean colNullObj = this.isUseColumnNullObjectHandling(hasCB, cb);
        boolean emptyRelationCB = hasCB && this.isSelectedRelationEmpty(cb);
        boolean specifiedOutsideSql = hasOql && this.isSpecifiedOutsideSql(oqlCtx);
        boolean skipRelationLoop = emptyRelationCB || specifiedOutsideSql;
        Map<String, Map<String, Integer>> selectIndexMap = ResourceContext.getSelectIndexMap();
        while (rs.next()) {
            if (selectColumnMap == null) {
                selectColumnMap = this.createSelectColumnMap(rs);
            }
            if (propertyCache == null) {
                propertyCache = this.createPropertyCache(selectColumnMap, selectIndexMap);
            }
            Object row = this.createRow(rs, selectIndexMap, propertyCache);
            if (skipRelationLoop) {
                this.adjustCreatedRow(row, checkNonSp, colNullObj, basePointBmd, cb);
                boolean continueToNext = handler.handle(row);
                if (continueToNext) continue;
                break;
            }
            if (relSelector == null) {
                relSelector = this.createRelationSelector(hasCB, cb);
            }
            if (relPropCache == null) {
                relPropCache = this.createRelationPropertyCache(selectColumnMap, selectIndexMap, relSelector);
            }
            if (relRowCache == null) {
                relRowCache = this.createRelationRowCache(hasCB, cb);
            }
            List<TnRelationPropertyType> rptList = basePointBmd.getRelationPropertyTypeList();
            for (TnRelationPropertyType rpt : rptList) {
                if (relSelector.isNonSelectedRelation(rpt.getRelationNoSuffixPart())) continue;
                this.mappingFirstRelation(rs, row, rpt, selectColumnMap, selectIndexMap, relPropCache, relRowCache, relSelector);
            }
            this.adjustCreatedRow(row, checkNonSp, colNullObj, basePointBmd, cb);
            boolean continueToNext = handler.handle(row);
            if (continueToNext) continue;
            break;
        }
    }

    protected TnRelationSelector createRelationSelector(final boolean hasCB, final ConditionBean cb) {
        final boolean colNullObj = this.isUseColumnNullObjectHandling(hasCB, cb);
        return new TnRelationSelector(){

            @Override
            public boolean isNonLimitMapping() {
                return hasCB;
            }

            @Override
            public boolean isNonSelectedRelation(String relationNoSuffix) {
                return hasCB && !cb.getSqlClause().hasSelectedRelation(relationNoSuffix);
            }

            @Override
            public boolean isNonSelectedNextConnectingRelation(String relationNoSuffix) {
                return hasCB && !cb.getSqlClause().isSelectedNextConnectingRelation(relationNoSuffix);
            }

            @Override
            public boolean canUseRelationCache(String relationNoSuffix) {
                return hasCB && cb.getSqlClause().canUseRelationCache(relationNoSuffix);
            }

            @Override
            public boolean isNonSpecifiedColumnAccessAllowed(String relationNoSuffix) {
                return hasCB && cb.isNonSpecifiedColumnAccessAllowed();
            }

            @Override
            public boolean isUsingSpecifyColumnInRelation(String relationNoSuffix) {
                if (!hasCB) {
                    return false;
                }
                SqlClause sqlClause = cb.getSqlClause();
                String tableAlias = sqlClause.translateSelectedRelationPathToTableAlias(relationNoSuffix);
                if (tableAlias == null) {
                    return false;
                }
                return sqlClause.hasSpecifiedSelectColumn(tableAlias);
            }

            @Override
            public Set<ColumnInfo> getRelationSpecifiedNullObjectColumnSet(String relationNoSuffix) {
                if (!hasCB) {
                    return DfCollectionUtil.emptySet();
                }
                return cb.getSqlClause().getRelationSpecifiedNullObjectColumnSet(relationNoSuffix);
            }

            @Override
            public boolean isColumnNullObjectEnabled(String relationNoSuffix) {
                return colNullObj;
            }
        };
    }

    protected TnRelationRowCache createRelationRowCache(boolean hasCB, ConditionBean cb) {
        int selectedRelationCount;
        int defaultRelSize = 4;
        int relSize = hasCB ? ((selectedRelationCount = this.getSelectedRelationCount(cb)) > 0 ? selectedRelationCount : 4) : 4;
        boolean canRowCache = hasCB ? this.canRelationMappingCache(cb) : true;
        return new TnRelationRowCache(relSize, canRowCache);
    }

    protected void mappingFirstRelation(ResultSet rs, Object row, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Map<String, Integer>> selectIndexMap, Map<String, Map<String, TnPropertyMapping>> relPropCache, TnRelationRowCache relRowCache, TnRelationSelector relSelector) throws SQLException {
        String relationNoSuffix = this.getFirstLevelRelationPath(rpt);
        TnRelationKey relKey = relRowCache.createRelationKey(rs, rpt, selectColumnMap, selectIndexMap, relationNoSuffix);
        Object relationRow = null;
        if (relKey != null) {
            boolean canUseRelationCache = relSelector.canUseRelationCache(relationNoSuffix);
            if (canUseRelationCache) {
                relationRow = relRowCache.getRelationRow(relationNoSuffix, relKey);
            }
            if (relationRow == null && (relationRow = this.createRelationRow(rs, rpt, selectColumnMap, selectIndexMap, relKey, relPropCache, relRowCache, relSelector)) != null) {
                this.adjustCreatedRelationRow(relationRow, relationNoSuffix, relSelector, rpt);
                if (canUseRelationCache) {
                    relRowCache.addRelationRow(relationNoSuffix, relKey, relationRow);
                }
            }
        }
        if ((relationRow = this.filterOptionalRelationRowIfNeeds(row, rpt, relationRow)) != null) {
            rpt.getPropertyAccessor().setValue(row, relationRow);
        }
    }

    protected String getFirstLevelRelationPath(TnRelationPropertyType rpt) {
        return rpt.getRelationNoSuffixPart();
    }

    protected Object filterOptionalRelationRowIfNeeds(Object row, TnRelationPropertyType rpt, Object relationRow) {
        return this._relationRowCreator.filterOptionalRelationRowIfNeeds(row, rpt, relationRow);
    }

    protected boolean checkNonSpecifiedColumnAccess(boolean hasCB, ConditionBean cb, boolean hasOql, OutsideSqlContext oqlCtx) {
        if (hasCB) {
            if (cb.isNonSpecifiedColumnAccessAllowed()) {
                return false;
            }
            String aliasName = cb.getSqlClause().getBasePointAliasName();
            return cb.getSqlClause().hasSpecifiedSelectColumn(aliasName);
        }
        if (hasOql) {
            Class<?> resultType = oqlCtx.getResultType();
            if (resultType == null) {
                return false;
            }
            return this.isOutsideSqlNonSpecifiedColumnAccessChecked(oqlCtx, resultType);
        }
        return false;
    }

    protected boolean isOutsideSqlNonSpecifiedColumnAccessChecked(OutsideSqlContext context, Class<?> resultType) {
        return this.isOutsideSqlNonSpecifiedColumnAccessCheckTarget(resultType) && !context.isNonSpecifiedColumnAccessAllowed();
    }

    protected boolean isOutsideSqlNonSpecifiedColumnAccessCheckTarget(Class<?> resultType) {
        return DomainEntity.class.isAssignableFrom(resultType);
    }

    protected boolean isUseColumnNullObjectHandling(boolean hasCB, ConditionBean cb) {
        return hasCB && cb.getSqlClause().isColumnNullObjectAllowed();
    }

    protected boolean hasConditionBean() {
        return ConditionBeanContext.isExistConditionBeanOnThread();
    }

    protected ConditionBean getConditionBean() {
        return ConditionBeanContext.getConditionBeanOnThread();
    }

    protected boolean isSelectedRelationEmpty(ConditionBean cb) {
        return cb.getSqlClause().isSelectedRelationEmpty();
    }

    protected int getSelectedRelationCount(ConditionBean cb) {
        return cb.getSqlClause().getSelectedRelationCount();
    }

    protected boolean canRelationMappingCache(ConditionBean cb) {
        return cb.canRelationMappingCache();
    }

    protected boolean hasOutsideSqlContext() {
        return OutsideSqlContext.isExistOutsideSqlContextOnThread();
    }

    protected boolean isSpecifiedOutsideSql(OutsideSqlContext context) {
        return context.isSpecifiedOutsideSql();
    }

    protected static interface BeanRowHandler {
        public boolean handle(Object var1) throws SQLException;
    }
}

