/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.extension;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbflute.Entity;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.accessory.ColumnNullObjectable;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.jdbc.ValueType;
import org.dbflute.s2dao.extension.TnRelationRowOptionalHandler;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.metadata.TnPropertyMapping;
import org.dbflute.s2dao.metadata.TnPropertyType;
import org.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.dbflute.s2dao.rowcreator.TnRelationKey;
import org.dbflute.s2dao.rowcreator.TnRelationRowCache;
import org.dbflute.s2dao.rowcreator.TnRelationRowCreationResource;
import org.dbflute.s2dao.rowcreator.TnRelationSelector;
import org.dbflute.s2dao.rowcreator.impl.TnRelationRowCreatorImpl;
import org.dbflute.util.DfReflectionUtil;

public class TnRelationRowCreatorExtension
extends TnRelationRowCreatorImpl {
    protected final TnRelationRowOptionalHandler _optionalHandler;

    public TnRelationRowCreatorExtension(TnRelationRowOptionalHandler optionalHandler) {
        this._optionalHandler = optionalHandler;
    }

    public static TnRelationRowCreatorExtension createRelationRowCreator(TnRelationRowOptionalHandler optionalHandler) {
        return new TnRelationRowCreatorExtension(optionalHandler);
    }

    @Override
    protected void setupRelationKeyValue(TnRelationRowCreationResource res) {
        TnRelationPropertyType rpt = res.getRelationPropertyType();
        TnBeanMetaData yourBmd = rpt.getYourBeanMetaData();
        DBMeta dbmeta = yourBmd.getDBMeta();
        if (!res.hasRowInstance()) {
            Object row = this.newRelationRow(rpt, dbmeta);
            res.setRow(row);
        }
    }

    protected Object newRelationRow(TnRelationPropertyType rpt, DBMeta dbmeta) {
        Object row = dbmeta != null ? dbmeta.newEntity() : this.newNonEntityRelationRow(rpt);
        return row;
    }

    protected Object newNonEntityRelationRow(TnRelationPropertyType rpt) {
        return DfReflectionUtil.newInstance(rpt.getPropertyDesc().getPropertyType());
    }

    @Override
    protected void setupRelationAllValue(TnRelationRowCreationResource res) throws SQLException {
        Map<String, TnPropertyMapping> propertyCacheElement = res.extractPropertyCacheElement();
        for (Map.Entry<String, TnPropertyMapping> entry : propertyCacheElement.entrySet()) {
            TnPropertyMapping pt = entry.getValue();
            res.setCurrentPropertyType(pt);
            if (!this.isValidRelationPerPropertyLoop(res)) {
                res.clearRowInstance();
                return;
            }
            this.setupRelationProperty(res);
        }
        if (!this.isValidRelationAfterPropertyLoop(res)) {
            res.clearRowInstance();
            return;
        }
        res.clearValidValueCount();
        if (res.isStopNextRelationMapping()) {
            return;
        }
        this.setupNextRelationRow(res);
    }

    protected void setupRelationProperty(TnRelationRowCreationResource res) throws SQLException {
        String columnName = res.buildRelationColumnName();
        this.registerRelationValue(res, columnName);
    }

    protected void registerRelationValue(TnRelationRowCreationResource res, String columnName) throws SQLException {
        TnPropertyMapping mapping = res.getCurrentPropertyMapping();
        Object value = null;
        if (res.containsRelationKeyColumn(columnName)) {
            value = res.extractRelationKeyValue(columnName);
        } else {
            ValueType valueType = mapping.getValueType();
            Map<String, Map<String, Integer>> selectIndexMap = res.getSelectIndexMap();
            ResultSet rs = res.getResultSet();
            if (selectIndexMap != null) {
                String relationNoSuffix = res.getRelationNoSuffix();
                value = ResourceContext.getRelationValue(rs, relationNoSuffix, columnName, valueType, selectIndexMap);
            } else {
                value = valueType.getValue(rs, columnName);
            }
        }
        this.handleRelationValueRegistration(res, mapping, value);
    }

    protected void handleRelationValueRegistration(TnRelationRowCreationResource res, TnPropertyMapping mapping, Object value) {
        if (value != null) {
            res.incrementValidValueCount();
        }
        this.doRegisterRelationValue(res, mapping, value);
    }

    protected void doRegisterRelationValue(TnRelationRowCreationResource res, TnPropertyMapping mapping, Object value) {
        ColumnInfo columnInfo = mapping.getEntityColumnInfo();
        if (columnInfo != null) {
            columnInfo.write((Entity)res.getRow(), value);
        } else {
            mapping.getPropertyAccessor().setValue(res.getRow(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRow(TnRelationRowCreationResource res) throws SQLException {
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        Object row = res.getRow();
        res.prepareNextLevelMapping();
        try {
            List<TnRelationPropertyType> nextRptList = nextBmd.getRelationPropertyTypeList();
            for (TnRelationPropertyType nextRpt : nextRptList) {
                this.setupNextRelationRowElement(res, row, nextRpt);
            }
        }
        finally {
            res.setRow(row);
            res.closeNextLevelMapping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupNextRelationRowElement(TnRelationRowCreationResource res, Object row, TnRelationPropertyType nextRpt) throws SQLException {
        res.prepareNextRelationProperty(nextRpt);
        try {
            this.mappingNextRelation(res, row);
        }
        finally {
            res.closeNextRelationProperty();
        }
    }

    protected void mappingNextRelation(TnRelationRowCreationResource res, Object row) throws SQLException {
        if (res.isStopCurrentRelationMapping()) {
            return;
        }
        TnRelationKey relKey = res.prepareRelationKey();
        TnRelationPropertyType rpt = res.getRelationPropertyType();
        Object relationRow = null;
        if (relKey != null) {
            String relationNoSuffix = res.getRelationNoSuffix();
            boolean canUseRelationCache = res.canUseRelationCache();
            TnRelationRowCache relRowCache = null;
            if (canUseRelationCache) {
                relRowCache = res.getRelRowCache();
                relationRow = relRowCache.getRelationRow(relationNoSuffix, relKey);
            }
            if (relationRow == null && (relationRow = this.createRelationRow(res)) != null) {
                TnRelationRowCreatorExtension.adjustCreatedRelationRow(relationRow, res.getRelationNoSuffix(), res.getRelationSelector(), rpt);
                if (canUseRelationCache) {
                    relRowCache.addRelationRow(relationNoSuffix, relKey, relationRow);
                }
            }
        }
        if ((relationRow = this.filterOptionalRelationRowIfNeeds(row, rpt, relationRow)) != null) {
            rpt.getPropertyAccessor().setValue(row, relationRow);
        }
    }

    public static void adjustCreatedRelationRow(Object relationRow, String relationNoSuffix, TnRelationSelector relSelector, TnRelationPropertyType rpt) {
        if (relationRow instanceof Entity) {
            Entity entity = (Entity)relationRow;
            if (!relSelector.isNonSpecifiedColumnAccessAllowed(relationNoSuffix) && relSelector.isUsingSpecifyColumnInRelation(relationNoSuffix)) {
                entity.modifiedToSpecified();
                Set<ColumnInfo> nullObjectColumnSet = relSelector.getRelationSpecifiedNullObjectColumnSet(relationNoSuffix);
                for (ColumnInfo columnInfo : nullObjectColumnSet) {
                    entity.myspecifyProperty(columnInfo.getPropertyName());
                }
            }
            if (relSelector.isColumnNullObjectEnabled(relationNoSuffix) && entity instanceof ColumnNullObjectable) {
                ((ColumnNullObjectable)((Object)entity)).enableColumnNullObject();
            }
            entity.clearModifiedInfo();
            entity.markAsSelect();
        } else {
            rpt.getYourBeanMetaData().getModifiedPropertyNames(relationRow).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setupPropertyCache(TnRelationRowCreationResource res) throws SQLException {
        if (res.isStopCurrentRelationMapping()) {
            return;
        }
        TnBeanMetaData nextBmd = res.getRelationBeanMetaData();
        List<TnPropertyType> ptList = nextBmd.getPropertyTypeList();
        for (TnPropertyType pt : ptList) {
            res.setCurrentPropertyType(pt);
            this.setupPropertyCacheElement(res);
        }
        if (res.isStopNextRelationMapping()) {
            return;
        }
        res.prepareNextLevelMapping();
        try {
            this.setupNextPropertyCache(res, nextBmd);
        }
        finally {
            res.closeNextLevelMapping();
        }
    }

    protected void setupNextPropertyCache(TnRelationRowCreationResource res, TnBeanMetaData nextBmd) throws SQLException {
        List<TnRelationPropertyType> nextRptList = nextBmd.getRelationPropertyTypeList();
        for (TnRelationPropertyType nextRpt : nextRptList) {
            this.setupNextPropertyCacheElement(res, nextRpt);
        }
    }

    protected void setupNextPropertyCacheElement(TnRelationRowCreationResource res, TnRelationPropertyType nextRpt) throws SQLException {
        res.prepareNextRelationProperty(nextRpt);
        try {
            this.setupPropertyCache(res);
        }
        finally {
            res.closeNextRelationProperty();
        }
    }

    @Override
    protected boolean isCreateDeadLink() {
        return false;
    }

    @Override
    protected int getLimitRelationNestLevel() {
        return 2;
    }

    @Override
    public Object filterOptionalRelationRowIfNeeds(Object row, TnRelationPropertyType rpt, Object relationRow) {
        return this._optionalHandler.filterOptionalRelationRowIfNeeds(row, rpt, relationRow);
    }
}

