/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.optional;

import org.dbflute.optional.BaseOptional;
import org.dbflute.optional.OptionalThing;
import org.dbflute.optional.OptionalThingConsumer;
import org.dbflute.optional.OptionalThingExceptionThrower;
import org.dbflute.optional.OptionalThingFunction;
import org.dbflute.optional.OptionalThingIfPresentAfter;
import org.dbflute.optional.OptionalThingPredicate;
import org.dbflute.optional.OptionalThingSupplier;

public class OptionalScalar<SCALAR>
extends BaseOptional<SCALAR> {
    protected static final OptionalScalar<Object> EMPTY_INSTANCE = new OptionalScalar<Object>(null, new OptionalThingExceptionThrower(){

        @Override
        public void throwNotFoundException() {
            String msg = "The empty optional so the value is null.";
            throw new IllegalStateException(msg);
        }
    });
    protected static final OptionalThingExceptionThrower NOWAY_THROWER = new OptionalThingExceptionThrower(){

        @Override
        public void throwNotFoundException() {
            throw new IllegalStateException("no way");
        }
    };

    public OptionalScalar(SCALAR thing, OptionalThingExceptionThrower thrower) {
        super(thing, thrower);
    }

    public static <EMPTY> OptionalScalar<EMPTY> empty() {
        return EMPTY_INSTANCE;
    }

    public static <OBJ> OptionalScalar<OBJ> of(OBJ object) {
        if (object == null) {
            String msg = "The argument 'object' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalScalar<OBJ>(object, NOWAY_THROWER);
    }

    public static <OBJ> OptionalScalar<OBJ> ofNullable(OBJ object, OptionalThingExceptionThrower noArgLambda) {
        if (object != null) {
            return OptionalScalar.of(object);
        }
        return new OptionalScalar<OBJ>(object, noArgLambda);
    }

    @Override
    public OptionalThingIfPresentAfter ifPresent(OptionalThingConsumer<SCALAR> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackIfPresent(oneArgLambda);
    }

    @Override
    public boolean isPresent() {
        return this.exists();
    }

    @Override
    public SCALAR get() {
        return (SCALAR)this.directlyGet();
    }

    @Override
    public OptionalScalar<SCALAR> filter(OptionalThingPredicate<SCALAR> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return (OptionalScalar)this.callbackFilter(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalScalar<ARG> createOptionalFilteredObject(ARG obj) {
        return new OptionalScalar<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalThing<RESULT> map(OptionalThingFunction<? super SCALAR, ? extends RESULT> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackMapping(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalScalar<ARG> createOptionalMappedObject(ARG obj) {
        return new OptionalScalar<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalThing<RESULT> flatMap(OptionalThingFunction<? super SCALAR, OptionalThing<RESULT>> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackFlatMapping(oneArgLambda);
    }

    @Override
    public SCALAR orElse(SCALAR other) {
        return this.directlyGetOrElse(other);
    }

    @Override
    public SCALAR orElseGet(OptionalThingSupplier<SCALAR> noArgLambda) {
        return this.directlyGetOrElseGet(noArgLambda);
    }

    @Override
    public <CAUSE extends Throwable> SCALAR orElseThrow(OptionalThingSupplier<? extends CAUSE> noArgLambda) throws CAUSE {
        return (SCALAR)this.directlyGetOrElseThrow(noArgLambda);
    }

    @Override
    public void alwaysPresent(OptionalThingConsumer<SCALAR> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        this.callbackAlwaysPresent(oneArgLambda);
    }

    @Override
    public SCALAR orElseNull() {
        return this.directlyGetOrElse(null);
    }

    protected void assertOneArgLambdaNotNull(Object oneArgLambda) {
        if (oneArgLambda == null) {
            throw new IllegalArgumentException("The argument 'oneArgLambda' should not be null.");
        }
    }
}

