/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbmeta.valuemap;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dbflute.Entity;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.jdbc.Classification;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class MetaHandlingMapToEntityMapper {
    protected final Map<String, ? extends Object> _valueMap;
    protected String _columnName;
    protected String _uncapPropName;
    protected String _propertyName;

    public MetaHandlingMapToEntityMapper(Map<String, ? extends Object> valueMap) {
        this._valueMap = valueMap;
    }

    public <ENTITY extends Entity> void mappingToEntity(ENTITY entity, Map<String, ? extends Object> columnMap, List<ColumnInfo> columnInfoList) {
        entity.clearModifiedInfo();
        for (ColumnInfo columnInfo : columnInfoList) {
            String columnName = columnInfo.getColumnDbName();
            String propertyName = columnInfo.getPropertyName();
            String uncapPropName = this.initUncap(propertyName);
            Class<?> nativeType = columnInfo.getObjectNativeType();
            if (!this.init(columnName, uncapPropName, propertyName)) continue;
            Object value = String.class.isAssignableFrom(nativeType) ? this.analyzeString(nativeType) : (Number.class.isAssignableFrom(nativeType) ? this.analyzeNumber(nativeType) : (LocalDate.class.isAssignableFrom(nativeType) ? this.analyzeLocalDate(nativeType) : (LocalDateTime.class.isAssignableFrom(nativeType) ? this.analyzeLocalDateTime(nativeType) : (LocalTime.class.isAssignableFrom(nativeType) ? this.analyzeLocalTime(nativeType) : (Date.class.isAssignableFrom(nativeType) ? this.analyzeDate(nativeType) : (Boolean.class.isAssignableFrom(nativeType) ? this.analyzeBoolean(nativeType) : (byte[].class.isAssignableFrom(nativeType) ? this.analyzeBinary(nativeType) : (UUID.class.isAssignableFrom(nativeType) ? this.analyzeUUID(nativeType) : this.analyzeOther(nativeType)))))))));
            columnInfo.write(entity, value);
        }
    }

    protected final String initUncap(String str) {
        return Srl.initUncap(str);
    }

    protected boolean init(String columnName, String uncapPropName, String propertyName) {
        this._columnName = columnName;
        this._uncapPropName = uncapPropName;
        this._propertyName = propertyName;
        return this._valueMap.containsKey(this._columnName);
    }

    public <PROPERTY> PROPERTY analyzeString(Class<PROPERTY> javaType) {
        return (PROPERTY)DfTypeUtil.toString(this.getColumnValue());
    }

    public <PROPERTY> PROPERTY analyzeNumber(Class<PROPERTY> javaType) {
        return (PROPERTY)DfTypeUtil.toNumber(this.getColumnValue(), javaType);
    }

    public <PROPERTY> PROPERTY analyzeLocalDate(Class<PROPERTY> javaType) {
        return (PROPERTY)DfTypeUtil.toLocalDate(this.getColumnValue());
    }

    public <PROPERTY> PROPERTY analyzeLocalDateTime(Class<PROPERTY> javaType) {
        return (PROPERTY)DfTypeUtil.toLocalDateTime(this.getColumnValue());
    }

    public <PROPERTY> PROPERTY analyzeLocalTime(Class<PROPERTY> javaType) {
        return (PROPERTY)DfTypeUtil.toLocalTime(this.getColumnValue());
    }

    public <PROPERTY> PROPERTY analyzeDate(Class<PROPERTY> javaType) {
        Object obj = this.getColumnValue();
        if (Time.class.isAssignableFrom(javaType)) {
            return (PROPERTY)DfTypeUtil.toTime(obj);
        }
        if (Timestamp.class.isAssignableFrom(javaType)) {
            return (PROPERTY)DfTypeUtil.toTimestamp(obj);
        }
        return (PROPERTY)DfTypeUtil.toDate(obj);
    }

    public <PROPERTY> PROPERTY analyzeBoolean(Class<PROPERTY> javaType) {
        return (PROPERTY)DfTypeUtil.toBoolean(this.getColumnValue());
    }

    public <PROPERTY> PROPERTY analyzeBinary(Class<PROPERTY> javaType) {
        Object obj = this.getColumnValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof Serializable) {
            return (PROPERTY)DfTypeUtil.toBinary((Serializable)obj);
        }
        throw new UnsupportedOperationException("unsupported binary type: " + obj.getClass());
    }

    public <PROPERTY> PROPERTY analyzeUUID(Class<PROPERTY> javaType) {
        return (PROPERTY)DfTypeUtil.toUUID(this.getColumnValue());
    }

    public <PROPERTY> PROPERTY analyzeOther(Class<PROPERTY> javaType) {
        Object obj = this.getColumnValue();
        if (obj == null) {
            return null;
        }
        if (Classification.class.isAssignableFrom(javaType)) {
            Class[] argTypes = new Class[]{Object.class};
            Method method = DfReflectionUtil.getPublicMethod(javaType, "codeOf", argTypes);
            return (PROPERTY)DfReflectionUtil.invokeStatic(method, new Object[]{obj});
        }
        return (PROPERTY)obj;
    }

    protected Object getColumnValue() {
        Object value = this._valueMap.get(this._columnName);
        return this.filterClassificationValue(value);
    }

    protected Object filterClassificationValue(Object value) {
        if (value != null && value instanceof Classification) {
            value = ((Classification)value).code();
        }
        return value;
    }
}

