/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.Entity;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.info.RelationInfo;
import org.dbflute.dbmeta.property.PropertyGateway;
import org.dbflute.dbmeta.property.PropertyMethodFinder;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.Srl;

public class ForeignInfo
implements RelationInfo {
    protected final String _constraintName;
    protected final String _foreignPropertyName;
    protected final DBMeta _localDBMeta;
    protected final DBMeta _foreignDBMeta;
    protected final Map<ColumnInfo, ColumnInfo> _localForeignColumnInfoMap;
    protected final Map<ColumnInfo, ColumnInfo> _foreignLocalColumnInfoMap;
    protected final int _relationNo;
    protected final Class<?> _objectNativeType;
    protected final Class<?> _propertyAccessType;
    protected final boolean _oneToOne;
    protected final boolean _bizOneToOne;
    protected final boolean _referrerAsOne;
    protected final boolean _additionalFK;
    protected final String _fixedCondition;
    protected final List<String> _dynamicParameterList;
    protected final boolean _fixedInline;
    protected final String _reversePropertyName;
    protected final boolean _canBeNullObject;
    protected final PropertyGateway _propertyGateway;
    protected final PropertyMethodFinder _propertyMethodFinder;
    protected final Method _readMethod;
    protected final Method _writeMethod;

    public ForeignInfo(String constraintName, String foreignPropertyName, DBMeta localDBMeta, DBMeta foreignDBMeta, Map<ColumnInfo, ColumnInfo> localForeignColumnInfoMap, int relationNo, Class<?> propertyAccessType, boolean oneToOne, boolean bizOneToOne, boolean referrerAsOne, boolean additionalFK, String fixedCondition, List<String> dynamicParameterList, boolean fixedInline, String reversePropertyName, boolean canBeNullObject, PropertyMethodFinder propertyMethodFinder) {
        this.assertObjectNotNull("constraintName", constraintName);
        this.assertObjectNotNull("foreignPropertyName", foreignPropertyName);
        this.assertObjectNotNull("localDBMeta", localDBMeta);
        this.assertObjectNotNull("foreignDBMeta", foreignDBMeta);
        this.assertObjectNotNull("localForeignColumnInfoMap", localForeignColumnInfoMap);
        this.assertObjectNotNull("propertyAccessType", propertyAccessType);
        this.assertObjectNotNull("propertyMethodFinder", propertyMethodFinder);
        this._constraintName = constraintName;
        this._foreignPropertyName = foreignPropertyName;
        this._localDBMeta = localDBMeta;
        this._foreignDBMeta = foreignDBMeta;
        this._localForeignColumnInfoMap = Collections.unmodifiableMap(localForeignColumnInfoMap);
        LinkedHashMap<ColumnInfo, ColumnInfo> foreignLocalColumnInfoMap = new LinkedHashMap<ColumnInfo, ColumnInfo>(4);
        for (Map.Entry<ColumnInfo, ColumnInfo> entry : localForeignColumnInfoMap.entrySet()) {
            foreignLocalColumnInfoMap.put(entry.getValue(), entry.getKey());
        }
        this._foreignLocalColumnInfoMap = Collections.unmodifiableMap(foreignLocalColumnInfoMap);
        this._relationNo = relationNo;
        this._objectNativeType = foreignDBMeta.getEntityType();
        this._propertyAccessType = propertyAccessType;
        this._oneToOne = oneToOne;
        this._bizOneToOne = bizOneToOne;
        this._referrerAsOne = referrerAsOne;
        this._additionalFK = additionalFK;
        this._fixedCondition = fixedCondition;
        this._fixedInline = fixedInline;
        this._dynamicParameterList = dynamicParameterList != null ? Collections.unmodifiableList(dynamicParameterList) : Collections.emptyList();
        this._reversePropertyName = reversePropertyName;
        this._canBeNullObject = canBeNullObject;
        this._propertyGateway = this.findPropertyGateway();
        this._propertyMethodFinder = propertyMethodFinder;
        this._readMethod = this.findReadMethod();
        this._writeMethod = this.findWriteMethod();
    }

    public boolean containsLocalColumn(ColumnInfo localColumn) {
        return this.doContainsLocalColumn(localColumn.getColumnDbName());
    }

    protected boolean doContainsLocalColumn(String columnName) {
        for (ColumnInfo columnInfo : this._localForeignColumnInfoMap.keySet()) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsForeignColumn(ColumnInfo foreignColumn) {
        return this.doContainsForeignColumn(foreignColumn.getColumnDbName());
    }

    protected boolean doContainsForeignColumn(String columnName) {
        for (ColumnInfo columnInfo : this._foreignLocalColumnInfoMap.keySet()) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public ColumnInfo findLocalByForeign(String foreignColumnDbName) {
        ColumnInfo keyColumnInfo = this._foreignDBMeta.findColumnInfo(foreignColumnDbName);
        ColumnInfo resultColumnInfo = this._foreignLocalColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by foreignColumnDbName in foreignLocalColumnInfoMap:";
            msg = msg + " foreignColumnDbName=" + foreignColumnDbName;
            msg = msg + " foreignLocalColumnInfoMap=" + this._foreignLocalColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    public ColumnInfo findForeignByLocal(String localColumnDbName) {
        ColumnInfo keyColumnInfo = this._localDBMeta.findColumnInfo(localColumnDbName);
        ColumnInfo resultColumnInfo = this._localForeignColumnInfoMap.get(keyColumnInfo);
        if (resultColumnInfo == null) {
            String msg = "Not found by localColumnDbName in localForeignColumnInfoMap:";
            msg = msg + " localColumnDbName=" + localColumnDbName;
            msg = msg + " localForeignColumnInfoMap=" + this._localForeignColumnInfoMap;
            throw new IllegalArgumentException(msg);
        }
        return resultColumnInfo;
    }

    @Override
    public <PROPERTY> PROPERTY read(Entity localEntity) {
        return (PROPERTY)this._propertyGateway.read(localEntity);
    }

    public Method getReadMethod() {
        return this._readMethod;
    }

    @Override
    public void write(Entity localEntity, Object foreignEntity) {
        this._propertyGateway.write(localEntity, foreignEntity);
    }

    public Method getWriteMethod() {
        return this._writeMethod;
    }

    protected PropertyGateway findPropertyGateway() {
        PropertyGateway gateway = this._localDBMeta.findForeignPropertyGateway(this._foreignPropertyName);
        if (gateway == null) {
            String msg = "Not found the foreign property gateway by the name: " + this._foreignPropertyName;
            throw new IllegalStateException(msg);
        }
        return gateway;
    }

    protected Method findReadMethod() {
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        return this._propertyMethodFinder.findReadMethod(localType, this._foreignPropertyName, this._propertyAccessType);
    }

    protected Method findWriteMethod() {
        Class<? extends Entity> localType = this._localDBMeta.getEntityType();
        return this._propertyMethodFinder.findWriteMethod(localType, this._foreignPropertyName, this._propertyAccessType);
    }

    protected Object invokeMethod(Method method, Object target, Object[] args) {
        return DfReflectionUtil.invoke(method, target, args);
    }

    @Override
    public String getRelationPropertyName() {
        return this.getForeignPropertyName();
    }

    @Override
    public DBMeta getTargetDBMeta() {
        return this.getForeignDBMeta();
    }

    @Override
    public Map<ColumnInfo, ColumnInfo> getLocalTargetColumnInfoMap() {
        return this.getLocalForeignColumnInfoMap();
    }

    @Override
    public boolean isReferrer() {
        return false;
    }

    protected String initCap(String name) {
        return Srl.initCap(name);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._foreignPropertyName.hashCode() + this._localDBMeta.hashCode() + this._foreignDBMeta.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ForeignInfo)) {
            return false;
        }
        ForeignInfo target = (ForeignInfo)obj;
        if (!this._foreignPropertyName.equals(target.getForeignPropertyName())) {
            return false;
        }
        if (!this._localDBMeta.equals(target.getLocalDBMeta())) {
            return false;
        }
        return this._foreignDBMeta.equals(target.getForeignDBMeta());
    }

    public String toString() {
        return "{" + this._localDBMeta.getTableDbName() + "." + this._foreignPropertyName + "->" + this._foreignDBMeta.getTableDbName() + "}";
    }

    @Override
    public String getConstraintName() {
        return this._constraintName;
    }

    public String getForeignPropertyName() {
        return this._foreignPropertyName;
    }

    @Override
    public DBMeta getLocalDBMeta() {
        return this._localDBMeta;
    }

    public DBMeta getForeignDBMeta() {
        return this._foreignDBMeta;
    }

    public Map<ColumnInfo, ColumnInfo> getLocalForeignColumnInfoMap() {
        return this._localForeignColumnInfoMap;
    }

    public Map<ColumnInfo, ColumnInfo> getForeignLocalColumnInfoMap() {
        return this._foreignLocalColumnInfoMap;
    }

    public int getRelationNo() {
        return this._relationNo;
    }

    @Override
    public Class<?> getObjectNativeType() {
        return this._objectNativeType;
    }

    @Override
    public Class<?> getPropertyAccessType() {
        return this._propertyAccessType;
    }

    @Override
    public boolean isOneToOne() {
        return this._oneToOne;
    }

    public boolean isBizOneToOne() {
        return this._bizOneToOne;
    }

    public boolean isReferrerAsOne() {
        return this._referrerAsOne;
    }

    public boolean isAdditionalFK() {
        return this._additionalFK;
    }

    public String getFixedCondition() {
        return this._fixedCondition;
    }

    public List<String> getDynamicParameterList() {
        return this._dynamicParameterList;
    }

    public boolean isFixedInline() {
        return this._fixedInline;
    }

    @Override
    public RelationInfo getReverseRelation() {
        return this._reversePropertyName != null ? this._foreignDBMeta.findRelationInfo(this._reversePropertyName) : null;
    }

    public boolean canBeNullObject() {
        return this._canBeNullObject;
    }

    @Override
    public boolean isCompoundKey() {
        return this.getLocalForeignColumnInfoMap().size() > 1;
    }

    public boolean isPureFK() {
        return !this._additionalFK && !this._referrerAsOne;
    }

    public boolean isNotNullFKColumn() {
        for (Map.Entry<ColumnInfo, ColumnInfo> entry : this.getLocalForeignColumnInfoMap().entrySet()) {
            ColumnInfo localColumnInfo = entry.getKey();
            if (localColumnInfo.isNotNull()) continue;
            return false;
        }
        return true;
    }

    public boolean hasFixedCondition() {
        return this._fixedCondition != null && this._fixedCondition.trim().length() > 0;
    }

    public boolean hasFixedConditionDynamicParameter() {
        return this.hasFixedCondition() && !this._dynamicParameterList.isEmpty();
    }

    public boolean isFixedConditionDynamicParameterRequired() {
        return this.hasFixedConditionDynamicParameter() && !this.getFixedCondition().contains("/*IF ");
    }
}

