/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.dream;

import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpCalcSpecification;
import org.dbflute.cbean.coption.ColumnConversionOption;
import org.dbflute.cbean.coption.FunctionFilterOptionCall;
import org.dbflute.cbean.dream.ColumnCalculator;
import org.dbflute.cbean.scoping.SpecifyQuery;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.name.ColumnRealName;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.exception.IllegalConditionBeanOperationException;

public class SpecifiedColumn
implements ColumnCalculator {
    protected final String _tableAliasName;
    protected final ColumnInfo _columnInfo;
    protected final ConditionBean _baseCB;
    protected final String _columnDirectName;
    protected final boolean _derived;
    protected SpecifiedColumn _mappedSpecifiedColumn;
    protected String _mappedDerivedAlias;
    protected String _onQueryName;
    protected HpCalcSpecification<ConditionBean> _calcSpecification;

    public SpecifiedColumn(String tableAliasName, ColumnInfo columnInfo, ConditionBean baseCB) {
        this.assertColumnInfo(tableAliasName, columnInfo);
        this.assertBaseCB(tableAliasName, baseCB);
        this._tableAliasName = tableAliasName;
        this._columnInfo = columnInfo;
        this._baseCB = baseCB;
        this._columnDirectName = null;
        this._derived = false;
    }

    public SpecifiedColumn(String tableAliasName, ColumnInfo columnInfo, ConditionBean baseCB, String columnDirectName, boolean derived) {
        this.assertColumnInfo(tableAliasName, columnInfo);
        this.assertBaseCB(tableAliasName, baseCB);
        this._tableAliasName = tableAliasName;
        this._columnInfo = columnInfo;
        this._baseCB = baseCB;
        this._columnDirectName = columnDirectName;
        this._derived = derived;
    }

    protected void assertColumnInfo(String tableAliasName, ColumnInfo columnInfo) {
        if (columnInfo == null) {
            String msg = "The argument 'columnInfo' should not be null: tableAliasName=" + tableAliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertBaseCB(String tableAliasName, ConditionBean baseCB) {
        if (baseCB == null) {
            String msg = "The argument 'baseCB' should not be null: tableAliasName=" + tableAliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    public boolean isDreamCruiseTicket() {
        return this._baseCB.xisDreamCruiseShip();
    }

    public void setupSelectDreamCruiseJourneyLogBookIfUnionExists() {
        if (!this.isDreamCruiseTicket()) {
            String msg = "This method is only allowed at Dream Cruise.";
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._baseCB.xsetupSelectDreamCruiseJourneyLogBookIfUnionExists();
    }

    public String getColumnDbName() {
        return this._columnInfo.getColumnDbName();
    }

    public ColumnSqlName toColumnSqlName() {
        return this._columnDirectName != null ? new ColumnSqlName(this._columnDirectName) : this._columnInfo.getColumnSqlName();
    }

    public ColumnRealName toColumnRealName() {
        return ColumnRealName.create(this._tableAliasName, this.toColumnSqlName());
    }

    public void mappedFrom(SpecifiedColumn mappedSpecifiedInfo) {
        this._mappedSpecifiedColumn = mappedSpecifiedInfo;
    }

    public void mappedFromDerived(String mappedDerivedAlias) {
        this._mappedDerivedAlias = mappedDerivedAlias;
    }

    public String getValidMappedOnQueryName() {
        if (this._mappedSpecifiedColumn != null) {
            return this._mappedSpecifiedColumn.getOnQueryName();
        }
        if (this._mappedDerivedAlias != null) {
            return this._mappedDerivedAlias;
        }
        return null;
    }

    @Override
    public SpecifiedColumn plus(Number plusValue) {
        this.assertObjectNotNull("plusValue", plusValue);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.plus(plusValue);
        return this;
    }

    @Override
    public SpecifiedColumn plus(SpecifiedColumn plusColumn) {
        this.assertObjectNotNull("plusColumn", plusColumn);
        this.assertCalculationColumnNumber(plusColumn);
        this.assertSpecifiedDreamCruiseTicket(plusColumn);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.plus(plusColumn);
        return this;
    }

    @Override
    public SpecifiedColumn minus(Number minusValue) {
        this.assertObjectNotNull("minusValue", minusValue);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.minus(minusValue);
        return this;
    }

    @Override
    public SpecifiedColumn minus(SpecifiedColumn minusColumn) {
        this.assertObjectNotNull("minusColumn", minusColumn);
        this.assertCalculationColumnNumber(minusColumn);
        this.assertSpecifiedDreamCruiseTicket(minusColumn);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.minus(minusColumn);
        return this;
    }

    @Override
    public SpecifiedColumn multiply(Number multiplyValue) {
        this.assertObjectNotNull("multiplyValue", multiplyValue);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.multiply(multiplyValue);
        return this;
    }

    @Override
    public SpecifiedColumn multiply(SpecifiedColumn multiplyColumn) {
        this.assertObjectNotNull("multiplyColumn", multiplyColumn);
        this.assertCalculationColumnNumber(multiplyColumn);
        this.assertSpecifiedDreamCruiseTicket(multiplyColumn);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.multiply(multiplyColumn);
        return this;
    }

    @Override
    public SpecifiedColumn divide(Number divideValue) {
        this.assertObjectNotNull("divideValue", divideValue);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.divide(divideValue);
        return this;
    }

    @Override
    public SpecifiedColumn divide(SpecifiedColumn divideColumn) {
        this.assertObjectNotNull("divideColumn", divideColumn);
        this.assertCalculationColumnNumber(divideColumn);
        this.assertSpecifiedDreamCruiseTicket(divideColumn);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.divide(divideColumn);
        return this;
    }

    @Override
    public SpecifiedColumn convert(FunctionFilterOptionCall<ColumnConversionOption> opLambda) {
        this.assertObjectNotNull("opLambda", opLambda);
        this.initializeCalcSpecificationIfNeeds();
        this._calcSpecification.convert((ColumnConversionOption op) -> {
            this.initializeConvOptionColumn((ColumnConversionOption)op);
            opLambda.callback((ColumnConversionOption)op);
        });
        return this;
    }

    protected void initializeConvOptionColumn(ColumnConversionOption option) {
        option.xsetTargetColumnInfo(this._columnInfo);
    }

    @Override
    public ColumnCalculator left() {
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.left();
    }

    @Override
    public ColumnCalculator right() {
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.right();
    }

    protected void initializeCalcSpecificationIfNeeds() {
        if (this._calcSpecification == null) {
            this._calcSpecification = this.createEmptyCalcSpecification();
            ConditionBean handlingCB = this._baseCB.xisDreamCruiseShip() ? this._baseCB.xgetDreamCruiseDeparturePort() : this._baseCB;
            this._calcSpecification.setBaseCB(handlingCB);
        }
    }

    protected HpCalcSpecification<ConditionBean> createEmptyCalcSpecification() {
        return this.newCalcSpecification(this.createEmptySpecifyQuery());
    }

    protected SpecifyQuery<ConditionBean> createEmptySpecifyQuery() {
        return new SpecifyQuery<ConditionBean>(){

            @Override
            public void specify(ConditionBean cb) {
            }
        };
    }

    protected HpCalcSpecification<ConditionBean> newCalcSpecification(SpecifyQuery<ConditionBean> specifyQuery) {
        return new HpCalcSpecification<ConditionBean>(specifyQuery);
    }

    public boolean hasSpecifyCalculation() {
        return this._calcSpecification != null;
    }

    public HpCalcSpecification<ConditionBean> getSpecifyCalculation() {
        return this._calcSpecification;
    }

    public void xinitSpecifyCalculation() {
        this._calcSpecification.specify(this._baseCB);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCalculationColumnNumber(SpecifiedColumn specifiedColumn) {
        ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
        if (columnInfo == null) {
            return;
        }
        if (!columnInfo.isObjectNativeTypeNumber()) {
            String msg = "The type of the calculation column should be Number: " + specifiedColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertSpecifiedDreamCruiseTicket(SpecifiedColumn column) {
        if (!column.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + column;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this._tableAliasName).append(", ");
        if (this._columnDirectName != null) {
            sb.append(this._columnDirectName + ", ");
        }
        sb.append(this._columnInfo).append("}");
        return sb.toString();
    }

    public String getTableAliasName() {
        return this._tableAliasName;
    }

    public ColumnInfo getColumnInfo() {
        return this._columnInfo;
    }

    public String getColumnDirectName() {
        return this._columnDirectName;
    }

    public boolean isDerived() {
        return this._derived;
    }

    public SpecifiedColumn getMappedSpecifiedInfo() {
        return this._mappedSpecifiedColumn;
    }

    public String getMappedAliasName() {
        return this._mappedDerivedAlias;
    }

    public String getOnQueryName() {
        return this._onQueryName;
    }

    public void setOnQueryName(String onQueryName) {
        this._onQueryName = onQueryName;
    }
}

