/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.chelper;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.ConditionQuery;
import org.dbflute.cbean.chelper.HpCBPurpose;
import org.dbflute.cbean.chelper.HpColumnSpHandler;
import org.dbflute.cbean.chelper.HpSDRFunction;
import org.dbflute.cbean.chelper.HpSDRFunctionFactory;
import org.dbflute.cbean.chelper.HpSDRSetupper;
import org.dbflute.cbean.chelper.HpSpQyCall;
import org.dbflute.cbean.chelper.HpSpQyDelegatingCall;
import org.dbflute.cbean.chelper.HpSpQyHas;
import org.dbflute.cbean.chelper.HpSpQyQy;
import org.dbflute.cbean.dream.SpecifiedColumn;
import org.dbflute.cbean.exception.ConditionBeanExceptionThrower;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.cbean.sqlclause.join.InnerJoinNoWaySpeaker;
import org.dbflute.cbean.sqlclause.query.QueryUsedAliasInfo;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.DBMetaProvider;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.system.DBFluteSystem;

public abstract class HpAbstractSpecification<CQ extends ConditionQuery>
implements HpColumnSpHandler {
    protected final ConditionBean _baseCB;
    protected final HpSpQyCall<CQ> _qyCall;
    protected HpSpQyCall<CQ> _syncQyCall;
    protected final HpCBPurpose _purpose;
    protected final DBMetaProvider _dbmetaProvider;
    protected final HpSDRFunctionFactory _sdrFuncFactory;
    protected CQ _query;
    protected boolean _alreadySpecifiedRequiredColumn;
    protected Map<String, SpecifiedColumn> _specifiedColumnMap;
    protected boolean _alreadySpecifiedEveryColumn;
    protected boolean _alreadySpecifiedExceptColumn;

    protected HpAbstractSpecification(ConditionBean baseCB, HpSpQyCall<CQ> qyCall, HpCBPurpose purpose, DBMetaProvider dbmetaProvider, HpSDRFunctionFactory sdrFuncFactory) {
        this._baseCB = baseCB;
        this._qyCall = qyCall;
        this._purpose = purpose;
        this._dbmetaProvider = dbmetaProvider;
        this._sdrFuncFactory = sdrFuncFactory;
    }

    @Override
    public SpecifiedColumn xspecifyColumn(String columnName) {
        return this.doColumn(columnName);
    }

    protected SpecifiedColumn doColumn(String columnName) {
        String tableAliasName;
        this.checkSpecifiedThemeColumnStatus(columnName);
        if (this.isSpecifiedColumn(columnName)) {
            return this.getSpecifiedColumn(columnName);
        }
        this.assertColumn(columnName);
        this.callQuery();
        if (this.isRequiredColumnSpecificationEnabled()) {
            this._alreadySpecifiedRequiredColumn = true;
            this.doSpecifyRequiredColumn();
        }
        SqlClause sqlClause = this._baseCB.getSqlClause();
        if (this._query.isBaseQuery()) {
            tableAliasName = sqlClause.getBasePointAliasName();
        } else {
            String relationPath = this._query.xgetRelationPath();
            int nestLevel = this._query.xgetNestLevel();
            tableAliasName = sqlClause.resolveJoinAliasName(relationPath, nestLevel);
            this.keepDreamCruiseJourneyLogBookIfNeeds(relationPath, tableAliasName);
            this.reflectDreamCruiseWhereUsedToJoin(relationPath, tableAliasName);
        }
        SpecifiedColumn specifiedColumn = this.createSpecifiedColumn(columnName, tableAliasName);
        sqlClause.specifySelectColumn(specifiedColumn);
        this.saveSpecifiedColumn(columnName, specifiedColumn);
        return specifiedColumn;
    }

    protected void checkSpecifiedThemeColumnStatus(String columnName) {
        if (this._alreadySpecifiedEveryColumn) {
            this.throwSpecifyColumnAlreadySpecifiedEveryColumnException(columnName);
        }
        if (this._alreadySpecifiedExceptColumn) {
            this.throwSpecifyColumnAlreadySpecifiedExceptColumnException(columnName);
        }
    }

    protected void callQuery() {
        if (this._query == null) {
            this._query = this.qyCall().qy();
        }
    }

    protected HpSpQyCall<CQ> qyCall() {
        return this._syncQyCall != null ? this._syncQyCall : this._qyCall;
    }

    protected boolean isRequiredColumnSpecificationEnabled() {
        if (this._alreadySpecifiedRequiredColumn) {
            return false;
        }
        return this.isNormalUse();
    }

    protected abstract void doSpecifyRequiredColumn();

    protected abstract String getTableDbName();

    protected SpecifiedColumn createSpecifiedColumn(String columnName, String tableAliasName) {
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(this._query.asTableDbName());
        ColumnInfo columnInfo = dbmeta.findColumnInfo(columnName);
        return new SpecifiedColumn(tableAliasName, columnInfo, this._baseCB);
    }

    public SpecifiedColumn getSpecifiedColumn(String columnName) {
        return this._specifiedColumnMap != null ? this._specifiedColumnMap.get(columnName) : null;
    }

    @Override
    public boolean hasSpecifiedColumn() {
        return this._specifiedColumnMap != null && !this._specifiedColumnMap.isEmpty();
    }

    @Override
    public boolean isSpecifiedColumn(String columnName) {
        return this._specifiedColumnMap != null && this._specifiedColumnMap.containsKey(columnName);
    }

    protected void saveSpecifiedColumn(String columnName, SpecifiedColumn specifiedColumn) {
        if (this._specifiedColumnMap == null) {
            this._specifiedColumnMap = new LinkedHashMap<String, SpecifiedColumn>();
        }
        this._specifiedColumnMap.put(columnName, specifiedColumn);
    }

    protected void keepDreamCruiseJourneyLogBookIfNeeds(String relationPath, String tableAliasName) {
        if (!this._baseCB.xisDreamCruiseShip()) {
            return;
        }
        this._baseCB.xkeepDreamCruiseJourneyLogBook(relationPath);
    }

    protected void reflectDreamCruiseWhereUsedToJoin(String relationPath, String tableAliasName) {
        if (!this._baseCB.xisDreamCruiseShip()) {
            return;
        }
        ConditionBean portCB = this._baseCB.xgetDreamCruiseDeparturePort();
        QueryUsedAliasInfo usedAliasInfo = new QueryUsedAliasInfo(tableAliasName, new InnerJoinNoWaySpeaker(){

            @Override
            public boolean isNoWayInner() {
                return true;
            }
        });
        portCB.getSqlClause().reflectWhereUsedToJoin(usedAliasInfo);
    }

    protected void doEveryColumn() {
        if (this.hasSpecifiedColumn()) {
            this.throwSpecifyEveryColumnAlreadySpecifiedColumnException();
        }
        this.callQuery();
        boolean specifiedUpdateUse = this.isSpecifiedUpdateUse();
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            if (specifiedUpdateUse && columnInfo.isPrimary()) continue;
            this.doColumn(columnInfo.getColumnDbName());
        }
        this._alreadySpecifiedEveryColumn = true;
    }

    @Override
    public boolean isSpecifiedEveryColumn() {
        return this._alreadySpecifiedEveryColumn;
    }

    protected void doExceptRecordMetaColumn() {
        if (this.hasSpecifiedColumn()) {
            this.throwSpecifyExceptColumnAlreadySpecifiedColumnException();
        }
        this.callQuery();
        boolean specifiedUpdateUse = this.isSpecifiedUpdateUse();
        List<ColumnInfo> columnInfoList = this.getColumnInfoList();
        for (ColumnInfo columnInfo : columnInfoList) {
            if (this.isRecordMetaColumn(columnInfo) || specifiedUpdateUse && columnInfo.isPrimary()) continue;
            this.doColumn(columnInfo.getColumnDbName());
        }
        this._alreadySpecifiedExceptColumn = true;
    }

    @Override
    public boolean isSpecifiedExceptColumn() {
        return this._alreadySpecifiedExceptColumn;
    }

    protected boolean isRecordMetaColumn(ColumnInfo columnInfo) {
        return columnInfo.isCommonColumn() || columnInfo.isOptimisticLock();
    }

    protected List<ColumnInfo> getColumnInfoList() {
        String tableDbName = this._query.asTableDbName();
        DBMeta dbmeta = this._dbmetaProvider.provideDBMeta(tableDbName);
        return dbmeta.getColumnInfoList();
    }

    protected boolean isSpecifiedUpdateUse() {
        return HpCBPurpose.SPECIFIED_UPDATE.equals((Object)this._purpose);
    }

    protected void assertColumn(String columnName) {
        if (this._purpose.isNoSpecifyColumnTwoOrMore() && this._specifiedColumnMap != null && this._specifiedColumnMap.size() > 0) {
            this.throwSpecifyColumnTwoOrMoreColumnException(columnName);
        }
        if (this._purpose.isNoSpecifyColumnWithDerivedReferrer() && this.hasDerivedReferrer()) {
            this.throwSpecifyColumnWithDerivedReferrerException(columnName, null);
        }
        if (this.isNormalUse() && this._query == null && !this.qyCall().has()) {
            this.throwSpecifyColumnNotSetupSelectColumnException(columnName);
        }
    }

    protected void assertRelation(String relationName) {
        if (this._purpose.isNoSpecifyRelation()) {
            this.throwSpecifyRelationIllegalPurposeException(relationName);
        }
    }

    protected void assertDerived(String referrerName) {
        if (this._purpose.isNoSpecifyDerivedReferrer()) {
            this.throwSpecifyDerivedReferrerIllegalPurposeException(referrerName);
        }
        if (this._purpose.isNoSpecifyDerivedReferrerTwoOrMore() && this.hasDerivedReferrer()) {
            this.throwSpecifyDerivedReferrerTwoOrMoreException(referrerName);
        }
        if (this._purpose.isNoSpecifyColumnWithDerivedReferrer() && this._specifiedColumnMap != null && this._specifiedColumnMap.size() > 0) {
            this.throwSpecifyColumnWithDerivedReferrerException(null, referrerName);
        }
    }

    protected boolean isNormalUse() {
        return HpCBPurpose.NORMAL_USE.equals((Object)this._purpose);
    }

    public boolean isAlreadySpecifiedRequiredColumn() {
        return this._alreadySpecifiedRequiredColumn;
    }

    protected boolean hasDerivedReferrer() {
        return !this._baseCB.getSqlClause().getSpecifiedDerivingAliasList().isEmpty();
    }

    public HpSpQyCall<CQ> xsyncQyCall() {
        return this._syncQyCall;
    }

    public void xsetSyncQyCall(HpSpQyCall<CQ> qyCall) {
        this._syncQyCall = qyCall;
    }

    @Override
    public boolean xhasSyncQyCall() {
        return this._syncQyCall != null;
    }

    protected <MYCQ extends ConditionQuery> HpSpQyCall<MYCQ> xcreateSpQyCall(HpSpQyHas<MYCQ> has, HpSpQyQy<MYCQ> qy) {
        return new HpSpQyDelegatingCall<MYCQ>(has, qy);
    }

    protected void throwSpecifyColumnTwoOrMoreColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnTwoOrMoreColumnException(this._purpose, this._baseCB, columnName);
    }

    protected void throwSpecifyColumnNotSetupSelectColumnException(String columnName) {
        this.createCBExThrower().throwSpecifyColumnNotSetupSelectColumnException(this._baseCB, columnName);
    }

    protected void throwSpecifyColumnWithDerivedReferrerException(String columnName, String referrerName) {
        this.createCBExThrower().throwSpecifyColumnWithDerivedReferrerException(this._purpose, this._baseCB, columnName, referrerName);
    }

    protected void throwSpecifyColumnAlreadySpecifiedEveryColumnException(String columnName) {
        String tableDbName = this._baseCB.asTableDbName();
        this.createCBExThrower().throwSpecifyColumnAlreadySpecifiedEveryColumnException(tableDbName, columnName);
    }

    protected void throwSpecifyColumnAlreadySpecifiedExceptColumnException(String columnName) {
        String tableDbName = this._baseCB.asTableDbName();
        this.createCBExThrower().throwSpecifyColumnAlreadySpecifiedExceptColumnException(tableDbName, columnName);
    }

    protected void throwSpecifyEveryColumnAlreadySpecifiedColumnException() {
        String tableDbName = this._baseCB.asTableDbName();
        this.createCBExThrower().throwSpecifyEveryColumnAlreadySpecifiedColumnException(tableDbName, this._specifiedColumnMap);
    }

    protected void throwSpecifyExceptColumnAlreadySpecifiedColumnException() {
        String tableDbName = this._baseCB.asTableDbName();
        this.createCBExThrower().throwSpecifyExceptColumnAlreadySpecifiedColumnException(tableDbName, this._specifiedColumnMap);
    }

    protected void throwSpecifyRelationIllegalPurposeException(String relationName) {
        this.createCBExThrower().throwSpecifyRelationIllegalPurposeException(this._purpose, this._baseCB, relationName);
    }

    protected void throwSpecifyDerivedReferrerIllegalPurposeException(String referrerName) {
        this.createCBExThrower().throwSpecifyDerivedReferrerIllegalPurposeException(this._purpose, this._baseCB, referrerName);
    }

    protected void throwSpecifyDerivedReferrerTwoOrMoreException(String referrerName) {
        this.createCBExThrower().throwSpecifyDerivedReferrerTwoOrMoreException(this._purpose, this._baseCB, referrerName);
    }

    protected <FUNC extends HpSDRFunction<REFERRER_CB, LOCAL_CQ>, REFERRER_CB extends ConditionBean, LOCAL_CQ extends ConditionQuery> FUNC cHSDRF(ConditionBean baseCB, LOCAL_CQ localCQ, HpSDRSetupper<REFERRER_CB, LOCAL_CQ> querySetupper, DBMetaProvider dbmetaProvider) {
        return (FUNC)this.newSDRFunction(baseCB, localCQ, querySetupper, dbmetaProvider, this._sdrFuncFactory);
    }

    protected <REFERRER_CB extends ConditionBean, LOCAL_CQ extends ConditionQuery> HpSDRFunction<REFERRER_CB, LOCAL_CQ> newSDRFunction(ConditionBean baseCB, LOCAL_CQ localCQ, HpSDRSetupper<REFERRER_CB, LOCAL_CQ> querySetupper, DBMetaProvider dbmetaProvider, HpSDRFunctionFactory sdrOpFactory) {
        return this._sdrFuncFactory.create(baseCB, localCQ, querySetupper, dbmetaProvider);
    }

    public HpSDRFunctionFactory xgetSDRFnFc() {
        return this._sdrFuncFactory;
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }
}

