/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbflute.Entity;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.ConditionQuery;
import org.dbflute.cbean.chelper.HpCBPurpose;
import org.dbflute.cbean.chelper.HpCalcSpecification;
import org.dbflute.cbean.chelper.HpColQyHandler;
import org.dbflute.cbean.chelper.HpColQyOperand;
import org.dbflute.cbean.chelper.HpDerivingSubQueryInfo;
import org.dbflute.cbean.chelper.HpSDRFunction;
import org.dbflute.cbean.chelper.HpSDRFunctionFactory;
import org.dbflute.cbean.chelper.HpSDRSetupper;
import org.dbflute.cbean.chelper.HpSpQyCall;
import org.dbflute.cbean.chelper.HpSpQyDelegatingCall;
import org.dbflute.cbean.chelper.HpSpQyHas;
import org.dbflute.cbean.chelper.HpSpQyQy;
import org.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.dbflute.cbean.coption.CursorSelectOption;
import org.dbflute.cbean.coption.DerivedReferrerOption;
import org.dbflute.cbean.coption.DerivedReferrerOptionFactory;
import org.dbflute.cbean.coption.SVOptionCall;
import org.dbflute.cbean.coption.ScalarSelectOption;
import org.dbflute.cbean.coption.StatementConfigCall;
import org.dbflute.cbean.dream.ColumnCalculator;
import org.dbflute.cbean.dream.SpecifiedColumn;
import org.dbflute.cbean.exception.ConditionBeanExceptionThrower;
import org.dbflute.cbean.ordering.OrderByBean;
import org.dbflute.cbean.paging.PagingBean;
import org.dbflute.cbean.paging.PagingInvoker;
import org.dbflute.cbean.scoping.AndQuery;
import org.dbflute.cbean.scoping.ModeQuery;
import org.dbflute.cbean.scoping.OrQuery;
import org.dbflute.cbean.scoping.SpecifyQuery;
import org.dbflute.cbean.scoping.UnionQuery;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.cbean.sqlclause.clause.ClauseLazyReflector;
import org.dbflute.cbean.sqlclause.clause.SelectClauseType;
import org.dbflute.cbean.sqlclause.join.InnerJoinNoWaySpeaker;
import org.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.dbflute.cbean.sqlclause.query.QueryClause;
import org.dbflute.cbean.sqlclause.query.QueryClauseFilter;
import org.dbflute.cbean.sqlclause.query.QueryUsedAliasInfo;
import org.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.DBMetaProvider;
import org.dbflute.dbmeta.accessory.DerivedTypeHandler;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.info.ForeignInfo;
import org.dbflute.dbmeta.name.ColumnRealName;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.exception.ColumnQueryCalculationUnsupportedColumnTypeException;
import org.dbflute.exception.ConditionInvokingFailureException;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.exception.OrScopeQueryAndPartUnsupportedOperationException;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.jdbc.StatementConfig;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.twowaysql.SqlAnalyzer;
import org.dbflute.twowaysql.factory.SqlAnalyzerFactory;
import org.dbflute.twowaysql.style.BoundDateDisplayStyle;
import org.dbflute.twowaysql.style.BoundDateDisplayTimeZoneProvider;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public abstract class AbstractConditionBean
implements ConditionBean {
    protected final SqlClause _sqlClause = this.createSqlClause();
    protected boolean _pagingCountLater;
    protected boolean _pagingReSelect = true;
    protected boolean _pagingSelectAndQuerySplit;
    protected List<ConditionBean> _unionCBeanList;
    protected UnionQuery<ConditionBean> _unionQuerySynchronizer;
    protected HpCBPurpose _purpose = HpCBPurpose.NORMAL_USE;
    protected boolean _locked;
    protected boolean _departurePortForDreamCruise;
    protected ConditionBean _dreamCruiseDeparturePort;
    protected SpecifiedColumn _dreamCruiseTicket;
    protected List<String> _dreamCruiseJourneyLogBook;
    protected Object _mysticBinding;
    protected int _safetyMaxResultSize;
    protected CursorSelectOption _cursorSelectOption;
    protected StatementConfig _statementConfig;
    protected boolean _canRelationMappingCache = true;
    protected boolean _nonSpecifiedColumnAccessAllowed;
    protected boolean _queryUpdateCountPreCheck;
    protected DerivedTypeHandler _derivedTypeHandler;
    protected BoundDateDisplayStyle _logDateDisplayStyle;
    protected boolean _isSelectCountIgnoreFetchScope;

    @Override
    public SqlClause getSqlClause() {
        return this._sqlClause;
    }

    protected abstract SqlClause createSqlClause();

    @Override
    public DBMeta asDBMeta() {
        return this.getDBMetaProvider().provideDBMetaChecked(this.asTableDbName());
    }

    protected abstract DBMetaProvider getDBMetaProvider();

    protected void doSetupSelect(SsCall callback) {
        String foreignPropertyName = callback.qf().xgetForeignPropertyName();
        String foreignTableAliasName = callback.qf().xgetAliasName();
        String localRelationPath = this.localCQ().xgetRelationPath();
        String foreignRelationPath = callback.qf().xgetRelationPath();
        this.getSqlClause().registerSelectedRelation(foreignTableAliasName, this.asTableDbName(), foreignPropertyName, localRelationPath, foreignRelationPath);
    }

    protected void assertSetupSelectPurpose(String foreignPropertyName) {
        if (this._purpose.isNoSetupSelect()) {
            String titleName = DfTypeUtil.toClassTitle(this);
            this.throwSetupSelectIllegalPurposeException(titleName, foreignPropertyName);
        }
        if (this.isLocked()) {
            this.createCBExThrower().throwSetupSelectThatsBadTimingException(this, foreignPropertyName);
        }
    }

    protected void throwSetupSelectIllegalPurposeException(String className, String foreignPropertyName) {
        this.createCBExThrower().throwSetupSelectIllegalPurposeException(this._purpose, this, foreignPropertyName);
    }

    protected <CQ extends ConditionQuery> HpSpQyCall<CQ> xcreateSpQyCall(HpSpQyHas<CQ> has, HpSpQyQy<CQ> qy) {
        return new HpSpQyDelegatingCall<CQ>(has, qy);
    }

    protected void assertSpecifyPurpose() {
        if (this._purpose.isNoSpecify()) {
            this.throwSpecifyIllegalPurposeException();
        }
        if (this.isLocked() && !this.xisDreamCruiseShip()) {
            this.createCBExThrower().throwSpecifyThatsBadTimingException(this);
        }
    }

    protected void throwSpecifyIllegalPurposeException() {
        this.createCBExThrower().throwSpecifyIllegalPurposeException(this._purpose, this);
    }

    protected void assertQueryPurpose() {
        if (this._purpose.isNoQuery()) {
            this.throwQueryIllegalPurposeException();
        }
        if (this.isLocked()) {
            this.createCBExThrower().throwQueryThatsBadTimingException(this);
        }
    }

    protected void throwQueryIllegalPurposeException() {
        this.createCBExThrower().throwQueryIllegalPurposeException(this._purpose, this);
    }

    @Override
    public void enableInnerJoinAutoDetect() {
        this.getSqlClause().enableInnerJoinAutoDetect();
    }

    @Override
    public void disableInnerJoinAutoDetect() {
        this.getSqlClause().disableInnerJoinAutoDetect();
    }

    protected <CB extends ConditionBean> ColumnCalculator xcolqy(CB leftCB, CB rightCB, SpecifyQuery<CB> leftSp, SpecifyQuery<CB> rightSp, String operand) {
        this.assertQueryPurpose();
        HpCalcSpecification<CB> leftCalcSp = this.xcreateCalcSpecification(leftSp);
        leftCalcSp.specify(leftCB);
        String leftColumn = this.xbuildColQyLeftColumn(leftCB, leftCalcSp);
        HpCalcSpecification<CB> rightCalcSp = this.xcreateCalcSpecification(rightSp);
        rightCalcSp.specify(rightCB);
        String rightColumn = this.xbuildColQyRightColumn(rightCB, rightCalcSp);
        rightCalcSp.setLeftCalcSp(leftCalcSp);
        QueryClause queryClause = this.xcreateColQyClause(leftColumn, operand, rightColumn, rightCalcSp);
        this.xregisterColQyClause(queryClause, leftCalcSp, rightCalcSp);
        return rightCalcSp;
    }

    protected <CB extends ConditionBean> HpColQyOperand<CB> xcreateColQyOperand(HpColQyHandler<CB> handler) {
        return new HpColQyOperand<CB>(handler);
    }

    protected <CB extends ConditionBean> HpColQyOperand.HpExtendedColQyOperandMySql<CB> xcreateColQyOperandMySql(HpColQyHandler<CB> handler) {
        return new HpColQyOperand.HpExtendedColQyOperandMySql<CB>(handler);
    }

    protected <CB extends ConditionBean> String xbuildColQyLeftColumn(CB leftCB, HpCalcSpecification<CB> leftCalcSp) {
        ColumnRealName realName = this.xextractColQyColumnRealName(leftCB, leftCalcSp);
        return this.xbuildColQyColumn(leftCB, realName.toString(), "left");
    }

    protected <CB extends ConditionBean> String xbuildColQyRightColumn(CB rightCB, HpCalcSpecification<CB> rightCalcSp) {
        ColumnRealName realName = this.xextractColQyColumnRealName(rightCB, rightCalcSp);
        return this.xbuildColQyColumn(rightCB, realName.toString(), "right");
    }

    protected <CB extends ConditionBean> ColumnRealName xextractColQyColumnRealName(CB cb, HpCalcSpecification<CB> calcSp) {
        Object mysticBinding = cb.xgetMysticBinding();
        if (mysticBinding != null) {
            calcSp.setMysticBindingSnapshot(mysticBinding);
            return this.xdoExtractColQyColumnMysticBinding(cb, mysticBinding);
        }
        return this.xdoExtractColQyColumnSpecifiedColumn(calcSp);
    }

    protected <CB extends ConditionBean> ColumnRealName xdoExtractColQyColumnMysticBinding(CB cb, Object mysticBinding) {
        String exp = cb.getSqlClause().registerFreeParameterToThemeList("mystic", mysticBinding);
        return ColumnRealName.create(null, new ColumnSqlName(exp));
    }

    protected <CB extends ConditionBean> ColumnRealName xdoExtractColQyColumnSpecifiedColumn(HpCalcSpecification<CB> calcSp) {
        ColumnRealName realName = calcSp.getResolvedSpecifiedColumnRealName();
        if (realName == null) {
            this.createCBExThrower().throwColumnQueryInvalidColumnSpecificationException(this);
        }
        return realName;
    }

    protected <CB extends ConditionBean> String xbuildColQyColumn(CB cb, String source, String themeKey) {
        String bindingExp = this.getSqlClause().registerColumnQueryObjectToThemeList(themeKey, cb);
        return Srl.replace(source, "/*pmb.conditionQuery.", bindingExp);
    }

    protected <CB extends ConditionBean> HpCalcSpecification<CB> xcreateCalcSpecification(SpecifyQuery<CB> calcSp) {
        return this.xnewCalcSpecification(calcSp, this);
    }

    protected <CB extends ConditionBean> HpCalcSpecification<CB> xnewCalcSpecification(SpecifyQuery<CB> calcSp, ConditionBean baseCB) {
        return new HpCalcSpecification<CB>(calcSp, baseCB);
    }

    protected <CB extends ConditionBean> QueryClause xcreateColQyClause(final String leftColumn, final String operand, final String rightColumn, final HpCalcSpecification<CB> rightCalcSp) {
        return new QueryClause(){

            @Override
            public String toString() {
                String leftExp = this.resolveColumnExp(rightCalcSp.getLeftCalcSp(), leftColumn);
                String rightExp = this.resolveColumnExp(rightCalcSp, rightColumn);
                return AbstractConditionBean.this.xbuildColQyClause(leftExp, operand, rightExp);
            }

            protected String resolveColumnExp(HpCalcSpecification<CB> calcSp, String columnExp) {
                String resolvedExp;
                if (calcSp != null) {
                    String statement = calcSp.buildStatementToSpecifidName(columnExp);
                    if (statement != null) {
                        this.assertCalculationColumnType(calcSp);
                        resolvedExp = statement;
                    } else {
                        ColumnInfo columnInfo = calcSp.getSpecifiedColumnInfo();
                        resolvedExp = columnInfo != null ? AbstractConditionBean.this.decryptIfNeeds(columnInfo, columnExp) : columnExp;
                    }
                } else {
                    resolvedExp = columnExp;
                }
                return resolvedExp;
            }

            protected void assertCalculationColumnType(HpCalcSpecification<CB> calcSp) {
                if (calcSp.hasConvert()) {
                    return;
                }
                ColumnInfo columnInfo = calcSp.getResolvedSpecifiedColumnInfo();
                if (columnInfo != null && !columnInfo.isObjectNativeTypeNumber()) {
                    String msg = "Not number column specified: " + columnInfo;
                    throw new ColumnQueryCalculationUnsupportedColumnTypeException(msg);
                }
            }
        };
    }

    protected String xbuildColQyClause(String leftExp, String operand, String rightExp) {
        StringBuilder sb = new StringBuilder();
        if (this.hasSubQueryEndOnLastLine(leftExp)) {
            if (this.hasSubQueryEndOnLastLine(rightExp)) {
                sb.append(this.reflectToSubQueryEndOnLastLine(leftExp, " " + operand + " "));
                sb.append(this.ln()).append("       ").append(rightExp);
            } else {
                sb.append(this.reflectToSubQueryEndOnLastLine(leftExp, " " + operand + " " + rightExp));
            }
        } else {
            sb.append(leftExp).append(" ").append(operand).append(" ").append(rightExp);
        }
        return sb.toString();
    }

    protected boolean hasSubQueryEndOnLastLine(String columnExp) {
        return SubQueryIndentProcessor.hasSubQueryEndOnLastLine(columnExp);
    }

    protected String reflectToSubQueryEndOnLastLine(String columnExp, String inserted) {
        return SubQueryIndentProcessor.moveSubQueryEndToRear(columnExp + inserted);
    }

    protected <CB extends ConditionBean> void xregisterColQyClause(QueryClause queryClause, HpCalcSpecification<CB> leftCalcSp, HpCalcSpecification<CB> rightCalcSp) {
        QueryUsedAliasInfo leftInfo = this.xcreateColQyAliasInfo(leftCalcSp);
        QueryUsedAliasInfo rightInfo = this.xcreateColQyAliasInfo(rightCalcSp);
        this.getSqlClause().registerWhereClause(queryClause, leftInfo, rightInfo);
    }

    protected <CB extends ConditionBean> QueryUsedAliasInfo xcreateColQyAliasInfo(final HpCalcSpecification<CB> calcSp) {
        String usedAliasName = calcSp.getResolvedSpecifiedTableAliasName();
        return new QueryUsedAliasInfo(usedAliasName, new InnerJoinNoWaySpeaker(){

            @Override
            public boolean isNoWayInner() {
                return calcSp.mayNullRevived();
            }
        });
    }

    @Override
    public void overTheWaves(SpecifiedColumn dreamCruiseTicket) {
        if (dreamCruiseTicket == null) {
            String msg = "The argument 'dreamCruiseColumn' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._dreamCruiseTicket != null) {
            String msg = "The other dream cruise ticket already exists: " + this._dreamCruiseTicket;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (!dreamCruiseTicket.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + dreamCruiseTicket;
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._dreamCruiseTicket = dreamCruiseTicket;
    }

    @Override
    public SpecifiedColumn inviteDerivedToDreamCruise(String derivedAlias) {
        if (!this.xisDreamCruiseShip()) {
            String msg = "This invitation is only allowed by Dream Cruise Ship: " + derivedAlias;
            throw new IllegalConditionBeanOperationException(msg);
        }
        SqlClause portClause = this.xgetDreamCruiseDeparturePort().getSqlClause();
        if (!portClause.hasSpecifiedDerivingSubQuery(derivedAlias)) {
            String msg = "Not found the derived info by the argument 'derivedAlias': " + derivedAlias;
            throw new IllegalArgumentException(msg);
        }
        ColumnInfo columnInfo = portClause.getSpecifiedDerivingColumnInfo(derivedAlias);
        if (columnInfo == null) {
            String msg = "Not found the derived column by the argument 'derivedAlias': " + derivedAlias;
            throw new IllegalArgumentException(msg);
        }
        return new SpecifiedColumn(null, columnInfo, this, derivedAlias, true);
    }

    @Override
    public ConditionBean xcreateDreamCruiseCB() {
        return this.xdoCreateDreamCruiseCB();
    }

    protected abstract ConditionBean xdoCreateDreamCruiseCB();

    @Override
    public void xmarkAsDeparturePortForDreamCruise() {
        this._departurePortForDreamCruise = true;
    }

    @Override
    public boolean xisDreamCruiseDeparturePort() {
        return this._departurePortForDreamCruise;
    }

    @Override
    public boolean xisDreamCruiseShip() {
        return HpCBPurpose.DREAM_CRUISE.equals((Object)this.getPurpose());
    }

    @Override
    public ConditionBean xgetDreamCruiseDeparturePort() {
        return this._dreamCruiseDeparturePort;
    }

    @Override
    public boolean xhasDreamCruiseTicket() {
        return this._dreamCruiseTicket != null;
    }

    @Override
    public SpecifiedColumn xshowDreamCruiseTicket() {
        return this._dreamCruiseTicket;
    }

    @Override
    public void xkeepDreamCruiseJourneyLogBook(String relationPath) {
        this.xassertDreamCruiseShip();
        if (this._dreamCruiseJourneyLogBook == null) {
            this._dreamCruiseJourneyLogBook = new ArrayList<String>();
        }
        this._dreamCruiseJourneyLogBook.add(relationPath);
    }

    @Override
    public void xsetupSelectDreamCruiseJourneyLogBook() {
        this.xassertDreamCruiseShip();
        if (this._dreamCruiseJourneyLogBook == null) {
            return;
        }
        this.xgetDreamCruiseDeparturePort().getSqlClause().registerClauseLazyReflector(new ClauseLazyReflector(){

            @Override
            public void reflect() {
                AbstractConditionBean.this.xdoSetupSelectDreamCruiseJourneyLogBook();
            }
        });
    }

    @Override
    public void xsetupSelectDreamCruiseJourneyLogBookIfUnionExists() {
        this.xassertDreamCruiseShip();
        if (this._dreamCruiseJourneyLogBook == null) {
            return;
        }
        if (this.xgetDreamCruiseDeparturePort().hasUnionQueryOrUnionAllQuery()) {
            this.xsetupSelectDreamCruiseJourneyLogBook();
        }
    }

    protected void xdoSetupSelectDreamCruiseJourneyLogBook() {
        ConditionBean departurePort = this.xgetDreamCruiseDeparturePort();
        for (String relationPath : this._dreamCruiseJourneyLogBook) {
            List<String> relNoExpList = Srl.splitList(relationPath, "_");
            StringBuilder sb = new StringBuilder();
            DBMeta currentMeta = this.asDBMeta();
            int index = 0;
            for (String relNoExp : relNoExpList) {
                if ("".equals(relNoExp)) continue;
                Integer relationNo = Integer.valueOf(relNoExp);
                ForeignInfo foreignInfo = currentMeta.findForeignInfo(relationNo);
                String foreignPropertyName = foreignInfo.getForeignPropertyName();
                if (index > 0) {
                    sb.append(".");
                }
                sb.append(foreignPropertyName);
                currentMeta = foreignInfo.getForeignDBMeta();
                ++index;
            }
            departurePort.invokeSetupSelect(sb.toString());
        }
    }

    protected void xassertDreamCruiseShip() {
        if (!this.xisDreamCruiseShip()) {
            String msg = "The operation is only allowed at Dream Cruise.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    @Override
    public void mysticRhythms(Object mysticBinding) {
        if (mysticBinding == null) {
            String msg = "The argument 'mysticBinding' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._mysticBinding != null) {
            String msg = "The other mystic binding already exists: " + mysticBinding;
            throw new IllegalConditionBeanOperationException(msg);
        }
        if (mysticBinding instanceof SpecifiedColumn) {
            String msg = "The mystic binding should be bound value: " + mysticBinding;
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._mysticBinding = mysticBinding;
    }

    @Override
    public Object xgetMysticBinding() {
        return this._mysticBinding;
    }

    protected <CB extends ConditionBean> void xorSQ(CB cb, OrQuery<CB> orQuery) {
        this.assertQueryPurpose();
        if (this.getSqlClause().isOrScopeQueryAndPartEffective()) {
            String msg = "The OrScopeQuery in and-part is unsupported: " + this.asTableDbName();
            throw new OrScopeQueryAndPartUnsupportedOperationException(msg);
        }
        this.xdoOrSQ(cb, orQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <CB extends ConditionBean> void xdoOrSQ(CB cb, OrQuery<CB> orQuery) {
        this.getSqlClause().beginOrScopeQuery();
        HpCBPurpose originalPurpose = this.xhandleOrSQPurposeChange();
        try {
            orQuery.query(cb);
        }
        finally {
            this.xhandleOrSQPurposeClose(originalPurpose);
            this.getSqlClause().endOrScopeQuery();
        }
    }

    protected HpCBPurpose xhandleOrSQPurposeChange() {
        HpCBPurpose originalPurpose = this.getPurpose();
        this.xsetupForOrScopeQuery();
        return originalPurpose;
    }

    protected void xhandleOrSQPurposeClose(HpCBPurpose originalPurpose) {
        if (originalPurpose != null) {
            this.xchangePurposeSqlClause(originalPurpose, null);
        }
    }

    protected <CB extends ConditionBean> void xorSQAP(CB cb, AndQuery<CB> andQuery) {
        this.assertQueryPurpose();
        if (!this.getSqlClause().isOrScopeQueryEffective()) {
            this.createCBExThrower().throwOrScopeQueryAndPartNotOrScopeException(cb);
        }
        if (this.getSqlClause().isOrScopeQueryAndPartEffective()) {
            this.createCBExThrower().throwOrScopeQueryAndPartAlreadySetupException(cb);
        }
        this.getSqlClause().beginOrScopeQueryAndPart();
        try {
            andQuery.query(cb);
        }
        finally {
            this.getSqlClause().endOrScopeQueryAndPart();
        }
    }

    @Override
    public void ignoreNullOrEmptyQuery() {
        this.assertOptionThatBadTiming("ignoreNullOrEmptyQuery()");
        this.getSqlClause().ignoreNullOrEmptyQuery();
    }

    @Override
    public void checkNullOrEmptyQuery() {
        this.assertOptionThatBadTiming("checkNullOrEmptyQuery()");
        this.getSqlClause().checkNullOrEmptyQuery();
    }

    @Override
    public void enableEmptyStringQuery(ModeQuery noArgInLambda) {
        this.assertOptionThatBadTiming("enableEmptyStringQuery()");
        this.assertObjectNotNull("noArgInLambda", noArgInLambda);
        boolean originallyAllowed = this.getSqlClause().isEmptyStringQueryAllowed();
        if (!originallyAllowed) {
            this.doEnableEmptyStringQuery();
        }
        try {
            noArgInLambda.query();
        }
        finally {
            if (!originallyAllowed) {
                this.disableEmptyStringQuery();
            }
        }
    }

    protected void doEnableEmptyStringQuery() {
        this.getSqlClause().enableEmptyStringQuery();
    }

    @Override
    public void disableEmptyStringQuery() {
        this.assertOptionThatBadTiming("disableEmptyStringQuery()");
        this.getSqlClause().disableEmptyStringQuery();
    }

    @Override
    public void enableOverridingQuery(ModeQuery noArgInLambda) {
        this.assertOptionThatBadTiming("enableOverridingQuery()");
        this.assertObjectNotNull("noArgInLambda", noArgInLambda);
        boolean originallyAllowed = this.getSqlClause().isOverridingQueryAllowed();
        if (!originallyAllowed) {
            this.doEnableOverridingQuery();
        }
        try {
            noArgInLambda.query();
        }
        finally {
            if (!originallyAllowed) {
                this.disableOverridingQuery();
            }
        }
    }

    protected void doEnableOverridingQuery() {
        this.getSqlClause().enableOverridingQuery();
    }

    @Override
    public void disableOverridingQuery() {
        this.assertOptionThatBadTiming("disableOverridingQuery()");
        this.getSqlClause().disableOverridingQuery();
    }

    @Override
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        if (!this.asDBMeta().hasPrimaryKey()) {
            String msg = "The table has no primary-keys: " + this.asTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        Entity entity = this.asDBMeta().newEntity();
        this.asDBMeta().acceptPrimaryKeyMap(entity, primaryKeyMap);
        Map<String, Object> filteredMap = this.asDBMeta().extractPrimaryKeyMap(entity);
        for (Map.Entry<String, Object> entry : filteredMap.entrySet()) {
            this.localCQ().invokeQuery(entry.getKey(), "equal", entry.getValue());
        }
    }

    @Override
    public boolean isPaging() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    public boolean canPagingCountLater() {
        return this._pagingCountLater;
    }

    @Override
    public boolean canPagingReSelect() {
        return this._pagingReSelect;
    }

    @Override
    public void paging(int pageSize, int pageNumber) {
        this.assertOptionThatBadTiming("paging()");
        if (pageSize <= 0) {
            this.throwPagingPageSizeNotPlusException(pageSize, pageNumber);
        }
        this.fetchFirst(pageSize);
        this.xfetchPage(pageNumber);
    }

    protected void throwPagingPageSizeNotPlusException(int pageSize, int pageNumber) {
        this.createCBExThrower().throwPagingPageSizeNotPlusException(this, pageSize, pageNumber);
    }

    @Override
    public void xsetPaging(boolean paging) {
    }

    @Override
    public void enablePagingCountLater() {
        this.assertOptionThatBadTiming("enablePagingCountLater()");
        this._pagingCountLater = true;
        this.getSqlClause().enablePagingCountLater();
    }

    @Override
    public void disablePagingCountLater() {
        this.assertOptionThatBadTiming("disablePagingCountLater()");
        this._pagingCountLater = false;
        this.getSqlClause().disablePagingCountLater();
    }

    @Override
    public void enablePagingReSelect() {
        this.assertOptionThatBadTiming("enablePagingReSelect()");
        this._pagingReSelect = true;
    }

    @Override
    public void disablePagingReSelect() {
        this.assertOptionThatBadTiming("disablePagingReSelect()");
        this._pagingReSelect = false;
    }

    @Override
    public void enablePagingCountLeastJoin() {
        this.assertOptionThatBadTiming("enablePagingCountLeastJoin()");
        this.getSqlClause().enablePagingCountLeastJoin();
    }

    @Override
    public void disablePagingCountLeastJoin() {
        this.assertOptionThatBadTiming("disablePagingCountLeastJoin()");
        this.getSqlClause().disablePagingCountLeastJoin();
    }

    @Override
    public boolean canPagingSelectAndQuerySplit() {
        return this._pagingSelectAndQuerySplit;
    }

    public void enablePagingSelectAndQuerySplit() {
        this.assertOptionThatBadTiming("enablePagingSelectAndQuerySplit()");
        DBMeta dbmeta = this.asDBMeta();
        if (!dbmeta.hasPrimaryKey() || dbmeta.getPrimaryInfo().isCompoundKey()) {
            String msg = "The PagingSelectAndQuerySplit needs only-one column key table: " + this.asTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this.disablePagingCountLater();
        this._pagingSelectAndQuerySplit = true;
    }

    public void disablePagingSelectAndQuerySplit() {
        this.assertOptionThatBadTiming("disablePagingSelectAndQuerySplit()");
        this._pagingSelectAndQuerySplit = false;
    }

    @Override
    public PagingBean fetchFirst(int fetchSize) {
        this.assertOptionThatBadTiming("fetchFirst()");
        this.getSqlClause().fetchFirst(fetchSize);
        return this;
    }

    @Override
    public PagingBean xfetchScope(int fetchStartIndex, int fetchSize) {
        this.assertOptionThatBadTiming("xfetchScope()");
        this.getSqlClause().fetchScope(fetchStartIndex, fetchSize);
        return this;
    }

    @Override
    public PagingBean xfetchPage(int fetchPageNumber) {
        this.assertOptionThatBadTiming("xfetchPage()");
        this.getSqlClause().fetchPage(fetchPageNumber);
        return this;
    }

    @Override
    public <ENTITY> PagingInvoker<ENTITY> createPagingInvoker(String tableDbName) {
        return new PagingInvoker(tableDbName);
    }

    @Override
    public int getFetchStartIndex() {
        return this.getSqlClause().getFetchStartIndex();
    }

    @Override
    public int getFetchSize() {
        return this.getSqlClause().getFetchSize();
    }

    @Override
    public int getFetchPageNumber() {
        return this.getSqlClause().getFetchPageNumber();
    }

    @Override
    public int getPageStartIndex() {
        return this.getSqlClause().getPageStartIndex();
    }

    @Override
    public int getPageEndIndex() {
        return this.getSqlClause().getPageEndIndex();
    }

    @Override
    public boolean isFetchScopeEffective() {
        return this.getSqlClause().isFetchScopeEffective();
    }

    public String getSelectHint() {
        return this.getSqlClause().getSelectHint();
    }

    public String getFromBaseTableHint() {
        return this.getSqlClause().getFromBaseTableHint();
    }

    public String getFromHint() {
        return this.getSqlClause().getFromHint();
    }

    public String getSqlSuffix() {
        return this.getSqlClause().getSqlSuffix();
    }

    @Override
    public void checkSafetyResult(int safetyMaxResultSize) {
        this.assertOptionThatBadTiming("checkSafetyResult()");
        this._safetyMaxResultSize = safetyMaxResultSize;
    }

    @Override
    public int getSafetyMaxResultSize() {
        return this._safetyMaxResultSize;
    }

    @Override
    public int getFetchNarrowingSkipStartIndex() {
        return this.getSqlClause().getFetchNarrowingSkipStartIndex();
    }

    @Override
    public int getFetchNarrowingLoopCount() {
        return this.getSqlClause().getFetchNarrowingLoopCount();
    }

    @Override
    public boolean isFetchNarrowingSkipStartIndexEffective() {
        return !this.getSqlClause().isFetchStartIndexSupported();
    }

    @Override
    public boolean isFetchNarrowingLoopCountEffective() {
        return !this.getSqlClause().isFetchSizeSupported();
    }

    @Override
    public boolean isFetchNarrowingEffective() {
        return this.getSqlClause().isFetchNarrowingEffective();
    }

    @Override
    public void xdisableFetchNarrowing() {
        String msg = "This method is unsupported on ConditionBean!";
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void xenableIgnoredFetchNarrowing() {
    }

    @Override
    public String getOrderByClause() {
        return this._sqlClause.getOrderByClause();
    }

    @Override
    public OrderByClause getOrderByComponent() {
        return this.getSqlClause().getOrderByComponent();
    }

    @Override
    public OrderByBean clearOrderBy() {
        this.getSqlClause().clearOrderBy();
        return this;
    }

    @Override
    public ConditionBean lockForUpdate() {
        this.assertOptionThatBadTiming("lockForUpdate()");
        this.getSqlClause().lockForUpdate();
        return this;
    }

    @Override
    public ConditionBean xsetupSelectCountIgnoreFetchScope(boolean uniqueCount) {
        this._isSelectCountIgnoreFetchScope = true;
        SelectClauseType clauseType = uniqueCount ? SelectClauseType.UNIQUE_COUNT : SelectClauseType.PLAIN_COUNT;
        this.getSqlClause().classifySelectClauseType(clauseType);
        this.getSqlClause().suppressOrderBy();
        this.getSqlClause().suppressFetchScope();
        return this;
    }

    @Override
    public ConditionBean xafterCareSelectCountIgnoreFetchScope() {
        this._isSelectCountIgnoreFetchScope = false;
        this.getSqlClause().rollbackSelectClauseType();
        this.getSqlClause().reviveOrderBy();
        this.getSqlClause().reviveFetchScope();
        return this;
    }

    @Override
    public boolean isSelectCountIgnoreFetchScope() {
        return this._isSelectCountIgnoreFetchScope;
    }

    @Override
    public CursorSelectOption getCursorSelectOption() {
        return this._cursorSelectOption;
    }

    protected void doAcceptCursorSelectOption(SVOptionCall<CursorSelectOption> opLambda) {
        CursorSelectOption op = this.newCursorSelectOption();
        opLambda.callback(op);
        this._cursorSelectOption = op;
    }

    protected CursorSelectOption newCursorSelectOption() {
        return new CursorSelectOption();
    }

    @Override
    public void xacceptScalarSelectOption(ScalarSelectOption option) {
        this.getSqlClause().acceptScalarSelectOption(option);
    }

    @Override
    public void configure(StatementConfigCall<StatementConfig> confLambda) {
        this.assertOptionThatBadTiming("configure()");
        this.assertStatementConfigNotDuplicated(confLambda);
        this._statementConfig = this.createStatementConfig(confLambda);
    }

    protected void assertStatementConfigNotDuplicated(StatementConfigCall<StatementConfig> configCall) {
        if (this._statementConfig != null) {
            String msg = "Already registered the configuration: existing=" + this._statementConfig + ", new=" + configCall;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected StatementConfig createStatementConfig(StatementConfigCall<StatementConfig> configCall) {
        if (configCall == null) {
            throw new IllegalArgumentException("The argument 'confLambda' should not be null.");
        }
        StatementConfig config = this.newStatementConfig();
        configCall.callback(config);
        return config;
    }

    protected StatementConfig newStatementConfig() {
        return new StatementConfig();
    }

    @Override
    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void disableRelationMappingCache() {
        this.assertOptionThatBadTiming("disableRelationMappingCache()");
        this._canRelationMappingCache = false;
    }

    @Override
    public boolean canRelationMappingCache() {
        return this._canRelationMappingCache;
    }

    @Override
    public void enableNonSpecifiedColumnAccess() {
        this._nonSpecifiedColumnAccessAllowed = true;
    }

    @Override
    public void disableNonSpecifiedColumnAccess() {
        this._nonSpecifiedColumnAccessAllowed = false;
    }

    @Override
    public boolean isNonSpecifiedColumnAccessAllowed() {
        return this._nonSpecifiedColumnAccessAllowed;
    }

    @Override
    public void enableColumnNullObject() {
        this.assertOptionThatBadTiming("enableColumnNullObject()");
        this.getSqlClause().enableColumnNullObject();
    }

    @Override
    public void disableColumnNullObject() {
        this.assertOptionThatBadTiming("disableColumnNullObject()");
        this.getSqlClause().disableColumnNullObject();
    }

    @Override
    public void enableQueryUpdateCountPreCheck() {
        this.assertOptionThatBadTiming("enableQueryUpdateCountPreCheck()");
        this._queryUpdateCountPreCheck = true;
    }

    @Override
    public void disableQueryUpdateCountPreCheck() {
        this.assertOptionThatBadTiming("disableQueryUpdateCountPreCheck()");
        this._queryUpdateCountPreCheck = false;
    }

    @Override
    public boolean isQueryUpdateCountPreCheck() {
        return this._queryUpdateCountPreCheck;
    }

    public void embedCondition(Set<ColumnInfo> embeddedColumnInfoSet, boolean quote) {
        this.assertOptionThatBadTiming("embedCondition()");
        if (embeddedColumnInfoSet == null) {
            String msg = "The argument 'embedCondition' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (quote) {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet));
        } else {
            this.addWhereClauseSimpleFilter(this.newToEmbeddedSimpleFilter(embeddedColumnInfoSet));
        }
    }

    private QueryClauseFilter newToEmbeddedQuotedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new QueryClauseFilter.QueryClauseToEmbeddedQuotedSimpleFilter(embeddedColumnInfoSet);
    }

    private QueryClauseFilter newToEmbeddedSimpleFilter(Set<ColumnInfo> embeddedColumnInfoSet) {
        return new QueryClauseFilter.QueryClauseToEmbeddedSimpleFilter(embeddedColumnInfoSet);
    }

    private void addWhereClauseSimpleFilter(QueryClauseFilter whereClauseSimpleFilter) {
        this._sqlClause.addWhereClauseSimpleFilter(whereClauseSimpleFilter);
    }

    @Override
    public String toDisplaySql() {
        SqlAnalyzerFactory factory = this.getSqlAnalyzerFactory();
        BoundDateDisplayStyle specifiedStyle = this.getLogDateDisplayStyle();
        BoundDateDisplayStyle realStyle = specifiedStyle != null ? specifiedStyle : this.createConfiguredBoundDateDisplayStyle();
        return AbstractConditionBean.convertConditionBean2DisplaySql(factory, this, realStyle);
    }

    protected abstract SqlAnalyzerFactory getSqlAnalyzerFactory();

    protected BoundDateDisplayStyle createConfiguredBoundDateDisplayStyle() {
        String datePattern = this.getConfiguredLogDatePattern();
        String timestampPattern = this.getConfiguredLogTimestampPattern();
        String timePattern = this.getConfiguredLogTimePattern();
        BoundDateDisplayTimeZoneProvider timeZoneProvider = this.getConfiguredLogTimeZoneProvider();
        return new BoundDateDisplayStyle(datePattern, timestampPattern, timePattern, timeZoneProvider);
    }

    protected abstract String getConfiguredLogDatePattern();

    protected abstract String getConfiguredLogTimestampPattern();

    protected abstract String getConfiguredLogTimePattern();

    protected abstract BoundDateDisplayTimeZoneProvider getConfiguredLogTimeZoneProvider();

    protected static String convertConditionBean2DisplaySql(SqlAnalyzerFactory factory, ConditionBean cb, BoundDateDisplayStyle dateDisplayStyle) {
        String twoWaySql = cb.getSqlClause().getClause();
        return SqlAnalyzer.convertTwoWaySql2DisplaySql(factory, twoWaySql, cb, dateDisplayStyle);
    }

    @Override
    public void styleLogDateDisplay(BoundDateDisplayStyle logDateDisplayStyle) {
        this.assertOptionThatBadTiming("styleLogDateDisplay()");
        this._logDateDisplayStyle = logDateDisplayStyle;
    }

    @Override
    public BoundDateDisplayStyle getLogDateDisplayStyle() {
        return this._logDateDisplayStyle;
    }

    @Override
    public boolean hasWhereClauseOnBaseQuery() {
        return this.getSqlClause().hasWhereClauseOnBaseQuery();
    }

    @Override
    public void clearWhereClauseOnBaseQuery() {
        this.getSqlClause().clearWhereClauseOnBaseQuery();
    }

    @Override
    public boolean hasSelectAllPossible() {
        if (!this.getSqlClause().hasWhereClauseOnBaseQuery() && !this.getSqlClause().hasBaseTableInlineWhereClause()) {
            return true;
        }
        if (this._unionCBeanList == null || this._unionCBeanList.isEmpty()) {
            return false;
        }
        for (ConditionBean unionCB : this._unionCBeanList) {
            if (!unionCB.hasSelectAllPossible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOrderByClause() {
        return this.getSqlClause().hasOrderByClause();
    }

    @Override
    public void invokeSetupSelect(String foreignPropertyNamePath) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyNamePath", foreignPropertyNamePath);
        String delimiter = ".";
        Object currentObj = this;
        String remainder = foreignPropertyNamePath;
        int count = 0;
        boolean last = false;
        do {
            String propertyName;
            int deimiterIndex;
            if ((deimiterIndex = remainder.indexOf(".")) < 0) {
                propertyName = remainder;
                last = true;
            } else {
                propertyName = remainder.substring(0, deimiterIndex);
                remainder = remainder.substring(deimiterIndex + ".".length(), remainder.length());
            }
            Class<?> targetType = currentObj.getClass();
            String methodName = (count == 0 ? "setupSelect_" : "with") + this.initCap(propertyName);
            Method method = this.xhelpGettingCBChainMethod(targetType, methodName, null);
            if (method == null) {
                String msg = "Not found the method for setupSelect:";
                msg = msg + " foreignPropertyNamePath=" + foreignPropertyNamePath;
                msg = msg + " targetType=" + targetType + " methodName=" + methodName;
                throw new ConditionInvokingFailureException(msg);
            }
            try {
                currentObj = DfReflectionUtil.invoke(method, currentObj, null);
            }
            catch (DfReflectionUtil.ReflectionFailureException e) {
                String msg = "Failed to invoke the method:";
                msg = msg + " foreignPropertyNamePath=" + foreignPropertyNamePath;
                msg = msg + " targetType=" + targetType + " methodName=" + methodName;
                throw new ConditionInvokingFailureException(msg, e);
            }
            ++count;
        } while (!last);
    }

    @Override
    public SpecifiedColumn invokeSpecifyColumn(String columnPropertyPath) {
        String delimiter = ".";
        Object currentObj = this.localSp();
        String remainder = columnPropertyPath;
        boolean last = false;
        do {
            String propertyName;
            int deimiterIndex;
            if ((deimiterIndex = remainder.indexOf(".")) < 0) {
                propertyName = remainder;
                last = true;
            } else {
                propertyName = remainder.substring(0, deimiterIndex);
                remainder = remainder.substring(deimiterIndex + ".".length(), remainder.length());
            }
            Class<?> targetType = currentObj.getClass();
            String methodName = (last ? "column" : "specify") + this.initCap(propertyName);
            Method method = this.xhelpGettingCBChainMethod(targetType, methodName, null);
            if (method == null) {
                String msg = "Not found the method for SpecifyColumn:";
                msg = msg + " columnPropertyPath=" + columnPropertyPath + " targetType=" + targetType + " methodName=" + methodName;
                throw new ConditionInvokingFailureException(msg);
            }
            try {
                currentObj = DfReflectionUtil.invoke(method, currentObj, null);
            }
            catch (DfReflectionUtil.ReflectionFailureException e) {
                String msg = "Failed to invoke the method:";
                msg = msg + " columnPropertyPath=" + columnPropertyPath + " targetType=" + targetType + " methodName=" + methodName;
                throw new ConditionInvokingFailureException(msg, e);
            }
        } while (!last);
        return (SpecifiedColumn)currentObj;
    }

    @Override
    public void invokeOrScopeQuery(OrQuery<ConditionBean> orQuery) {
        this.xorSQ(this, orQuery);
    }

    @Override
    public void invokeOrScopeQueryAndPart(AndQuery<ConditionBean> andQuery) {
        this.xorSQAP(this, andQuery);
    }

    protected Method xhelpGettingCBChainMethod(Class<?> type, String methodName, Class<?>[] argTypes) {
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(type);
        return beanDesc.getMethodNoException(methodName, argTypes);
    }

    protected Object xhelpInvokingCBChainMethod(Class<?> type, Method method, Object[] args) {
        return DfReflectionUtil.invokeForcedly(method, type, args);
    }

    protected void xsaveUCB(ConditionBean unionCB) {
        if (this._unionCBeanList == null) {
            this._unionCBeanList = new ArrayList<ConditionBean>();
        }
        this._unionCBeanList.add(unionCB);
    }

    protected void xsyncUQ(ConditionBean unionCB) {
        if (this._unionQuerySynchronizer != null) {
            this._unionQuerySynchronizer.query(unionCB);
        }
    }

    @Override
    public void xregisterUnionQuerySynchronizer(UnionQuery<ConditionBean> unionQuerySynchronizer) {
        this._unionQuerySynchronizer = unionQuerySynchronizer;
    }

    protected String decryptIfNeeds(ColumnInfo columnInfo, String valueExp) {
        ColumnFunctionCipher cipher = this.getSqlClause().findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.decrypt(valueExp) : valueExp;
    }

    @Override
    public DerivedTypeHandler xgetDerivedTypeHandler() {
        if (this._derivedTypeHandler != null) {
            return this._derivedTypeHandler;
        }
        this._derivedTypeHandler = this.xcreateDerivedTypeHandler();
        return this._derivedTypeHandler;
    }

    protected DerivedTypeHandler xcreateDerivedTypeHandler() {
        return new DerivedTypeHandler(){

            @Override
            public Class<?> findMappingType(HpDerivingSubQueryInfo derivingInfo) {
                Class<?> mappingType = derivingInfo.isFunctionCountFamily() ? AbstractConditionBean.this.xfindDerivedMappingTypeOfCount(derivingInfo) : (derivingInfo.isFunctionMax() ? AbstractConditionBean.this.xfindDerivedMappingTypeOfMax(derivingInfo) : (derivingInfo.isFunctionMin() ? AbstractConditionBean.this.xfindDerivedMappingTypeOfMin(derivingInfo) : (derivingInfo.isFunctionSum() ? AbstractConditionBean.this.xfindDerivedMappingTypeOfSum(derivingInfo) : (derivingInfo.isFunctionAvg() ? AbstractConditionBean.this.xfindDerivedMappingTypeOfAvg(derivingInfo) : AbstractConditionBean.this.xfindDerivedMappingTypeOfDefault(derivingInfo)))));
                return mappingType;
            }

            @Override
            public Object convertToMapValue(HpDerivingSubQueryInfo derivingInfo, Object selectedValue) {
                return AbstractConditionBean.this.xconvertToDerivedMapValue(derivingInfo, selectedValue);
            }
        };
    }

    protected Class<?> xfindDerivedMappingTypeOfCount(HpDerivingSubQueryInfo derivingInfo) {
        return Integer.class;
    }

    protected Class<?> xfindDerivedMappingTypeOfMax(HpDerivingSubQueryInfo derivingInfo) {
        return derivingInfo.extractDerivingColumnInfo().getObjectNativeType();
    }

    protected Class<?> xfindDerivedMappingTypeOfMin(HpDerivingSubQueryInfo derivingInfo) {
        return derivingInfo.extractDerivingColumnInfo().getObjectNativeType();
    }

    protected Class<?> xfindDerivedMappingTypeOfSum(HpDerivingSubQueryInfo derivingInfo) {
        return BigDecimal.class;
    }

    protected Class<?> xfindDerivedMappingTypeOfAvg(HpDerivingSubQueryInfo derivingInfo) {
        return BigDecimal.class;
    }

    protected Class<?> xfindDerivedMappingTypeOfDefault(HpDerivingSubQueryInfo derivingInfo) {
        return String.class;
    }

    public Object xconvertToDerivedMapValue(HpDerivingSubQueryInfo derivingInfo, Object value) {
        return value;
    }

    protected HpSDRFunctionFactory xcSDRFnFc() {
        return new HpSDRFunctionFactory(){

            @Override
            public <REFERRER_CB extends ConditionBean, LOCAL_CQ extends ConditionQuery> HpSDRFunction<REFERRER_CB, LOCAL_CQ> create(ConditionBean baseCB, LOCAL_CQ localCQ, HpSDRSetupper<REFERRER_CB, LOCAL_CQ> querySetupper, DBMetaProvider dbmetaProvider) {
                DerivedReferrerOptionFactory optionFactory = AbstractConditionBean.this.createSpecifyDerivedReferrerOptionFactory();
                return AbstractConditionBean.this.newSDFFunction(baseCB, localCQ, querySetupper, dbmetaProvider, optionFactory);
            }
        };
    }

    protected <LOCAL_CQ extends ConditionQuery, REFERRER_CB extends ConditionBean> HpSDRFunction<REFERRER_CB, LOCAL_CQ> newSDFFunction(ConditionBean baseCB, LOCAL_CQ localCQ, HpSDRSetupper<REFERRER_CB, LOCAL_CQ> querySetupper, DBMetaProvider dbmetaProvider, DerivedReferrerOptionFactory optionFactory) {
        return new HpSDRFunction<REFERRER_CB, LOCAL_CQ>(baseCB, localCQ, querySetupper, dbmetaProvider, optionFactory);
    }

    protected DerivedReferrerOptionFactory createSpecifyDerivedReferrerOptionFactory() {
        return new DerivedReferrerOptionFactory(){

            @Override
            public DerivedReferrerOption create() {
                return AbstractConditionBean.this.newSpecifyDerivedReferrerOption();
            }
        };
    }

    protected DerivedReferrerOption newSpecifyDerivedReferrerOption() {
        return new DerivedReferrerOption();
    }

    public void useInScopeSubQuery() {
        this.assertOptionThatBadTiming("useInScopeSubQuery()");
        HpCBPurpose purpose = this.getPurpose();
        if (!purpose.isAny(HpCBPurpose.EXISTS_REFERRER, HpCBPurpose.MYSELF_EXISTS)) {
            String msg = "The method 'useInScopeSubQuery()' can be called only when ExistsReferrer.";
            throw new IllegalConditionBeanOperationException(msg);
        }
        this.getSqlClause().useInScopeSubQueryForExistsReferrer();
    }

    @Override
    public HpCBPurpose getPurpose() {
        return this._purpose;
    }

    public void xsetupForUnion(ConditionBean mainCB) {
        this.xinheritSubQueryInfo(mainCB.localCQ());
        this.xchangePurposeSqlClause(HpCBPurpose.UNION_QUERY, mainCB.localCQ());
    }

    public void xsetupForExistsReferrer(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.EXISTS_REFERRER, mainCQ);
    }

    public void xsetupForInScopeRelation(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.IN_SCOPE_RELATION, mainCQ);
    }

    public void xsetupForDerivedReferrer(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.DERIVED_REFERRER, mainCQ);
    }

    @Override
    public void xsetupForScalarSelect() {
        this.xchangePurposeSqlClause(HpCBPurpose.SCALAR_SELECT, null);
    }

    public void xsetupForScalarCondition(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.SCALAR_CONDITION, mainCQ);
    }

    public void xsetupForScalarConditionPartitionBy(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.SCALAR_CONDITION_PARTITION_BY, mainCQ);
    }

    public void xsetupForMyselfExists(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.MYSELF_EXISTS, mainCQ);
    }

    public void xsetupForMyselfInScope(ConditionQuery mainCQ) {
        this.xprepareSubQueryInfo(mainCQ);
        this.xchangePurposeSqlClause(HpCBPurpose.MYSELF_IN_SCOPE, mainCQ);
    }

    @Override
    public void xsetupForQueryInsert() {
        this.xchangePurposeSqlClause(HpCBPurpose.QUERY_INSERT, null);
        this.getSqlClause().disableSelectColumnCipher();
    }

    public void xsetupForColumnQuery(ConditionBean mainCB) {
        this.xinheritSubQueryInfo(mainCB.localCQ());
        this.xchangePurposeSqlClause(HpCBPurpose.COLUMN_QUERY, mainCB.localCQ());
        this.xprepareSyncQyCall(mainCB);
    }

    public void xsetupForOrScopeQuery() {
        this.xchangePurposeSqlClause(HpCBPurpose.OR_SCOPE_QUERY, null);
    }

    public void xsetupForDreamCruise(ConditionBean mainCB) {
        mainCB.xmarkAsDeparturePortForDreamCruise();
        this.xinheritSubQueryInfo(mainCB.localCQ());
        this.xchangePurposeSqlClause(HpCBPurpose.DREAM_CRUISE, mainCB.localCQ());
        this._dreamCruiseDeparturePort = mainCB;
        this.xprepareSyncQyCall(mainCB);
    }

    @Override
    public void xsetupForVaryingUpdate() {
        this.xchangePurposeSqlClause(HpCBPurpose.VARYING_UPDATE, null);
        this.xprepareSyncQyCall(null);
    }

    @Override
    public void xsetupForSpecifiedUpdate() {
        this.xchangePurposeSqlClause(HpCBPurpose.SPECIFIED_UPDATE, null);
        this.xprepareSyncQyCall(null);
    }

    protected void xinheritSubQueryInfo(ConditionQuery mainCQ) {
        if (mainCQ.xgetSqlClause().isForSubQuery()) {
            this.getSqlClause().setupForSubQuery(mainCQ.xgetSqlClause().getSubQueryLevel());
        }
    }

    protected void xprepareSubQueryInfo(ConditionQuery mainCQ) {
        int nextSubQueryLevel = mainCQ.xgetSqlClause().getSubQueryLevel() + 1;
        this.getSqlClause().setupForSubQuery(nextSubQueryLevel);
    }

    protected void xchangePurposeSqlClause(HpCBPurpose purpose, ConditionQuery mainCQ) {
        this._purpose = purpose;
        this.getSqlClause().setPurpose(purpose);
        if (mainCQ != null) {
            this.xinheritInvalidQueryInfo(mainCQ);
            this.xinheritStructurePossibleInnerJoin(mainCQ);
            this.xinheritWhereUsedInnerJoin(mainCQ);
            this.xinheritThatsBadTiming(mainCQ);
        }
    }

    protected void xinheritInvalidQueryInfo(ConditionQuery mainCQ) {
        if (mainCQ.xgetSqlClause().isNullOrEmptyQueryChecked()) {
            this.checkNullOrEmptyQuery();
        } else {
            this.ignoreNullOrEmptyQuery();
        }
        if (mainCQ.xgetSqlClause().isEmptyStringQueryAllowed()) {
            this.doEnableEmptyStringQuery();
        } else {
            this.disableEmptyStringQuery();
        }
        if (mainCQ.xgetSqlClause().isOverridingQueryAllowed()) {
            this.doEnableOverridingQuery();
        } else {
            this.disableOverridingQuery();
        }
    }

    protected void xinheritStructurePossibleInnerJoin(ConditionQuery mainCQ) {
        if (mainCQ.xgetSqlClause().isStructuralPossibleInnerJoinEnabled()) {
            this.getSqlClause().enableStructuralPossibleInnerJoin();
        } else {
            this.getSqlClause().disableStructuralPossibleInnerJoin();
        }
    }

    protected void xinheritWhereUsedInnerJoin(ConditionQuery mainCQ) {
        if (mainCQ.xgetSqlClause().isWhereUsedInnerJoinEnabled()) {
            this.getSqlClause().enableWhereUsedInnerJoin();
        } else {
            this.getSqlClause().disableWhereUsedInnerJoin();
        }
    }

    protected void xinheritThatsBadTiming(ConditionQuery mainCQ) {
        if (mainCQ.xgetSqlClause().isThatsBadTimingDetectAllowed()) {
            this.getSqlClause().enableThatsBadTimingDetect();
        } else {
            this.getSqlClause().disableThatsBadTimingDetect();
        }
    }

    protected abstract void xprepareSyncQyCall(ConditionBean var1);

    protected boolean isLocked() {
        if (this.xisDreamCruiseDeparturePort()) {
            return false;
        }
        return this.getSqlClause().isLocked();
    }

    protected void lock() {
        this.getSqlClause().lock();
    }

    protected void unlock() {
        this.getSqlClause().unlock();
    }

    @Override
    public void enableThatsBadTiming() {
        this.assertOptionThatBadTiming("enableThatsBadTiming()");
        this.getSqlClause().enableThatsBadTimingDetect();
    }

    @Override
    public void disableThatsBadTiming() {
        this.assertOptionThatBadTiming("disableThatsBadTiming()");
        this.getSqlClause().disableThatsBadTimingDetect();
    }

    protected void assertOptionThatBadTiming(String optionName) {
        if (this.isLocked()) {
            this.createCBExThrower().throwOptionThatsBadTimingException(this, optionName);
        }
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String initCap(String str) {
        return Srl.initCap(str);
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String titleName = DfTypeUtil.toClassTitle(this);
        sb.append(titleName).append(":");
        try {
            String displaySql = this.toDisplaySql();
            sb.append(this.ln()).append(displaySql);
        }
        catch (RuntimeException e) {
            sb.append("{toDisplaySql() failed}");
        }
        return sb.toString();
    }

    @FunctionalInterface
    protected static interface SsCall {
        public ConditionQuery qf();
    }
}

