/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.core.command;

import org.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.dbmeta.DBMetaProvider;
import org.dbflute.dbway.DBDef;
import org.dbflute.outsidesql.OutsideSqlContext;
import org.dbflute.outsidesql.OutsideSqlFilter;
import org.dbflute.outsidesql.OutsideSqlOption;
import org.dbflute.outsidesql.factory.OutsideSqlContextFactory;

public abstract class AbstractOutsideSqlCommand<RESULT>
extends AbstractBehaviorCommand<RESULT> {
    protected String _outsideSqlPath;
    protected Object _parameterBean;
    protected OutsideSqlOption _outsideSqlOption;
    protected DBDef _currentDBDef;
    protected OutsideSqlContextFactory _outsideSqlContextFactory;
    protected OutsideSqlFilter _outsideSqlFilter;

    @Override
    public boolean isConditionBean() {
        return false;
    }

    @Override
    public boolean isOutsideSql() {
        return true;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public boolean isSelectCursor() {
        return false;
    }

    @Override
    public boolean isInsert() {
        return false;
    }

    @Override
    public boolean isUpdate() {
        return false;
    }

    @Override
    public boolean isDelete() {
        return false;
    }

    @Override
    public ConditionBean getConditionBean() {
        return null;
    }

    @Override
    public String getOutsideSqlPath() {
        return this._outsideSqlPath;
    }

    @Override
    public Object getParameterBean() {
        return this._parameterBean;
    }

    @Override
    public OutsideSqlOption getOutsideSqlOption() {
        return this._outsideSqlOption;
    }

    protected OutsideSqlContext createOutsideSqlContext() {
        DBMetaProvider dbmetaProvider = ResourceContext.dbmetaProvider();
        String outsideSqlPackage = ResourceContext.getOutsideSqlPackage();
        OutsideSqlContext context = this._outsideSqlContextFactory.createContext(dbmetaProvider, outsideSqlPackage);
        this.setupOutsideSqlContextProperty(context);
        context.setupBehaviorQueryPathIfNeeds();
        return context;
    }

    protected void setupOutsideSqlContextProperty(OutsideSqlContext context) {
        String path = this._outsideSqlPath;
        Object pmb = this._parameterBean;
        OutsideSqlOption option = this._outsideSqlOption;
        context.setOutsideSqlPath(path);
        context.setParameterBean(pmb);
        context.setResultType(this.getResultType());
        context.setMethodName(this.getCommandName());
        context.setStatementConfig(option.getStatementConfig());
        context.setTableDbName(option.getTableDbName());
        context.setOffsetByCursorForcedly(option.isAutoPaging());
        context.setLimitByCursorForcedly(option.isAutoPaging());
        context.setOutsideSqlFilter(this._outsideSqlFilter);
        context.setRemoveBlockComment(option.isRemoveBlockComment());
        context.setRemoveLineComment(option.isRemoveLineComment());
        context.setFormatSql(option.isFormatSql());
        context.setNonSpecifiedColumnAccessAllowed(option.isNonSpecifiedColumnAccessAllowed());
        context.setInternalDebug(ResourceContext.isInternalDebug());
        context.setupBehaviorQueryPathIfNeeds();
    }

    protected abstract Class<?> getResultType();

    protected String buildDbmsSuffix() {
        this.assertOutsideSqlBasic("buildDbmsSuffix");
        String productName = this._currentDBDef.code();
        return productName != null ? "_" + productName.toLowerCase() : "";
    }

    protected boolean isRemoveBlockComment(OutsideSqlContext context) {
        return context.isRemoveBlockComment() || this.needsToRemoveBlockComment();
    }

    protected boolean isRemoveLineComment(OutsideSqlContext context) {
        return context.isRemoveLineComment() || this.needsToRemoveLineComment();
    }

    protected boolean needsToRemoveBlockComment() {
        this.assertOutsideSqlBasic("needsToRemoveBlockComment");
        return !this._currentDBDef.dbway().isBlockCommentSupported();
    }

    protected boolean needsToRemoveLineComment() {
        this.assertOutsideSqlBasic("needsToRemoveLineComment");
        return !this._currentDBDef.dbway().isLineCommentSupported();
    }

    protected void assertOutsideSqlBasic(String methodName) {
        if (this._outsideSqlPath == null) {
            throw new IllegalStateException(this.buildAssertMessage("_outsideSqlPath", methodName));
        }
        if (this._outsideSqlOption == null) {
            throw new IllegalStateException(this.buildAssertMessage("_outsideSqlOption", methodName));
        }
        if (this._currentDBDef == null) {
            throw new IllegalStateException(this.buildAssertMessage("_currentDBDef", methodName));
        }
        if (this._outsideSqlContextFactory == null) {
            throw new IllegalStateException(this.buildAssertMessage("_outsideSqlContextFactory", methodName));
        }
    }

    public void setOutsideSqlPath(String outsideSqlPath) {
        this._outsideSqlPath = outsideSqlPath;
    }

    public void setParameterBean(Object parameterBean) {
        this._parameterBean = parameterBean;
    }

    public void setOutsideSqlOption(OutsideSqlOption outsideSqlOption) {
        this._outsideSqlOption = outsideSqlOption;
    }

    public void setCurrentDBDef(DBDef currentDBDef) {
        this._currentDBDef = currentDBDef;
    }

    public void setOutsideSqlContextFactory(OutsideSqlContextFactory outsideSqlContextFactory) {
        this._outsideSqlContextFactory = outsideSqlContextFactory;
    }

    public void setOutsideSqlFilter(OutsideSqlFilter outsideSqlFilter) {
        this._outsideSqlFilter = outsideSqlFilter;
    }
}

