/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xsd.sage;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.xsd.sage.NodeOptionName;
import org.dbdoclet.xsd.sage.NodeOptionValue;
import org.dbdoclet.xsd.sage.NodeRoot;
import org.dbdoclet.xsd.sage.NodeValue;
import org.dbdoclet.xsd.sage.ParseException;
import org.dbdoclet.xsd.sage.SampleDataParser;
import org.dbdoclet.xsd.sage.SampleDataParserVisitor;
import org.dbdoclet.xsd.sage.SimpleNode;

public class SampleData
implements SampleDataParserVisitor {
    private int counter = 0;
    private int lastIndex;
    private String lastValue;
    private String optionName;
    private HashMap<String, String> options;
    private Random rand;
    private TreeMap<String, Integer> statisticMap;
    private ArrayList<String> values = new ArrayList();

    public SampleData() {
        this.options = new HashMap();
        this.statisticMap = new TreeMap();
        this.rand = new Random();
    }

    public SampleData(File file) throws UnsupportedEncodingException, ParseException, IOException {
        this(FileServices.readToString(file));
    }

    public SampleData(String buffer) throws UnsupportedEncodingException, ParseException {
        this();
        NodeRoot root = SampleDataParser.parse(buffer);
        this.traverseNodes(root, this);
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public String getLastValue() {
        return this.lastValue;
    }

    public String getOption(String name) {
        return this.options.get(name);
    }

    public Map<String, Integer> getStatistics() {
        return this.statisticMap;
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.values.size()) {
            return null;
        }
        String value = this.values.get(index);
        value = value.replace("${%03d}", String.format("%03d", this.counter));
        ++this.counter;
        Integer usage = this.statisticMap.get(value);
        if (usage == null) {
            this.statisticMap.put(value, new Integer(1));
        } else {
            this.statisticMap.put(value, new Integer(usage + 1));
        }
        this.lastValue = value;
        this.lastIndex = index;
        return value;
    }

    public String getValue() {
        int index = this.rand.nextInt(this.values.size());
        return this.getValue(index);
    }

    public ArrayList<String> getValues() {
        return this.values;
    }

    public boolean isFollowsEnabled() {
        return this.options.get("follows") != null;
    }

    public void setValue(String value) {
        this.values.clear();
        this.values.add(value);
    }

    public void setValues(ArrayList<String> enumList) {
        this.values.clear();
        for (String e : enumList) {
            this.values.add(e);
        }
    }

    @Override
    public Object visit(NodeOptionName node, Object data) {
        this.optionName = node.getValue();
        return null;
    }

    @Override
    public Object visit(NodeOptionValue node, Object data) {
        this.options.put(this.optionName, node.getValue());
        return null;
    }

    @Override
    public Object visit(NodeRoot node, Object data) {
        return null;
    }

    @Override
    public Object visit(NodeValue node, Object data) {
        String value = node.getValue();
        if (value != null && value.trim().length() > 0) {
            this.values.add(node.getValue());
        }
        return null;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    private void traverseNodes(SimpleNode node, SampleDataParserVisitor visitor) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode sn = (SimpleNode)node.jjtGetChild(i);
            sn.jjtAccept(visitor, null);
            this.traverseNodes(sn, visitor);
        }
    }
}

