/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xsd;

import java.util.ArrayList;
import java.util.Random;
import org.dbdoclet.xsd.ContentModel;

public class XsdMetaData {
    private ArrayList<String> enumList;
    private String importNamespace;
    private Integer maxLength;
    private String maxOccurs;
    private String minOccurs;
    private String type;
    private ContentModel contentModel;

    public void addEnumeration(String enumValue) {
        if (enumValue == null) {
            return;
        }
        if (this.enumList == null) {
            this.enumList = new ArrayList();
        }
        this.enumList.add(enumValue);
    }

    public ContentModel getContentModel() {
        return this.contentModel;
    }

    public String getEnum(int index) {
        if (this.enumList != null && this.enumList.size() > index) {
            return this.enumList.get(index);
        }
        return null;
    }

    public ArrayList<String> getEnumList() {
        return this.enumList;
    }

    public String getImportNamespace() {
        return this.importNamespace;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public String getMinOccurs() {
        return this.minOccurs;
    }

    public String getRandomEnum() {
        if (this.enumList == null || this.enumList.size() == 0) {
            return null;
        }
        Random rand = new Random();
        return this.enumList.get(rand.nextInt(this.enumList.size()));
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnum() {
        return this.enumList != null && this.enumList.size() > 0;
    }

    public boolean isOptional() {
        if (this.minOccurs != null) {
            try {
                int min = Integer.parseInt(this.minOccurs);
                if (min == 0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setContentModel(ContentModel contentModel) {
        this.contentModel = contentModel;
    }

    public void setImportNamespace(String importNamespace) {
        this.importNamespace = importNamespace;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxOccurs(String maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public void setMinOccurs(String minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setType(String type) {
        this.type = type;
    }
}

