/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xsd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.ResourceServices;
import org.dbdoclet.xiphias.XPathServices;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xsd.AttributeGroup;
import org.dbdoclet.xsd.ComplexType;
import org.dbdoclet.xsd.ContentModel;
import org.dbdoclet.xsd.Group;
import org.dbdoclet.xsd.SimpleType;
import org.dbdoclet.xsd.XsdMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlSchema {
    private static final String XSD = "xsd";
    public static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    private Element[] rootElements;
    private ArrayList<Document> xsdDocumentList;
    private HashMap<Element, Document> masterDocumentMap;
    private HashMap<String, ComplexType> complexTypeMap;
    private HashMap<String, SimpleType> simpleTypeMap;
    private HashMap<String, Group> groupMap;
    private HashMap<String, AttributeGroup> attributeGroupMap;
    private HashMap<String, String> namespaceMap;
    private HashMap<String, Element> elementMap;
    private InputSource xsdSource;
    private Stack<Integer> complexTypeStack;

    public XmlSchema(File xsdFile) throws IOException, SAXException, ParserConfigurationException {
        InputSource xsdSource = new InputSource(new FileInputStream(xsdFile));
        xsdSource.setSystemId(xsdFile.getCanonicalPath());
        this.construct(xsdSource);
    }

    public XmlSchema(InputSource xsdSource) throws IOException, SAXException, ParserConfigurationException {
        this.construct(xsdSource);
    }

    private void construct(InputSource xsdSource) throws IOException, SAXException, ParserConfigurationException {
        this.xsdSource = xsdSource;
        Document xsdDocument = XmlServices.parse(xsdSource, false, null);
        this.namespaceMap = new HashMap();
        Element documentElement = xsdDocument.getDocumentElement();
        NamedNodeMap attributeMap = documentElement.getAttributes();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            Node attr = attributeMap.item(i);
            String name = attr.getNodeName();
            if (!name.startsWith("xmlns:")) continue;
            this.namespaceMap.put(attr.getNodeValue(), name.substring("xmlns:".length()));
        }
        this.xsdDocumentList = new ArrayList();
        this.masterDocumentMap = new HashMap();
        this.elementMap = new HashMap();
        this.complexTypeMap = new HashMap();
        this.complexTypeStack = new Stack();
        this.simpleTypeMap = new HashMap();
        this.groupMap = new HashMap();
        this.attributeGroupMap = new HashMap();
        this.initialize(xsdDocument);
    }

    private static String getLocalName(Element element) {
        if (element == null) {
            return null;
        }
        String name = element.getNodeName();
        return XmlSchema.getLocalName(name);
    }

    private static String getLocalName(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(58) != -1) {
            return name.substring(name.indexOf(58) + 1);
        }
        return name;
    }

    public ContentModel getContentModelForElement(String elementName) {
        XsdMetaData xsdData;
        Element element = this.elementMap.get(elementName);
        if (element != null && (xsdData = (XsdMetaData)element.getUserData(XSD)) != null) {
            return xsdData.getContentModel();
        }
        return ContentModel.PCDATA;
    }

    public Document getMasterDocument(Element rootElement) {
        return this.masterDocumentMap.get(rootElement);
    }

    public Element getElementByName(String tagName) {
        return this.elementMap.get(tagName);
    }

    public Element[] getRootElements() {
        return this.rootElements;
    }

    public String getXmlSchemaNamespace() {
        return this.namespaceMap.get(XML_SCHEMA_URI);
    }

    public void traverse(Document doc, Element element, Node xsdNode) {
        if (xsdNode != null) {
            NodeList xsdChildList = xsdNode.getChildNodes();
            for (int i = 0; i < xsdChildList.getLength(); ++i) {
                Node xsdChild = xsdChildList.item(i);
                if (!(xsdChild instanceof Element)) continue;
                Element xsdElement = (Element)xsdChild;
                String tagName = XmlSchema.getLocalName(xsdElement);
                if (tagName.equals("element")) {
                    this.processElement(doc, element, xsdElement);
                    continue;
                }
                if (tagName.equals("complexType")) {
                    XsdMetaData xsdData = new XsdMetaData();
                    element.setUserData(XSD, xsdData, null);
                    this.parseComplexType(doc, element, xsdElement, xsdData);
                    continue;
                }
                if (tagName.equals("extension")) {
                    String base = xsdElement.getAttribute("base");
                    XsdMetaData xsdData = new XsdMetaData();
                    element.setUserData(XSD, xsdData, null);
                    this.processBase(doc, element, xsdElement, xsdData, base);
                    this.traverse(doc, element, xsdElement);
                    continue;
                }
                if (tagName.equals("group")) {
                    Group group;
                    String ref = xsdElement.getAttribute("ref");
                    if (ref == null) continue;
                    String prefix = this.getTargetNamespacePrefix(xsdElement);
                    if (prefix != null) {
                        ref = prefix + ":" + ref;
                    }
                    if ((group = this.groupMap.get(ref)) == null) continue;
                    this.traverse(doc, element, group.getElement());
                    continue;
                }
                this.traverse(doc, element, xsdChild);
            }
        }
    }

    private String getTargetNamespacePrefix(Element xsdElement) {
        Document ownerDocument = xsdElement.getOwnerDocument();
        Element documentElement = ownerDocument.getDocumentElement();
        String targetNamespace = documentElement.getAttribute("targetNamespace");
        return this.namespaceMap.get(targetNamespace);
    }

    private String getXmlSchemaNamespacePrefix() {
        return this.namespaceMap.get(XML_SCHEMA_URI);
    }

    private boolean hasNamespace(String name) {
        return name.indexOf(58) != -1;
    }

    private void initialize(Document xsdDocument) throws IOException, SAXException, ParserConfigurationException {
        this.xsdDocumentList.add(xsdDocument);
        this.initialzeImports(xsdDocument);
        ArrayList<Node> nodeList = XPathServices.getNodes(xsdDocument, "xs", XML_SCHEMA_URI, "/xs:schema/xs:element");
        Element schemaNode = (Element)XPathServices.getNode(xsdDocument, "xs", XML_SCHEMA_URI, "/xs:schema");
        String targetNamespace = schemaNode.getAttribute("targetNamespace");
        this.initializeComplexTypes();
        this.initializeSimpleTypes();
        this.initializeGroups();
        this.initializeAttributeGroups();
        this.rootElements = new Element[nodeList.size()];
        int index = 0;
        for (Node node : nodeList) {
            ComplexType complexType;
            if (!(node instanceof Element)) continue;
            DocumentImpl doc = new DocumentImpl();
            Element xsdElement = (Element)node;
            String name = xsdElement.getAttribute("name");
            ElementImpl rootElem = doc.createElement(name);
            this.elementMap.put(name, rootElem);
            if (targetNamespace != null) {
                rootElem.setAttribute("xmlns", targetNamespace);
            }
            this.rootElements[index++] = rootElem;
            this.masterDocumentMap.put(rootElem, doc);
            doc.setDocumentElement(rootElem);
            String type = xsdElement.getAttribute("type");
            XsdMetaData xsdData = new XsdMetaData();
            xsdData.setType(type);
            rootElem.setUserData(XSD, xsdData, null);
            SimpleType simpleType = this.simpleTypeMap.get(type);
            if (simpleType != null) {
                xsdData.setContentModel(ContentModel.PCDATA);
                this.parseSimpleType(doc, rootElem, simpleType.getElement(), xsdData);
            }
            if ((complexType = this.complexTypeMap.get(type)) != null) {
                if (this.isSimpleContent(complexType.getElement())) {
                    xsdData.setContentModel(ContentModel.PCDATA);
                    this.parseSimpleType(doc, rootElem, complexType.getElement(), xsdData);
                } else {
                    if (complexType.isMixed()) {
                        xsdData.setContentModel(ContentModel.MIXED);
                    } else {
                        xsdData.setContentModel(ContentModel.BLOCK);
                    }
                    this.traverse(doc, rootElem, complexType.getElement());
                }
            }
            this.traverse(doc, rootElem, xsdElement);
        }
    }

    private void initializeAttributeGroups() {
        for (Document doc : this.xsdDocumentList) {
            ArrayList<Node> attributeGroupList = XPathServices.getNodes(doc, "xs", XML_SCHEMA_URI, "/xs:schema/xs:attributeGroup");
            for (Node node : attributeGroupList) {
                Element element;
                String name;
                if (!(node instanceof Element) || (name = (element = (Element)node).getAttribute("name")) == null) continue;
                String ns = this.getTargetNamespacePrefix(element);
                if (ns != null) {
                    name = ns + ":" + name;
                }
                this.attributeGroupMap.put(name, new AttributeGroup(element));
            }
        }
    }

    private void initializeComplexTypes() {
        for (Document doc : this.xsdDocumentList) {
            String namespace = null;
            XsdMetaData xsdData = (XsdMetaData)doc.getUserData(XSD);
            if (xsdData != null && (namespace = xsdData.getImportNamespace()) != null) {
                namespace = this.namespaceMap.get(namespace);
            }
            ArrayList<Node> complexTypeList = XPathServices.getNodes(doc, "xs", XML_SCHEMA_URI, "/xs:schema/xs:complexType");
            for (Node node : complexTypeList) {
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String name = element.getAttribute("name");
                if (namespace != null) {
                    name = namespace + ":" + name;
                }
                if (name == null) continue;
                this.complexTypeMap.put(name, new ComplexType(element));
            }
        }
    }

    private void initializeGroups() {
        for (Document doc : this.xsdDocumentList) {
            ArrayList<Node> complexTypeList = XPathServices.getNodes(doc, "xs", XML_SCHEMA_URI, "/xs:schema/xs:group");
            for (Node node : complexTypeList) {
                Element element;
                String name;
                if (!(node instanceof Element) || (name = (element = (Element)node).getAttribute("name")) == null) continue;
                String ns = this.getTargetNamespacePrefix(element);
                if (ns != null) {
                    name = ns + ":" + name;
                }
                this.groupMap.put(name, new Group(element));
            }
        }
    }

    private void initializeSimpleTypes() {
        for (Document doc : this.xsdDocumentList) {
            String namespace = null;
            XsdMetaData xsdData = (XsdMetaData)doc.getUserData(XSD);
            if (xsdData != null && (namespace = xsdData.getImportNamespace()) != null) {
                namespace = this.namespaceMap.get(namespace);
            }
            ArrayList<Node> simpleTypeList = XPathServices.getNodes(doc, "xs", XML_SCHEMA_URI, "/xs:schema/xs:simpleType");
            for (Node node : simpleTypeList) {
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String name = element.getAttribute("name");
                if (namespace != null) {
                    name = namespace + ":" + name;
                }
                if (name == null) continue;
                this.simpleTypeMap.put(name, new SimpleType(element));
            }
        }
    }

    private void initialzeImports(Document xsdDocument) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<Node> nodeList = XPathServices.getNodes(xsdDocument, "xs", XML_SCHEMA_URI, "/xs:schema/xs:import | /xs:schema/xs:include");
        for (Node node : nodeList) {
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            String namespace = elem.getAttribute("namespace");
            String schemaLocation = elem.getAttribute("schemaLocation");
            String path = FileServices.appendFileName(FileServices.getDirName(this.xsdSource.getSystemId()), schemaLocation);
            File includeFile = new File(path);
            Document doc = null;
            if (includeFile.exists()) {
                doc = XmlServices.parse(includeFile);
            } else {
                InputStream instream = ResourceServices.getResourceAsStream(path);
                if (instream != null) {
                    InputSource source = new InputSource(instream);
                    source.setSystemId(path);
                    doc = XmlServices.parse(source, false, null);
                }
            }
            if (doc != null) {
                XsdMetaData xsdData = new XsdMetaData();
                xsdData.setImportNamespace(namespace);
                doc.setUserData(XSD, xsdData, null);
                this.xsdDocumentList.add(doc);
                continue;
            }
            throw new IOException(String.format("Included resource %s does not exist", schemaLocation));
        }
    }

    private boolean isComplexType(Element xsdElement) {
        Element complexType = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "/xs:complexType");
        return complexType != null;
    }

    private boolean isSimpleContent(Element xsdElement) {
        Element simpleContent = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "/xs:simpleContent");
        return simpleContent != null;
    }

    private boolean isSimpleType(Element xsdElement) {
        Element simpleType = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "/xs:simpleType");
        return simpleType != null;
    }

    private void parseAttributes(Document doc, Element element, Element xsdElement, XsdMetaData xsdData) {
        AttributeGroup agroup;
        String ref;
        Element attributeGroup = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "xs:attributeGroup");
        if (attributeGroup != null && (ref = attributeGroup.getAttribute("ref")) != null && (agroup = this.attributeGroupMap.get(ref)) != null) {
            ArrayList<Node> attrList = XPathServices.getNodes(agroup.getElement(), "xs", XML_SCHEMA_URI, "xs:attribute");
            for (Node attrNode : attrList) {
                Element attr = (Element)attrNode;
                element.setAttribute(attr.getAttribute("name"), "");
            }
        }
        ArrayList<Node> attrList = XPathServices.getNodes(xsdElement, "xs", XML_SCHEMA_URI, "xs:attribute");
        for (Node attrNode : attrList) {
            Element attr = (Element)attrNode;
            String value = "";
            if (attr.getAttribute("fixed") != null) {
                value = attr.getAttribute("fixed");
            }
            element.setAttribute(attr.getAttribute("name"), value);
        }
    }

    private boolean parseComplexType(Document doc, Element element, Element xsdElement, XsdMetaData xsdData) {
        if (this.complexTypeStack.contains(xsdElement.hashCode())) {
            return false;
        }
        this.complexTypeStack.push(xsdElement.hashCode());
        String tagName = xsdElement.getTagName();
        if (tagName.equals("element") || tagName.endsWith(":element")) {
            xsdElement = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "./xs:complexType");
        }
        if (ComplexType.isMixed(xsdElement)) {
            xsdData.setContentModel(ContentModel.MIXED);
        } else {
            xsdData.setContentModel(ContentModel.BLOCK);
        }
        this.parseExtension(doc, element, xsdElement, xsdData);
        this.parseRestriction(doc, element, xsdElement, xsdData);
        ArrayList<Node> nodeList = XPathServices.getNodes(xsdElement, "xs", XML_SCHEMA_URI, ".//xs:sequence/xs:element|.//xs:choice/xs:element");
        for (Node childNode : nodeList) {
            Element child = (Element)childNode;
            this.processElement(doc, element, child);
        }
        this.complexTypeStack.pop();
        return true;
    }

    private void parseExtension(Document doc, Element element, Element xsdElement, XsdMetaData xsdData) {
        Element extension = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "/*/*/xs:extension | /*/xs:extension | xs:extension");
        if (extension != null) {
            String type = extension.getAttribute("base");
            this.processBase(doc, element, xsdElement, xsdData, type);
            this.parseAttributes(doc, element, extension, xsdData);
        }
    }

    private void parseRestriction(Document doc, Element element, Element xsdElement, XsdMetaData xsdData) {
        Element restriction = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "/*/*/xs:restriction | /*/xs:restriction | xs:restriction");
        if (restriction != null) {
            String type = restriction.getAttribute("base");
            this.processBase(doc, element, xsdElement, xsdData, type);
            ArrayList<Node> nodeList = XPathServices.getNodes(restriction, "xs", XML_SCHEMA_URI, "/xs:enumeration");
            for (Node node : nodeList) {
                xsdData.addEnumeration(((Element)node).getAttribute("value"));
            }
            Element maxLength = (Element)XPathServices.getNode(restriction, "xs", XML_SCHEMA_URI, "/xs:maxLength");
            if (maxLength != null) {
                xsdData.setMaxLength(new Integer(maxLength.getAttribute("value")));
            }
        }
    }

    private void parseSimpleType(Document doc, Element element, Element xsdElement, XsdMetaData xsdData) {
        String memberTypes;
        SimpleType memberType;
        xsdData.setContentModel(ContentModel.PCDATA);
        Element union = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "/*/*/xs:union | /*/xs:union | xs:union");
        if (union != null && (memberType = this.simpleTypeMap.get(memberTypes = union.getAttribute("memberTypes"))) != null) {
            this.parseSimpleType(doc, element, memberType.getElement(), xsdData);
        }
        this.parseRestriction(doc, element, xsdElement, xsdData);
        this.parseExtension(doc, element, xsdElement, xsdData);
    }

    private void processBase(Document doc, Element element, Element xsdElement, XsdMetaData xsdData, String base) {
        if (base != null) {
            String prefix = this.getXmlSchemaNamespacePrefix();
            if (base != null && !base.startsWith(prefix + ":")) {
                ComplexType complexType;
                SimpleType simpleType = this.simpleTypeMap.get(base);
                if (simpleType != null) {
                    this.parseSimpleType(doc, element, simpleType.getElement(), xsdData);
                }
                if ((complexType = this.complexTypeMap.get(base)) != null) {
                    if (this.isSimpleContent(complexType.getElement())) {
                        this.parseSimpleType(doc, element, complexType.getElement(), xsdData);
                    } else {
                        this.traverse(doc, element, complexType.getElement());
                    }
                }
            } else if (base != null && base.startsWith(prefix + ":")) {
                xsdData.setType(base);
            }
        }
    }

    private void processElement(Document doc, Element elem, Element xsdElement) {
        SimpleType simpleType;
        int idx;
        String name = xsdElement.getAttribute("name");
        boolean isRef = false;
        if (name == null || name.length() == 0) {
            name = xsdElement.getAttribute("ref");
            isRef = true;
        }
        if ((idx = name.indexOf(58)) != -1) {
            name = name.substring(idx + 1);
        }
        Element child = doc.createElement(name);
        elem.appendChild(child);
        if (!isRef) {
            this.elementMap.put(name, child);
        }
        String type = xsdElement.getAttribute("type");
        XsdMetaData xsdData = new XsdMetaData();
        xsdData.setType(type);
        String attrValue = xsdElement.getAttribute("minOccurs");
        if (attrValue != null && attrValue.trim().length() > 0) {
            xsdData.setMinOccurs(attrValue);
        }
        if ((attrValue = xsdElement.getAttribute("maxOccurs")) != null && attrValue.trim().length() > 0) {
            xsdData.setMaxOccurs(attrValue);
        }
        child.setUserData(XSD, xsdData, null);
        if (type == null || type.length() == 0) {
            if (this.isSimpleType(xsdElement)) {
                this.parseSimpleType(doc, child, xsdElement, xsdData);
            }
            if (this.isComplexType(xsdElement) && !this.parseComplexType(doc, child, xsdElement, xsdData)) {
                elem.removeChild(child);
            }
            return;
        }
        String prefix = this.getTargetNamespacePrefix(xsdElement);
        if (!this.hasNamespace(type) && prefix != null) {
            type = prefix + ":" + type;
        }
        if ((simpleType = this.simpleTypeMap.get(type)) != null) {
            this.parseSimpleType(doc, child, simpleType.getElement(), xsdData);
            return;
        }
        ComplexType complexType = this.complexTypeMap.get(type);
        if (complexType != null) {
            if (this.isSimpleContent(complexType.getElement())) {
                this.parseSimpleType(doc, child, complexType.getElement(), xsdData);
            } else {
                this.traverse(doc, child, complexType.getElement());
            }
            return;
        }
        this.traverse(doc, child, xsdElement);
    }

    protected boolean isComplexContent(Element xsdElement) {
        Element complexContent = (Element)XPathServices.getNode(xsdElement, "xs", XML_SCHEMA_URI, "/xs:complexContent");
        return complexContent != null;
    }

    public boolean isValidParent(String tagChild, String tagParent) {
        if (tagChild == null || tagParent == null) {
            return false;
        }
        Element parentElement = this.getElementByName(tagParent);
        if (parentElement == null) {
            return false;
        }
        NodeList childList = parentElement.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child == null || child.getNodeName() == null || !child.getNodeName().equals(tagChild)) continue;
            return true;
        }
        return false;
    }
}

