/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.annotation.Annotation;
import org.dbdoclet.xiphias.dom.AttrImpl;
import org.dbdoclet.xiphias.dom.CommentImpl;
import org.dbdoclet.xiphias.dom.DocumentFragmentImpl;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.EntityImpl;
import org.dbdoclet.xiphias.dom.INodeVisitor;
import org.dbdoclet.xiphias.dom.NodeListImpl;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
implements Node {
    public static final int FORMAT_BLOCK = 3;
    public static final int FORMAT_CONTENT = 2;
    public static final int FORMAT_INLINE = 1;
    public static final int HTML = 3;
    private static Log logger = LogFactory.getLog(NodeImpl.class);
    private static final String LSEP = System.getProperty("line.separator");
    public static final int SGML = 1;
    public static final int XML = 2;
    private static int flavour = 2;
    public static final short XML_DECLARATION = 23;
    private NodeListImpl childNodes = new NodeListImpl();
    private int column;
    private DocumentImpl document;
    protected boolean isCaseInsensitive = false;
    private boolean isEmpty = false;
    private boolean isMute = false;
    private boolean isRawData = false;
    private int line;
    private String namespaceUri;
    private boolean needsPadding = false;
    private String nodeName = "node";
    private short nodeType = 1;
    private String nodeValue;
    private NodeImpl parent = null;
    private String prefix;
    private HashMap<String, Object> userDataMap;
    private ArrayList<Annotation> annotationList;

    public static NodeImpl findParent(Node node, Class<?> parentClass) {
        Node parent;
        if (node == null || parentClass == null) {
            return null;
        }
        for (parent = node.getParentNode(); parent != null && !parentClass.isInstance(parent); parent = parent.getParentNode()) {
        }
        return (NodeImpl)parent;
    }

    public static String getTextContent(NodeImpl node) {
        NodeListImpl children;
        String buffer = "";
        if (node instanceof TextImpl) {
            buffer = buffer + ((TextImpl)node).getData();
        }
        if ((children = node.getTrafoChildNodes()) == null) {
            return buffer;
        }
        for (NodeImpl o : children) {
            if (o == null || o instanceof CommentImpl) continue;
            if (o instanceof TextImpl) {
                buffer = buffer + ((TextImpl)o).getData();
                continue;
            }
            try {
                buffer = buffer + NodeImpl.getTextContent(o);
            }
            catch (StackOverflowError oops) {
                logger.fatal((Object)("[NodeImpl.getTextContent] StackOverflowError. Possibly recursive structure detected!!! Node: " + node.toString()));
            }
        }
        return buffer;
    }

    public static void setCodeType(int type) {
        switch (type) {
            case 3: {
                flavour = 3;
                break;
            }
            case 1: {
                flavour = 1;
                break;
            }
            case 2: {
                flavour = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong type " + type);
            }
        }
    }

    public static void setCodeType(String type) {
        if (type == null) {
            return;
        }
        if (type.equalsIgnoreCase("xml")) {
            flavour = 2;
        } else if (type.equalsIgnoreCase("sgml")) {
            flavour = 1;
        } else if (type.equalsIgnoreCase("html")) {
            flavour = 3;
        } else {
            logger.error((Object)("Unknown type " + type + ". Using SGML!"));
        }
    }

    public static void traverse(Node node, INodeVisitor visitor) throws Exception {
        if (node != null) {
            Document doc;
            if (node instanceof Document && (doc = (Document)node).getDocumentElement() != null) {
                node = doc.getDocumentElement();
            }
            if (visitor != null) {
                visitor.accept(node);
            }
            NodeList childList = node.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                NodeImpl.traverse(childList.item(i), visitor);
            }
        }
    }

    public NodeImpl() {
    }

    public NodeImpl(String name) {
        this(name, null);
    }

    public NodeImpl(String name, NodeImpl parent) {
        if (name != null) {
            this.nodeName = name;
        }
        if (this.isCaseInsensitive) {
            this.nodeName = this.nodeName.toLowerCase();
        }
        this.parent = parent;
    }

    public void addAnnotation(Annotation annotation) {
        if (annotation != null) {
            if (this.annotationList == null) {
                this.annotationList = new ArrayList();
            }
            this.annotationList.add(annotation);
        }
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild instanceof NodeImpl) {
            return this.appendChild((NodeImpl)newChild);
        }
        throw new IllegalArgumentException("The new child must be of type " + NodeImpl.class.getName());
    }

    public NodeImpl appendChild(NodeImpl node) {
        if (node == null) {
            throw new IllegalArgumentException("Variable node is null!");
        }
        if (this.childNodes == null) {
            throw new IllegalStateException("Variable childNodes  is null!");
        }
        node.setParentNode(this);
        if (node instanceof DocumentFragment) {
            NodeList childList = node.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                this.childNodes.add((NodeImpl)childList.item(i));
            }
        } else {
            this.childNodes.add(node);
        }
        logger.debug((Object)("Appended child " + node + " to " + this + "."));
        return this;
    }

    public NodeImpl appendChild(String text) {
        return this.appendChild(text, true);
    }

    public NodeImpl appendChild(String text, boolean escape) {
        TextImpl node;
        if (escape) {
            node = new TextImpl(XmlServices.textToXml(text));
        } else {
            node = new TextImpl(text);
            node.isRawData(true);
        }
        node.setParentNode(this);
        this.childNodes.add(node);
        return this;
    }

    @Override
    public Node cloneNode(boolean deep) {
        System.err.println("Not yet implemented");
        return null;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        System.err.println("Not yet implemented");
        return 0;
    }

    public NodeImpl findChildElement(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("The argument tagName must not be null!");
        }
        if (this.childNodes == null || this.childNodes.size() < 1) {
            return null;
        }
        NodeImpl element = null;
        String nodeName = null;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (!(this.childNodes.get(i) instanceof ElementImpl) || (nodeName = (element = (NodeImpl)this.childNodes.get(i)).getNodeName()) == null || !nodeName.equals(tagName)) continue;
            return element;
        }
        return null;
    }

    public Text findFirstText() {
        Text firstText = this.getFirstText();
        if (firstText != null) {
            return firstText;
        }
        for (Element element : this.getChildElementList()) {
            firstText = ((ElementImpl)element).findFirstText();
            if (firstText == null) continue;
            return firstText;
        }
        return null;
    }

    public NodeImpl findParent(Class<?> parentClass) {
        Node parent = this.getParentNode();
        return NodeImpl.findParent(parent, parentClass);
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this instanceof Element) {
            return ((Element)((Object)this)).getAttributes();
        }
        return null;
    }

    public Map<String, Attr> getAttributesAsMap() {
        if (this instanceof ElementImpl) {
            return this.getAttributesAsMap();
        }
        return null;
    }

    @Override
    public String getBaseURI() {
        System.err.println("Not yet implemented");
        return null;
    }

    public ArrayList<Element> getChildElementList() {
        ArrayList<Element> list = new ArrayList<Element>();
        if (this.childNodes != null) {
            for (Node child : this.childNodes) {
                if (!(child instanceof Element)) continue;
                list.add((Element)child);
            }
        }
        return list;
    }

    @Override
    public NodeList getChildNodes() {
        if (this.childNodes == null) {
            throw new IllegalStateException("Variable childNodes  is null!");
        }
        return this.childNodes;
    }

    public int getColumn() {
        return this.column;
    }

    public DocumentImpl getDocument() {
        if (this.document == null) {
            for (Node parent = this.getParentNode(); parent != null && this.document == null; parent = parent.getParentNode()) {
                this.document = (DocumentImpl)parent.getOwnerDocument();
            }
        }
        if (this.document == null) {
            this.document = new DocumentImpl();
        }
        return this.document;
    }

    public NodeListImpl getElementChildNodes() {
        if (this.childNodes == null) {
            throw new IllegalStateException("Variable childNodes is null!");
        }
        NodeListImpl list = new NodeListImpl();
        for (int i = 0; i < this.childNodes.getLength(); ++i) {
            Node child = this.childNodes.item(i);
            if (!(child instanceof ElementImpl)) continue;
            list.add((NodeImpl)child);
        }
        return list;
    }

    @Override
    public Object getFeature(String feature, String version) {
        System.err.println("Not yet implemented");
        return null;
    }

    @Override
    public NodeImpl getFirstChild() {
        if (this.childNodes == null || this.childNodes.size() < 1) {
            return null;
        }
        return (NodeImpl)this.childNodes.get(0);
    }

    public Element getFirstChildElement() {
        if (this.childNodes == null || this.childNodes.size() < 1) {
            return null;
        }
        NodeImpl element = null;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (!(this.childNodes.get(i) instanceof ElementImpl)) continue;
            element = (NodeImpl)this.childNodes.get(i);
            break;
        }
        return (Element)((Object)element);
    }

    public Text getFirstText() {
        if (this.childNodes == null || this.childNodes.size() < 1) {
            return null;
        }
        NodeImpl element = null;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (!(this.childNodes.get(i) instanceof Text)) continue;
            element = (NodeImpl)this.childNodes.get(i);
            break;
        }
        return (Text)((Object)element);
    }

    public int getFlavour() {
        return flavour;
    }

    @Override
    public Node getLastChild() {
        if (this.childNodes == null || this.childNodes.size() == 0) {
            return null;
        }
        return (Node)this.childNodes.get(this.childNodes.size() - 1);
    }

    public NodeImpl getLastChild(Class<? extends NodeImpl> type) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type must not be null!");
        }
        if (this.childNodes == null || this.childNodes.size() < 1) {
            return null;
        }
        NodeImpl element = null;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            NodeImpl node = (NodeImpl)this.childNodes.get(i);
            String classname = node.getClass().getName();
            if (!classname.equals(type.getName())) continue;
            element = (NodeImpl)this.childNodes.get(i);
        }
        return element;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public String getLocalName() {
        if (this instanceof ElementImpl || this instanceof AttrImpl || this instanceof EntityImpl) {
            String qualifiedName = this.getNodeName();
            if (qualifiedName.indexOf(58) == -1) {
                return qualifiedName;
            }
            return qualifiedName.split(":")[1];
        }
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    @Override
    public Node getNextSibling() {
        NodeImpl parent = this.getTrafoParentNode();
        if (parent == null) {
            return null;
        }
        int index = 0;
        NodeListImpl children = parent.getTrafoChildNodes();
        for (NodeImpl child : children) {
            if (child == this) break;
            ++index;
        }
        if (index < children.size() - 1) {
            return (Node)children.get(index + 1);
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    public int getNumberOfChildNodes() {
        return this.childNodes.size();
    }

    @Override
    public Document getOwnerDocument() {
        return this.getDocument();
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        if (this instanceof ElementImpl || this instanceof AttrImpl) {
            String qualifiedName = this.getNodeName();
            if (qualifiedName.indexOf(58) == -1) {
                return null;
            }
            return qualifiedName.split(":")[0];
        }
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        NodeImpl parent = this.getTrafoParentNode();
        if (parent == null) {
            return null;
        }
        int index = 0;
        NodeListImpl children = parent.getTrafoChildNodes();
        for (NodeImpl child : children) {
            if (child == this) break;
            ++index;
        }
        if (index > 0) {
            return (Node)children.get(index - 1);
        }
        return null;
    }

    public NodeImpl getRoot() {
        Node parent = this.getParentNode();
        if (parent == null) {
            return this;
        }
        Node root = parent;
        while (parent != null) {
            if ((parent = parent.getParentNode()) == null) continue;
            root = parent;
        }
        return (NodeImpl)root;
    }

    @Override
    public String getTextContent() {
        return NodeImpl.getTextContent(this);
    }

    public NodeListImpl getTrafoChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new NodeListImpl();
        }
        return this.childNodes;
    }

    public NodeImpl getTrafoParentNode() {
        return this.parent;
    }

    @Override
    public Object getUserData(String key) {
        if (key == null || this.userDataMap == null) {
            return null;
        }
        return this.userDataMap.get(key);
    }

    public String hardenText(String text) {
        if (text == null) {
            return "";
        }
        String buffer = StringServices.replace(text, "&", "&amp;");
        buffer = StringServices.replace(buffer, "<", "&lt;");
        buffer = StringServices.replace(buffer, ">", "&gt;");
        return buffer;
    }

    @Override
    public boolean hasAttributes() {
        System.err.println("Not yet implemented");
        return false;
    }

    @Override
    public boolean hasChildNodes() {
        if (this.childNodes == null) {
            throw new IllegalStateException("Parameter childNodes is null!");
        }
        int size = this.childNodes.size();
        return size > 0;
    }

    public boolean hasElementChildren() {
        if (this.childNodes == null) {
            throw new IllegalStateException("Parameter childNodes is null!");
        }
        for (int i = 0; i < this.childNodes.size(); ++i) {
            NodeImpl node = (NodeImpl)this.childNodes.get(i);
            if (!(node instanceof ElementImpl)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSiblingElements() {
        NodeImpl parent = (NodeImpl)this.getParentNode();
        if (parent == null) {
            return false;
        }
        NodeListImpl list = parent.getElementChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = (Node)list.get(i);
            if (node == this) continue;
            return true;
        }
        return false;
    }

    public boolean hasText() {
        String text = this.getTextContent();
        return text != null && !text.trim().equals("");
    }

    public Node insertAfter(Node newChild, Node refChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("The argument newChild must not be null!");
        }
        if (refChild == null) {
            throw new IllegalArgumentException("The argument refChild must not be null!");
        }
        int index = -1;
        if (this.childNodes != null && this.childNodes.size() > 0) {
            for (int i = 0; i < this.childNodes.size(); ++i) {
                NodeImpl node = (NodeImpl)this.childNodes.get(i);
                if (node != refChild) continue;
                index = i;
            }
            if (index > -1) {
                NodeImpl newChildImpl = (NodeImpl)newChild;
                newChildImpl.setParentNode(this);
                this.childNodes.add(index + 1, newChildImpl);
            }
        }
        return this;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        NodeListImpl childList = (NodeListImpl)this.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (!child.equals(refChild)) continue;
            NodeImpl newChildImpl = (NodeImpl)newChild;
            newChildImpl.setParentNode(this);
            logger.debug((Object)("Inserting " + newChild + "before " + refChild));
            childList.add(i, newChildImpl);
            return this;
        }
        logger.warn((Object)("InsertBefore: Couldn't find reference child " + refChild));
        return this;
    }

    public NodeImpl insertChild(int index, NodeImpl node) {
        node.setParentNode(this);
        this.childNodes.add(index, node);
        return this;
    }

    public NodeImpl isCaseInsensitive(boolean isCaseInsensitive) {
        this.isCaseInsensitive = isCaseInsensitive;
        if (this.nodeName != null) {
            this.nodeName = this.nodeName.toLowerCase();
        }
        return this;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        System.err.println("Not yet implemented");
        return false;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public NodeImpl isEmpty(boolean isEmpty) {
        this.isEmpty = isEmpty;
        return this;
    }

    @Override
    public boolean isEqualNode(Node otherNode) {
        return this.equals(otherNode);
    }

    public boolean isMute() {
        return this.isMute;
    }

    public void isMute(boolean isMute) {
        this.isMute = isMute;
    }

    public boolean isRawData() {
        return this.isRawData;
    }

    public void isRawData(boolean isRawData) {
        this.isRawData = isRawData;
    }

    public boolean isRoot() {
        return this.parent == null || this instanceof DocumentFragmentImpl;
    }

    @Override
    public boolean isSameNode(Node other) {
        System.err.println("Not yet implemented");
        return false;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        System.err.println("Not yet implemented");
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        System.err.println("Not yet implemented");
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        System.err.println("Not yet implemented");
        return null;
    }

    public boolean needsPadding() {
        return this.needsPadding;
    }

    public NodeImpl needsPadding(boolean needsPadding) {
        this.needsPadding = needsPadding;
        return this;
    }

    @Override
    public void normalize() {
        System.err.println("Not yet implemented");
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        if (node == null) {
            throw new IllegalArgumentException("Variable node is null!");
        }
        if (this.childNodes == null) {
            throw new IllegalStateException("Variable childNodes  is null!");
        }
        Node removedChild = null;
        for (int i = 0; i < this.childNodes.getLength(); ++i) {
            Node child = this.childNodes.item(i);
            if (!child.equals(node)) continue;
            this.childNodes.remove(i);
            removedChild = child;
            break;
        }
        return removedChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        logger.debug((Object)("(W3C) Replacing child " + oldChild + " with child " + newChild));
        NodeList childList = this.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (!child.equals(oldChild)) continue;
            logger.debug((Object)"Found child to replace.");
            this.insertBefore(newChild, oldChild);
            this.removeChild(oldChild);
        }
        return this;
    }

    public void setChildNodes(NodeList children) {
        if (children == null) {
            this.childNodes = new NodeListImpl();
        }
        this.childNodes = (NodeListImpl)children;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setDocument(DocumentImpl document) {
        this.document = document;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setMute(boolean isMute) {
        this.isMute = isMute;
    }

    public void setNamespaceURI(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setNodeType(short nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.nodeValue = nodeValue;
    }

    public void setParentNode(NodeImpl parent) {
        if (this == parent) {
            throw new IllegalStateException("Self referencing " + parent);
        }
        this.parent = parent;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.prefix = prefix;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.childNodes.clear();
        if (textContent != null) {
            if (this instanceof TextImpl) {
                ((TextImpl)this).setData(textContent);
            } else {
                this.appendChild(new TextImpl(textContent));
            }
        }
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.userDataMap == null) {
            this.userDataMap = new HashMap();
        }
        if (key != null) {
            this.userDataMap.put(key, data);
        }
        return data;
    }

    public void swapWithParent() {
        NodeListImpl childNodes1 = this.childNodes;
        NodeList childNodes2 = this.parent.getChildNodes();
        Node hook = this.parent.getParentNode();
        if (hook == null) {
            return;
        }
        this.parent.setChildNodes(childNodes1);
        this.setChildNodes(childNodes2);
        this.removeChild(this);
        this.insertChild(0, this.parent);
        hook.replaceChild(this, this.parent);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("name=");
        if (this.nodeName != null) {
            buffer.append(this.nodeName);
        }
        buffer.append(',');
        buffer.append("value=");
        if (this.nodeValue != null) {
            buffer.append(this.nodeValue);
        }
        buffer.append(",line=");
        buffer.append(this.getLine());
        buffer.append(",column=");
        buffer.append(this.getColumn());
        String text = buffer.toString();
        if (text.length() > 42) {
            text = text.substring(0, 39) + "...";
        }
        return text;
    }

    public String toTag() {
        String str = "<" + this.nodeName + ">";
        return str;
    }

    public String toTree(String prefix, int[] levels, int level) {
        int i;
        if (level >= levels.length) {
            logger.fatal((Object)String.format("Resulting node tree has more than %d levels.", levels.length));
            return "";
        }
        String buffer = "";
        levels[level] = this.getTrafoChildNodes().size();
        buffer = "+ " + this.getNodeName() + "[" + this.hashCode() + "]:children[" + this.getTrafoChildNodes().size() + "]\n";
        String spaces = "";
        for (i = 0; i <= level; ++i) {
            spaces = levels[i] > 0 ? spaces + "|  " : spaces + "   ";
        }
        buffer = buffer + spaces + LSEP;
        spaces = "";
        for (i = 0; i < level; ++i) {
            spaces = levels[i] > 0 ? spaces + "|  " : spaces + "   ";
        }
        prefix = spaces + "+--";
        for (NodeImpl node : this.getTrafoChildNodes()) {
            int n = level;
            levels[n] = levels[n] - 1;
            if (node instanceof TextImpl) {
                buffer = buffer + prefix + ((TextImpl)node).toString() + "(Text)\n";
                continue;
            }
            if (!(node instanceof ElementImpl)) continue;
            NodeImpl elem = node;
            buffer = buffer + prefix + elem.toTree(prefix, levels, level + 1);
        }
        return buffer;
    }

    public void traverse(INodeVisitor visitor) throws Exception {
        NodeImpl.traverse(this, visitor);
    }

    public String treeView() {
        int[] levels = new int[1024];
        return this.toTree("", levels, 0);
    }

    protected boolean validateAttributes() {
        return true;
    }

    public boolean validateParentPath(HashMap<String, HashMap<String, String>> validParentMap) {
        NodeImpl parent = this.getTrafoParentNode();
        if (parent == null || this.isRoot()) {
            return true;
        }
        while (parent.isMute()) {
            if ((parent = parent.getTrafoParentNode()) != null) continue;
            return true;
        }
        String path = parent.getNodeName() + " -> " + this.toTag();
        while (parent != null && !(parent instanceof DocumentFragmentImpl)) {
            if (validParentMap.get(parent.getNodeName()) == null) {
                return false;
            }
            if ((parent = parent.getTrafoParentNode()) == null) continue;
            while (parent.isMute()) {
                if ((parent = parent.getTrafoParentNode()) != null) continue;
                return true;
            }
            path = parent.getNodeName() + " -> " + path;
        }
        return true;
    }

    public <T> T getAnnotation(Class<T> type) {
        if (this.annotationList == null) {
            return null;
        }
        List collected = this.annotationList.stream().filter(annotation -> type.isInstance(annotation)).collect(Collectors.toList());
        if (collected != null && collected.size() > 0) {
            return collected.get(0);
        }
        return null;
    }

    public void vanish() {
        if (this.parent != null) {
            NodeListImpl children = this.parent.getTrafoChildNodes();
            children.remove(this);
        }
    }

    public <T> List<T> getAnnotations(Class<T> type) {
        ArrayList foundList = new ArrayList();
        if (this.annotationList == null) {
            return foundList;
        }
        List collected = this.annotationList.stream().filter(annotation -> type.isInstance(annotation)).collect(Collectors.toList());
        if (collected != null && collected.size() > 0) {
            return collected;
        }
        return foundList;
    }
}

