/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias.dom;

import java.util.LinkedHashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
extends LinkedHashMap<String, Node>
implements NamedNodeMap {
    private static final long serialVersionUID = 1L;

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public Node getNamedItem(String name) {
        return (Node)this.get(name);
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return (Node)this.get(namespaceURI + ":" + localName);
    }

    @Override
    public Node item(int index) {
        Node[] nodes = this.values().toArray(new Node[0]);
        if (nodes == null || index >= nodes.length || index < 0) {
            return null;
        }
        return nodes[index];
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        return (Node)this.remove(name);
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return (Node)this.remove(namespaceURI + ":" + localName);
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        this.put(node.getLocalName(), node);
        return node;
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        String namespace = node.getNamespaceURI();
        this.put(namespace + ":" + node.getLocalName(), node);
        return node;
    }
}

