/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias.dom;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.xiphias.dom.AttrImpl;
import org.dbdoclet.xiphias.dom.DOMTraverser;
import org.dbdoclet.xiphias.dom.ElementByTagNameVisitor;
import org.dbdoclet.xiphias.dom.NamedNodeMapImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    public static final int FORMAT_BLOCK = 3;
    public static final int FORMAT_CONTENT = 2;
    public static final int FORMAT_INLINE = 1;
    private static int idCounter = 1;
    private static Log logger = LogFactory.getLog(ElementImpl.class);
    private static final Pattern xmlIdPattern = Pattern.compile("[^\\w\\.-]+");
    private static final Pattern xmlNameStartPattern = Pattern.compile("^[a-zA-Z_].*$");
    private Map<String, Attr> attributes = new TreeMap<String, Attr>();
    private int formatType = 2;
    private boolean isLiteral = false;

    public static String hardenId(String id) {
        if (id == null || id.length() == 0) {
            id = StringServices.fillInt(idCounter++, 5);
            id = "N" + id;
        }
        String buffer = new String(id);
        try {
            buffer = URLDecoder.decode(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException oops) {
            logger.fatal((Object)("Decoding of id '" + buffer + "' failed!"), (Throwable)oops);
        }
        Matcher matcher = xmlIdPattern.matcher(buffer);
        buffer = matcher.replaceAll("-");
        matcher = xmlNameStartPattern.matcher(buffer);
        if (!matcher.matches()) {
            buffer = "dbdoclet." + buffer;
        }
        return buffer;
    }

    public ElementImpl() {
        this.setNodeType((short)1);
    }

    public ElementImpl(String name) {
        super(name);
        this.setNodeType((short)1);
    }

    public ElementImpl(String name, NodeImpl parent) {
        super(name, parent);
        this.setNodeType((short)1);
    }

    private void addAttribute(Attr newAttr) {
        String key = this.createAttributeKey(newAttr.getNamespaceURI(), newAttr.getNodeName());
        this.attributes.put(key, newAttr);
    }

    public void clearAttributes() {
        this.attributes = new TreeMap<String, Attr>();
    }

    public void closed() {
    }

    private String createAttributeKey(String namespaceUri, String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (name.contains(":")) {
            name = name.split(":")[1];
        }
        String key = name;
        if (namespaceUri != null && namespaceUri.trim().length() > 0) {
            key = String.format("{%s %s}", namespaceUri, name);
        }
        return key;
    }

    public <T extends Element> ArrayList<T> findChildren(Class<T> type) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element element : this.getChildElementList()) {
            if (!type.isInstance(element)) continue;
            list.add(element);
        }
        return list;
    }

    public Element findFirstElement() {
        ArrayList<Element> childList = this.getChildElementList();
        if (childList != null && childList.size() > 0) {
            return childList.get(0);
        }
        return null;
    }

    @Override
    public String getAttribute(String name) {
        if (name == null || name.equals("")) {
            return "";
        }
        Attr attr = this.attributes.get(name = name.toLowerCase());
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        name = name.toLowerCase();
        return this.attributes.get(this.createAttributeKey(null, name));
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        String key = this.createAttributeKey(namespaceURI, localName);
        return this.attributes.get(key);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        NamedNodeMapImpl map = new NamedNodeMapImpl();
        for (Attr attr : this.attributes.values()) {
            map.setNamedItem(attr);
        }
        return map;
    }

    @Override
    public Map<String, Attr> getAttributesAsMap() {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, Attr>();
        }
        return this.attributes;
    }

    public String getAttributesAsText() {
        if (this.attributes != null && this.attributes.size() > 0) {
            this.validateAttributes();
            return this.attributes.values().stream().map(a -> a.getNodeName() + "=\"" + a.getNodeValue() + "\"").collect(Collectors.joining(" "));
        }
        return "";
    }

    public boolean getBooleanAttribute(String name) {
        String value;
        if (name == null || name.equals("")) {
            return false;
        }
        Attr attr = this.attributes.get(name);
        String bval = "false";
        if (attr != null && (value = attr.getValue()) != null && value.trim().equals("1")) {
            bval = "true";
        }
        Boolean b = new Boolean(bval);
        return b;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        ElementByTagNameVisitor visitor = new ElementByTagNameVisitor(name);
        DOMTraverser dt = new DOMTraverser(visitor);
        try {
            dt.traverse(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return visitor.getElementList();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    public int getFormatType() {
        return this.formatType;
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public Integer getIntAttribute(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        Attr attr = this.attributes.get(name);
        if (attr == null) {
            return null;
        }
        String value = attr.getValue();
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        int number = 0;
        try {
            number = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException oops) {
            logger.warn((Object)("Attribute " + name + " of tag " + this.getTagName() + " is not a valid integer. It has a value of '" + value + "'."));
            return null;
        }
        return number;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    public boolean hasAttribute(String name) {
        return false;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return false;
    }

    public boolean isFirstChildElement() {
        ElementImpl parent = (ElementImpl)this.getParentNode();
        Element first = parent.getFirstChildElement();
        return first != null && this == first;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }

    public NodeImpl isLiteral(boolean isLiteral) {
        this.isLiteral = isLiteral;
        return this;
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        if (name != null) {
            if (this.isCaseInsensitive) {
                name = name.toLowerCase();
            }
            this.attributes.remove(name);
        }
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr == null) {
            return null;
        }
        return this.attributes.remove(oldAttr.getName());
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
    }

    public void setAttribute(String name, Object value) throws DOMException {
        if (value != null) {
            this.setAttribute(name, value.toString());
        }
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        if (name != null && name.length() > 0 && value != null) {
            if (this.isCaseInsensitive) {
                name = name.toLowerCase();
            }
            AttrImpl attr = (AttrImpl)this.getDocument().createAttribute(name);
            attr.setNodeValue(value);
            attr.setOwnerElement(this);
            this.addAttribute(attr);
        }
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (newAttr == null) {
            return null;
        }
        String name = newAttr.getName();
        Attr oldAttr = this.attributes.get(name);
        this.addAttribute(newAttr);
        return oldAttr;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return null;
    }

    @Override
    public void setAttributeNS(String namespaceUri, String qualifiedName, String value) throws DOMException {
        AttrImpl attr = (AttrImpl)this.getDocument().createAttributeNS(namespaceUri, qualifiedName);
        attr.setNodeValue(value);
        attr.setOwnerElement(this);
        this.addAttribute(attr);
    }

    public NodeImpl setFormatType(int formatType) {
        this.formatType = formatType;
        return this;
    }

    public void setId(int number) {
        this.setAttribute("id", String.valueOf(number));
    }

    public void setId(String id) {
        this.setAttribute("id", ElementImpl.hardenId(id));
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    public NodeImpl setTrafoAttributes(Map<String, Attr> nattrs) {
        if (nattrs == null) {
            throw new IllegalArgumentException("Parameter attributes is null!");
        }
        this.attributes.putAll(nattrs);
        this.attributes.values().stream().forEach(attr -> ((AttrImpl)attr).setOwnerElement(this));
        return this;
    }

    public NodeImpl setTrafoStringAttributes(Map<String, String> tokenAttrs) {
        if (tokenAttrs == null) {
            throw new IllegalArgumentException("Parameter attributes is null!");
        }
        Iterator<String> iterator = tokenAttrs.keySet().iterator();
        while (iterator.hasNext()) {
            String tokenAttrName;
            String attrName = tokenAttrName = iterator.next();
            if (this.isCaseInsensitive) {
                attrName = attrName.toLowerCase();
            }
            AttrImpl attr = (AttrImpl)this.getDocument().createAttribute(attrName);
            attr.setNodeValue(tokenAttrs.get(tokenAttrName));
            attr.setOwnerElement(this);
            this.addAttribute(attr);
        }
        return this;
    }
}

