/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias.dom;

import org.dbdoclet.service.StringServices;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.EntityImpl;
import org.dbdoclet.xiphias.dom.NamedNodeMapImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;

public class DocumentTypeImpl
extends NodeImpl
implements DocumentType {
    public static DocumentTypeImpl DOCBOOK_XML_ARTICLE_4_3 = new DocumentTypeImpl("article", "-//OASIS//DTD DocBook XML V4.3//EN", "http://www.oasis-open.org/docbook/xml/4.3/docbookx.dtd");
    public static DocumentTypeImpl DOCBOOK_XML_ARTICLE_4_4 = new DocumentTypeImpl("article", "-//OASIS//DTD DocBook XML V4.4//EN", "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd");
    public static DocumentTypeImpl DOCBOOK_XML_ARTICLE_4_5 = new DocumentTypeImpl("article", "-//OASIS//DTD DocBook XML V4.5//EN", "http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd");
    private String name = "";
    private String publicId = "";
    private String systemId = "";
    private NamedNodeMapImpl entityMap;

    public DocumentTypeImpl() {
        this.setNodeName("@doctype@");
        this.setNodeType((short)10);
        this.entityMap = new NamedNodeMapImpl();
    }

    private DocumentTypeImpl(String name, String publicId, String systemId) {
        this();
        if (name == null) {
            throw new IllegalArgumentException("The argument name must not be null!");
        }
        if (publicId == null) {
            throw new IllegalArgumentException("The argument publicId must not be null!");
        }
        if (systemId == null) {
            throw new IllegalArgumentException("The argument systemId must not be null!");
        }
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNodeValue() {
        return "<!DOCTYPE " + XmlServices.textToXml(this.name) + " PUBLIC \"" + XmlServices.textToXml(this.publicId) + "\" \"" + XmlServices.textToXml(this.systemId) + "\">";
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The argument name must not be empty!");
        }
        this.name = name;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setSystemId(String systemId) {
        if (systemId != null) {
            systemId = StringServices.replace(systemId, "\\", "\\\\");
        }
        this.systemId = systemId;
    }

    @Override
    public String toString() {
        return "<!DOCTYPE>";
    }

    @Override
    public NamedNodeMap getEntities() {
        return this.entityMap;
    }

    @Override
    public String getInternalSubset() {
        return null;
    }

    @Override
    public NamedNodeMap getNotations() {
        return null;
    }

    public void addEntity(EntityImpl entity) {
        this.entityMap.setNamedItem(entity);
    }
}

