/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias.dom;

import java.util.ArrayList;
import org.dbdoclet.xiphias.dom.INodeVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTraverser {
    private ArrayList<INodeVisitor> visitors = new ArrayList();

    public DOMTraverser(INodeVisitor visitor) {
        this.addVisitor(visitor);
    }

    public void addVisitor(INodeVisitor visitor) {
        this.visitors.add(visitor);
    }

    public void traverse(Node node) throws Exception {
        int i;
        if (node.getNodeType() == 1) {
            this.openTag(node);
        }
        this.accept(node);
        if (node.getNodeType() == 1 && node.hasAttributes()) {
            NamedNodeMap attrs = ((Element)node).getAttributes();
            for (i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                this.accept(attr);
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                this.traverse(child);
            }
        }
        if (node.getNodeType() == 1) {
            this.closeTag(node);
        }
    }

    private void openTag(Node node) throws Exception {
        for (INodeVisitor visitor : this.visitors) {
            visitor.openTag(node);
        }
    }

    private void accept(Node node) throws Exception {
        for (INodeVisitor visitor : this.visitors) {
            visitor.accept(node);
        }
    }

    private void closeTag(Node node) throws Exception {
        for (INodeVisitor visitor : this.visitors) {
            visitor.closeTag(node);
        }
    }
}

