/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.io.File;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.dbdoclet.service.ResourceServices;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XmlValidationResult
implements ErrorHandler,
LSResourceResolver {
    private boolean hasErrors = false;
    private boolean fileNotFound = false;
    private boolean canNotRead = false;
    private int errorCounter = 0;
    private final ArrayList<String> errorList;
    private final ArrayList<String> warningList;
    private final ArrayList<Throwable> exceptionList;
    private Throwable throwable;
    private final File xmlFile;
    private final ResourceBundle res;
    private String systemId;

    public XmlValidationResult(File xmlFile, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("The argument locale must not be null!");
        }
        this.xmlFile = xmlFile;
        this.res = ResourceBundle.getBundle("org/dbdoclet/xiphias/Resources", locale);
        this.errorList = new ArrayList();
        this.warningList = new ArrayList();
        this.exceptionList = new ArrayList();
    }

    public XmlValidationResult(File xmlFile) {
        this(xmlFile, Locale.getDefault());
    }

    public XmlValidationResult(String systemId) {
        this(null, Locale.getDefault());
        this.systemId = systemId;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public String getSourceDescription() {
        if (this.xmlFile != null) {
            return this.xmlFile.getAbsolutePath();
        }
        if (this.systemId == null || this.systemId.length() == 0) {
            return "Anonymous InputStream";
        }
        return this.systemId;
    }

    public boolean failed() {
        return this.hasErrors;
    }

    public void setFileNotFound(boolean fileNotFound) {
        this.fileNotFound = fileNotFound;
        String msg = MessageFormat.format(ResourceServices.getString(this.res, "C_XML_VALIDATION_ERROR_FILE_NOT_FOUND"), this.getSourceDescription());
        this.errorList.add(msg);
        this.hasErrors = true;
        ++this.errorCounter;
    }

    public boolean getFileNotFound() {
        return this.fileNotFound;
    }

    public void setCanNotRead(boolean canNotRead) {
        this.canNotRead = canNotRead;
        String msg = MessageFormat.format(this.res.getString("C_XML_VALIDATION_ERROR_FILE_CAN_NOT_READ"), this.getSourceDescription());
        this.errorList.add(msg);
        this.hasErrors = true;
        ++this.errorCounter;
    }

    public boolean getCanNotRead() {
        return this.canNotRead;
    }

    public int getNumOfErrors() {
        return this.errorCounter;
    }

    public void setThrowable(Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("The argument throwable must not be null!");
        }
        this.throwable = throwable;
        String msg = "(" + throwable.getClass().getName() + ") " + throwable.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = throwable.getClass().getName();
        }
        msg = this.getSourceDescription() + ": " + msg;
        this.errorList.add(msg);
        this.hasErrors = true;
        ++this.errorCounter;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public void fatalError(SAXParseException oops) {
        ++this.errorCounter;
        String msg = MessageFormat.format(ResourceServices.getString(this.res, "C_XML_VALIDATION_FATAL"), this.getSourceDescription(), String.valueOf(oops.getLineNumber()), String.valueOf(oops.getColumnNumber()), oops.getMessage());
        this.errorList.add(msg);
        this.exceptionList.add(oops);
        this.hasErrors = true;
    }

    @Override
    public void error(SAXParseException oops) {
        ++this.errorCounter;
        String msg = MessageFormat.format(ResourceServices.getString(this.res, "C_XML_VALIDATION_ERROR"), this.getSourceDescription(), String.valueOf(oops.getLineNumber()), String.valueOf(oops.getColumnNumber()), oops.getMessage());
        this.errorList.add(msg);
        this.exceptionList.add(oops);
        this.hasErrors = true;
    }

    @Override
    public void warning(SAXParseException oops) {
        String msg = MessageFormat.format(ResourceServices.getString(this.res, "C_XML_VALIDATION_WARNING"), this.getSourceDescription(), String.valueOf(oops.getLineNumber()), String.valueOf(oops.getColumnNumber()), oops.getMessage());
        this.warningList.add(msg);
    }

    public String createTextReport() {
        return this.createReport(false);
    }

    public String createHtmlReport() {
        return this.createReport(true);
    }

    public String createReport(boolean isHtml) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\n');
        if (isHtml) {
            buffer.append("<p>");
        }
        String msg = MessageFormat.format(ResourceServices.getString(this.res, "C_XML_VALIDATION_OF_FILE"), this.getSourceDescription());
        buffer.append(msg);
        if (isHtml) {
            buffer.append("</p>");
        }
        Iterator<String> iterator = this.warningList.iterator();
        while (iterator.hasNext()) {
            if (isHtml) {
                buffer.append("<pre>");
            }
            buffer.append('\n');
            msg = iterator.next();
            buffer.append(msg);
            if (isHtml) {
                buffer.append("</pre>");
            }
            buffer.append('\n');
        }
        buffer.append('\n');
        if (!this.failed()) {
            if (isHtml) {
                buffer.append("<p><b>");
                buffer.append(ResourceServices.getString(this.res, "C_XML_VALIDATION_SUCCESSFUL"));
                buffer.append("</b></p>");
            } else {
                buffer.append(ResourceServices.getString(this.res, "C_XML_VALIDATION_SUCCESSFUL"));
            }
            buffer.append('\n');
        } else {
            iterator = this.errorList.iterator();
            while (iterator.hasNext()) {
                if (isHtml) {
                    buffer.append("<pre>");
                }
                buffer.append('\n');
                msg = iterator.next();
                buffer.append(msg);
                if (isHtml) {
                    buffer.append("</pre>");
                }
                buffer.append('\n');
            }
            buffer.append('\n');
            msg = MessageFormat.format(ResourceServices.getString(this.res, "C_XML_VALIDATION_NUMBER_OF_ERRORS"), String.valueOf(this.errorCounter));
            buffer.append(msg);
            buffer.append('\n');
            if (isHtml) {
                buffer.append("<p><b>");
                buffer.append(ResourceServices.getString(this.res, "C_XML_VALIDATION_FAILED"));
                buffer.append("</b></p>");
            } else {
                buffer.append(ResourceServices.getString(this.res, "C_XML_VALIDATION_FAILED"));
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId != null && systemId.length() > 0 && systemId.startsWith("http://")) {
            try {
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementationLS domImpl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                LSInput input = domImpl.createLSInput();
                input.setCharacterStream(new StringReader(""));
                return input;
            }
            catch (Exception oops) {
                oops.printStackTrace();
            }
        }
        return null;
    }
}

