/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.service.ReplaceServices;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.service.UnicodeServices;
import org.dbdoclet.xiphias.NodeSerializer;
import org.dbdoclet.xiphias.XPathServices;
import org.dbdoclet.xiphias.XmlValidationResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlServices {
    public static final String test = "&nbsp;";
    private static final Pattern encPattern = Pattern.compile("^(?i).*<\\?xml\\s*.*encoding=['\"](.*)['\"].*\\?>.*$");
    private static Log logger = LogFactory.getLog(XmlServices.class);
    private static final Pattern startsWithDigitPattern = Pattern.compile("^[0-9].*$");

    public static int findDocBookTextIndex(String buffer, int index) {
        int length = 0;
        Stack<String> blocked = new Stack<String>();
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == '<') {
                StringBuffer tagName = new StringBuffer();
                while (c != '>' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                    tagName.append(c);
                }
                if (tagName.toString().startsWith("</")) {
                    String closingTag = tagName.toString();
                    if (closingTag.equals("</indexterm>") && !blocked.empty()) {
                        blocked.pop();
                    }
                } else {
                    String openTag = tagName.toString();
                    if (openTag.equals("<indexterm>")) {
                        blocked.push(openTag);
                    }
                }
                --i;
                continue;
            }
            if (c == '&') {
                c = buffer.charAt(i++);
                while (c != ';' && c != ' ' && c != '\t' && c != '\r' && c != '\n' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                }
                --i;
                continue;
            }
            if (length == index) {
                return i;
            }
            if (blocked.size() != 0) continue;
            ++length;
        }
        return -1;
    }

    public static int findXmlTextIndex(String buffer, int index) {
        int length = 0;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == '<') {
                while (c != '>' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                }
                --i;
                continue;
            }
            if (c == '&') {
                c = buffer.charAt(i++);
                while (c != ';' && c != ' ' && c != '\t' && c != '\r' && c != '\n' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                }
                --i;
                continue;
            }
            if (length == index) {
                return i;
            }
            ++length;
        }
        return -1;
    }

    public static int getDocBookTextLength(String buffer) {
        return XmlServices.getDocBookTextLength(new StringBuffer(buffer));
    }

    public static int getDocBookTextLength(StringBuffer buffer) {
        int length = 0;
        Stack<String> blocked = new Stack<String>();
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == '<') {
                StringBuffer tagName = new StringBuffer();
                while (c != '>' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                    tagName.append(c);
                }
                if (tagName.toString().startsWith("</")) {
                    String closingTag = tagName.toString();
                    if (closingTag.equals("</indexterm>") && !blocked.empty()) {
                        blocked.pop();
                    }
                } else {
                    String openTag = tagName.toString();
                    if (openTag.equals("<indexterm>")) {
                        blocked.push(openTag);
                    }
                }
                --i;
                continue;
            }
            if (c == '&') {
                c = buffer.charAt(i++);
                while (c != ';' && c != ' ' && c != '\t' && c != '\r' && c != '\n' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                }
                --i;
                continue;
            }
            if (blocked.size() != 0) continue;
            ++length;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncoding(File source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("The argument source must not be null!");
        }
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(source));
            while ((line = reader.readLine()) != null) {
                logger.debug((Object)("line=" + line));
                Matcher matcher = encPattern.matcher(line);
                if (!matcher.matches()) continue;
                String string = matcher.group(1);
                return string;
            }
        }
        return "UTF-8";
    }

    public static String getEncoding(String source) throws IOException {
        String line;
        if (source == null) {
            throw new IllegalArgumentException("The argument source must not be null!");
        }
        BufferedReader reader = new BufferedReader(new StringReader(source));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = encPattern.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return "UTF-8";
    }

    public static String getFullyQualifiedElementName(Element element) {
        if (element == null) {
            return null;
        }
        Stack<String> stack = new Stack<String>();
        for (Element parent = element; parent != null; parent = (Element)parent.getParentNode()) {
            stack.push(parent.getTagName());
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('/');
        while (!stack.isEmpty()) {
            buffer.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            buffer.append('/');
        }
        return buffer.toString();
    }

    public static int getXmlTextLength(String buffer) {
        return XmlServices.getXmlTextLength(new StringBuffer(buffer));
    }

    public static int getXmlTextLength(StringBuffer buffer) {
        int length = 0;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == '<') {
                while (c != '>' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                }
                --i;
                continue;
            }
            if (c == '&') {
                c = buffer.charAt(i++);
                while (c != ';' && c != ' ' && c != '\t' && c != '\r' && c != '\n' && i < buffer.length()) {
                    c = buffer.charAt(i++);
                }
                --i;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static boolean isEntity(StringBuffer word) {
        if (word == null) {
            throw new IllegalArgumentException("The argument word must not be null!");
        }
        int length = word.length();
        int max = length - 1;
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (i == 0 && c != '&') {
                return false;
            }
            if (i == max && c != ';') {
                return false;
            }
            if (!Character.isWhitespace(c)) continue;
            return false;
        }
        String buffer = word.toString();
        buffer = StringServices.cutPrefix(buffer, "&");
        Matcher matcher = startsWithDigitPattern.matcher(buffer = StringServices.cutSuffix(buffer, ";"));
        return !matcher.matches();
    }

    public static String normalizeText(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\\s+", " ");
    }

    public static Document parse(File source) throws IOException, SAXException, ParserConfigurationException {
        return XmlServices.parse(source, true, null);
    }

    public static Document parse(File source, boolean validate) throws IOException, SAXException, ParserConfigurationException {
        return XmlServices.parse(source, validate, null);
    }

    public static Document parse(File file, boolean validate, URL schemaUrl) throws IOException, SAXException, ParserConfigurationException {
        String encoding = XmlServices.getEncoding(file);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(file.getCanonicalPath());
        return XmlServices.parse(inputSource, validate, null);
    }

    public static Document parse(InputSource source, boolean validate, URL schemaUrl) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder parser;
        if (source == null) {
            throw new IllegalArgumentException("The argument source may not be null!");
        }
        System.setProperty("xml.catalog.ignoreMissing", "yes");
        if (schemaUrl != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setXIncludeAware(true);
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            parser = factory.newDocumentBuilder();
        } else {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setXIncludeAware(true);
            parser = factory.newDocumentBuilder();
            parser.setEntityResolver((EntityResolver)new CatalogResolver());
        }
        XmlValidationResult result = new XmlValidationResult(new File(source.getSystemId()), Locale.getDefault());
        parser.setErrorHandler(result);
        Document doc = parser.parse(source);
        return doc;
    }

    public static Document loadDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("The argument source may not be null!");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder parser = factory.newDocumentBuilder();
        parser.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
            }
        });
        XmlValidationResult result = new XmlValidationResult(file, Locale.getDefault());
        parser.setErrorHandler(result);
        Document doc = parser.parse(file);
        return doc;
    }

    public static Document parse(File source, URL schemaUrl) throws IOException, SAXException, ParserConfigurationException {
        return XmlServices.parse(source, true, schemaUrl);
    }

    public static void recode(File file, String to, URL schemaUrl) throws IOException, SAXException, ParserConfigurationException {
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        if (to == null) {
            throw new IllegalArgumentException("The argument to must not be null!");
        }
        String from = XmlServices.getEncoding(file);
        if (from == null) {
            from = "UTF-8";
        }
        if (from.toLowerCase().equals(to.toLowerCase())) {
            return;
        }
        Document doc = XmlServices.parse(file, false, schemaUrl);
        NodeSerializer serializer = new NodeSerializer();
        serializer.setEncoding(to);
        serializer.write((Node)doc, file);
    }

    public static String replaceAmpersand(String text, boolean isHtml) {
        StringBuffer source = new StringBuffer(text);
        StringBuffer dest = new StringBuffer();
        int max = source.length() - 1;
        block0: for (int i = 0; i <= max; ++i) {
            char c = source.charAt(i);
            if (c == '&') {
                StringBuffer word = new StringBuffer();
                if (i == max) {
                    dest.append("&amp;");
                    continue;
                }
                if (source.charAt(i + 1) == ';') {
                    ++i;
                    dest.append("&amp;;");
                    continue;
                }
                word.append('&');
                while (i < max) {
                    if (Character.isWhitespace(c = source.charAt(++i)) || c == '&' || c == ';' || i == max) {
                        if (c == ';') {
                            word.append(c);
                        }
                        if (XmlServices.isEntity(word)) {
                            String entity = word.toString();
                            if (isHtml) {
                                entity = XmlServices.resolveHtmlEntity(entity);
                            }
                            entity = XmlServices.resolveNumericEntity(entity);
                            dest.append(entity);
                            if (!Character.isWhitespace(c)) continue block0;
                            dest.append(c);
                            continue block0;
                        }
                        dest.append("&amp;");
                        dest.append(word.substring(1));
                        if (Character.isWhitespace(c)) {
                            dest.append(c);
                        }
                        if (i == max) {
                            if (c == '&') {
                                dest.append("&amp;");
                            } else if (c != ';') {
                                dest.append(c);
                            }
                        }
                        logger.debug((Object)("dest: " + dest.toString()));
                        if (c != '&') continue block0;
                        word = new StringBuffer();
                        word.append('&');
                        continue;
                    }
                    word.append(c);
                }
                continue;
            }
            dest.append(c);
        }
        return dest.toString();
    }

    public static String resolveHtmlEntity(String entity) {
        if (entity == null || entity.length() == 0) {
            return "";
        }
        if (!entity.startsWith("&") || !entity.endsWith(";")) {
            return entity;
        }
        if (entity.equals(test)) {
            return XmlServices.resolveNumericEntity("&#160;");
        }
        if (entity.equals("&iexcl;")) {
            return XmlServices.resolveNumericEntity("&#161;");
        }
        if (entity.equals("&curren;")) {
            return XmlServices.resolveNumericEntity("&#164;");
        }
        if (entity.equals("&cent;")) {
            return XmlServices.resolveNumericEntity("&#162;");
        }
        if (entity.equals("&pound;")) {
            return XmlServices.resolveNumericEntity("&#163;");
        }
        if (entity.equals("&yen;")) {
            return XmlServices.resolveNumericEntity("&#165;");
        }
        if (entity.equals("&brvbar;")) {
            return XmlServices.resolveNumericEntity("&#166;");
        }
        if (entity.equals("&sect;")) {
            return XmlServices.resolveNumericEntity("&#167;");
        }
        if (entity.equals("&uml;")) {
            return XmlServices.resolveNumericEntity("&#168;");
        }
        if (entity.equals("&copy;")) {
            return XmlServices.resolveNumericEntity("&#169;");
        }
        if (entity.equals("&ordf;")) {
            return XmlServices.resolveNumericEntity("&#170;");
        }
        if (entity.equals("&laquo;")) {
            return XmlServices.resolveNumericEntity("&#171;");
        }
        if (entity.equals("&not;")) {
            return XmlServices.resolveNumericEntity("&#172;");
        }
        if (entity.equals("&shy;")) {
            return XmlServices.resolveNumericEntity("&#173;");
        }
        if (entity.equals("&reg;")) {
            return XmlServices.resolveNumericEntity("&#174;");
        }
        if (entity.equals("&trade;")) {
            return XmlServices.resolveNumericEntity("&#8482;");
        }
        if (entity.equals("&macr;")) {
            return XmlServices.resolveNumericEntity("&#175;");
        }
        if (entity.equals("&deg;")) {
            return XmlServices.resolveNumericEntity("&#176;");
        }
        if (entity.equals("&plusmn;")) {
            return XmlServices.resolveNumericEntity("&#177;");
        }
        if (entity.equals("&sup2;")) {
            return XmlServices.resolveNumericEntity("&#178;");
        }
        if (entity.equals("&sup3;")) {
            return XmlServices.resolveNumericEntity("&#179;");
        }
        if (entity.equals("&acute;")) {
            return XmlServices.resolveNumericEntity("&#180;");
        }
        if (entity.equals("&micro;")) {
            return XmlServices.resolveNumericEntity("&#181;");
        }
        if (entity.equals("&para;")) {
            return XmlServices.resolveNumericEntity("&#182;");
        }
        if (entity.equals("&middot;")) {
            return XmlServices.resolveNumericEntity("&#183;");
        }
        if (entity.equals("&cedil;")) {
            return XmlServices.resolveNumericEntity("&#184;");
        }
        if (entity.equals("&sup1;")) {
            return XmlServices.resolveNumericEntity("&#185;");
        }
        if (entity.equals("&ordm;")) {
            return XmlServices.resolveNumericEntity("&#186;");
        }
        if (entity.equals("&raquo;")) {
            return XmlServices.resolveNumericEntity("&#187;");
        }
        if (entity.equals("&frac14;")) {
            return XmlServices.resolveNumericEntity("&#188;");
        }
        if (entity.equals("&frac12;")) {
            return XmlServices.resolveNumericEntity("&#189;");
        }
        if (entity.equals("&frac34;")) {
            return XmlServices.resolveNumericEntity("&#190;");
        }
        if (entity.equals("&iquest;")) {
            return XmlServices.resolveNumericEntity("&#191;");
        }
        if (entity.equals("&times;")) {
            return XmlServices.resolveNumericEntity("&#215;");
        }
        if (entity.equals("&divide;")) {
            return XmlServices.resolveNumericEntity("&#247;");
        }
        if (entity.equals("&Agrave;")) {
            return XmlServices.resolveNumericEntity("&#192;");
        }
        if (entity.equals("&Aacute;")) {
            return XmlServices.resolveNumericEntity("&#193;");
        }
        if (entity.equals("&Acirc;")) {
            return XmlServices.resolveNumericEntity("&#194;");
        }
        if (entity.equals("&Atilde;")) {
            return XmlServices.resolveNumericEntity("&#195;");
        }
        if (entity.equals("&Auml;")) {
            return XmlServices.resolveNumericEntity("&#196;");
        }
        if (entity.equals("&Aring;")) {
            return XmlServices.resolveNumericEntity("&#197;");
        }
        if (entity.equals("&AElig;")) {
            return XmlServices.resolveNumericEntity("&#198;");
        }
        if (entity.equals("&Ccedil;")) {
            return XmlServices.resolveNumericEntity("&#199;");
        }
        if (entity.equals("&Egrave;")) {
            return XmlServices.resolveNumericEntity("&#200;");
        }
        if (entity.equals("&Eacute;")) {
            return XmlServices.resolveNumericEntity("&#201;");
        }
        if (entity.equals("&Ecirc;")) {
            return XmlServices.resolveNumericEntity("&#202;");
        }
        if (entity.equals("&Euml;")) {
            return XmlServices.resolveNumericEntity("&#203;");
        }
        if (entity.equals("&Igrave;")) {
            return XmlServices.resolveNumericEntity("&#204;");
        }
        if (entity.equals("&Iacute;")) {
            return XmlServices.resolveNumericEntity("&#205;");
        }
        if (entity.equals("&Icirc;")) {
            return XmlServices.resolveNumericEntity("&#206;");
        }
        if (entity.equals("&Iuml;")) {
            return XmlServices.resolveNumericEntity("&#207;");
        }
        if (entity.equals("&ETH;")) {
            return XmlServices.resolveNumericEntity("&#208;");
        }
        if (entity.equals("&Ntilde;")) {
            return XmlServices.resolveNumericEntity("&#209;");
        }
        if (entity.equals("&Ograve;")) {
            return XmlServices.resolveNumericEntity("&#210;");
        }
        if (entity.equals("&Oacute;")) {
            return XmlServices.resolveNumericEntity("&#211;");
        }
        if (entity.equals("&Ocirc;")) {
            return XmlServices.resolveNumericEntity("&#212;");
        }
        if (entity.equals("&Otilde;")) {
            return XmlServices.resolveNumericEntity("&#213;");
        }
        if (entity.equals("&Ouml;")) {
            return XmlServices.resolveNumericEntity("&#214;");
        }
        if (entity.equals("&Oslash;")) {
            return XmlServices.resolveNumericEntity("&#216;");
        }
        if (entity.equals("&Ugrave;")) {
            return XmlServices.resolveNumericEntity("&#217;");
        }
        if (entity.equals("&Uacute;")) {
            return XmlServices.resolveNumericEntity("&#218;");
        }
        if (entity.equals("&Ucirc;")) {
            return XmlServices.resolveNumericEntity("&#219;");
        }
        if (entity.equals("&Uuml;")) {
            return XmlServices.resolveNumericEntity("&#220;");
        }
        if (entity.equals("&Yacute;")) {
            return XmlServices.resolveNumericEntity("&#221;");
        }
        if (entity.equals("&THORN;")) {
            return XmlServices.resolveNumericEntity("&#222;");
        }
        if (entity.equals("&szlig;")) {
            return XmlServices.resolveNumericEntity("&#223;");
        }
        if (entity.equals("&agrave;")) {
            return XmlServices.resolveNumericEntity("&#224;");
        }
        if (entity.equals("&aacute;")) {
            return XmlServices.resolveNumericEntity("&#225;");
        }
        if (entity.equals("&acirc;")) {
            return XmlServices.resolveNumericEntity("&#226;");
        }
        if (entity.equals("&atilde;")) {
            return XmlServices.resolveNumericEntity("&#227;");
        }
        if (entity.equals("&auml;")) {
            return XmlServices.resolveNumericEntity("&#228;");
        }
        if (entity.equals("&aring;")) {
            return XmlServices.resolveNumericEntity("&#229;");
        }
        if (entity.equals("&aelig;")) {
            return XmlServices.resolveNumericEntity("&#230;");
        }
        if (entity.equals("&ccedil;")) {
            return XmlServices.resolveNumericEntity("&#231;");
        }
        if (entity.equals("&egrave;")) {
            return XmlServices.resolveNumericEntity("&#232;");
        }
        if (entity.equals("&eacute;")) {
            return XmlServices.resolveNumericEntity("&#233;");
        }
        if (entity.equals("&ecirc;")) {
            return XmlServices.resolveNumericEntity("&#234;");
        }
        if (entity.equals("&euml;")) {
            return XmlServices.resolveNumericEntity("&#235;");
        }
        if (entity.equals("&igrave;")) {
            return XmlServices.resolveNumericEntity("&#236;");
        }
        if (entity.equals("&iacute;")) {
            return XmlServices.resolveNumericEntity("&#237;");
        }
        if (entity.equals("&icirc;")) {
            return XmlServices.resolveNumericEntity("&#238;");
        }
        if (entity.equals("&iuml;")) {
            return XmlServices.resolveNumericEntity("&#239;");
        }
        if (entity.equals("&eth;")) {
            return XmlServices.resolveNumericEntity("&#240;");
        }
        if (entity.equals("&ntilde;")) {
            return XmlServices.resolveNumericEntity("&#241;");
        }
        if (entity.equals("&ograve;")) {
            return XmlServices.resolveNumericEntity("&#242;");
        }
        if (entity.equals("&oacute;")) {
            return XmlServices.resolveNumericEntity("&#243;");
        }
        if (entity.equals("&ocirc;")) {
            return XmlServices.resolveNumericEntity("&#244;");
        }
        if (entity.equals("&otilde;")) {
            return XmlServices.resolveNumericEntity("&#245;");
        }
        if (entity.equals("&ouml;")) {
            return XmlServices.resolveNumericEntity("&#246;");
        }
        if (entity.equals("&oslash;")) {
            return XmlServices.resolveNumericEntity("&#248;");
        }
        if (entity.equals("&ugrave;")) {
            return XmlServices.resolveNumericEntity("&#249;");
        }
        if (entity.equals("&uacute;")) {
            return XmlServices.resolveNumericEntity("&#250;");
        }
        if (entity.equals("&ucirc;")) {
            return XmlServices.resolveNumericEntity("&#251;");
        }
        if (entity.equals("&uuml;")) {
            return XmlServices.resolveNumericEntity("&#252;");
        }
        if (entity.equals("&yacute;")) {
            return XmlServices.resolveNumericEntity("&#253;");
        }
        if (entity.equals("&thorn;")) {
            return XmlServices.resolveNumericEntity("&#254;");
        }
        if (entity.equals("&yuml;")) {
            return XmlServices.resolveNumericEntity("&#255;");
        }
        if (entity.equals("&OElig;")) {
            return XmlServices.resolveNumericEntity("&#338;");
        }
        if (entity.equals("&oelig;")) {
            return XmlServices.resolveNumericEntity("&#339;");
        }
        if (entity.equals("&Scaron;")) {
            return XmlServices.resolveNumericEntity("&#352;");
        }
        if (entity.equals("&scaron;")) {
            return XmlServices.resolveNumericEntity("&#353;");
        }
        if (entity.equals("&Yuml;")) {
            return XmlServices.resolveNumericEntity("&#376;");
        }
        if (entity.equals("&circ;")) {
            return XmlServices.resolveNumericEntity("&#710;");
        }
        if (entity.equals("&tilde;")) {
            return XmlServices.resolveNumericEntity("&#732;");
        }
        if (entity.equals("&ensp;")) {
            return XmlServices.resolveNumericEntity("&#8194;");
        }
        if (entity.equals("&emsp;")) {
            return XmlServices.resolveNumericEntity("&#8195;");
        }
        if (entity.equals("&thinsp;")) {
            return XmlServices.resolveNumericEntity("&#8201;");
        }
        if (entity.equals("&zwnj;")) {
            return XmlServices.resolveNumericEntity("&#8204;");
        }
        if (entity.equals("&zwj;")) {
            return XmlServices.resolveNumericEntity("&#8205;");
        }
        if (entity.equals("&lrm;")) {
            return XmlServices.resolveNumericEntity("&#8206;");
        }
        if (entity.equals("&rlm;")) {
            return XmlServices.resolveNumericEntity("&#8207;");
        }
        if (entity.equals("&ndash;")) {
            return XmlServices.resolveNumericEntity("&#8211;");
        }
        if (entity.equals("&mdash;")) {
            return XmlServices.resolveNumericEntity("&#8212;");
        }
        if (entity.equals("&lsquo;")) {
            return XmlServices.resolveNumericEntity("&#8216;");
        }
        if (entity.equals("&rsquo;")) {
            return XmlServices.resolveNumericEntity("&#8217;");
        }
        if (entity.equals("&sbquo;")) {
            return XmlServices.resolveNumericEntity("&#8218;");
        }
        if (entity.equals("&ldquo;")) {
            return XmlServices.resolveNumericEntity("&#8220;");
        }
        if (entity.equals("&rdquo;")) {
            return XmlServices.resolveNumericEntity("&#8221;");
        }
        if (entity.equals("&bdquo;")) {
            return XmlServices.resolveNumericEntity("&#8222;");
        }
        if (entity.equals("&dagger;")) {
            return XmlServices.resolveNumericEntity("&#8224;");
        }
        if (entity.equals("&Dagger;")) {
            return XmlServices.resolveNumericEntity("&#8225;");
        }
        if (entity.equals("&hellip;")) {
            return XmlServices.resolveNumericEntity("&#8230;");
        }
        if (entity.equals("&permil;")) {
            return XmlServices.resolveNumericEntity("&#8240;");
        }
        if (entity.equals("&lsaquo;")) {
            return XmlServices.resolveNumericEntity("&#8249;");
        }
        if (entity.equals("&rsaquo;")) {
            return XmlServices.resolveNumericEntity("&#8250;");
        }
        if (entity.equals("&euro;")) {
            return XmlServices.resolveNumericEntity("&#8364;");
        }
        return entity;
    }

    public static String resolveNumericEntity(String entity) {
        if (entity == null || entity.length() == 0) {
            return "";
        }
        if (!entity.startsWith("&#") || !entity.endsWith(";")) {
            return entity;
        }
        String str = entity;
        str = StringServices.cutPrefix(str, "&#");
        str = StringServices.cutSuffix(str, ";");
        int code = -1;
        int radix = 10;
        if (str.startsWith("x")) {
            str = StringServices.cutPrefix(str, "x");
            radix = 16;
        }
        try {
            code = Integer.parseInt(str, radix);
        }
        catch (NumberFormatException oops) {
            return entity;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append((char)code);
        return buffer.toString();
    }

    public static String textToHtml(String text) {
        if (text == null) {
            return null;
        }
        text = XmlServices.textToXml(text, true);
        return text;
    }

    public static String textToXml(String text) {
        return XmlServices.textToXml(text, false);
    }

    public static String textToXml(String text, boolean isHtml) {
        logger.debug((Object)("Argument text: \"" + text + "\""));
        logger.debug((Object)("Argument isHtml: \"" + isHtml + "\""));
        if (text == null) {
            return null;
        }
        text = StringServices.replace(text, "&lt;", "<");
        text = StringServices.replace(text, "&gt;", ">");
        text = StringServices.replace(text, "&quot;", "\"");
        text = StringServices.replace(text, "&apos;", "'");
        text = StringServices.replace(text, "&#39;", "'");
        text = StringServices.replace(text, "<", "&lt;");
        text = StringServices.replace(text, ">", "&gt;");
        text = StringServices.replace(text, "\"", "&quot;");
        text = StringServices.replace(text, "\uf0e0", "<img class=\"arrowImage\" src=\"../../../img/uF0E0.png\">");
        text = isHtml ? StringServices.replace(text, "'", "&#39;") : StringServices.replace(text, "'", "&apos;");
        text = XmlServices.replaceAmpersand(text, isHtml);
        text = UnicodeServices.removeUndefinedCharacters(text);
        logger.debug((Object)("Return: \"" + text + "\""));
        return text;
    }

    public static XmlValidationResult validate(File file) throws ParserConfigurationException, SAXException, IOException {
        return XmlServices.validate(file, null, Locale.getDefault());
    }

    public static XmlValidationResult validate(File file, Locale locale) throws ParserConfigurationException, SAXException, IOException {
        return XmlServices.validate(file, null, locale);
    }

    public static XmlValidationResult validate(File file, URL schemaUrl) throws ParserConfigurationException, SAXException, IOException {
        return XmlServices.validate(file, schemaUrl, Locale.getDefault());
    }

    public static XmlValidationResult validate(File file, URL schemaUrl, Locale locale) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder parser;
        DocumentBuilderFactory factory;
        if (file == null) {
            throw new IllegalArgumentException("The argument file may not be null!");
        }
        if (locale == null) {
            throw new IllegalArgumentException("The argument locale must not be null!");
        }
        XmlValidationResult result = new XmlValidationResult(file, locale);
        if (!file.exists()) {
            result.setFileNotFound(true);
            return result;
        }
        if (!file.canRead()) {
            result.setCanNotRead(true);
            return result;
        }
        System.setProperty("xml.catalog.ignoreMissing", "yes");
        if (schemaUrl != null) {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            factory.setXIncludeAware(true);
            parser = factory.newDocumentBuilder();
            parser.setEntityResolver((EntityResolver)new CatalogResolver());
        } else {
            factory = DocumentBuilderFactory.newInstance();
            parser = factory.newDocumentBuilder();
            parser.setEntityResolver((EntityResolver)new CatalogResolver());
        }
        factory.setValidating(true);
        parser.setErrorHandler(result);
        try {
            parser.parse(file);
        }
        catch (SAXParseException schema) {
        }
        catch (Throwable oops) {
            result.setThrowable(oops);
        }
        return result;
    }

    public static XmlValidationResult validate(String source) throws ParserConfigurationException, SAXException, IOException {
        if (source == null) {
            throw new IllegalArgumentException("The argument source may not be null!");
        }
        return XmlServices.validate(new File(source));
    }

    public static byte[] validate(String xmlCode, String encoding) throws CharacterCodingException, ParserConfigurationException, SAXException, IOException {
        return XmlServices.validate(xmlCode, encoding, null);
    }

    public static byte[] validate(String xmlCode, String encoding, URL schemaUrl) throws CharacterCodingException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilder parser;
        DocumentBuilderFactory factory;
        if (xmlCode == null) {
            throw new IllegalArgumentException("The argument xmlCode may not be null!");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The argument encoding may not be null!");
        }
        System.setProperty("xml.catalog.ignoreMissing", "yes");
        Charset charset = Charset.forName(encoding);
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer inBuffer = CharBuffer.wrap(xmlCode);
        ByteBuffer byteBuffer = encoder.encode(inBuffer);
        int limit = byteBuffer.limit();
        byte[] data = new byte[limit];
        byteBuffer.get(data, 0, limit);
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        if (schemaUrl != null) {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            factory.setXIncludeAware(true);
            parser = factory.newDocumentBuilder();
        } else {
            factory = DocumentBuilderFactory.newInstance();
            parser = factory.newDocumentBuilder();
            parser.setEntityResolver((EntityResolver)new CatalogResolver());
        }
        factory.setValidating(true);
        parser.parse(stream);
        return data;
    }

    public static boolean isNewline(Node node) {
        String text;
        return node != null && node instanceof Text && (text = ((Text)node).getData()) != null && text.trim().length() == 0 && text.indexOf(10) != -1;
    }

    public static String normalizeText(Text text) {
        String data = text.getData();
        data = ReplaceServices.replaceAll(data, "\\s+", " ");
        return data;
    }

    public static String xmlToText(String text) {
        if (text == null) {
            return null;
        }
        text = StringServices.replace(text, "&apos;", "'");
        text = StringServices.replace(text, "&#39;", "'");
        text = StringServices.replace(text, "&quot;", "\"");
        text = StringServices.replace(text, "&lt;", "<");
        text = StringServices.replace(text, "&gt;", ">");
        text = StringServices.replace(text, "&amp;", "&");
        return text;
    }

    public static void xslt(File in, String xsl, HashMap<String, String> params, File out, String encoding, boolean validate) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        XmlServices.xslt(in.getCanonicalPath(), xsl, params, out.getCanonicalPath(), encoding, validate, null);
    }

    public static void xslt(File in, String xsl, HashMap<String, String> params, File out, String encoding, boolean validate, ErrorListener listener) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        XmlServices.xslt(in.getCanonicalPath(), xsl, params, out.getCanonicalPath(), encoding, validate, listener);
    }

    public static void xslt(String in, String xsl, HashMap<String, String> params, String out) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        XmlServices.xslt(in, xsl, params, out, "UTF-8", false, null);
    }

    public static void xslt(String in, String xsl, HashMap<String, String> params, String out, String encoding, boolean validate) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        XmlServices.xslt(in, xsl, params, out, encoding, validate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xslt(String in, String xsl, HashMap<String, String> params, String out, String encoding, boolean validate, ErrorListener listener) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        if (in == null) {
            throw new IllegalArgumentException("Parameter in is null!");
        }
        if (xsl == null) {
            throw new IllegalArgumentException("Parameter xsl is null!");
        }
        if (out == null) {
            throw new IllegalArgumentException("Parameter out is null!");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The argument encoding may not be null!");
        }
        System.setProperty("xml.catalog.ignoreMissing", "yes");
        FileInputStream fis = null;
        FileOutputStream fos = null;
        logger.debug((Object)("validate=" + validate));
        String spf = System.getProperty("javax.xml.parsers.SAXParserFactory");
        String dbf = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
        String tf = System.getProperty("javax.xml.transform.TransformerFactory");
        try {
            Transformer transformer;
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (listener != null) {
                transformerFactory.setErrorListener(listener);
            }
            if (validate) {
                transformerFactory.setURIResolver((URIResolver)new CatalogResolver());
            }
            if ((transformer = transformerFactory.newTransformer(new StreamSource(xsl))) == null) {
                throw new TransformerException("Can't create transformer for stylesheet " + xsl + ". Working directory is " + new File(".").getAbsolutePath());
            }
            if (listener != null) {
                transformer.setErrorListener(listener);
            }
            if (validate) {
                transformer.setURIResolver((URIResolver)new CatalogResolver());
            }
            if (params != null) {
                for (String param : params.keySet()) {
                    String value = params.get(param);
                    transformer.setParameter(param, value);
                }
            }
            fis = new FileInputStream(in);
            fos = new FileOutputStream(out);
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                if (validate) {
                    reader.setEntityResolver((EntityResolver)new CatalogResolver());
                }
                transformer.transform(new SAXSource(reader, new InputSource(in)), new StreamResult(new OutputStreamWriter((OutputStream)fos, encoding)));
            }
            catch (Exception oops) {
                logger.fatal((Object)"XmlServices.xslt", (Throwable)oops);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (spf != null) {
                System.setProperty("javax.xml.parsers.SAXParserFactory", spf);
            }
            if (dbf != null) {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactor", dbf);
            }
            if (tf != null) {
                System.setProperty("javax.xml.transform.TransformerFactory", tf);
            }
        }
    }

    public static void xslt(String in, String xsl, HashMap<String, String> params, String out, String encoding, ErrorListener listener) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        XmlServices.xslt(in, xsl, params, out, encoding, false, listener);
    }

    public static void xslt(String in, String xsl, String out) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        XmlServices.xslt(in, xsl, new HashMap<String, String>(), out, "UTF-8", false, null);
    }

    public static void xslt(String in, String xsl, String out, ErrorListener listener) throws IOException, SAXException, TransformerConfigurationException, TransformerException, UnsupportedEncodingException {
        XmlServices.xslt(in, xsl, new HashMap<String, String>(), out, "UTF-8", false, listener);
    }

    public static void relocateSrc(File file, File imgDir) throws IOException, SAXException, ParserConfigurationException {
        Document doc = XmlServices.loadDocument(file);
        ArrayList<Node> imgNodeList = XPathServices.getNodes(doc, "xhtml", "http://www.w3.org/1999/xhtml", "//xhtml:img");
        for (Node node : imgNodeList) {
            File fromFile;
            Element img = (Element)node;
            String srcAttr = img.getAttribute("src");
            if (srcAttr == null || srcAttr.trim().length() == 0) continue;
            if (srcAttr.startsWith("file:")) {
                URL srcUrl = new URL(srcAttr);
                fromFile = new File(srcUrl.getPath());
            } else {
                fromFile = new File(srcAttr);
            }
            if (!fromFile.exists()) {
                logger.warn((Object)("Image file doesn't exist: " + fromFile.getAbsolutePath()));
                continue;
            }
            String toFileName = FileServices.appendPath(imgDir, fromFile.getName());
            File toFile = FileServices.createUniqueFile(new File(toFileName));
            FileServices.copyFileToFile(fromFile, toFile);
            img.setAttribute("src", FileServices.relativePath(file, toFile));
        }
        NodeSerializer serializer = new NodeSerializer();
        serializer.write((Node)doc, file);
    }

    public static String printPath(Node node) {
        if (node == null) {
            return "Path: null";
        }
        StringBuilder buffer = new StringBuilder();
        for (Node parent = node; parent != null; parent = parent.getParentNode()) {
            buffer.insert(0, " -> ");
            buffer.insert(0, parent.getNodeName());
        }
        String text = buffer.toString();
        text = StringServices.cutPrefix(text, " -> ");
        return "Path: " + text;
    }

    static {
        System.setProperty("xml.catalog.ignoreMissing", "yes");
    }
}

