/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class XPathServices {
    private static Log logger = LogFactory.getLog(XPathServices.class);

    public static Object getValue(Object contextBean, String query) {
        return XPathServices.getValue(contextBean, null, null, query);
    }

    public static Object getValue(Object contextBean, String namespace, String namespaceUrl, String query) {
        Object obj = null;
        JXPathContext context = JXPathContext.newContext((Object)contextBean);
        if (namespace != null && namespaceUrl != null) {
            context.registerNamespace(namespace, namespaceUrl);
        }
        CompiledExpression expr = JXPathContext.compile((String)query);
        try {
            obj = expr.getValue(context);
        }
        catch (JXPathException oops) {
            logger.debug((Object)("JXPathException: " + oops.getMessage()));
            obj = null;
        }
        return obj;
    }

    public static ArrayList<String> getValues(Object contextBean, String query) {
        return XPathServices.getValues(contextBean, null, null, query);
    }

    public static ArrayList<String> getValues(Object contextBean, String namespace, String namespaceUrl, String query) {
        Object obj = null;
        JXPathContext context = JXPathContext.newContext((Object)contextBean);
        if (namespace != null && namespaceUrl != null) {
            context.registerNamespace(namespace, namespaceUrl);
        }
        CompiledExpression expr = JXPathContext.compile((String)query);
        ArrayList<String> list = new ArrayList<String>();
        try {
            Iterator iterator = expr.iterate(context);
            while (iterator.hasNext()) {
                obj = iterator.next();
                if (obj == null) continue;
                list.add(obj.toString());
            }
        }
        catch (JXPathException oops) {
            oops.printStackTrace();
        }
        return list;
    }

    public static ArrayList<Node> getNodes(Object contextBean, String query) {
        return XPathServices.getNodes(contextBean, null, null, query);
    }

    public static ArrayList<Node> getNodes(Object contextBean, String namespace, String namespaceUrl, String query) {
        JXPathContext context = JXPathContext.newContext((Object)contextBean);
        if (namespace != null && namespaceUrl != null) {
            context.registerNamespace(namespace, namespaceUrl);
        }
        List list = context.selectNodes(query);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (Object obj : list) {
            if (!(obj instanceof Node)) continue;
            nodeList.add((Node)obj);
        }
        return nodeList;
    }

    public static Node getNode(Object contextBean, String query) {
        return XPathServices.getNode(contextBean, null, null, query);
    }

    public static Node getNode(Object contextBean, String namespace, String namespaceUrl, String query) {
        ArrayList<Node> list = XPathServices.getNodes(contextBean, namespace, namespaceUrl, query);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

