/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dbdoclet.xiphias.XmlServices;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class W3cServices {
    public static Element getChildElement(Element parent, String childName) {
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent may not be null!");
        }
        if (childName == null) {
            throw new IllegalArgumentException("The argument childName may not be null!");
        }
        Element element = null;
        String nodeName = null;
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element) || (nodeName = (element = (Element)childNodes.item(i)).getNodeName()) == null || !nodeName.equals(childName)) continue;
            return element;
        }
        return null;
    }

    public static List<Element> getChildElements(Element parent, String childName) {
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent may not be null!");
        }
        if (childName == null) {
            throw new IllegalArgumentException("The argument childName may not be null!");
        }
        Element element = null;
        String nodeName = null;
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element) || (nodeName = (element = (Element)childNodes.item(i)).getNodeName()) == null || !nodeName.equals(childName)) continue;
            children.add(element);
        }
        return children;
    }

    public static Element[] getElementPath(Element elem) {
        if (elem == null) {
            throw new IllegalArgumentException("The argument elem must not be null!");
        }
        ArrayList<Node> elementList = new ArrayList<Node>();
        elementList.add(elem);
        for (Node parent = elem.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof Element)) continue;
            elementList.add(parent);
        }
        Collections.reverse(elementList);
        Element[] path = new Element[elementList.size()];
        for (int i = 0; i < elementList.size(); ++i) {
            path[i] = elem = (Element)elementList.get(i);
        }
        return path;
    }

    public static Element getFirstElement(Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent may not be null!");
        }
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            return (Element)childNodes.item(i);
        }
        return null;
    }

    public static void setText(Element parent, String text) {
        Document doc;
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent must not be null!");
        }
        NodeList childNodes = parent.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                parent.removeChild(childNode);
            }
        }
        if ((doc = parent.getOwnerDocument()) == null) {
            throw new NullPointerException("Owner document of element must not be null!");
        }
        Text textNode = doc.createTextNode(XmlServices.textToXml(text));
        parent.appendChild(textNode);
    }

    public static String getText(Node parent) {
        if (parent == null) {
            throw new IllegalArgumentException("The argument parent must not be null!");
        }
        String buffer = "";
        NodeList childNodes = parent.getChildNodes();
        if (childNodes == null || childNodes.getLength() == 0) {
            return buffer;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode instanceof Text) {
                Text textNode = (Text)childNode;
                buffer = buffer + textNode.getNodeValue();
                continue;
            }
            if (!(childNode instanceof Element)) continue;
            buffer = buffer + W3cServices.getText(childNode);
        }
        return buffer;
    }

    public static void insertElementAfter(Element newNode, Element refNode) {
        Node node;
        if (newNode == null) {
            throw new IllegalArgumentException("The argument newNode must not be null!");
        }
        if (refNode == null) {
            throw new IllegalArgumentException("The argument refNode must not be null!");
        }
        Element parentNode = (Element)refNode.getParentNode();
        if (parentNode == null) {
            throw new IllegalStateException("The parent node of the destination node must not be null!");
        }
        Element siblingNode = null;
        for (node = refNode.getNextSibling(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        if (node != null && node instanceof Element) {
            siblingNode = (Element)node;
        }
        if (siblingNode != null) {
            parentNode.insertBefore(newNode, siblingNode);
        } else {
            parentNode.appendChild(newNode);
        }
    }

    public static void setElementText(Element elem, String text) {
        Document doc;
        if (elem == null) {
            throw new IllegalArgumentException("The argument elem must not be null!");
        }
        if (text == null) {
            text = "";
        }
        if ((doc = elem.getOwnerDocument()) == null) {
            return;
        }
        if (elem.hasChildNodes()) {
            NodeList childNodes = elem.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                elem.removeChild(childNode);
            }
        }
        Text textNode = doc.createTextNode(text);
        elem.appendChild(textNode);
    }

    public static Node copyNode(Document doc, Node oNode) {
        if (doc == null) {
            throw new IllegalArgumentException("The argument doc must not be null!");
        }
        if (oNode == null) {
            throw new IllegalArgumentException("The argument oNode must not be null!");
        }
        Node nNode = null;
        switch (oNode.getNodeType()) {
            case 1: {
                nNode = doc.createElement(oNode.getNodeName());
                NamedNodeMap attrMap = oNode.getAttributes();
                for (int i = 0; i < attrMap.getLength(); ++i) {
                    Node attrNode = attrMap.item(i);
                    nNode.setAttribute(attrNode.getNodeName(), attrNode.getNodeValue());
                }
                break;
            }
            case 3: {
                nNode = doc.createTextNode(oNode.getNodeValue());
                break;
            }
            case 6: {
                nNode = doc.createTextNode(oNode.getNodeName());
                break;
            }
            case 5: {
                nNode = doc.createEntityReference(oNode.getNodeName());
                break;
            }
            case 8: {
                nNode = doc.createComment(oNode.getNodeValue());
                break;
            }
            case 4: {
                nNode = doc.createCDATASection(oNode.getNodeValue());
                break;
            }
            case 7: {
                nNode = doc.createProcessingInstruction(oNode.getNodeName(), oNode.getNodeValue());
            }
        }
        if (nNode == null) {
            return null;
        }
        NodeList childNodes = oNode.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node nChild;
                short nodeType = childNodes.item(i).getNodeType();
                if (nodeType == 2 || (nChild = W3cServices.copyNode(doc, childNodes.item(i))) == null) continue;
                nNode.appendChild(nChild);
            }
        }
        return nNode;
    }

    public static String getAttributesAsText(Element elem) {
        String buffer = "";
        NamedNodeMap attributes = elem.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                buffer = buffer + " " + attr.getNodeName() + "=\"" + XmlServices.textToXml(attr.getNodeValue()) + "\"";
            }
        }
        return buffer;
    }

    public static void setAttribute(Node node, String attr, String namespace) {
        if (node instanceof Element) {
            Element elem = (Element)node;
            elem.setAttribute(attr, namespace);
        }
    }

    public static boolean hasNamespace(Element element, String namespace) {
        NamedNodeMap attrMap = element.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node item = attrMap.item(i);
            if (item.getNodeName() == null || !item.getNodeName().startsWith("xmlns") || !namespace.equals(item.getNodeValue())) continue;
            return true;
        }
        return false;
    }

    public static void copyNamespaces(Element documentElement, Element element) {
        NamedNodeMap attrMap = documentElement.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node item = attrMap.item(i);
            if (item.getNodeName() == null || !item.getNodeName().startsWith("xmlns")) continue;
            element.setAttribute(item.getNodeName(), item.getNodeValue());
        }
    }
}

