/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.StringServices;

public class UrlServices {
    private static Log logger = LogFactory.getLog((String)UrlServices.class.getName());
    public static final String USEP = "/";
    public static final String PROTOCOL_SEPARATOR = "://";

    public static String appendPath(URL url, String path) {
        return UrlServices.appendPath(url.toString(), path, false);
    }

    public static String appendPath(String url, String path) {
        return UrlServices.appendPath(url, path, false);
    }

    public static String appendPath(String url, String path, boolean endsWithSep) {
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException("The argument url must not be null!");
        }
        if (path == null || path.length() == 0) {
            throw new IllegalStateException("The field path must not be null!");
        }
        if (!url.endsWith(USEP)) {
            url = url + USEP;
        }
        if (path.startsWith(USEP) && path.length() > USEP.length()) {
            path = path.substring(USEP.length());
        }
        if (endsWithSep && !path.endsWith(USEP)) {
            path = path + USEP;
        }
        return url + path;
    }

    public static String getProtocol(String url) {
        String protocol = "";
        if (url == null || url.trim().length() == 0) {
            return protocol;
        }
        try {
            URL jnu = new URL(url);
            return jnu.getProtocol();
        }
        catch (MalformedURLException jnu) {
            int index = url.indexOf(PROTOCOL_SEPARATOR);
            if (index != -1) {
                return url.substring(0, index);
            }
            return "";
        }
    }

    public static String getPath(String url) {
        String path = "";
        if (url == null || url.trim().length() == 0) {
            return path;
        }
        try {
            URL jnu = new URL(url);
            return jnu.getPath();
        }
        catch (MalformedURLException jnu) {
            if (url.startsWith("cocs://")) {
                logger.debug((Object)("URL(cocs://)=" + url));
                path = StringServices.cutPrefix(url, "cocs://");
                int index = path.indexOf(63);
                if (index != -1) {
                    path = path.substring(0, index);
                }
                return path;
            }
            return path;
        }
    }

    public static String getQuery(String url) {
        String query = "";
        if (url == null || url.trim().length() == 0) {
            return query;
        }
        try {
            URL jnu = new URL(url);
            return jnu.getQuery();
        }
        catch (MalformedURLException jnu) {
            if (url.startsWith("cocs://")) {
                logger.debug((Object)("URL(cocs://)=" + url));
                int index = url.indexOf(63);
                if (index != -1) {
                    query = url.substring(index);
                    query = StringServices.cutPrefix(query, "?");
                }
                return query;
            }
            return query;
        }
    }

    public static String getParameter(String url, String key) {
        String param = "";
        if (url == null || url.trim().length() == 0) {
            return param;
        }
        if (key == null || key.trim().length() == 0) {
            return param;
        }
        String query = UrlServices.getQuery(url);
        query = StringServices.cutPrefix(query, "?");
        String[] paramList = query.split("&");
        for (int i = 0; i < paramList.length; ++i) {
            String[] token = paramList[i].split("=");
            if (token.length != 2 || !token[0].equals(key)) continue;
            param = token[1];
            break;
        }
        return param;
    }

    public static String getName(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        while (url.endsWith(USEP) && url.length() > 0) {
            url = StringServices.chop(url, USEP);
        }
        int index = url.lastIndexOf(USEP);
        if (index == -1) {
            return url;
        }
        return url.substring(index + 1);
    }

    public static String getParent(String url) {
        if (url == null || url.length() == 0 || url.equals(USEP)) {
            return url;
        }
        while (url.endsWith(USEP) && url.length() > 0) {
            url = StringServices.chop(url, USEP);
        }
        int index = url.lastIndexOf(USEP);
        if (index == -1) {
            return url;
        }
        return url.substring(0, index);
    }

    public static String getLastPart(String url) {
        if (url == null || url.length() == 0 || url.equals(USEP)) {
            return url;
        }
        int index = url.endsWith(USEP) && url.length() > 1 ? url.lastIndexOf(USEP, url.length() - 2) : url.lastIndexOf(USEP);
        if (index == -1) {
            return url;
        }
        if (index < url.length() - 2) {
            return url.substring(index + 1);
        }
        return url;
    }

    public static String normalize(URL url) {
        return UrlServices.normalize(url.toString());
    }

    public static String normalize(String url) {
        if (url == null || url.length() == 0 || url.equals(USEP)) {
            return url;
        }
        url = StringServices.chop(url, USEP);
        url = url.toLowerCase();
        return url;
    }

    public static String normalizePath(String path) {
        if (path == null || path.length() == 0 || path.equals(USEP)) {
            return path;
        }
        path = StringServices.chop(path, USEP);
        path = path.toLowerCase();
        return path;
    }
}

