/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class SaxErrorHandler
implements ErrorHandler {
    private static Log logger = LogFactory.getLog((String)"sax");
    private static String fatalPrefix = "[XML Parser FATAL] ";
    private static String errorPrefix = "[XML Parser ERROR] ";
    private static String warnPrefix = "[XML Parser WARN ] ";
    private boolean first = true;
    private int errors = 0;
    private File source;

    public SaxErrorHandler(File source) {
        if (source == null) {
            throw new IllegalArgumentException("The argument source may not be null!");
        }
        this.source = source;
    }

    public int getNumOfErrors() {
        return this.errors;
    }

    @Override
    public void error(SAXParseException oops) {
        if (this.first) {
            this.printHeader();
            this.first = false;
        }
        ++this.errors;
        this.print(errorPrefix, oops);
    }

    @Override
    public void fatalError(SAXParseException oops) {
        if (this.first) {
            this.printHeader();
            this.first = false;
        }
        this.print(fatalPrefix, oops);
    }

    @Override
    public void warning(SAXParseException oops) {
        if (this.first) {
            this.printHeader();
            this.first = false;
        }
        this.print(warnPrefix, oops);
    }

    private void printHeader() {
        System.err.println("\nValidation Error(s):");
        System.err.println("Source: " + this.source.getAbsolutePath());
    }

    private void print(String prefix, SAXParseException oops) {
        String line = prefix + " " + this.source.getAbsolutePath() + ":" + oops.getLineNumber() + "," + oops.getColumnNumber() + " " + oops.getMessage();
        System.err.println(line);
        if (line.startsWith(fatalPrefix)) {
            logger.fatal((Object)line);
        }
        if (line.startsWith(errorPrefix)) {
            logger.error((Object)line);
        }
        if (line.startsWith(warnPrefix)) {
            logger.warn((Object)line);
        }
    }
}

