/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dbdoclet.xiphias.XmlValidationResult;

public class RngServices {
    public static XmlValidationResult validate(File xmlFile, File schemaFile) throws FileNotFoundException {
        if (schemaFile == null) {
            throw new IllegalArgumentException("The argument schemaFile must not be null!");
        }
        File[] schemaFiles = new File[]{schemaFile};
        return RngServices.validate(xmlFile, schemaFiles);
    }

    public static XmlValidationResult validate(File xmlFile, File[] schemaFiles) throws FileNotFoundException {
        if (xmlFile == null) {
            throw new IllegalArgumentException("The argument xmlFile must not be null!");
        }
        if (schemaFiles == null) {
            throw new IllegalArgumentException("The argument schemaFiles must not be null!");
        }
        if (!xmlFile.exists()) {
            throw new FileNotFoundException(xmlFile.getAbsolutePath());
        }
        Source[] schemaSources = new Source[schemaFiles.length];
        for (int i = 0; i < schemaFiles.length; ++i) {
            if (!schemaFiles[i].exists()) {
                throw new FileNotFoundException(schemaFiles[i].getAbsolutePath());
            }
            schemaSources[i] = new StreamSource(schemaFiles[i]);
        }
        StreamSource xml = new StreamSource(xmlFile);
        return RngServices.validate((Source)xml, schemaSources);
    }

    public static XmlValidationResult validate(Source xmlSource, Source schemaSource) {
        Source[] schemaSources = new Source[]{schemaSource};
        return RngServices.validate(xmlSource, schemaSources);
    }

    public static XmlValidationResult validate(Source xmlSource, Source[] schemaSources) {
        if (xmlSource == null) {
            throw new IllegalArgumentException("The argument xmlSource must not be null!");
        }
        if (schemaSources == null) {
            throw new IllegalArgumentException("The argument schemaSources must not be null!");
        }
        XmlValidationResult result = new XmlValidationResult(xmlSource.getSystemId());
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
            Schema schema = factory.newSchema(schemaSources);
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (Exception oops) {
            result.setThrowable(oops);
        }
        return result;
    }
}

