/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.Sfv;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.xiphias.W3cServices;
import org.dbdoclet.xiphias.XmlServices;
import org.dbdoclet.xiphias.dom.DocumentImpl;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class NodeSerializer {
    private static final String INDENT = "  ";
    private static Log logger = LogFactory.getLog(NodeSerializer.class);
    private HashMap<String, Integer> chunkElementSet = new HashMap();
    private HashMap<Node, Writer> chunkOutMap = new HashMap();
    private Stack<Integer> chunkElementStack = new Stack();
    private ArrayList<ProgressListener> listeners;
    private int literalContext = 0;
    private String encoding = "UTF-8";
    private File systemId;
    private Element documentElement;
    private boolean validation = false;
    private boolean indentation = true;

    private Writer addChunk(String indent, Node node, Writer out) throws IOException {
        if (this.systemId == null) {
            return out;
        }
        File baseDir = this.systemId.getParentFile();
        String tagName = node.getNodeName();
        int maxDepth = this.chunkElementSet.get(tagName);
        int depth = this.getDepth(node);
        if (depth > maxDepth) {
            return out;
        }
        int pos = this.getChunkIndex(node);
        this.chunkElementStack.push(new Integer(pos));
        String fileName = "";
        for (Integer i : this.chunkElementStack) {
            if (fileName.equals("")) {
                fileName = String.valueOf(i);
                continue;
            }
            fileName = String.format("%s.%d", fileName, i);
        }
        fileName = String.format("%s-%s.xml", tagName, fileName);
        File incFile = new File(baseDir, fileName);
        logger.debug((Object)String.format("Creating chunk file %s", fileName));
        out.write(indent + "<xi:include href=\"" + XmlServices.textToXml(fileName) + "\"/>" + Sfv.LSEP);
        out = new OutputStreamWriter((OutputStream)new FileOutputStream(incFile), this.encoding);
        this.writeXmlDeclaration(out);
        if (node instanceof Element) {
            String lang;
            String version;
            Element element = (Element)node;
            if (this.documentElement != null) {
                W3cServices.copyNamespaces(this.documentElement, element);
            }
            if ((version = this.documentElement.getAttribute("version")) != null) {
                element.setAttribute("version", version);
            }
            if ((lang = this.documentElement.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang")) != null) {
                element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
            }
            if (!W3cServices.hasNamespace(element, "http://www.w3.org/2001/XInclude")) {
                W3cServices.setAttribute(node, "xmlns:xi", "http://www.w3.org/2001/XInclude");
            }
        }
        this.chunkOutMap.put(node, out);
        return out;
    }

    private int getChunkIndex(Node node) {
        Node parentNode = node.getParentNode();
        if (parentNode == null) {
            return 0;
        }
        NodeList childList = parentNode.getChildNodes();
        int pos = 0;
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (this.chunkElementSet.get(child.getNodeName()) != null) {
                ++pos;
            }
            if (child == node) break;
        }
        return pos;
    }

    private int getDepth(Node node) {
        int depth = 0;
        String tagName = node.getNodeName();
        if (tagName == null) {
            return depth;
        }
        for (Node parentNode = node; parentNode != null; parentNode = parentNode.getParentNode()) {
            if (!tagName.equals(parentNode.getNodeName())) continue;
            ++depth;
        }
        return depth;
    }

    public void addChunkElement(String nodeName) {
        this.addChunkElement(nodeName, 1);
    }

    public void addChunkElement(String nodeName, int depth) {
        this.chunkElementSet.put(nodeName, depth);
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void addProgressListeners(ArrayList<ProgressListener> newListeners) {
        if (newListeners == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.addAll(newListeners);
    }

    private void fireProgressEvent(ProgressEvent event) {
        if (this.listeners != null) {
            for (ProgressListener listener : this.listeners) {
                listener.progress(event);
            }
        }
    }

    private boolean isInsideLiteralElement() {
        return this.literalContext > 0;
    }

    protected boolean isInsideLiteralElement(Text text) {
        Node parent = text.getParentNode();
        while (parent != null) {
            ElementImpl elem;
            if (!(parent instanceof ElementImpl) || !(elem = (ElementImpl)parent).isLiteral()) continue;
            return true;
        }
        return false;
    }

    private String resolveEntityReference(String entityName) {
        if (entityName == null) {
            return null;
        }
        if (entityName.equals("linefeed")) {
            return "#x0A";
        }
        return entityName;
    }

    public void setProgressListeners(ArrayList<ProgressListener> listeners) {
        this.listeners = listeners;
    }

    public String toXML(Node node) {
        try {
            StringWriter buffer = new StringWriter();
            NodeSerializer serializer = new NodeSerializer();
            serializer.write(node, buffer);
            return buffer.toString();
        }
        catch (IOException oops) {
            return oops.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Node node, File file) throws IOException {
        if (node == null) {
            throw new IllegalArgumentException("The argument node must not be null!");
        }
        if (file == null) {
            throw new IllegalArgumentException("The argument file must not be null!");
        }
        FileOutputStream fos = null;
        OutputStreamWriter out = null;
        try {
            this.systemId = file;
            fos = new FileOutputStream(file);
            out = new OutputStreamWriter((OutputStream)fos, this.encoding);
            this.write(node, out, "");
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.systemId = null;
            this.encoding = "UTF-8";
            this.documentElement = null;
        }
    }

    public void write(Node node, OutputStream out) throws IOException {
        this.write(node, new OutputStreamWriter(out));
    }

    public void write(Node node, Writer out) throws IOException {
        this.write(node, out, "");
    }

    public void write(Node node, Writer out, boolean inMixedContent, String indent) throws IOException {
        if (node == null) {
            throw new IllegalArgumentException("The argument node must not be null!");
        }
        if (out == null) {
            throw new IllegalArgumentException("The argument out must not be null!");
        }
        ProgressEvent event = new ProgressEvent(node.toString());
        this.fireProgressEvent(event);
        if (this.isValidationEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(node.getNodeName());
            for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                buffer.insert(0, parent.getNodeName() + " -> ");
                if (parent != node) continue;
                logger.fatal((Object)String.format("Endless self referncing loop ! %s", buffer.toString()));
                return;
            }
        }
        if (this.chunkElementSet.get(node.getNodeName()) != null) {
            out = this.addChunk(indent, node, out);
            indent = "";
        }
        switch (node.getNodeType()) {
            case 11: {
                this.writeFragmentNode(node, out);
                break;
            }
            case 9: {
                this.writeDocumentNode(node, out);
                break;
            }
            case 10: {
                this.writeDocumentTypeNode((DocumentType)node, out);
                break;
            }
            case 6: {
                this.writeEntityNode(node, out);
                break;
            }
            case 5: {
                this.writeEntityReferenceNode(node, out);
                break;
            }
            case 1: {
                try {
                    this.writeElementNode(node, out, inMixedContent, indent);
                }
                catch (StackOverflowError oops) {
                    logger.fatal((Object)("[NodeSerializer.write] StackOverflowError. Self referencing recursive structure detected!!! Node: " + node.toString()));
                }
                break;
            }
            case 3: {
                this.writeTextNode(node, out);
                break;
            }
            case 4: {
                this.writeDataSectionNode(node, out);
                break;
            }
            case 8: {
                this.writeCommentNode(node, out, indent);
                break;
            }
            case 7: {
                this.writeProcessingInstructionNode(node, out, indent);
            }
        }
        this.closeChunk(node);
    }

    private void closeChunk(Node node) throws IOException {
        Writer out = this.chunkOutMap.get(node);
        if (out != null) {
            logger.debug((Object)String.format("Closing chunk for Node %s:%s", node.getNodeName(), node.hashCode()));
            out.close();
            if (!this.chunkElementStack.empty()) {
                this.chunkElementStack.pop();
            }
        }
    }

    public void write(Node node, Writer out, String indent) throws IOException {
        this.write(node, out, false, indent);
    }

    private void writeCommentNode(Node node, Writer out, String indent) throws IOException {
        Comment comment = (Comment)node;
        out.write(indent + "<!--" + comment.getData() + "-->");
        out.write(Sfv.LSEP);
    }

    private void writeDataSectionNode(Node node, Writer out) throws IOException {
        CDATASection cdata = (CDATASection)node;
        out.write("<![CDATA[" + cdata.getData() + "]]>");
    }

    private void writeDocumentNode(Node node, Writer out) throws IOException {
        Document tdoc = (Document)node;
        Element documentElement = tdoc.getDocumentElement();
        if (documentElement != null) {
            this.documentElement = documentElement;
            if (tdoc instanceof DocumentImpl) {
                out.write(((DocumentImpl)tdoc).createXmlDeclaration());
            } else {
                this.writeXmlDeclaration(out);
            }
            DocumentType docType = tdoc.getDoctype();
            if (docType != null) {
                this.writeDocumentTypeNode(docType, out);
            }
            if (!W3cServices.hasNamespace(documentElement, "http://www.w3.org/2001/XInclude")) {
                documentElement.setAttribute("xmlns:xi", "http://www.w3.org/2001/XInclude");
            }
            this.write(documentElement, out, "");
        } else {
            NodeList children = tdoc.getChildNodes();
            if (children != null && children.getLength() != 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    this.write(children.item(i), out, "");
                    out.write(Sfv.LSEP);
                }
            }
        }
    }

    private void writeXmlDeclaration(Writer out) throws IOException {
        out.write("<?xml version='1.0' encoding='" + this.encoding + "'?>" + Sfv.LSEP);
    }

    public void writeDocumentTypeNode(DocumentType docType, Writer out) throws IOException {
        out.write("<!DOCTYPE " + docType.getName());
        if (docType.getPublicId() != null && docType.getPublicId().trim().length() > 0) {
            out.write(" PUBLIC '" + docType.getPublicId() + "'");
        } else {
            out.write(" SYSTEM");
        }
        out.write(" '" + docType.getSystemId() + "'");
        NamedNodeMap entityMap = docType.getEntities();
        if (entityMap != null && entityMap.getLength() > 0) {
            out.write("[" + Sfv.LSEP);
            for (int i = 0; i < entityMap.getLength(); ++i) {
                Entity entity = (Entity)entityMap.item(i);
                out.write("<!ENTITY " + entity.getNodeName() + " SYSTEM \"" + entity.getSystemId() + "\">" + Sfv.LSEP);
            }
            out.write("]");
        }
        out.write(">");
        out.write(Sfv.LSEP);
    }

    private void writeElementNode(Node node, Writer out, boolean inMixedContent, String indent) throws IOException {
        Element elem = (Element)node;
        String name = elem.getNodeName();
        ElementImpl elemImpl = null;
        if (elem instanceof ElementImpl) {
            elemImpl = (ElementImpl)elem;
        }
        if (!inMixedContent) {
            out.write(indent);
            out.write(60);
            out.write(name);
        } else {
            out.write(60);
            out.write(name);
        }
        if (elemImpl != null) {
            String attributesAsText = elemImpl.getAttributesAsText();
            if (attributesAsText != null && attributesAsText.length() > 0) {
                out.write(32);
                out.write(attributesAsText);
            }
            if (elemImpl.isLiteral()) {
                ++this.literalContext;
            }
        } else {
            out.write(W3cServices.getAttributesAsText(elem));
        }
        NodeList children = elem.getChildNodes();
        if (children != null && children.getLength() != 0) {
            int i;
            out.write(">");
            boolean hasMixedContent = false;
            for (i = 0; i < children.getLength(); ++i) {
                String buffer;
                Node child = children.item(i);
                if (child.getNodeType() == 5) {
                    hasMixedContent = true;
                }
                if (child.getNodeType() != 3 || (buffer = child.getTextContent()) == null || buffer.trim().length() <= 0) continue;
                hasMixedContent = true;
            }
            if (elemImpl != null && elemImpl.getFormatType() != 3) {
                hasMixedContent = true;
            }
            if (!hasMixedContent) {
                out.write(Sfv.LSEP);
            }
            for (i = 0; i < children.getLength(); ++i) {
                if (this.isIndentationEnabled()) {
                    this.write(children.item(i), out, hasMixedContent, indent + INDENT);
                    continue;
                }
                this.write(children.item(i), out, hasMixedContent, "");
            }
            if (!hasMixedContent) {
                out.write(indent + "</" + name + ">");
                out.write(Sfv.LSEP);
            } else {
                out.write("</" + name + ">");
                if (!inMixedContent) {
                    out.write(Sfv.LSEP);
                }
            }
        } else {
            out.write("/>");
            if (!(inMixedContent || elemImpl != null && elemImpl.getFormatType() == 1)) {
                out.write(Sfv.LSEP);
            }
        }
        if (elemImpl != null && elemImpl.isLiteral()) {
            --this.literalContext;
        }
    }

    private void writeEntityNode(Node node, Writer out) throws IOException {
        Entity entity = (Entity)node;
        out.write("&" + entity.getNodeName() + ";");
    }

    private void writeEntityReferenceNode(Node node, Writer out) throws IOException {
        EntityReference entityReference = (EntityReference)node;
        out.write("&" + this.resolveEntityReference(entityReference.getNodeName()) + ";");
    }

    private void writeFragmentNode(Node node, Writer out) throws IOException {
        NodeList nodes = node.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                this.write(nodes.item(i), out, "");
            }
        }
    }

    private void writeProcessingInstructionNode(Node node, Writer out, String indent) throws IOException {
        ProcessingInstruction pi = (ProcessingInstruction)node;
        out.write(indent + "<?" + pi.getTarget() + " " + pi.getData() + "?>");
        out.write(Sfv.LSEP);
    }

    private void writeTextNode(Node node, Writer out) throws IOException {
        Text text = (Text)node;
        String data = text.getData();
        if (data != null && !this.isInsideLiteralElement()) {
            data = XmlServices.normalizeText(data);
        }
        if (text instanceof TextImpl) {
            if (((TextImpl)text).isRawData()) {
                out.write(data);
            } else {
                out.write(XmlServices.textToXml(data));
            }
        } else {
            out.write(XmlServices.textToXml(data));
        }
    }

    public void setSystemId(File systemId) {
        this.systemId = systemId;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setValidationEnabled(boolean validation) {
        this.validation = validation;
    }

    public boolean isValidationEnabled() {
        return this.validation;
    }

    public void setIndentationEnabled(boolean indentation) {
        this.indentation = indentation;
    }

    public boolean isIndentationEnabled() {
        return this.indentation;
    }
}

