/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.dbdoclet.Sfv;
import org.dbdoclet.service.FileServices;

public class ImageServices {
    private static Log logger = LogFactory.getLog(ImageServices.class);
    public static double A4_WIDTH = 210.0;
    public static double A4_HEIGHT = 297.0;
    public static double INCH = 25.4;
    public static int DPI = 72;

    public static int getWidth(File imageFile) {
        if (imageFile == null) {
            throw new IllegalArgumentException("The argument imageFile must not be null!");
        }
        try {
            ImageIcon image = new ImageIcon(imageFile.toURI().toURL());
            return image.getIconWidth();
        }
        catch (Throwable oops) {
            logger.fatal((Object)"ImageServices.getWidth", oops);
            return 100;
        }
    }

    public static int getHeight(File imageFile) {
        if (imageFile == null) {
            throw new IllegalArgumentException("The argument imageFile must not be null!");
        }
        try {
            ImageIcon image = new ImageIcon(imageFile.toURI().toURL());
            return image.getIconHeight();
        }
        catch (Throwable oops) {
            logger.fatal((Object)"ImageServices.getWidth", oops);
            return 100;
        }
    }

    public static File giftopng(File gifFile) throws IOException {
        if (gifFile == null) {
            throw new IllegalArgumentException("The argument gifFile must not be null!");
        }
        String pngPath = FileServices.getFileBase(gifFile) + ".png";
        File pngFile = new File(pngPath);
        return ImageServices.giftopng(gifFile, pngFile);
    }

    public static File giftopng(File gifFile, File pngFile) throws IOException {
        if (gifFile == null) {
            throw new IllegalArgumentException("The argument gifFile must not be null!");
        }
        if (pngFile == null) {
            throw new IllegalArgumentException("The argument pngFile must not be null!");
        }
        BufferedImage image = ImageIO.read(gifFile);
        ImageIO.write((RenderedImage)image, "png", pngFile);
        return pngFile;
    }

    public static String toBase64(File inFile) throws IOException {
        if (inFile == null) {
            throw new IllegalArgumentException("The argument inFile  must not be null!");
        }
        if (!inFile.exists()) {
            throw new IllegalArgumentException("The argument inFile must exist!");
        }
        byte[] enc = Base64.encodeBase64((byte[])FileServices.readToByteArray(inFile));
        return new String(enc, "UTF-8");
    }

    public static String toXml(File inFile) throws IOException {
        String xml = ImageServices.toBase64(inFile);
        xml = "<?xml version='1.0' encoding='UTF-8'?>" + Sfv.LSEP + "<image file=\"" + inFile.getCanonicalPath() + "\">" + xml + "</image>" + Sfv.LSEP;
        return xml;
    }

    public static void toEps(File inFile, File epsFile) throws IOException {
        if (inFile == null) {
            throw new IllegalArgumentException("The argument inFile must not be null!");
        }
        if (epsFile == null) {
            throw new IllegalArgumentException("The argument epsFile must not be null!");
        }
        String format = FileServices.getExtension(inFile.getName());
        if (!((format = format.toLowerCase()).equals("gif") || format.equals("jpg") || format.equals("png") || format.equals("bmp"))) {
            throw new IllegalArgumentException("UnsupportedFormat " + format + "!");
        }
        if (!inFile.exists()) {
            throw new FileNotFoundException("No such file : " + inFile.getAbsolutePath());
        }
        if (!inFile.canRead()) {
            throw new IOException("File is not readable: " + inFile.getAbsolutePath());
        }
        BufferedImage image = ImageIO.read(inFile);
        EPSDocumentGraphics2D graphics = new EPSDocumentGraphics2D(false);
        graphics.setGraphicContext(new GraphicContext());
        FileOutputStream out = new FileOutputStream(epsFile);
        int maxWidth = (int)(A4_WIDTH * 0.95 / INCH) * DPI;
        if (image.getWidth() > maxWidth) {
            double ratio = (double)image.getHeight() / (double)image.getWidth();
            int newHeight = (int)(ratio * (double)maxWidth);
            image = ImageServices.toBufferedImage(image.getScaledInstance(maxWidth, newHeight, 4));
        }
        graphics.setupDocument((OutputStream)out, image.getWidth(null), image.getHeight(null));
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.finish();
    }

    public static boolean scale(File imageFile, int maxWidth) throws IOException {
        if (imageFile == null) {
            throw new IllegalArgumentException("The argument imageFile must not be null!");
        }
        if (maxWidth < 1) {
            throw new IllegalArgumentException("The argument maxWidth must not be less than 1!");
        }
        String format = FileServices.getExtension(imageFile.getName());
        BufferedImage image = ImageIO.read(imageFile);
        logger.debug((Object)("Bild = " + imageFile.getName()));
        int width = image.getWidth();
        logger.debug((Object)("Bildbreite = " + width));
        int height = image.getHeight();
        logger.debug((Object)("Bildh\u00f6he = " + height));
        if (width > maxWidth) {
            float factor = (float)maxWidth / (float)width;
            logger.debug((Object)("Skalierungsfaktor = " + factor));
            height = (int)((float)height * factor);
            width = maxWidth;
            Image scaledImage = image.getScaledInstance(width, height, 4);
            BufferedImage scaledBufferedImage = new BufferedImage(width, height, 1);
            Graphics graphics = scaledBufferedImage.getGraphics();
            graphics.drawImage(scaledImage, 0, 0, null);
            ImageIO.write((RenderedImage)scaledBufferedImage, format, imageFile);
            return true;
        }
        return false;
    }

    public static ImageIcon getScaledIcon(ImageIcon icon, int width, int height) {
        if (height < 1 && width < 1) {
            throw new IllegalArgumentException("Both arguments height and width must not be smaller than 1!");
        }
        int iconHeight = icon.getIconHeight();
        int iconWidth = icon.getIconWidth();
        if (iconHeight < 1 && iconWidth < 1) {
            return icon;
        }
        if (width < 1 && (width = height * iconWidth / iconHeight) < 1) {
            width = 1;
        }
        if (height < 1 && (height = width * iconHeight / iconWidth) < 1) {
            height = 1;
        }
        Image image = icon.getImage().getScaledInstance(width, height, 4);
        icon.setImage(image);
        return icon;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("The argument image must not be null!");
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageServices.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            logger.error((Object)"headless exception creating buffered image", (Throwable)e);
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException oops) {
            oops.printStackTrace();
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }
}

