/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Hyphenation {
    public HyphenationChar hyphenationChar = HyphenationChar.SOFT_HYPHEN;

    public HyphenationChar getHyphenationChar() {
        return this.hyphenationChar;
    }

    public String hyphenateAfter(String text, HyphenationChar hyphenChar, String ... tokens) {
        if (text == null || text.length() == 0) {
            return text;
        }
        if (tokens == null || tokens.length == 0) {
            return text;
        }
        String wrapable = text;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token == null || token.length() == 0) continue;
            Pattern pattern = Pattern.compile("(\\S" + token + ")(\\S)");
            Matcher matcher = pattern.matcher(wrapable);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(buffer, matcher.group(1) + this.hyphenationChar.getEntity() + matcher.group(2));
            }
            matcher.appendTail(buffer);
            wrapable = buffer.toString();
        }
        return wrapable;
    }

    public String hyphenateAfter(String buffer, String ... tokens) {
        return this.hyphenateAfter(buffer, this.hyphenationChar, tokens);
    }

    public String hyphenateCamelCase(String text) {
        StringBuilder buffer = new StringBuilder();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (buffer.length() > 0 && Character.isUpperCase(c.charValue())) {
                buffer.append(this.hyphenationChar.getEntity());
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public void setHyphenationChar(HyphenationChar hyphenationChar) {
        this.hyphenationChar = hyphenationChar;
    }

    public static enum HyphenationChar {
        SOFT_HYPHEN("&#x00ad;"),
        ZERO_WIDTH_SPACE("&#x200b;");

        public String entity;

        private HyphenationChar(String entity) {
            this.entity = entity;
        }

        public String getEntity() {
            return this.entity;
        }
    }
}

