/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.xiphias;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.xiphias.ImageServices;
import org.dbdoclet.xiphias.NodeSerializer;
import org.dbdoclet.xiphias.W3cServices;
import org.dbdoclet.xiphias.XPathServices;
import org.dbdoclet.xiphias.XmlServices;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DInc {
    private static Log logger = LogFactory.getLog(DInc.class);
    private String includeMsg = "Including file {0}";
    private String relocateMsg = "Relocating file {0}";
    private String compPath;
    private ArrayList<String> midList;
    private final ProgressListener listener;

    public DInc(ProgressListener listener) {
        this.listener = listener;
    }

    public DInc() {
        this(null);
    }

    public void setIncludeMsg(String includeMsg) {
        this.includeMsg = includeMsg;
    }

    public String getIncludeMsg() {
        return this.includeMsg;
    }

    public void setRelocateMsg(String relocateMsg) {
        this.relocateMsg = relocateMsg;
    }

    public String getRelocateMsg() {
        return this.relocateMsg;
    }

    public void setCompPath(String compPath) {
        this.compPath = compPath;
    }

    public void merge(File xmlFile, File xmlBase, String sectionNode) throws IOException, SAXException, ParserConfigurationException {
        if (xmlFile == null) {
            throw new IllegalArgumentException("The argument xmlFile must not be null!");
        }
        String path = xmlFile.getCanonicalPath();
        File xmlFileDir = new File(path);
        xmlFileDir = xmlFileDir.getParentFile();
        if (xmlBase == null || xmlBase.equals("")) {
            xmlBase = xmlFileDir;
        }
        if (sectionNode == null || sectionNode.equals("")) {
            sectionNode = "//sect1";
        }
        logger.debug((Object)("Mergin the xml file '" + xmlFile.getCanonicalPath() + "'..."));
        Document doc = XmlServices.parse(xmlFile, false);
        ArrayList<Node> dincList = XPathServices.getNodes(doc, "dodo", "http://www.dbdoclet.org/xml/ns/dodo", "//dodo:include");
        logger.debug((Object)("Number of dodo:include elements " + dincList.size() + "."));
        path = FileServices.appendPath(xmlFileDir, "data");
        FileServices.delete(path);
        FileServices.createPath(path);
        File dataDir = new File(path);
        Iterator<Node> iterator = dincList.iterator();
        this.midList = new ArrayList();
        while (iterator.hasNext()) {
            Node obj = iterator.next();
            if (!(obj instanceof Element)) continue;
            Element elem = (Element)obj;
            Element parent = (Element)elem.getParentNode();
            String fileName = W3cServices.getText(elem);
            fileName = FileServices.appendFileName(xmlBase, fileName);
            File file = new File(fileName);
            fileName = file.getCanonicalPath();
            if (!(file = new File(fileName)).exists()) {
                logger.warn((Object)("The file " + fileName + " doesn't exist."));
                parent.removeChild(elem);
                continue;
            }
            logger.debug((Object)("including the file " + fileName));
            this.fireProgressEvent(fileName, this.includeMsg);
            Document incDoc = XmlServices.parse(file);
            ArrayList<Node> childList = XPathServices.getNodes(incDoc, sectionNode);
            Collections.reverse(childList);
            if (childList.size() > 0) {
                Node refChild = W3cServices.copyNode(doc, childList.get(0));
                this.relocateImages(dataDir, file.getParentFile(), refChild);
                this.checkMids(refChild);
                parent.replaceChild(refChild, elem);
                for (int i = 1; i < childList.size(); ++i) {
                    Node newChild = W3cServices.copyNode(doc, childList.get(i));
                    this.relocateImages(dataDir, file.getParentFile(), newChild);
                    this.checkMids(newChild);
                    parent.insertBefore(newChild, refChild);
                    refChild = newChild;
                }
                continue;
            }
            parent.removeChild(elem);
        }
        NodeSerializer serializer = new NodeSerializer();
        serializer.setEncoding("UTF-8");
        serializer.write((Node)doc, xmlFile);
    }

    private void checkMids(Node node) {
        ArrayList<Node> idAttrList = XPathServices.getNodes(node, "//@xml:id");
        for (Node idObj : idAttrList) {
            if (!(idObj instanceof Attr)) continue;
            Attr idAttr = (Attr)idObj;
            String mid = idAttr.getValue();
            if (this.midList.contains(mid)) {
                int ind = 0;
                while (this.midList.contains(mid + "_" + ind)) {
                    ++ind;
                }
                idAttr.setValue(mid + "_" + ind);
                this.midList.add(mid + "_" + ind);
                continue;
            }
            this.midList.add(mid);
        }
    }

    private void relocateImages(File destDir, File xmlBase, Node node) throws IOException {
        if (destDir == null) {
            throw new IllegalArgumentException("The argument dataDir must not be null!");
        }
        if (xmlBase == null) {
            throw new IllegalArgumentException("The argument xmlBase must not be null!");
        }
        ArrayList<Node> srcList = XPathServices.getNodes(node, "//imgdata");
        logger.debug((Object)("Number of elements with attribute fileref " + srcList.size() + "."));
        for (Node imgDataNode : srcList) {
            String path;
            Element imgData = (Element)imgDataNode;
            if (!imgData.hasAttribute("fileref")) continue;
            String fileref = imgData.getAttribute("fileref");
            if (fileref.startsWith("../")) {
                fileref = fileref.substring(3);
            }
            String srcFileName = xmlBase.getParentFile() + "/" + fileref;
            srcFileName = FileServices.correctPathSeperator(srcFileName);
            File srcFile = new File(srcFileName);
            String extensionDest = imgData.getAttribute("format").toLowerCase();
            if (!(srcFile.exists() || (srcFile = new File(path = FileServices.getFileBase(srcFile) + ".png")).exists() || (srcFile = new File(path = FileServices.getFileBase(srcFile) + ".gif")).exists() || (srcFile = new File(path = FileServices.getFileBase(srcFile) + ".eps")).exists())) {
                imgData.setAttribute("fileref", "");
                continue;
            }
            String extensionSrc = FileServices.getExtension(srcFileName).toLowerCase();
            String tempFileName = fileref.substring(3, fileref.lastIndexOf("."));
            String destFileName = this.createUuidFileName(this.compPath + tempFileName) + "." + extensionDest;
            File destFile = new File(FileServices.appendFileName(destDir, destFileName));
            this.fireProgressEvent(srcFileName + "\n    ------->\n" + destFileName, this.relocateMsg);
            if (extensionSrc.equals(extensionDest)) {
                FileServices.copyFileToFile(srcFile, destFile);
            }
            if (extensionDest.equals("png")) {
                if (extensionSrc.equals("gif")) {
                    destFile = ImageServices.giftopng(srcFile, destFile);
                }
            } else if (extensionDest.equals("eps")) {
                if (extensionSrc.equals("gif")) {
                    destFile = ImageServices.giftopng(srcFile, destFile);
                }
                if (extensionSrc.equals("png")) {
                    ImageServices.toEps(srcFile, destFile);
                }
            } else {
                path = "";
            }
            path = "data/" + destFileName;
            imgData.setAttribute("fileref", path);
        }
    }

    private String createUuidFileName(String picPath) {
        UUID uuidModule = UUID.nameUUIDFromBytes(("http://unico-media.de/" + picPath).getBytes());
        return uuidModule.toString();
    }

    private void fireProgressEvent(String fileName, String res) {
        if (this.listener != null) {
            String msg = fileName;
            if (res != null) {
                msg = MessageFormat.format(res, fileName);
            }
            this.listener.progress(new ProgressEvent(msg, false));
        }
    }
}

