/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.unit;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.unit.LengthUnit;

public class Length {
    private static final LengthUnit DEFAULT_UNIT = LengthUnit.MILLIMETER;
    private static Log logger = LogFactory.getLog(Length.class);
    private Double distance = null;
    private boolean excludePercent = true;
    private Locale locale = Locale.getDefault();
    private LengthUnit unit = LengthUnit.MILLIMETER;

    public Length() {
        this(Locale.getDefault(), null, null);
    }

    public Length(Double distance) {
        this(Locale.getDefault(), distance, DEFAULT_UNIT);
    }

    public Length(Double distance, LengthUnit unit) {
        this(Locale.getDefault(), distance, unit);
    }

    public Length(float distance, LengthUnit unit) {
        this(Locale.getDefault(), new Double(distance), unit);
    }

    public Length(int top) {
        this(Locale.getDefault(), new Double(top), DEFAULT_UNIT);
    }

    public Length(Locale locale, Double distance, LengthUnit unit) {
        this.setLocale(locale);
        this.distance = distance;
        this.unit = unit;
    }

    public static double toMillimeter(Object value) {
        if (!(value instanceof Length)) {
            throw new IllegalArgumentException("The argument value must be of type Distance!");
        }
        Length length = (Length)value;
        if (length.getUnit() == LengthUnit.POINT) {
            return length.getLength() / 72.0f * 25.4f;
        }
        if (length.getUnit() == LengthUnit.INCH) {
            return length.getLength() * 25.4f;
        }
        if (length.getUnit() == LengthUnit.CENTIMETER) {
            return length.getLength() * 10.0f;
        }
        return length.getLength();
    }

    public static Length valueOf(String value) {
        return Length.valueOf(value, true);
    }

    public static Length valueOf(String value, boolean excludePercent) {
        Length distance = new Length(Locale.US, null, DEFAULT_UNIT);
        distance.setExcludePercent(excludePercent);
        if (!distance.processValue(Locale.US, value)) {
            return null;
        }
        return distance;
    }

    public void decrDistance(float decr) {
        if (this.distance != null) {
            this.distance = this.distance - (double)decr;
        }
    }

    public Length deepCopy() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.unit == null) {
            this.unit = LengthUnit.MILLIMETER;
        }
        if (this.distance == null) {
            return new Length(this.locale, null, this.unit);
        }
        Length copy = new Length(this.locale, new Double(this.distance), this.unit);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Length other = (Length)obj;
        if (this.distance == null && other.distance != null) {
            return false;
        }
        if (this.distance == null && other.distance == null) {
            return false;
        }
        if (!this.distance.equals(other.distance)) {
            return false;
        }
        if (this.unit == null && other.unit != null) {
            return false;
        }
        return this.unit.equals((Object)other.unit);
    }

    public boolean excludePercent() {
        return this.excludePercent;
    }

    public float getLength() {
        if (this.distance == null) {
            return 0.0f;
        }
        return this.distance.floatValue();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.distance == null ? 0 : this.distance.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public void incrDistance(float incr) {
        if (this.distance != null) {
            this.distance = this.distance + (double)incr;
        }
    }

    public Length minus(Length operand) {
        if (operand == null) {
            return this.deepCopy();
        }
        double sum = this.toMillimeter() - operand.toMillimeter();
        return new Length(sum, LengthUnit.MILLIMETER);
    }

    public Length plus(Length operand) {
        if (operand == null) {
            return this.deepCopy();
        }
        double sum = this.toMillimeter() + operand.toMillimeter();
        return new Length(sum, LengthUnit.MILLIMETER);
    }

    public boolean processValue(Locale locale, String value) {
        double td;
        if (value == null || value.trim().length() == 0) {
            this.unit = null;
            this.distance = null;
            return false;
        }
        String tu = null;
        value = value.trim().toLowerCase();
        for (LengthUnit unit : LengthUnit.values()) {
            if (this.excludePercent() && unit.equals((Object)LengthUnit.PERCENT) || !value.endsWith(unit.getAbbreviation())) continue;
            tu = unit.getAbbreviation();
            break;
        }
        if (tu == null) {
            tu = LengthUnit.POINT.getAbbreviation();
        }
        value = StringServices.cutSuffix(value, tu);
        try {
            NumberFormat formatter = NumberFormat.getInstance(locale);
            Number num = formatter.parse(value);
            td = num.doubleValue();
        }
        catch (Throwable oops) {
            logger.error((Object)("Invalid value " + value + " for length."), oops);
            return false;
        }
        this.unit = LengthUnit.valueOfAbbrev(tu);
        this.distance = td;
        return true;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setExcludePercent(boolean excludePercent) {
        this.excludePercent = excludePercent;
    }

    public void setLength(double length) {
        this.distance = length;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocalizedValue(String value) {
        this.processValue(this.getLocale(), value);
    }

    public void setUnit(LengthUnit unit) {
        this.unit = unit;
    }

    public double toMillimeter() {
        return Length.toMillimeter(this);
    }

    public String toNormalizedString() {
        if (this.distance == null) {
            return null;
        }
        if (this.unit == LengthUnit.PERCENT) {
            return String.format(Locale.US, "%.0f%s", this.distance, this.unit.getAbbreviation());
        }
        return String.format(Locale.US, "%.2f%s", this.distance, this.unit.getAbbreviation());
    }

    public double toPoint() {
        double millis = this.toMillimeter();
        return millis * 2.834645669;
    }

    public String toString() {
        if (this.distance == null) {
            return null;
        }
        return String.format(this.getLocale(), "%.2f %s", this.distance, this.unit.getAbbreviation());
    }
}

