/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.transaction;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.service.FileServices;
import org.dbdoclet.transaction.RollbackException;

public class TransactionLog {
    private static Log logger = LogFactory.getLog(TransactionLog.class);
    private HashMap<Object, String> actionMap = new HashMap();
    private File transactionDir = null;
    private File shadowedDir = null;
    private File shadowCopyDir = null;

    public void setTransactionDirectory(File transactionDir) throws IOException {
        if (transactionDir == null) {
            throw new IllegalArgumentException("The argument transactionDir must not be null!");
        }
        String shadowCopyPath = FileServices.appendPath(transactionDir, "__tlog.01");
        this.shadowCopyDir = new File(shadowCopyPath);
        FileServices.createPath(this.shadowCopyDir);
        this.transactionDir = transactionDir;
    }

    public void createShadowCopy(File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("The argument dir must not be null!");
        }
        if (this.transactionDir == null) {
            throw new IllegalStateException("The field transactionDir must not be null!");
        }
        FileServices.copyDir(dir, this.shadowCopyDir);
        this.shadowedDir = dir;
    }

    public void restoreShadowCopy() throws IOException {
        FileServices.setWritable(this.shadowedDir);
        FileServices.setWritable(this.shadowCopyDir);
        FileServices.delete(this.shadowedDir);
        FileServices.createPath(this.shadowedDir);
        FileServices.copyDir(this.shadowCopyDir, this.shadowedDir);
    }

    public void addDelete(File file) {
        this.actionMap.put(file, "delete");
    }

    public Iterator<Object> iterator() {
        return this.actionMap.keySet().iterator();
    }

    public void rollback() throws RollbackException {
        this.rollback(null);
    }

    public void rollback(Throwable cause) throws RollbackException {
        logger.info((Object)"TransactionLog.rollback - Starting rollback..");
        if (this.transactionDir == null || this.transactionDir.length() == 0L) {
            logger.error((Object)"TransactionLog.rollback - The transaction directory must not be null! Stopping rollback.");
            return;
        }
        HashMap<Throwable, String> oopsMap = new HashMap<Throwable, String>();
        if (cause != null) {
            oopsMap.put(cause, "Cause");
        }
        FileServices.setWritable(this.transactionDir);
        String lockFileName = FileServices.appendFileName(this.transactionDir, "TRANSACTION_LOCKED");
        File lockFile = new File(lockFileName);
        try {
            FileServices.touch(lockFile);
        }
        catch (IOException oops) {
            logger.fatal((Object)"!!!===[ ROLLBACK FAILED ]===!!!", (Throwable)oops);
            oopsMap.put(oops, lockFile.getAbsolutePath());
        }
        for (Object obj : this.actionMap.keySet()) {
            if (obj == null || !(obj instanceof File)) continue;
            File file = (File)obj;
            String action = this.actionMap.get(obj);
            if (action == null || !action.equals("delete") || !file.exists()) continue;
            try {
                logger.info((Object)("TransactionLog.rollback - Deleting file " + file.getAbsolutePath() + "."));
                FileServices.setWritable(file);
                FileServices.delete(file);
            }
            catch (IOException oops) {
                logger.fatal((Object)"!!!===[ ROLLBACK FAILED ]===!!!", (Throwable)oops);
                oopsMap.put(oops, file.getAbsolutePath());
            }
        }
        if (this.shadowedDir != null) {
            try {
                logger.info((Object)("TransactionLog.rollback - Restoring shadow directory " + this.shadowCopyDir.getAbsolutePath() + " to " + this.shadowedDir.getAbsolutePath()));
                this.restoreShadowCopy();
            }
            catch (IOException oops) {
                logger.fatal((Object)"!!!===[ ROLLBACK FAILED ]===!!!", (Throwable)oops);
                oopsMap.put(oops, this.shadowedDir.getAbsolutePath());
            }
        }
        if (oopsMap.size() > 0) {
            RollbackException oops = new RollbackException(oopsMap);
            throw oops;
        }
    }
}

