/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.script.parser;

import org.dbdoclet.trafo.param.BooleanParam;
import org.dbdoclet.trafo.param.NumberParam;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.AttributeRule;
import org.dbdoclet.trafo.script.Namespace;
import org.dbdoclet.trafo.script.NodeRule;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.script.Section;
import org.dbdoclet.trafo.script.parser.TrafoScriptBaseListener;
import org.dbdoclet.trafo.script.parser.TrafoScriptParser;

public class TrafoScriptListenerImpl
extends TrafoScriptBaseListener {
    private Script script;
    private Namespace namespace;
    private String currentParamId;
    private Section currentSection;

    public TrafoScriptListenerImpl(Script script, String namespaceName) {
        this.script = script;
        if (namespaceName == null || namespaceName.trim().length() == 0) {
            namespaceName = "";
        }
        this.namespace = new Namespace(namespaceName);
        script.addNamespace(this.namespace);
    }

    @Override
    public void enterTransformation(TrafoScriptParser.TransformationContext ctx) {
        this.script.addNamespace(this.namespace);
        this.script.setSystemParameter(this.namespace.getName(), "transformation.name", ctx.ID().getText());
    }

    @Override
    public void enterSection(TrafoScriptParser.SectionContext ctx) {
        Section section = new Section();
        if (ctx.ID() != null) {
            section.setName(ctx.ID().getText());
        }
        if (ctx.REGEXP() != null) {
            section.setName(ctx.REGEXP().getText());
        }
        this.namespace.addSection(section);
        this.currentSection = section;
    }

    @Override
    public void enterParam(TrafoScriptParser.ParamContext ctx) {
        this.currentParamId = ctx.ID().getText();
    }

    @Override
    public void enterNode(TrafoScriptParser.NodeContext ctx) {
        NodeRule nodeRule = new NodeRule();
        if (ctx.TEXT() != null) {
            nodeRule.setName(ctx.TEXT().getText());
        }
        this.namespace.addNodeRule(nodeRule);
        this.currentSection = nodeRule;
    }

    @Override
    public void enterAttribute(TrafoScriptParser.AttributeContext ctx) {
        AttributeRule attributeRule = new AttributeRule();
        if (ctx.TEXT() != null) {
            attributeRule.setName(ctx.TEXT().getText());
        }
        this.namespace.addAttributeRule(attributeRule);
        this.currentSection = attributeRule;
    }

    @Override
    public void enterExpr(TrafoScriptParser.ExprContext ctx) {
        if (ctx.BOOL() != null) {
            this.currentSection.addParam(new BooleanParam(this.currentParamId, Boolean.valueOf(ctx.BOOL().getText())));
        }
        if (ctx.NUMBER() != null) {
            this.currentSection.addParam(new NumberParam(this.currentParamId, Integer.valueOf(ctx.NUMBER().getText())));
        }
        if (ctx.TEXT() != null) {
            this.currentSection.addParam(new TextParam(this.currentParamId, ctx.TEXT().getText()));
        }
        if (ctx.MULTILINE() != null) {
            this.currentSection.addParam(new TextParam(this.currentParamId, ctx.MULTILINE().getText()));
        }
    }
}

