/*
 * Decompiled with CFR 0.152.
 */
package org.dbdoclet.trafo.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.dbdoclet.service.StringServices;
import org.dbdoclet.tag.ITransformPosition;
import org.dbdoclet.trafo.param.Param;
import org.dbdoclet.trafo.param.TextParam;
import org.dbdoclet.trafo.script.Namespace;
import org.dbdoclet.trafo.script.NodeRule;
import org.dbdoclet.trafo.script.ScriptEvent;
import org.dbdoclet.trafo.script.ScriptListener;
import org.dbdoclet.trafo.script.Section;

public class Script {
    public static final String DEFAULT_NAMESPACE = "";
    private static final String DEFAULT_SECTION = "main";
    private static final String SECTION_SYSTEM = "SYS PARAMS";
    public static final String SYSPARAM_TRANSFORMATION_NAME = "transformation.name";
    private static final String SECTION_INPUT = "input";
    private static final String SECTION_OUTPUT = "output";
    private static final String PARAM_FORMAT = "format";
    private final LinkedHashMap<String, Param<?>> variableMap;
    private final LinkedHashMap<String, Namespace> namespaceMap = new LinkedHashMap();
    private ArrayList<ScriptListener> listeners;
    private ITransformPosition transformPosition;
    private ArrayList<String> contextList;

    public Script() {
        this.variableMap = new LinkedHashMap();
        this.contextList = new ArrayList();
    }

    public void addContext(String context) {
        this.contextList.add(0, context);
    }

    public void addScriptListener(ScriptListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public String dump() {
        StringBuilder buffer = new StringBuilder();
        for (String namespaceName : this.namespaceMap.keySet()) {
            System.out.println("\n+++ Namespace: " + namespaceName);
            Namespace namespace = this.namespaceMap.get(namespaceName);
            for (Section section : namespace.getSections()) {
                System.out.println("> Section: " + section.getName());
                for (Param<?> param : section.getParameters()) {
                    System.out.println(param.toString());
                }
            }
            for (NodeRule nodeRule : namespace.getNodeRules()) {
                System.out.println("> Section: " + nodeRule.getName());
                for (Param<?> param : nodeRule.getParameters()) {
                    System.out.println(param.toString());
                }
            }
            for (Section section : namespace.getSections()) {
                System.out.println("> Section: " + section.getName());
                for (Param<?> param : section.getParameters()) {
                    System.out.println(param.toString());
                }
            }
        }
        return buffer.toString();
    }

    private Section findSection(String namespaceName, String name) {
        Namespace namespace;
        if (namespaceName == null) {
            namespaceName = DEFAULT_NAMESPACE;
        }
        if (name == null) {
            name = DEFAULT_SECTION;
        }
        if ((namespace = this.namespaceMap.get(namespaceName)) == null) {
            return null;
        }
        return namespace.findSection(name);
    }

    public void fireScriptEvent(ScriptEvent<?> event) {
        if (this.listeners == null) {
            return;
        }
        for (ScriptListener listener : this.listeners) {
            listener.scriptChanged(event);
        }
    }

    public String getInputFormat() {
        return this.getInputFormat(DEFAULT_NAMESPACE);
    }

    public String getInputFormat(String namespace) {
        return this.getTextParameter(namespace, SECTION_INPUT, PARAM_FORMAT, null);
    }

    public int getIntParameter(String section, String name, int def) {
        return this.getIntParameter(DEFAULT_NAMESPACE, section, name, def);
    }

    public int getIntParameter(String namespace, String section, String name, int def) {
        Param<?> param = this.getParameter(namespace, section, name);
        if (param == null) {
            return def;
        }
        return (Integer)param.getValue();
    }

    public String getOutputFormat() {
        return this.getOutputFormat(DEFAULT_NAMESPACE);
    }

    public String getOutputFormat(String namespace) {
        return this.getTextParameter(namespace, SECTION_OUTPUT, PARAM_FORMAT, null);
    }

    public Collection<NodeRule> getNodeRules(String section, String name) {
        return this.getNodeRules(DEFAULT_NAMESPACE, section, name);
    }

    private Collection<NodeRule> getNodeRules(String namespaceName, String section, String name) {
        Namespace namespace = this.namespaceMap.get(namespaceName);
        if (namespace == null) {
            return null;
        }
        return namespace.getNodeRules();
    }

    public Param<?> getParameter(String section, String name) {
        return this.getParameter(DEFAULT_NAMESPACE, section, name);
    }

    public Param<?> getParameter(String namespaceName, String sectionName, String paramName) {
        Param<?> param;
        Namespace namespace = this.namespaceMap.get(namespaceName);
        if (namespace == null) {
            return null;
        }
        List specificSectionList = namespace.getSections().stream().filter(section -> this.contextList.contains(section.getName())).collect(Collectors.toList());
        List regexpSectionList = namespace.getSections().stream().filter(section -> {
            if (section.getName().startsWith("/") && section.getName().endsWith("/")) {
                String regexp = StringServices.trim(section.getName(), "/");
                return this.contextList.stream().filter(contextName -> contextName.matches(regexp)).collect(Collectors.toList()).size() > 0;
            }
            return false;
        }).collect(Collectors.toList());
        Section section2 = namespace.findSection(sectionName);
        if (specificSectionList != null && specificSectionList.size() > 0 && (param = ((Section)specificSectionList.get(0)).findParameter(paramName)) != null) {
            return param;
        }
        if (regexpSectionList != null && regexpSectionList.size() > 0 && (param = ((Section)regexpSectionList.get(0)).findParameter(paramName)) != null) {
            return param;
        }
        if (section2 == null) {
            return null;
        }
        return section2.findParameter(paramName);
    }

    public <T> T getParameterValue(String namespace, String section, String name, T def) {
        Param<?> param = this.getParameter(namespace, section, name);
        if (param == null) {
            return def;
        }
        Object value = def;
        try {
            Object paramValue = param.getValue();
            if (paramValue != null) {
                value = paramValue;
            }
        }
        catch (Throwable oops) {
            oops.printStackTrace();
        }
        return value;
    }

    public <T> T getParameterValue(String section, String name, T def) {
        return this.getParameterValue(DEFAULT_NAMESPACE, section, name, def);
    }

    public Namespace getNamespace(String namespaceName) {
        return this.namespaceMap.get(namespaceName);
    }

    public Param<?> getSystemParameter(String namespace, String name) {
        Section section = this.findSection(namespace, SECTION_SYSTEM);
        if (section == null) {
            return null;
        }
        return section.findParameter(name);
    }

    public String getTextParameter(String section, String name, String def) {
        return this.getTextParameter(DEFAULT_NAMESPACE, section, name, def);
    }

    public String getTextParameter(String namespace, String section, String name, String def) {
        Param<?> param = this.getParameter(namespace, section, name);
        if (param == null) {
            return def;
        }
        return param.getValueAsText();
    }

    public List<String> getTextParameterList(String section, String name) {
        return this.getTextParameterList(DEFAULT_NAMESPACE, section, name, new ArrayList<String>());
    }

    public List<String> getTextParameterList(String section, String name, List<String> def) {
        return this.getTextParameterList(DEFAULT_NAMESPACE, section, name, def);
    }

    public List<String> getTextParameterList(String namespace, String section, String name, List<String> def) {
        Param<?> param = this.getParameter(namespace, section, name);
        if (param == null) {
            return def;
        }
        ArrayList<?> values = param.getValues();
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (Object value : values) {
            list.add(value.toString());
        }
        return list;
    }

    public ITransformPosition getTransformPosition() {
        return this.transformPosition;
    }

    public Param<?> getVariable(String param) {
        return this.variableMap.get(param);
    }

    public boolean isEnabled(String section, String name) {
        Param<?> param = this.getParameter(section, name);
        if (param != null) {
            param.isEnabled();
        }
        return false;
    }

    public boolean isParameterOn(String section, String name, boolean def) {
        return this.isParameterOn(DEFAULT_NAMESPACE, section, name, def);
    }

    public boolean isParameterOn(String namespace, String section, String name, boolean def) {
        Param<?> param = this.getParameter(namespace, section, name);
        if (param == null) {
            return def;
        }
        Object value = param.getValue();
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public void mergeNamespaces() {
        Namespace defNamespace = this.namespaceMap.get(DEFAULT_NAMESPACE);
        if (defNamespace == null) {
            defNamespace = new Namespace(DEFAULT_NAMESPACE);
        }
        ArrayList<Namespace> removeList = new ArrayList<Namespace>();
        for (Namespace namespace : this.namespaceMap.values()) {
            if (namespace.getName().equals(DEFAULT_NAMESPACE)) continue;
            for (Section section : namespace.getSections()) {
                Section defSection = defNamespace.findSection(section.getName());
                if (defSection == null) {
                    defSection = new Section(section.getName());
                    defNamespace.addSection(defSection);
                }
                for (Param<?> param : section.getParameters()) {
                    defSection.addParam(param);
                }
            }
            removeList.add(namespace);
        }
        for (Namespace namespace : removeList) {
            this.namespaceMap.remove(namespace);
        }
    }

    public void removeContext(String context) {
        this.contextList.remove(context);
    }

    public void removeScriptListener(ScriptListener listener) {
        if (this.listeners == null || listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setEnabled(String section, String name, boolean flag) {
        Param<?> param = this.getParameter(section, name);
        if (param != null) {
            param.setEnabled(flag);
        }
    }

    public void setSystemParameter(String name, String value) {
        this.setSystemParameter(DEFAULT_NAMESPACE, name, value);
    }

    public void setSystemParameter(String namespaceName, String name, String value) {
        Section section;
        Namespace namespace = this.namespaceMap.get(namespaceName);
        if (namespace == null) {
            namespace = new Namespace(namespaceName);
            this.namespaceMap.put(namespaceName, namespace);
        }
        if ((section = namespace.findSection(SECTION_SYSTEM)) == null) {
            section = new Section(SECTION_SYSTEM);
            namespace.addSection(section);
        }
        section.addParam(new TextParam(name, value));
    }

    public void setTransformPosition(ITransformPosition transformPosition) {
        this.transformPosition = transformPosition;
    }

    public void setVariable(Param<?> param) {
        this.variableMap.put(param.getName(), param);
    }

    public void unsetVariable(String varname) {
        this.variableMap.remove(varname);
    }

    public void addNamespace(Namespace namespace) {
        this.namespaceMap.put(namespace.getName(), namespace);
    }

    public Namespace getNamespace() {
        Namespace namespace = this.getNamespace(DEFAULT_NAMESPACE);
        if (namespace == null) {
            namespace = new Namespace(DEFAULT_NAMESPACE);
            this.addNamespace(namespace);
        }
        return namespace;
    }

    public static enum SectionType {
        SECTION,
        NODE,
        ATTRIBUTE;

    }
}

